<?php

namespace Hwapx\Admin\Controller\Admin;

use Hwapx\Admin\Controller\Admin\Admin;
use Hwapx\Core\Library\Template;
use Hwapx\Core\Library\Validator;
use Hwapx\Core\Library\Web;
use Hwapx\Core\Library\Form;
use HwapX\Admin\Library\Builder\TableBuilder;
use HwapX\Admin\Library\Builder\FormBuilder;
use HwapX\Core\Library\ModuleManager;

class Group extends Admin {
  protected $validator = null;
  protected $logger    = null;
  protected $form = array(
      'title'  => 'Grupos',
      'name'   => 'Grupo',
      'table'  => 'admin_group_list',
      'groups' => array(
          'main' => array(
              'legend' => 'Dados de acesso',
              'fields' =>  array(
                  'description' => array(
                      'label' => 'Descrição',
                      'type'  => 'text',
                      'rules' => array(
                          'required'
                        )
                    ),
                  'active'    => array(
                      'label'   => 'Ativo',
                      'type'    => 'radio',
                      'options' => array(
                          '1' => 'Sim',
                          '0' => 'Não',
                        ),
                      'rules'   => array(
                          'required'
                        )
                    )/*,
                  'confirm'  => array(
                      'label' => 'Confirme a senha',
                      'type'  => 'password',
                      'rules' => array(
                          'equals' => 'password'
                        )
                    )*/
                )
            ),
          'roles' => array(
              'legend' => 'Permissões',
              'fields' => array(
                  'roles' => array(
                      'label' => 'Regras',
                      'type'  => 'checkbox',
                      'rules' => array(
                          'required'
                        ),
                      'options' => array()
                    )
                )
            )
        )
    );

  protected $table = array(
      'title'   => 'Lista de Grupos',
      'name'    => 'Grupos',
      'cols'    => array(
          'id'          => '#',
          'description' => 'Descrição',
          'active_s'    => 'Ativo'
        ),
      'actions' => array(
          array(
              'route'       => 'admin_group_create',
              'description' => 'Novo',
              'class'       => 'btn-primary',
              'role'        => 'hwapx.admin.group_create'
            )
        ),
      'rowactions' => array(
          array(
              'route'       => 'admin_group_edit',
              'description' => 'Alterar',
              'class'       => 'btn-primary',
              'default'     => true,
              'role'        => 'hwapx.admin.group_edit'
            ),
          array(
              'route'       => 'admin_group_remove',
              'description' => 'Remover',
              'class'       => 'btn-danger',
              'confirm'     => true,
              'role'        => 'hwapx.admin.group_remove'
            )
        ),
      'route'       => 'admin_group_list',
      'legend' => array(
          'default' => 'Ativo',
          'danger'  => 'Inativo',
      ),
    );

  public function __construct($f3) {
    parent::__construct($f3);

    if(!$this->module->hasRole('hwapx.admin.group_roles')) {
      unset($this->form['groups']['roles']);
    } else {
      $this->form['groups']['roles']['fields']['roles']['options'] = ModuleManager::instance()->roleList();

      foreach ($this->form['groups']['roles']['fields']['roles']['options'] as $key => $value) {
        if(!ModuleManager::instance()->hasRole($key)) {
          unset($this->form['groups']['roles']['fields']['roles']['options'][$key]);
          /*unset($_POST['roles'][$key]);
          unset($_GET['roles'][$key]);
          unset($_REQUEST['roles'][$key]);
          $f3->clear("POST.roles['$key']");*/
        }
      }
    }

    $this->logger = new \Log(date('Y-m-d').'_group.log');
  }

	public function index($f3) {
    $this->module->checkRole('hwapx.admin.group_list');

    $db    = $f3->get('db');
    $mapper = new \DB\SQL\Mapper($db, 'hwapx_group');
    $mapper->active_s = "CASE active WHEN 1 THEN 'SIM' ELSE 'NÃO' END";

    $this->table['rowcallback'] = function($mapper) {
        return array('class' => $mapper->active ? '' : 'danger');
    };

		echo TableBuilder::instance($mapper, $this->table)->render();
	}

  public function create($f3) {
    $this->module->checkRole('hwapx.admin.group_create');

    $db   = $f3->get('db');
    $mapper = new \DB\SQL\Mapper($db, 'hwapx_group');

    if(!$this->module->hasRole('hwapx.admin.group_roles')) {
      unset($this->form['groups']['roles']);
    }

    echo FormBuilder::instance($mapper, $this->form, $this->logger)->handle();
  }

	public function alter($f3) {
    $this->module->checkRole('hwapx.admin.group_edit');

    $db     = $f3->get('db');
    $mapper = new \DB\SQL\Mapper($db, 'hwapx_group');

    if(!$this->module->hasRole('hwapx.admin.group_roles')) {
      unset($this->form['groups']['roles']);
    }

    echo FormBuilder::instance($mapper, $this->form, $this->logger)->handle();
	}

  public function remove($f3) {
    $this->module->checkRole('hwapx.admin.group_remove');

    $db     = $f3->get('db');
    $mapper = new \DB\SQL\Mapper($db, 'hwapx_group');

    echo FormBuilder::instance($mapper, $this->form, $this->logger)->delete();
  }
}
