<?php

namespace Hwapx\Admin\Controller\Admin;

use Hwapx\Admin\Controller\Admin\Admin;
use Hwapx\Core\Library\Template;
use Valitron\Validator;

class Settings extends Admin
{
    protected $validator = null;
    protected $form_groups = array();
    protected $form_rules = array();
    protected $form_actions = array(
        array(
            'route' => 'admin_purge_cache',
            'description' => 'Limpar cache',
            'class' => 'btn-warning',
            'confirm' => true
        )
    );

    public function __construct($f3)
    {
        parent::__construct($f3);

        $this->module->checkRole('settings');

        $db = $f3->get('db');
        $settings = new \DB\SQL\Mapper($db, 'hwapx_setting');
        $settings->load(null, array('order' => 'group asc, field_order asc'));

        while (!$settings->dry()) {
            $fieldname = str_replace('.', '___', $settings->id);
            $this->form_groups[$settings->group]['legend'] = $settings->group;
            $this->form_groups[$settings->group]['fields'][$fieldname] = array('label' => $settings->label, 'type' => $settings->type);

            if ($settings->rules != '') {
                $rules = explode(';', $settings->rules);

                foreach ($rules as $str) {
                    $arr = explode('=', $str);
                    $rule = $arr[0];
                    $params = isset($arr[1]) ? explode(',', $arr[1]) : array();
                    foreach ($params as &$p)
                        if (substr_count($p, '|') > 0) {
                        $p = explode('|', $p);
                    }

                    $this->form_rules[$rule][] = array_merge(array($fieldname), $params);

                    if ($params)
                        $this->form_groups[$settings->group]['fields'][$fieldname]['rules'][$rule] = count($params) == 1 ? $params[0] : $params;
                    else
                        $this->form_groups[$settings->group]['fields'][$fieldname]['rules'][] = $rule;

                    if ($rule == 'in') {
                        $this->form_groups[$settings->group]['fields'][$fieldname]['type'] = 'dropdown';

                        foreach ($params[0] as $val)
                            $this->form_groups[$settings->group]['fields'][$fieldname]['options'][$val] = $val ? : '-- Nenhum(a) --';
                    }
                }
            }

            $settings->next();
        }

    //print_r($this->form_rules);
    //die();

        if ($f3->get('VERB') == 'POST') {
            $this->validator = new Validator($f3->get('POST'));
            $this->validator->rules($this->form_rules);

            foreach ($this->form_groups as $group)
                $this->validator->labels(array_map(function ($v) {
                return $v['label'];
            }, $group['fields']));
        }

        $f3->set('page.title', 'Configurações');
    }

    public function index($f3)
    {
        $db = $f3->get('db');
        $settings = new \DB\SQL\Mapper($db, 'hwapx_setting');

        if ($f3->get('VERB') == 'POST') {
            $f3->set('form.values', $f3->get('POST'));

            if ($this->validator->validate()) {
                foreach ($this->form_groups as $g)
                    foreach ($g['fields'] as $k => $f)
                    if ($f['type'] === 'password' && $f3->get('POST.' . str_replace('.', '___', $k)) == '********')
                    $f3->clear('POST.' . str_replace('.', '___', $k));

                foreach ($f3->get('POST') as $key => $val) {
                    $settings->reset();
                    $settings->load(array('id = ?', str_replace('___', '.', $key)));

                    if (in_array($settings->type, array('datetime', 'date', 'time'))) {
                        $settings->value = $this->formatDatetime($val, $this->f3->get("app.{$data['type']}.format"), $this->f3->get("app.{$data['type']}.format4"));
                    } else if ($settings->type == 'number') {
                        $settings->value = str_replace(array($this->f3->get('app.number.thousands'), $this->f3->get('app.number.radixpoint')), array('', '.'), $val);
                    } else {
                        $settings->value = $val;
                    }
                    
                    $settings->save();
                }

                $settings->load(null, null, -1);

                flash('success', "Configurações salvas com sucesso.");
            } else {
                $f3->set('form.errors', $this->validator->errors());

                flash('error', "Ocorreu um erro ao salvar o item!\nverifique os campos para mais detalhes.");
            }
        } else {
            $settings->load();

            while (!$settings->dry()) {
                $f3->set('form.values.' . str_replace('.', '___', $settings->id), $settings->value);
                $settings->next();
            }
        }

        $f3->set('form.groups', $this->form_groups);
        $f3->set('form.actions', $this->form_actions);
        $f3->set('form.title', 'Configurações');

        echo Template::instance()->render('hwapx/admin/admin/form.html');
    }

    protected function fileList($dir)
    {
        $entries = scandir($dir);

        $files = array();
        foreach ($entries as $e) {
            if ($e === '.htaccess')
                continue;

            $f = $dir . $e;
            if (is_file($f))
                $files[] = $f;
        }

        return $files;
    }

    public function purge_cache($f3)
    {
        $cache_dir = $f3->get('CACHE');
        $temp_dir = $f3->get('TEMP');
        $files = $this->fileList($temp_dir);

        if (is_dir($cache_dir))
            $files += $this->fileList($cache_dir);

        $size = 0;
        foreach ($files as $f) {
            $size += filesize($f);
            unlink($f);
        }

        $msgs = sprintf('%d Arquivos um total de %.2fkb removidos.', count($files), $size / 1024);

        flash('success', $msgs);
        $f3->reroute('@admin_settings');
    }
}
