<?php

namespace Hwapx\Api\Controller;

use Log;

class Api {
    protected $log = null;

    public function __construct($f3) {
        $class = explode('\\', get_class($this));
        $this->log = new Log(date('Y-m-d') . '_' . strtolower(end($class)) . '_api.log');
    }

    public function json($data, $error = null, $return = false) {
        $response = array();

        if($error === null)
            $error = !(bool)$data;

        $response['error'] = (bool)$error;
        $response['message'] = is_string($error) ? $error : ($error ? 'Erro' : 'Sucesso');
        $response['data']    = $data;

        $response = json_encode($response);

        if(!$return) {
            header('Content-type: application/json');
            die($response);
        }

        return $response;
    }
}
