<?php

namespace HwapX\Core\Library;

use \F3;
use \Prefab;
use \DB\SQL;

class Database extends Prefab {
  protected $f3        = null;
  protected static $db = null;

  public function __construct() {
    $this->f3 = \F3::instance();
    
    $db       = new SQL($this->f3->get('app.db.connection'), $this->f3->get('app.db.username'), $this->f3->get('app.db.password'), array(
      \PDO::ATTR_TIMEOUT => 60 * 10,
      \PDO::ATTR_ERRMODE => \PDO::ERRMODE_EXCEPTION,
    ));
    self::$db = $db;
    $this->f3->set('db', $db);
  }

  public static function instance() {
    if(self::$db == null)
      new self();
    return self::$db;
  }
}