<?php

namespace HwapX\Core\Library;

use F3;

class Modulebase {
  protected static $ns = null;

  public function roles() {
    $ns = self::moduleNS();
    return ModuleManager::instance()->roles($ns);
  }

  public function hasRole($ns, $role = null) {
    if($role === null) {
      $role = $ns;
      $ns   = self::moduleNS();
    }

    if(strpos($role, str_replace('\\', '.', strtolower($ns))) === 0) {
      $ns   = $role;
      $role = null;
    }
    
    return ModuleManager::instance()->hasRole($ns, $role);
  }

  public function checkRole($ns, $role = null) {
    if($role === null) {
      $role = $ns;
      $ns   = self::moduleNS();
    }

    if(strpos($role, str_replace('\\', '.', strtolower($ns))) === 0) {
      $ns   = $role;
      $role = null;
    }

    return ModuleManager::instance()->checkRole($ns, $role);
  }

  protected function moduleNS() {
    if(!self::$ns)
      self::$ns = ModuleManager::instance()->moduleNamespaceOf($this);

    return self::$ns;
  }
}