<?php

namespace Hwapx\Core\Library;

use F3;
use Prefab;

class PluginLoader extends Prefab {
  protected $f3         = null;
  protected $plugin_dir = '';
  public    $plugins    = array();

  public function __construct($f3) {
    $this->f3         = $f3;

    $this->plugin_dir = $f3->get('app.plugin.dir');

    $this->load();
  }

  public function load() {
    foreach(glob($this->plugin_dir."*/*/", GLOB_ONLYDIR) as $mdir) {
      $this->f3->concat('PLUGINS', ";".$this->plugin_dir);

      if(file_exists($mdir.'lib'))
        $this->f3->concat('PLUGINS', ";".$mdir.'lib/');
      else
        $this->f3->concat('PLUGINS', ";".$mdir.'/');
    }
  }
}