<?php

namespace HwapX\Core\Library;

use F3;
use Web as F3Web;

class Web extends F3Web {
  public function receive($func=NULL,$overwrite=FALSE,$slug=TRUE) {
    if($slug == FALSE)
      $slug = function($filename) { 
        $ext = '';
        if(substr_count($filename, '.')) {
          $parts = explode('.', $filename);
          $ext   = array_pop($parts);
          if($ext)
            $ext = '.'.$ext;
        }
        return md5(uniqid(rand(), true)).$ext;
      };

    $result = array();

    $x = parent::receive(function($file,$formFieldName) use(&$func, &$result) {
        $valid = true;

        if(is_callable($func))
          $valid = $func($file,$formFieldName);

        if($valid)
          $result[$formFieldName] = basename($file['name']);

        return $valid;
      }, $overwrite, $slug);

    return $result;
  }
}
