<?php

namespace Hwapx\Core {

//require dirname(__FILE__). '/helpers/datetime.php';
require dirname(__FILE__).'/helpers/arrayhelper.php';
require dirname(__FILE__).'/helpers/datetimehelper.php';

use HwapX\Core\Library\Template;
use HwapX\Core\Library\Validator;
use HwapX\Core\Library\Database;
use HwapX\Core\Library\Session;
use HwapX\Core\Library\PluginLoader;
use HwapX\Core\Library\ModuleManager;

use F3;
use Log;

use Hwapx\Core\Library\Modulebase;

class Module extends Modulebase {
    protected $f3 = null;

    public function __construct($f3) {
        $this->f3 = $f3;
        PluginLoader::instance($this->f3)->load();
        Database::instance();
    }

    public function setup($f3) {

    }

    public function upgrade($f3) {

    }

    public function boot($f3) {
        Validator::instance()->addRule('numeric', function($field, $value) {
          return is_numeric(str_replace(array($this->f3->get('app.number.thousands'), $this->f3->get('app.number.radixpoint')), array('', '.'), $value));
        });
        //Session::instance();
        
        \HwapX\Core\Library\DB\Sql\Session::instance($f3->get('db'), 'hwapx_sessions', false, function() { return TRUE; });
        error_reporting(E_ALL);
        session_start();
        error_reporting(0);
        Template::instance();
    }
}
}

namespace {

    function flash($k) {
      $f3 = F3::instance();
      $k = 'SESSION.flash.'.$k;
      $r = null;
    
      if(func_num_args() == 1) {
        if($f3->exists($k, $r))
          $f3->clear($k);
        return $r;
      } else {
        $f3->set($k, func_get_arg(1));
      }
    }
}