<?php

namespace Hwapx\Email\Controller\Admin;

use Hwapx\Admin\Controller\Admin\Admin;
use Hwapx\Core\Library\Template;
use Hwapx\Core\Library\Validator;
use Hwapx\Core\Library\Web;
use Hwapx\Core\Library\Form;
use HwapX\Admin\Library\Builder\TableBuilder;
use HwapX\Admin\Library\Builder\FormBuilder;

class Account extends Admin {
  protected $validator = null;
  protected $logger    = null;
  protected $form = array(
      'name'   => 'Conta',
      'table'  => 'admin_email_account_list',
      'groups' => array(
          'main' => array(
              'legend' => 'Conta',
              'fields' =>  array(
                  'description' => array(
                      'label' => 'Descrição',
                      'type'  => 'text',
                      'rules' => array(
                          'required'
                        )
                    ),
                  'slug'    => array(
                      'label' => 'Slug',
                      'type'  => 'text',
                      'rules' => array(
                          'required',
                          'slug'
                        )
                    ),
                  'email'    => array(
                      'label' => 'Email',
                      'type'  => 'email',
                      'rules' => array(
                          'required',
                          'email'
                        )
                    ),
                  'password' => array(
                      'label' => 'Senha',
                      'type'  => 'password',
                      'rules' => array(
                          'required'
                        )
                    ),
                  'host' => array(
                      'label' => 'Servidor',
                      'type'  => 'text',
                      'rules' => array(
                          'required'
                        )
                    ),
                  'port' => array(
                      'label' => 'Porta',
                      'type'  => 'number',
                      'rules' => array(
                          'required',
                          'integer'
                        )
                    ),
                  'scheme' => array(
                      'label' => 'Modo',
                      'type'  => 'dropdown',
                      'options' => array(
                          '' => 'Normal',
                          'ssl' => 'SSL',
                          'tls' => 'TLS'
                        ),
                      'rules' => array(
                          'required'
                        )
                    ),
                )
            ),
        )
    );

  protected $table = array(
      'name'   => 'Contas',
      'cols'    => array(
          'id'          => '#',
          'description' => 'Descrição',
          'email'       => 'Email',
          'host'        => 'Servidor'
        ),
      'actions' => array(
          array(
              'route'       => 'admin_email_account_create',
              'description' => 'Novo',
              'class'       => 'btn-primary',
              'role'        => 'hwapx.email.account_create'
            )
        ),
      'rowactions' => array(
          array(
              'route'       => 'admin_email_account_edit',
              'description' => 'Alterar',
              'class'       => 'btn-primary',
              'default'     => true,
              'role'        => 'hwapx.email.account_edit'
            ),
          array(
              'route'       => 'admin_email_account_remove',
              'description' => 'Remover',
              'class'       => 'btn-danger',
              'confirm'     => true,
              'role'        => 'hwapx.email.account_remove'
            )
        ),
      'route'       => 'admin_email_account_list'
    );

  public function __construct($f3) {
    parent::__construct($f3);
  }

	public function index($f3) {
    $this->module->checkRole('hwapx.email.account_list');

    $db    = $f3->get('db');
    $mapper = new \DB\SQL\Mapper($db, 'hwapx_email_account');

		echo TableBuilder::instance($mapper, $this->table)->render();
	}

  public function create($f3) {
    $this->module->checkRole('hwapx.email.account_create');

    $db   = $f3->get('db');
    $mapper = new \DB\SQL\Mapper($db, 'hwapx_email_account');

    echo FormBuilder::instance($mapper, $this->form)->handle();
  }

	public function alter($f3) {
    $this->module->checkRole('hwapx.email.account_edit');

    $db     = $f3->get('db');
    $mapper = new \DB\SQL\Mapper($db, 'hwapx_email_account');

    echo FormBuilder::instance($mapper, $this->form)->handle();
	}

  public function remove($f3) {
    $this->module->checkRole('hwapx.email.account_remove');

    $db     = $f3->get('db');
    $mapper = new \DB\SQL\Mapper($db, 'hwapx_email_account');

    echo FormBuilder::instance($mapper, $this->form)->delete();
  }
}
