<?php

namespace Hwapx\Email\Controller\Admin;

use Hwapx\Admin\Controller\Admin\Admin;
use Hwapx\Core\Library\Template as SystemTemplate;
use Hwapx\Core\Library\Validator;
use Hwapx\Core\Library\Web;
use Hwapx\Core\Library\Form;
use HwapX\Admin\Library\Builder\TableBuilder;
use HwapX\Admin\Library\Builder\FormBuilder;
use DB\SQL\Mapper;

class Template extends Admin
{
    protected $validator = null;
    protected $logger = null;
    protected $form = array(
        'name' => 'Template',
        'table' => 'admin_email_template_list',
        'groups' => array(
            'main' => array(
                'legend' => 'Template',
                'fields' => array(
                    'description' => array(
                        'label' => 'Descrição',
                        'type' => 'text',
                        'rules' => array(
                            'required'
                        )
                    ),
                    'slug' => array(
                        'label' => 'Slug',
                        'type' => 'text',
                        'rules' => array(
                            'required',
                            'slug'
                        )
                    ),
                    'subject' => array(
                        'label' => 'Assunto',
                        'type' => 'text',
                        'rules' => array(
                            'required'
                        )
                    ),
                    'from' => array(
                        'label' => 'Remetente',
                        'type' => 'text',
                        'rules' => array()
                    ),
                    'to' => array(
                        'label' => 'Para',
                        'type' => 'text',
                        'rules' => array()
                    ),
                    'reply_to' => array(
                        'label' => 'Responder para',
                        'type' => 'text',
                        'rules' => array()
                    ),
                    'cc' => array(
                        'label' => 'CC',
                        'type' => 'text',
                        'rules' => array()
                    ),
                    'bcc' => array(
                        'label' => 'BCC',
                        'type' => 'text',
                        'rules' => array()
                    ),
                    'body' => array(
                        'label' => 'Corpo',
                        'type' => 'wysiwyg',
                        'rules' => array(
                            'required'
                        )
                    ),
                    'account_id' => array(
                        'label' => 'Conta',
                        'type' => 'dropdown',
                        'options' => array(
                            '' => '-- Nenhuma --',
                        ),
                        'rules' => array()
                    ),
                    'track' => array(
                        'label' => 'Rastrear Leitura',
                        'type' => 'dropdown',
                        'width' => 3,
                        'default' => 0,
                        'options' => array(
                            '1' => 'Sim',
                            '0' => 'Não',
                        ),
                        'rules' => array(
                            'required',
                        )
                    ),
                    'parse' => array(
                        'label' => 'Processar Imediatamente',
                        'type' => 'dropdown',
                        'width' => 3,
                        'default' => 0,
                        'options' => array(
                            '1' => 'Sim',
                            '0' => 'Não',
                        ),
                        'rules' => array(
                            'required',
                        )
                    ),
                )
            )
        )
    );

    protected $table = array(
        'name' => 'Templates',
        'cols' => array(
            'id' => '#',
            'description' => 'Descrição',
            'account_s' => 'Conta',
            'subject' => 'Assunto',
            'from' => 'Remetente'
        ),
        'actions' => array(
            array(
                'route' => 'admin_email_template_create',
                'description' => 'Novo',
                'class' => 'btn-primary',
                'role' => 'hwapx.email.template_create'
            )
        ),
        'rowactions' => array(
            array(
                'route' => 'admin_email_template_edit',
                'description' => 'Alterar',
                'class' => 'btn-primary',
                'default' => true,
                'role' => 'hwapx.email.template_edit'
            ),
            array(
                'route' => 'admin_email_template_remove',
                'description' => 'Remover',
                'class' => 'btn-danger',
                'confirm' => true,
                'role' => 'hwapx.email.template_remove'
            )
        ),
        'rowcount' => true,
        'route' => 'admin_email_template_list'
    );

    public function __construct($f3)
    {
        parent::__construct($f3);

        $db = $f3->get('db');
        $mapper = new Mapper($db, 'hwapx_email_account');

        foreach ($mapper->find() as $row)
            $this->form['groups']['main']['fields']['account_id']['options'][$row->id] = $row->description;
    }

    public function index($f3)
    {
        $this->module->checkRole('hwapx.email.template_list');

        $db = $f3->get('db');
        $mapper = new \DB\SQL\Mapper($db, 'hwapx_email_template');

        $mapper->account_s = 'SELECT hwapx_email_account.description FROM hwapx_email_account WHERE hwapx_email_account.id = hwapx_email_template.account_id';

        echo TableBuilder::instance($mapper, $this->table)->render();
    }

    public function create($f3)
    {
        $this->module->checkRole('hwapx.email.template_create');

        $db = $f3->get('db');
        $mapper = new \DB\SQL\Mapper($db, 'hwapx_email_template');

        echo FormBuilder::instance($mapper, $this->form)->handle();
    }

    public function alter($f3)
    {
        $this->module->checkRole('hwapx.email.template_edit');

        $db = $f3->get('db');
        $mapper = new \DB\SQL\Mapper($db, 'hwapx_email_template');

        echo FormBuilder::instance($mapper, $this->form)->handle();
    }

    public function remove($f3)
    {
        $this->module->checkRole('hwapx.email.template_remove');

        $db = $f3->get('db');
        $mapper = new \DB\SQL\Mapper($db, 'hwapx_email_template');

        echo FormBuilder::instance($mapper, $this->form)->delete();
    }
}
