<?php

namespace HwapX\Email\Controller\Api;

use DB\SQL\Mapper;

class Tracker extends \Hwapx\Api\Controller\Api {
    protected $transparent_png_pixel = "iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAQAAAC1HAwCAAAAC0lEQVR42mNkYAAAAAYAAjCB0C8AAAAASUVORK5CYII=";

    public function track($f3) {
        $db = $f3->get('db');
        $id = $f3->get('PARAMS.id');

        $mapper = new Mapper($db, 'hwapx_email_queue');

        if(!$mapper->load(array('id = ?', $id)))
            $f3->error(404);

        $mapper->read_count++;
        $mapper->save();

        $ip = $f3->get('IP');
        $agent = $f3->get('AGENT');

        $this->log->write("Requisição do pixel de rastreamento do email $id feito pelo IP $ip UserAgent $agent");

        header('Content-Type: image/png');
        echo base64_decode($this->transparent_png_pixel);
    }
}