<?php
namespace Hwapx\Redirect\Controller\Admin;

use DB\SQL\Mapper;
use Hwapx\Admin\Controller\Admin\Admin;
use HwapX\Admin\Library\Builder\FormBuilder;
use HwapX\Admin\Library\Builder\TableBuilder;

class Redirect extends Admin
{
    protected $db = null;

    protected $form = array(
        //'title'  => '',
        'name'   => 'Redirectionamento',
        'table'  => 'admin_redirects',
        'fields' => array(
            'description' => array(
                'label' => 'Descrição',
                'type'  => 'text',
                'rules' => array(
                    'required'
                )
            ),
            'active'      => array(
                'label'   => 'Ativo',
                'type'    => 'radio',
                'options' => array(
                    '1' => 'Sim',
                    '0' => 'Não'
                ),
                'default' => '1',
                'rules'   => array(
                    'required'
                )
            ),
            'url_from'    => array(
                'label' => 'Da url',
                'type'  => 'text',
                'rules' => array(
                    'required'
                )
            ),
            'url_to'      => array(
                'label' => 'Para a url',
                'type'  => 'text',
                'rules' => array(
                    'required'
                )
            ),
            'permanent'   => array(
                'label'   => 'Tipo',
                'type'    => 'radio',
                'options' => array(
                    '1' => 'Permanente',
                    '0' => 'Temporário'
                ),
                'default' => '0',
                'rules'   => array(
                    'required'
                )
            ),
            'method'      => array(
                'label'     => 'Método',
                'type'      => 'checkbox',
                'delimiter' => '|',
                'options'   => array(
                    'HEAD'    => 'HEAD',
                    'GET'     => 'GET',
                    'POST'    => 'POST',
                    'PUT'     => 'PUT',
                    'DELETE'  => 'DELETE',
                    'PATCH'   => 'PATCH',
                    'CONNECT' => 'CONNECT'
                ),
                'default'   => array(
                    'GET',
                    'HEAD'
                ),
                'rules'     => array(
                    'required'
                )
            )
        )
    );

    protected $logger = null;

    protected $mapper = null;

    protected $table = array(
        'title'      => 'Lista de Redirecionamentos',
        'name'       => 'Redirecionamentos',
        'cols'       => array(
            'id'          => '#',
            'description' => 'Descrição',
            'url_from'    => 'Redicionar Url',
            'url_to'      => 'Para Url',
            'active_s'    => 'Ativo',
            'permanent_s' => 'Tipo',
            'method'      => 'Métodos'
        ),
        'actions'    => array(
            array(
                'route'       => 'admin_redirect_create',
                'description' => 'Novo',
                'class'       => 'btn-primary',
                'role'        => 'redirect_create'
            )
        ),
        'rowactions' => array(
            array(
                'route'       => 'admin_redirect_edit',
                'description' => 'Alterar',
                'class'       => 'btn-primary',
                'default'     => true,
                'role'        => 'redirect_edit'
            ),
            array(
                'route'       => 'admin_redirect_remove',
                'description' => 'Remover',
                'class'       => 'btn-danger',
                'confirm'     => true,
                'role'        => 'redirect_remove'
            ),
            array(
                'route'       => 'admin_redirect_test',
                'description' => 'Testar',
                'class'       => 'btn-warning',
                'confirm'     => true,
                'target'      => '_blank'
            )
        ),
        'route'      => 'admin_redirects'
    );

    protected $validator = null;

    public function __construct($f3)
    {
        parent::__construct($f3);

        $this->logger = new \Log(date('Y-m-d').'_redirect.log');
        $this->db     = $f3->get('db');
        $this->mapper = new \DB\SQL\Mapper($this->db, 'hwapx_redirect');
    }

    public function alter($f3)
    {
        $this->module->checkRole('redirect_edit');

        echo FormBuilder::instance($this->mapper, $this->form, $this->logger)->handle();
    }

    public function create($f3)
    {
        $this->module->checkRole('redirect_create');

        echo FormBuilder::instance($this->mapper, $this->form, $this->logger)->handle();
    }

    public function index($f3)
    {
        $this->module->checkRole('redirect_list');

        $this->mapper->active_s    = "CASE active WHEN 1 THEN 'SIM' ELSE 'NÃO' END";
        $this->mapper->permanent_s = "CASE permanent WHEN 1 THEN 'PERMANENTE' ELSE 'TEMPORARIO' END";

        echo TableBuilder::instance($this->mapper, $this->table)->render();
    }

    public function remove($f3)
    {
        $this->module->checkRole('redirect_remove');

        FormBuilder::instance($mapper, $this->form, $this->logger)->delete();

        $f3->reroute('@admin_redirects');
    }

    public function test($f3)
    {
        $this->mapper->load(array('id = ?', $f3->get('PARAMS.id')));

        if ($this->mapper->dry()) {
            $f3->error(404);
        }

        $f3->reroute($this->mapper->url_from, false);
    }
}
