<?php

namespace Softsat\Locacao\Controller\Admin;

use Hwapx\Admin\Controller\Admin\Admin;
use Hwapx\Core\Library\Template;
use Hwapx\Core\Library\Validator;
use HwapX\Admin\Library\Builder\TableBuilder;
use HwapX\Admin\Library\Builder\FormBuilder;
use HwapX\Core\Library\DB\SQL\Mapper;

use Softsat\Locacao\Model\BoletoModel;

class Boleto extends Admin {
    protected $validator = null;
    protected $logger    = null;
    protected $mapper    = null;
    protected $form = array(
        'name'   => 'Boleto',
        'table'  => 'softsat_locacao_admin_boleto_list',
        'groups' => array(
            'sacado' => array(
                'legend' => 'Sacado/Pagador',
                'fields' =>  array(
                    'contrato_id' => array(
                        'label' => 'Contrato',
                        'type'  => 'dropdown',
                        'options'=> array(
                            '' => '-- Selecione --'
                        ),
                        'width' => 6,
                    ),
                    'cliente_id' => array(
                        'label' => 'Cliente',
                        'type'  => 'dropdown',
                        'options'=> array(
                            '' => '-- Selecione --'
                        ),
                        'width' => 6,
                    ),
                    'sacado_nome' => array(
                        'label' => 'Nome',
                        'type'  => 'text',
                        'width' => 8,
                        'rules' => array(
                            'required',
                            'lengthMax' => 40
                        ),
                    ),
                    'sacado_cnpj_cpf' => array(
                        'label' => 'CNPJ/CPF',
                        'type'  => 'text',
                        'width' => 4,
                        'mask'  => '(999.999.999-99)|(99.999.999/9999-99)',
                        'rules' => array(
                            'required',
                            'cnpj_cpf',
                            ////'regex' => '/^[0-9]{3}\.[0-9]{3}\.[0-9]{3}-[0-9]{2}|[0-9]{2}.[0-9]{3}.[0-9]{3}\/[0-9]{4}-[0-9]{2}$/',
                        ),
                        'attributes' => array(
                            'data-inputmask-keepstatic' => 'true'
                        )
                    ),
                    'sacado_endereco' => array(
                        'label' => 'Endereço',
                        'type'  => 'text',
                        'width' => 8,
                        'rules' => array(
                            'required',
                            'lengthMax' => 40
                        ),
                    ),
                    'sacado_bairro' => array(
                        'label' => 'Bairro',
                        'type'  => 'text',
                        'width' => 4,
                        'rules' => array(
                            'required',
                            'lengthMax' => 15
                        ),
                    ),
                    'sacado_cidade' => array(
                        'label' => 'Cidade',
                        'type'  => 'text',
                        'width' => 5,
                        'rules' => array(
                            'required',
                            'lengthMax' => 15
                        ),
                    ),
                    'sacado_uf' => array(
                        'label'   => 'Estado',
                        'type'    => 'dropdown',
                        'width'   => 3,
                        'options' => array(
                            '' => '-- Selecione --',
                            'AC' => 'Acre',
                            'AL' => 'Alagoas',
                            'AP' => 'Amapá',
                            'AM' => 'Amazonas',
                            'BA' => 'Bahia',
                            'CE' => 'Ceará',
                            'DF' => 'Distrito Federal',
                            'ES' => 'Espírito Santo',
                            'GO' => 'Goiás',
                            'MA' => 'Maranhão',
                            'MT' => 'Mato Grosso',
                            'MS' => 'Mato Grosso do Sul',
                            'MG' => 'Minas Gerais',
                            'PA' => 'Pará',
                            'PB' => 'Paraíba',
                            'PR' => 'Paraná',
                            'PE' => 'Pernambuco',
                            'PI' => 'Piauí',
                            'RJ' => 'Rio de Janeiro',
                            'RN' => 'Rio Grande do Norte',
                            'RS' => 'Rio Grande do Sul',
                            'RO' => 'Rondônia',
                            'RR' => 'Roraima',
                            'SC' => 'Santa Catarina',
                            'SP' => 'São Paulo',
                            'SE' => 'Sergipe',
                            'TO' => 'Tocantins',
                        ),
                        'rules' => array(
                            'required'
                        ),
                    ),
                    'sacado_cep' => array(
                        'label' => 'CEP',
                        'type'  => 'text',
                        'width' => 4,
                        'mask'  => '99999-999',
                        'rules' => array(
                            'required'
                        ),
                    ),
                    'sacado_email' => array(
                        'label' => 'Email',
                        'type'  => 'email',
                        'width' => 8,
                        'rules' => array(
                            'email',
                        )
                    ),
                ),
            ),
            'cedente' => array(
                'legend' => 'Cedente',
                'fields' => array(
                    'cedente_nome' => array(
                        'label' => 'Nome',
                        'type'  => 'text',
                        'width' => 8,
                        'rules' => array(
                            'required',
                            'lengthMax' => 40
                        ),
                    ),
                    'cedente_cnpj' => array(
                        'label' => 'CNPJ',
                        'type'  => 'text',
                        'width' => 4,
                        'mask'  => '99.999.999/9999-99',
                        'rules' => array(
                            'required',
                            'cnpj',
                            ////'regex' => '/^[0-9]{3}\.[0-9]{3}\.[0-9]{3}-[0-9]{2}|[0-9]{2}.[0-9]{3}.[0-9]{3}\/[0-9]{4}-[0-9]{2}$/',
                        ),
                        'attributes' => array(
                            'data-inputmask-keepstatic' => 'true'
                        )
                    ),
                    'cedente_endereco' => array(
                        'label' => 'Endereço',
                        'type'  => 'text',
                        'width' => 8,
                        'rules' => array(
                            'required',
                            'lengthMax' => 40
                        ),
                    ),
                    'cedente_bairro' => array(
                        'label' => 'Bairro',
                        'type'  => 'text',
                        'width' => 4,
                        'rules' => array(
                            'lengthMax' => 15
                        ),
                    ),
                    'cedente_cidade' => array(
                        'label' => 'Cidade',
                        'type'  => 'text',
                        'width' => 5,
                        'rules' => array(
                            'required',
                            'lengthMax' => 15
                        ),
                    ),
                    'cedente_uf' => array(
                        'label'   => 'Estado',
                        'type'    => 'dropdown',
                        'width'   => 3,
                        'options' => array(
                            '' => '-- Selecione --',
                            'AC' => 'Acre',
                            'AL' => 'Alagoas',
                            'AP' => 'Amapá',
                            'AM' => 'Amazonas',
                            'BA' => 'Bahia',
                            'CE' => 'Ceará',
                            'DF' => 'Distrito Federal',
                            'ES' => 'Espírito Santo',
                            'GO' => 'Goiás',
                            'MA' => 'Maranhão',
                            'MT' => 'Mato Grosso',
                            'MS' => 'Mato Grosso do Sul',
                            'MG' => 'Minas Gerais',
                            'PA' => 'Pará',
                            'PB' => 'Paraíba',
                            'PR' => 'Paraná',
                            'PE' => 'Pernambuco',
                            'PI' => 'Piauí',
                            'RJ' => 'Rio de Janeiro',
                            'RN' => 'Rio Grande do Norte',
                            'RS' => 'Rio Grande do Sul',
                            'RO' => 'Rondônia',
                            'RR' => 'Roraima',
                            'SC' => 'Santa Catarina',
                            'SP' => 'São Paulo',
                            'SE' => 'Sergipe',
                            'TO' => 'Tocantins',
                        ),
                        'rules' => array(
                            'required'
                        ),
                    ),
                    'cedente_cep' => array(
                        'label' => 'CEP',
                        'type'  => 'text',
                        'width' => 4,
                        'mask'  => '99999-999',
                        'rules' => array(
                            'required'
                        ),
                    ),
                )
            ),
            'boleto' => array(
                'legend' => 'Boleto',
                'fields' => arraY(
                    'sequencia' => array(
                        'label' => 'Sequencia(Nosso Número)',
                        'type' => 'number',
                        'width' => 4,
                        'rules' => array(
                            'required',
                        )
                    ),
                    'agencia' => array(
                        'label' => 'Agencia',
                        'type' => 'text',
                        'width' => 4,
                        'rules' => array(
                            'required',
                        )
                    ),
                    'conta' => array(
                        'label' => 'Conta',
                        'type' => 'text',
                        'width' => 4,
                        'rules' => array(
                            'required',
                        )
                    ),
                    'cod_beneficiario' => array(
                        'label' => 'Código do beneficiário',
                        'type' => 'text',
                        'width' => 4,
                        'rules' => array(
                            'required',
                        )
                    ),
                    'carteira' => array(
                        'label' => 'Carteira',
                        'type' => 'dropdown',
                        'options' => array(
                            '' => '-- Selecione --',
                            '101' => '101',
                            '102' => '102',
                            '201' => '201',
                        ),
                        'width' => 4,
                        'rules' => array(
                            'required',
                        )
                    ),
                    'especie_doc' => array(
                        'label' => 'Especie de documento',
                        'type' => 'text',
                        'width' => 4,
                        'rules' => array(
                            'required',
                        )
                    ),
                    'emissao' => array(
                        'label' => 'Emissão',
                        'type' => 'date',
                        'width' => 4,
                        'rules' => array(
                            'required',
                        )
                    ),
                    'vencimento' => array(
                        'label' => 'Vencimento',
                        'type' => 'date',
                        'width' => 4,
                        'rules' => array(
                            'required',
                        )
                    ),
                    'dias_protesto' => array(
                        'label' => 'Dias para protesto',
                        'type' => 'number',
                        'width' => 4,
                        'rules' => array(
                            'required',
                        )
                    ),
                    'valor' => array(
                        'label' => 'Valor',
                        'type' => 'number',
                        'digits' => 2,
                        'width' => 4,
                        'rules' => array(
                            'required',
                        )
                    ),
                    'multa' => array(
                        'label' => 'Multa %',
                        'type' => 'number',
                        'digits' => 2,
                        'width' => 4,
                        'rules' => array(
                            'required',
                        )
                    ),
                    'multa_valor' => array(
                        'label' => 'Multa R$',
                        'type' => 'number',
                        'digits' => 2,
                        'width' => 4,
                        'rules' => array(
                            'required',
                        )
                    ),
                    'mora' => array(
                        'label' => 'Mora %',
                        'type' => 'number',
                        'digits' => 2,
                        'width' => 4,
                        'rules' => array(
                            'required',
                        )
                    ),
                    'mora_valor' => array(
                        'label' => 'Mora R$',
                        'type' => 'number',
                        'digits' => 2,
                        'width' => 4,
                        'rules' => array(
                            'required',
                        )
                    ),
                    'cancelado' => array(
                        'label' => 'Cancelado',
                        'type' => 'dropdown',
                        'options' => array(
                            '0' => 'Não',
                            '1' => 'Sim'
                        ),
                        'width' => 4,
                        'rules' => array(
                            'required',
                        )
                    ),
                    'demonstrativo' => array(
                        'label' => 'Demonstrativo',
                        'type' => 'textarea',
                        'width' => 12,
                        'rules' => array(
                        )
                    ),
                    'instrucoes' => array(
                        'label' => 'Instruções',
                        'type' => 'textarea',
                        'width' => 12,
                        'rules' => array(
                        )
                    ),
                )
            )
        ),
    );

    protected $form_novo = array(
        'name'   => 'Boleto',
        'table'  => 'softsat_locacao_admin_boleto_list',
        'fields' =>  array(
            'contrato_id' => array(
                'label' => 'Contrato',
                'type'  => 'dropdown',
                'options'=> array(
                    '' => '-- Nenhum --'
                ),
                'rules' => array(
                ),
                'width' => 6,
            ),
            'cliente_id' => array(
                'label' => 'Cliente',
                'type'  => 'dropdown',
                'options'=> array(
                    '' => '-- Selecione --'
                ),
                'rules' => array(
                    'required'
                ),
                'width' => 6,
            ),
            'vencimento' => array(
                'label' => 'Vencimento',
                'type' => 'date',
                'width' => 4,
                'rules' => array(
                    'required',
                )
            ),
            'valor' => array(
                'label' => 'Valor',
                'type' => 'number',
                'digits' => 2,
                'width' => 4,
                'rules' => array(
                    'required',
                )
            ),
            'desconto_valor' => array(
                'label' => 'Desconto p/ pagto até vencimento',
                'type' => 'number',
                'digits' => 2,
                'width' => 4,
                'default' => 0,
                'rules' => array(
                    'required',
                )
            ),
            'demonstrativo' => array(
                'label' => 'Demonstrativo',
                'type' => 'textarea',
                'width' => 12,
            ),
        ),
    );

    protected $table = array(
        'name'   => 'Boletos',
        'cols'   => array(
            'id'    => 'Código',
            'sacado_nome'  => 'Sacado/Pagador',
            'sacado_cnpj_cpf'   => array(
                'label' => 'CNPJ/CPF',
                //'mask'  => '(999.999.999-99)|(99.999.9999/9999-99)',
            ),
            'sequencia' => 'Nosso número',
            'contrato_id' => 'Contrato',
            'valor'   => array(
                'label' => 'Valor',
                'type' => 'number',
                'digits' => 2
            ),
            'vencimento' => array(
                'label' => 'Vencimento',
                'mask' => '99/99/9999',
                'type' => 'date'
            )
        ),
        'actions' => array(
            array(
                'route'       => 'softsat_locacao_admin_boleto_create',
                'description' => 'Novo',
                'class'       => 'btn-primary',
                'role'        => 'softsat.locacao.boleto_create'
            )
        ),
        'rowactions' => array(
            array(
                'route'       => 'softsat_locacao_admin_boleto_edit',
                'description' => 'Alterar',
                'class'       => 'btn-primary',
                'default'     => true,
                'role'        => 'softsat.locacao.boleto_edit'
            ),
            array(
                'route'       => 'softsat_locacao_admin_boleto_remove',
                'description' => 'Remover',
                'class'       => 'btn-danger',
                'confirm'     => true,
                'role'        => 'softsat.locacao.boleto_remove'
            ),
            array(
                'route'       => 'softsat_locacao_admin_boleto_print',
                'description' => 'Imprimir',
                'class'       => 'btn-default',
                'role'        => 'softsat.locacao.boleto_print'
            ),
            array(
                'route'       => 'softsat_locacao_admin_boleto_email',
                'description' => 'E-mail',
                'class'       => 'btn-warning',
                'role'        => 'softsat.locacao.boleto_email'
            )
        ),
        'legend' => array(
            '' => 'Sem remessa',
            'info' => 'Com remessa',
            'warning' => 'Cancelado sem remessa',
            'danger' => 'Cancelado com remessa',
            'active' => 'Descartado'
        ),
        'rowcount' => true,
        'route'    => 'softsat_locacao_admin_boleto_list'
    );

    public function __construct($f3) {
        parent::__construct($f3);

        $db           = $f3->get('db');
        $this->mapper = new \DB\SQL\Mapper($db, 'softsat_locacao_boleto');
        
        $mapper = new Mapper($db, 'softsat_locacao_cliente');

        foreach ($mapper->find() as $cliente) {
            $this->form['groups']['sacado']['fields']['cliente_id']['options'][$cliente->id] = "[$cliente->cnpj_cpf] $cliente->nome";
            $this->form_novo['fields']['cliente_id']['options'][$cliente->id] = "[$cliente->cnpj_cpf] $cliente->nome";
        }

        $mapper = new Mapper($db, 'softsat_locacao_contrato');
        $mapper->cliente = 'SELECT softsat_locacao_cliente.nome FROM softsat_locacao_cliente WHERE softsat_locacao_cliente.id = softsat_locacao_contrato.cliente_id';
        foreach ($mapper->find() as $contrato) {
            $this->form['groups']['sacado']['fields']['contrato_id']['options'][$contrato->id] = "[{$contrato->id}] {$contrato->cliente}";
            $this->form_novo['fields']['contrato_id']['options'][$contrato->id] = array(
                'label' => "[$contrato->id] $contrato->cliente",
                'attributes' => array(
                    'data-cliente_id' => $contrato->cliente_id
                )
            );
        }
    }

    public function index($f3) {
        $this->module->checkRole('softsat.locacao.boleto_list');
        
        $this->table['rowcallback'] = function($mapper) {
            $data = array();

            if($mapper->cancelado) {
                if($mapper->remessa_criacao) {
                    if($mapper->remessa_baixa)
                        $data['class'] = 'danger';
                    else
                        $data['class'] = 'warning';
                } else {
                    $data['class'] = 'active';
                }
            } else {
                if($mapper->remessa_criacao)
                    $data['class'] = 'info';
                else
                    $data['class'] = '';
            }

            return $data;
        };

        echo TableBuilder::instance($this->mapper, $this->table)->render(null, null, array('order' => 'id DESC'));
    }

    public function create($f3) {
        $this->module->checkRole('softsat.locacao.boleto_create');

        $this->f3->set('meta.styles.raw.contrato', '
        select[readonly].select2-hidden-accessible + .select2-container {
            pointer-events: none;
            touch-action: none;
        }
    
        select[readonly].select2-hidden-accessible + .select2-container .select2-selection {
            background: #eee;
            box-shadow: none;
        }
    
        select[readonly].select2-hidden-accessible + .select2-container .select2-selection__arrow, select[readonly].select2-hidden-accessible + .select2-container .select2-selection__clear {
            display: none;
        }
        ');

        $this->f3->set('meta.scripts.raw.contrato', '
        $(document).ready(function() {
            $("[name=contrato_id]").change(function() {
                var $this = $(this);
                var $cliente = $("[name=cliente_id]");
                var contratoId = this.value;
                var clienteId = null;

                if(contratoId) {
                    var $opt = $this.find("option[value=" + contratoId + "]");
                    clienteId = $opt.data("cliente_id");
                    $cliente.attr("readonly", true);
                } else {
                    $cliente.removeAttr("readonly");
                }

                $cliente.val(clienteId).trigger("change");
            });
        });
        ');

        echo FormBuilder::instance($this->mapper, $this->form_novo)
                        ->beforeSave(function($mapper) {
                            $mapper->avulso = 1;
                        })->handle();
    }

    public function edit($f3) {
        $this->module->checkRole('softsat.locacao.boleto_edit');

        echo FormBuilder::instance($this->mapper, $this->form)->handle();
    }

    public function remove($f3, $args) {
        $this->module->checkRole('softsat.locacao.boleto_remove');

        $db = $f3->get('db');
        $mapper = new Mapper($db, 'softsat_locacao_boleto');

        if($mapper->load(array('id = ?', $args['id'])) && $mapper->remessa_criacao) {
            flash('error', 'O boleto selecionado já consta em uma remessa. Não é permitido exclui-lo');
            $f3->reroute('@softsat_locacao_admin_boleto_list');
            return;
        }

        echo FormBuilder::instance($this->mapper, $this->form)->delete();
    }
    
    public function preview($f3) {
        $this->module->checkRole('softsat.locacao.boleto_print');

        $db     = $f3->get('db');
        $boleto = new Mapper($db, 'softsat_locacao_boleto');

        $data = array(
            'boleto' => $boleto->findone(array('id = ?', $f3->get('PARAMS.id')))
        );

        if(!$data['boleto'])
            $this->f3->error(404);

        echo Template::instance()->render('softsat/locacao/boleto/preview.html', null, $data);
    }

    public function pdf($f3) {
        $this->module->checkRole('softsat.locacao.boleto_print');
        
        $boleto = new BoletoModel($f3);
        $data   = $boleto->renderBoletoPdf($f3->get('PARAMS.id'));

        if(!$data) {
            $this->f3->error(404);
            return;
        }

        header('content-type: application/pdf');
        echo $data;
    }

    public function email($f3) {
        $this->module->checkRole('softsat.locacao.boleto_email');

        $db     = $f3->get('db');
        $boleto = new Mapper($db, 'softsat_locacao_boleto');

        if(!$boleto->load(array('id = ?', $f3->get('PARAMS.id')))) {
            $this->f3->error(404);
            return;
        }

        if(!$boleto->sacado_email) {
            flash('error', 'O sacado não possui e-mail, não é possível enviar.');
            $this->f3->reroute('@softsat_locacao_admin_boleto_list');
            return;
        }

        $model = new BoletoModel($f3);
        $filename = $model->boletoPdf($f3->get('PARAMS.id'));

        SMTPEnqueue('softsat_locacao_boleto_avulso', $boleto->cast(), $boleto->sacado_email, array('boleto.pdf' => $filename));
        flash('success', 'E-mail enviado para '.$boleto->sacado_email);
        $this->f3->reroute('@softsat_locacao_admin_boleto_list');
    }
}
