<?php

namespace Softsat\Locacao\Controller\Admin;

use Hwapx\Admin\Controller\Admin\Admin;
use Hwapx\Core\Library\Template;
use Hwapx\Core\Library\Validator;
use HwapX\Admin\Library\Builder\TableBuilder;
use HwapX\Admin\Library\Builder\FormBuilder;
use HwapX\Core\Library\DB\SQL\Mapper;

use \CnabPHP\Remessa;

class Boletoremessa extends Admin {
    protected $table = array(
        'name'   => 'Remessas de boleto',
        'cols'   => array(
            //'id'   => 'Código',
            'numero' => 'Número',
            'emissao' => array(
                'label' => 'Emissão',
                'mask'  => '99/99/9999',
            ),
        ),
        'actions' => array(
            array(
                'route'       => 'softsat_locacao_admin_boleto_remessa_create',
                'description' => 'Gerar remessa',
                'class'       => 'btn-primary',
                'role'        => 'softsat.locacao.boleto_remessa_create'
            )
        ),
        'rowactions' => array(
            array(
                'route'       => 'softsat_locacao_admin_boleto_remessa_download',
                'description' => 'Download',
                'class'       => 'btn-primary',
                'role'        => 'softsat.locacao.boleto_remessa_download'
            ),
        ),
        'rowcount' => true,
        'route'       => 'softsat_locacao_admin_boleto_remessa_list'
    );

    public function __construct($f3) {
        parent::__construct($f3);

        $db           = $f3->get('db');
        $this->mapper = new \DB\SQL\Mapper($db, 'softsat_locacao_boleto_remessa');
    }

    public function index($f3) {
        $this->module->checkRole('softsat.locacao.boleto_remessa_list');

        $db = $f3->get('db');
        $estatisticas = $db->exec('SELECT 
                                SUM(IF(cancelado = 0 AND remessa_criacao IS NULL, 1, 0)) AS criados,
                                SUM(IF(cancelado = 1 AND remessa_criacao IS NOT NULL AND remessa_baixa IS NULL, 1, 0)) AS cancelados 
                            FROM softsat_locacao_boleto')[0];

        if($estatisticas['criados'] + $estatisticas['cancelados'] > 0)
            flash('warning', "Existem {$estatisticas['criados']} novos boletos e {$estatisticas['cancelados']} cancelados sem remessa");
        else
            unset($this->table['actions']);
        
        echo TableBuilder::instance($this->mapper, $this->table)->render(null, null, array('order' => 'id DESC'));
    }

    public function create($f3) {
        $this->module->checkRole('softsat.locacao.boleto_remessa_create');

        $db = $f3->get('db');

        $db->exec('CALL softsat_locacao_boleto_remessa_gerar()');
        $id = $db->exec('SELECT MAX(id) AS id FROM softsat_locacao_boleto_remessa')[0]['id'];

        if($this->module->hasRole('softsat.locacao.boleto_remessa_download'))
            $f3->reroute("@softsat_locacao_admin_boleto_remessa_download(@id=$id)");
        else
            $f3->reroute("@softsat_locacao_boleto_remessa_list");
    }

    public function download($f3) {
        $this->module->checkRole('softsat.locacao.boleto_remessa_download');

        $db = $f3->get('db');
        $mapper   = new Mapper($db, 'softsat_locacao_boleto');
        $remessa  = new Mapper($db, 'softsat_locacao_boleto_remessa');
        $settings = $f3->get('settings.softsat.locacao.boleto');
        $cedente  = $settings['cedente'];
        $agencia  = explode('-', $settings['agencia']);
        $conta    = explode('-', $settings['conta']);
        $cod_benef= explode('-', $settings['cod_beneficiario']);
        $template = Template::instance();

        if(!$remessa->load(array('id = ?', $f3->get('PARAMS.id'))))
            $f3->error(404);

        $boletos  = $mapper->find(array('remessa_criacao = :numero OR remessa_baixa = :numero', ':numero' => $remessa->numero));

        $arquivo = new Remessa('033','cnab240',array(
            'nome_empresa' => $cedente['nome'], // seu nome de empresa
            'tipo_inscricao'  => 2, // 1 para cpf, 2 cnpj 
            'numero_inscricao' => $cedente['cnpj'], // seu cpf ou cnpj completo
            'agencia'       => $agencia[0], // agencia sem o digito verificador 
            'agencia_dv'    => $agencia[1], // somente o digito verificador da agencia 
            'conta'         => $conta[0], // número da conta
            'conta_dv'     => $conta[1], // digito da conta
            'codigo_beneficiario'    => $cod_benef[0], // codigo fornecido pelo banco
            'codigo_beneficiario_dv' => $cod_benef[1],
            'numero_sequencial_arquivo' => $remessa->numero, // sequencial do arquivo um numero novo para cada arquivo gerado
        ));

        $lote  = $arquivo->addLote(array('tipo_servico'=> 1/*, 'codigo_transmissao' => $settings['cod_transmissao']*/)); // tipo_servico  = 1 para cobrança registrada, 2 para sem registro

        foreach($boletos as $boleto) {
            $instrucoes = $template->resolve($boleto->instrucoes, array('boleto' => $boleto->cast()));

            $lote->inserirDetalhe(array(
                'codigo_movimento'  => $boleto->cancelado ? 2 : 1, //1 = Entrada de título, para outras opçoes ver nota explicativa C004 manual Cnab_SIGCB na pasta docs
                'nosso_numero'      => $boleto->sequencia, // numero sequencial de boleto
                'seu_numero'        => $boleto->id,// se nao informado usarei o nosso numero 
                
                /* campos necessarios somente para itau e siccob,  não precisa comentar se for outro layout    */
                //'carteira_banco'    => $boleto->carteira, // codigo da carteira ex: 109,RG esse vai o nome da carteira no banco
                //'cod_carteira'      => $boleto->carteira, // I para a maioria ddas carteiras do itau
                /*----------------------------------------------------------------------------------------    */
                 
                'especie_titulo'    => $boleto->especie_doc, // informar dm e sera convertido para codigo em qualquer laytou conferir em especie.php
                'valor'             => $boleto->valor, // Valor do boleto como float valido em php
                'emissao_boleto'    => 2, // tipo de emissao do boleto informar 2 para emissao pelo beneficiario e 1 para emissao pelo banco
                'prazo_protesto'    => (int)$boleto->dias_protesto, // Informar o numero de dias apos o vencimento para iniciar o protesto
                'protestar'         => (int)$boleto->dias_protesto ? 1 : 0, // 1 = Protestar com (Prazo) dias, 3 = Devolver após (Prazo) dias
                'nome_pagador'      => $boleto->sacado_nome, // O Pagador é o cliente, preste atenção nos campos abaixo
                'tipo_inscricao'    => strlen($boleto->sacado_cnpj_cpf) == 18 ? 2 : 1, //campo fixo, escreva '1' se for pessoa fisica, 2 se for pessoa juridica
                'numero_inscricao'  => $boleto->sacado_cnpj_cpf,//cpf ou ncpj do pagador
                'endereco_pagador'  => $boleto->sacado_endereco,
                'bairro_pagador'    => $boleto->sacado_bairro,
                'cep_pagador'       => $boleto->sacado_cep, // com hífem
                'cidade_pagador'    => $boleto->sacado_cidade,
                'uf_pagador'        => $boleto->sacado_uf,
                'data_vencimento'   => $boleto->vencimento, // informar a data neste formato
                'data_emissao'      => $boleto->emissao, // informar a data neste formato
                'vlr_juros'         => $boleto->mora_valor, // Valor do juros de 1 dia'
                'codigo_desconto'   => $boleto->desconto_valor > 0 ? 1 : 0,
                'data_desconto'     => $boleto->desconto_valor > 0 ? $boleto->vencimento : '', // informar a data neste formato
                'vlr_desconto'      => $boleto->desconto_valor, // Valor do desconto
                'baixar'            => 2, // codigo para indicar o tipo de baixa '1' (Baixar/ Devolver) ou '2' (Não Baixar / Não Devolver)
                'prazo_baixar'      => $settings['dias_baixa'], // prazo de dias para o cliente pagar após o vencimento
                'mensagem'          => $instrucoes,
                'email_pagador'     => $boleto->sacado_email,
                'data_multa'        => $boleto->vencimento, // informar a data neste formato, // data da multa
                'vlr_multa'         => $boleto->multa, // valor da multa
                'codigo_multa'      => 2,
                'tipo_documento' => 2,
                'codigo_juros'   => 1,
                'data_juros'     => $boleto->vencimento,
                
                // campos necessários somente para o sicoob
                //'taxa_multa'         => 30.00, // taxa de multa em percentual
                //'taxa_juros'         => 30.00, // taxa de juros em percentual
            ));
        }

        $data = $arquivo->getText();

        $filename = "remessa-{$remessa->numero}.rem";

        header('Content-Description: File Transfer');
        header('Content-Type: application/octet-stream');
        header('Content-Disposition: attachment; filename=' . $filename); 
        header('Content-Transfer-Encoding: binary');
        header('Connection: Keep-Alive');
        header('Expires: 0');
        header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
        header('Pragma: public');
        //header('Content-Length: ' . $size);
        echo $data;
    }
}
