<?php

namespace Softsat\Locacao\Controller;

use Hwapx\Admin\Controller\Admin\Admin;
use Hwapx\Core\Library\Template;
use Hwapx\Core\Library\Validator;
use HwapX\Admin\Library\Builder\TableBuilder;
use HwapX\Admin\Library\Builder\FormBuilder;
use HwapX\Core\Library\DB\SQL\Mapper;

class Boletoretorno extends Admin {
    protected $validator = null;
    protected $logger    = null;
    protected $mapper    = null;
    protected $form = array(
        'name'   => 'Arquivo de retorno',
        'table'  => 'softsat_locacao_boleto_retorno_list',
        'fields' =>  array(
            'data' => array(
                'label' => 'Data',
                'type'  => 'date',
                'width' => 3,
                'rules' => array(
                    'required'
                )
            ),
            'arquivo' => array(
                'label' => 'Tabela(Arquivo)',
                'type'  => 'file',
                'width' => 9,
                'rules' => array(
                    'required',
                    'file'
                )
            ),
        ),
    );

    protected $table = array(
        'name'   => 'Arquivos de retorno',
        'cols'   => array(
            'id'   => 'Código',
            'data' => 'Data',
        ),
        'actions' => array(
            array(
                'route'       => 'softsat_locacao_boleto_retorno_create',
                'description' => 'Nova',
                'class'       => 'btn-primary',
                'role'        => 'softsat.locacao.boleto_retorno_create'
            )
        ),
        'rowactions' => array(
            array(
                'route'       => 'softsat_locacao_boleto_retorno_remove',
                'description' => 'Remover',
                'class'       => 'btn-danger',
                'confirm'     => true,
                'role'        => 'softsat.locacao.boleto_retorno_remove'
            ),
        ),
        'rowcount' => true,
        'route'    => 'softsat_locacao_boleto_retono_list',
    );

    public function __construct($f3) {
        parent::__construct($f3);

        $db           = $f3->get('db');
        $this->mapper = new \DB\SQL\Mapper($db, 'softsat_locacao_boleto_retorno');
    }

    public function index($f3) {
        $this->module->checkRole('softsat.locacao.boleto_retorno_list');

        $db = $f3->get('db');

        $versaoAtual = $db->exec('SELECT MAX(versao) AS versao FROM softsat_ibpt_tabela ' . 
          'WHERE CURRENT_DATE BETWEEN vigenciainicio AND vigenciafim')[0]['versao'];

        $this->table['rowcallback'] = function($mapper) use($f3, $versaoAtual) {
            $data = array();

            if($mapper->versao == $versaoAtual)
                $data['class'] = 'success';
            elseif(strtotime($mapper->vigenciainicio) > time())
                $data['class'] = 'info';
            elseif(strtotime($mapper->vigenciafim) > strtotime('-1 month'))
                $data['class'] = '';
            else
                $data['class'] = 'active';

            return $data;
        };

        echo TableBuilder::instance($this->mapper, $this->table)->render();
    }

    public function create($f3) {
        $this->module->checkRole('softsat.locacao.boleto_retorno_create');

        $this->appendScripts();

        echo FormBuilder::instance($this->mapper, $this->form)->handle();
    }

    public function remove($f3) {
        $this->module->checkRole('softsat.locacao.boleto_retorno_remove');

        echo FormBuilder::instance($this->mapper, $this->form)->delete();
    }
}
