<?php

namespace Softsat\Locacao\Controller\Admin;

use Hwapx\Admin\Controller\Admin\Admin;
use Hwapx\Core\Library\Template;
use Hwapx\Core\Library\Validator;
use HwapX\Admin\Library\Builder\TableBuilder;
use HwapX\Admin\Library\Builder\FormBuilder;
use HwapX\Core\Library\DB\SQL\Mapper;

class Checklist extends Admin {
    protected $validator = null;
    protected $logger    = null;
    protected $mapper    = null;
    protected $form = array(
        'name'   => 'Item do Checklist',
        'table'  => 'softsat_locacao_admin_checklist_list',
        'depends'=> array(
            'softsat_locacao_contrato_checklist' => array(
                'name' => 'Contrato',
                'foreignkey' => 'checklist_id'
            ),
        ),
        'fields' =>  array(
            'descricao' => array(
                'label' => 'Descrição',
                'type'  => 'text',
                'width' => 9,
                'rules' => array(
                    'required'
                )
            ),
            'ativo' => array(
                'label' => 'Ativo',
                'type'  => 'dropdown',
                'width' => 3,
                'default' => 1,
                'options' => array(
                    1 => 'Sim',
                    0 => 'Não',
                ),
                'rules' => array(
                    'required'
                )
            ),
        )
    );

    protected $table = array(
        'name'   => 'Itens do checklist',
        'cols'   => array(
            'id'        => 'Código',
            'descricao' => 'Descrição',
        ),
        'actions' => array(
            array(
                'route'       => 'softsat_locacao_admin_checklist_create',
                'description' => 'Novo',
                'class'       => 'btn-primary',
                'role'        => 'softsat.locacao.checklist_create'
            )
        ),
        'rowactions' => array(
            array(
                'route'       => 'softsat_locacao_admin_checklist_edit',
                'description' => 'Alterar',
                'class'       => 'btn-primary',
                'default'     => true,
                'role'        => 'softsat.locacao.checklist_edit'
            ),
            array(
                'route'       => 'softsat_locacao_admin_checklist_remove',
                'description' => 'Remover',
                'class'       => 'btn-danger',
                'confirm'     => true,
                'role'        => 'softsat.locacao.checklist_remove'
            )
        ),
        'rowcount' => true,
        'route'    => 'softsat_locacao_admin_checklist_list',
        'legend'   => array(
            'default' => 'Ativo',
            'danger'  => 'Inativo',
        )
    );

    public function __construct($f3) {
        parent::__construct($f3);

        $db           = $f3->get('db');
        $this->mapper = new \DB\SQL\Mapper($db, 'softsat_locacao_checklist');    
    }

    public function index($f3) {
        $this->module->checkRole('softsat.locacao.checklist_list');
        
        $this->table['rowcallback'] = function($mapper) {
            return array('class' => $mapper->ativo ? '' : 'danger');
        };
        
        echo TableBuilder::instance($this->mapper, $this->table)->render();
    }

    public function create($f3) {
        $this->module->checkRole('softsat.locacao.checklist_create');

        echo FormBuilder::instance($this->mapper, $this->form)->handle();
    }

    public function edit($f3) {
        $this->module->checkRole('softsat.locacao.checklist_edit');

        echo FormBuilder::instance($this->mapper, $this->form)->handle();
    }

    public function remove($f3) {
        $this->module->checkRole('softsat.locacao.checklist_remove');

        echo FormBuilder::instance($this->mapper, $this->form)->delete();
    }

    /*public function __construct($f3) {
        parent::__construct($f3);

        $db   = $f3->get('db');
        $this->mappers = array(
            new \DB\SQL\Mapper($db, 'softsat_process_correspondente'),
            'etapas' => new \DB\SQL\Mapper($db, 'softsat_process_etapa'),
        );
    }

    public function edit2($f3) {
        $this->module->checkRole('softsat.process.etapa_edit');

        $f3->set('PARAMS.id', $f3->get('SESSION.admin.correspondente_id'));

        echo FormBuilder::instance($this->mappers, $this->form)->handle();
    }*/
}
