<?php

namespace Softsat\Locacao\Controller\Admin;

use Hwapx\Admin\Controller\Admin\Admin;
use Hwapx\Core\Library\Template;
use Hwapx\Core\Library\Validator;
use HwapX\Admin\Library\Builder\TableBuilder;
use HwapX\Admin\Library\Builder\FormBuilder;
use HwapX\Core\Library\DB\SQL\Mapper;

class Combustivel extends Admin {
    protected $validator = null;
    protected $logger    = null;
    protected $mapper    = null;
    protected $form = array(
        'name'   => 'Combustível',
        'table'  => 'softsat_locacao_admin_combustivel_list',
        'depends'=> array(
            'softsat_locacao_veiculo' => array(
                'name' => 'Veículos',
                'foreignkey' => 'combustivel_id'
            ),
        ),
        'fields' =>  array(
            'nome' => array(
                'label' => 'Nome',
                'type'  => 'text',
                'width' => 12,
                'rules' => array(
                    'required'
                )
            ),
        )
    );

    protected $table = array(
        'name'   => 'Combustíveis',
        'cols'   => array(
            'id'   => 'Código',
            'nome' => 'Nome',
        ),
        'actions' => array(
            array(
                'route'       => 'softsat_locacao_admin_combustivel_create',
                'description' => 'Novo',
                'class'       => 'btn-primary',
                'role'        => 'softsat.locacao.combustivel_create'
            )
        ),
        'rowactions' => array(
            array(
                'route'       => 'softsat_locacao_admin_combustivel_edit',
                'description' => 'Alterar',
                'class'       => 'btn-primary',
                'default'     => true,
                'role'        => 'softsat.locacao.combustivel_edit'
            ),
            array(
                'route'       => 'softsat_locacao_admin_combustivel_remove',
                'description' => 'Remover',
                'class'       => 'btn-danger',
                'confirm'     => true,
                'role'        => 'softsat.locacao.combustivel_remove'
            )
        ),
        'rowcount' => true,
        'route'       => 'softsat_locacao_admin_combustivel_list'
    );

    public function __construct($f3) {
        parent::__construct($f3);

        $db           = $f3->get('db');
        $this->mapper = new \DB\SQL\Mapper($db, 'softsat_locacao_combustivel');    }

    public function index($f3) {
        $this->module->checkRole('softsat.locacao.combustivel_list');
        
        echo TableBuilder::instance($this->mapper, $this->table)->render();
    }

    public function create($f3) {
        $this->module->checkRole('softsat.locacao.combustivel_create');

        echo FormBuilder::instance($this->mapper, $this->form)->handle();
    }

    public function edit($f3) {
        $this->module->checkRole('softsat.locacao.combustivel_edit');

        echo FormBuilder::instance($this->mapper, $this->form)->handle();
    }

    public function remove($f3) {
        $this->module->checkRole('softsat.locacao.combustivel_remove');

        echo FormBuilder::instance($this->mapper, $this->form)->delete();
    }
}
