<?php

namespace Softsat\Locacao\Controller\Admin;

use Hwapx\Admin\Controller\Admin\Admin;
use Hwapx\Core\Library\Template;
use Hwapx\Core\Library\Validator;
use HwapX\Admin\Library\Builder\TableBuilder;
use HwapX\Admin\Library\Builder\FormBuilder;
use HwapX\Core\Library\DB\SQL\Mapper;

class Despesa extends Admin {
    protected $validator = null;
    protected $logger    = null;
    protected $mapper    = null;
    protected $form = array(
        'name'   => 'Despesa',
        'table'  => 'softsat_locacao_admin_despesa_list',
        'fields' =>  array(
            'veiculo_id' => array(
                'label' => 'Veículo',
                'type'  => 'dropdown',
                'options' => array(
                    '' => '-- Nenhum --'
                ),
                'width' => 9,
                'rules' => array(
                )
            ),
            'data' => array(
                'label'  => 'Data',
                'type'   => 'date',
                'width'  => 3,
                'rules'  => array(
                    'required'
                )
            ),
            'plano_conta_id' => array(
                'label' => 'Plano de conta',
                'type'  => 'dropdown',
                'options' => array(
                    '' => '-- Selecione --'
                ),
                'width' => 9,
                'rules' => array(
                    'required'
                )
            ),
            'valor' => array(
                'label'  => 'Valor',
                'type'   => 'number',
                'width'  => 3,
                'digits' => 2,
                'rules'  => array(
                    'required'
                )
            ),
            'observacao' => array(
                'label'  => 'Observação',
                'type'   => 'textarea',
                'width'  => 12
            ),
        )
    );

    protected $table = array(
        'name'   => 'Despesas',
        'cols'   => array(
            'id'          => 'Código',
            'plano_conta' => array(
                'label' => 'Plano de conta',
                'mask'  => '1.99.99',
            ),
            'veiculo'     => 'Veículo',
            'data'        => array(
                'label' => 'Data',
                'type'  => 'date',
                'mask'  => '99/99/9999',
            ),
            'valor'       => array(
                'label'  => 'Valor',
                'type'   => 'number',
                'digits' => 2,
            ),
        ),
        'actions' => array(
            array(
                'route'       => 'softsat_locacao_admin_despesa_create',
                'description' => 'Novo',
                'class'       => 'btn-primary',
                'role'        => 'softsat.locacao.despesa_create'
            )
        ),
        'rowactions' => array(
            array(
                'route'       => 'softsat_locacao_admin_despesa_edit',
                'description' => 'Alterar',
                'class'       => 'btn-primary',
                'default'     => true,
                'role'        => 'softsat.locacao.despesa_edit'
            ),
            array(
                'route'       => 'softsat_locacao_admin_despesa_remove',
                'description' => 'Remover',
                'class'       => 'btn-danger',
                'confirm'     => true,
                'role'        => 'softsat.locacao.despesa_remove'
            )
        ),
        'rowcount' => true,
        'route'       => 'softsat_locacao_admin_despesa_list'
    );

    public function __construct($f3) {
        parent::__construct($f3);

        $db           = $f3->get('db');
        $this->mapper = new Mapper($db, 'softsat_locacao_despesa');

        $mapper = new Mapper($db, 'softsat_locacao_veiculo_detalhe');

        foreach ($mapper->find(array('inativado_em IS NULL OR inativado_em > CURRENT_DATE')) as $veiculo) {
            $this->form['fields']['veiculo_id']['options'][$veiculo->id] = $veiculo->descricao;
        }

        $mapper = new Mapper($db, 'softsat_locacao_plano_conta');

        foreach ($mapper->find(array(''), array('order' => 'conta')) as $plano) {
            $option = array(
                'label' => "[{$plano->conta}] {$plano->nome}"
            );

            if(strlen($plano->conta) != 7)
                $option['attributes'] = array('disabled' => 'disabled');

            $this->form['fields']['plano_conta_id']['options'][$plano->id] = $option;
        }
    }

    public function index($f3) {
        $this->module->checkRole('softsat.locacao.despesa_list');

        $db           = $f3->get('db');
        $this->mapper = new Mapper($db, 'softsat_locacao_despesa_detalhe');

        echo TableBuilder::instance($this->mapper, $this->table)->render();
    }

    public function create($f3) {
        $this->module->checkRole('softsat.locacao.despesa_create');

        echo FormBuilder::instance($this->mapper, $this->form)->handle();
    }

    public function edit($f3) {
        $this->module->checkRole('softsat.locacao.despesa_edit');

        echo FormBuilder::instance($this->mapper, $this->form)->handle();
    }

    public function remove($f3) {
        $this->module->checkRole('softsat.locacao.despesa_remove');

        echo FormBuilder::instance($this->mapper, $this->form)->delete();
    }
}
