<?php

namespace Softsat\Locacao\Controller\Admin;

use Hwapx\Admin\Controller\Admin\Admin;
use Hwapx\Core\Library\Template;
use Hwapx\Core\Library\Validator;
use HwapX\Admin\Library\Builder\TableBuilder;
use HwapX\Admin\Library\Builder\FormBuilder;
use HwapX\Core\Library\DB\SQL\Mapper;

class Formapagamento extends Admin {
    protected $validator = null;
    protected $logger    = null;
    protected $mapper    = null;
    protected $form = array(
        'name'   => 'Forma de Pagamento',
        'table'  => 'softsat_locacao_admin_forma_pagamento_list',
        'depends'=> array(
            'softsat_locacao_contrato' => array(
                'name' => 'Contratos',
                'foreignkey' => 'forma_pagamento_id'
            ),
        ),
        'fields' =>  array(
            'nome' => array(
                'label' => 'Nome',
                'type'  => 'text',
                'width' => 12,
                'rules' => array(
                    'required'
                )
            ),
        )
    );

    protected $table = array(
        'name'   => 'Formas de Pagamento',
        'cols'   => array(
            'id'   => 'Código',
            'nome' => 'Nome',
        ),
        'actions' => array(
            array(
                'route'       => 'softsat_locacao_admin_forma_pagamento_create',
                'description' => 'Nova',
                'class'       => 'btn-primary',
                'role'        => 'softsat.locacao.forma_pagamento_create'
            )
        ),
        'rowactions' => array(
            array(
                'route'       => 'softsat_locacao_admin_forma_pagamento_edit',
                'description' => 'Alterar',
                'class'       => 'btn-primary',
                'default'     => true,
                'role'        => 'softsat.locacao.forma_pagamento_edit'
            ),
            array(
                'route'       => 'softsat_locacao_admin_forma_pagamento_remove',
                'description' => 'Remover',
                'class'       => 'btn-danger',
                'confirm'     => true,
                'role'        => 'softsat.locacao.forma_pagamento_remove'
            )
        ),
        'rowcount' => true,
        'route'       => 'softsat_locacao_admin_forma_pagamento_list'
    );

    public function __construct($f3) {
        parent::__construct($f3);

        $db           = $f3->get('db');
        $this->mapper = new \DB\SQL\Mapper($db, 'softsat_locacao_forma_pagamento');    }

    public function index($f3) {
        $this->module->checkRole('softsat.locacao.forma_pagamento_list');
        
        echo TableBuilder::instance($this->mapper, $this->table)->render();
    }

    public function create($f3) {
        $this->module->checkRole('softsat.locacao.forma_pagamento_create');

        echo FormBuilder::instance($this->mapper, $this->form)->handle();
    }

    public function edit($f3) {
        $this->module->checkRole('softsat.locacao.forma_pagamento_edit');

        echo FormBuilder::instance($this->mapper, $this->form)->handle();
    }

    public function remove($f3) {
        $this->module->checkRole('softsat.locacao.forma_pagamento_remove');

        echo FormBuilder::instance($this->mapper, $this->form)->delete();
    }
}
