<?php

namespace Softsat\Locacao\Controller\Admin;

use Hwapx\Admin\Controller\Admin\Admin;
use Hwapx\Core\Library\Template;
use Hwapx\Core\Library\Validator;
use HwapX\Admin\Library\Builder\TableBuilder;
use HwapX\Admin\Library\Builder\FormBuilder;
use HwapX\Core\Library\DB\SQL\Mapper;

class Ipva extends Admin {
    protected $validator = null;
    protected $logger    = null;
    protected $mappers   = array();
    protected $form = array(
        'name'   => 'Tabela de vencimentos do IPVA',
        'table'  => 'softsat_locacao_admin_ipva_list',
        /*'depends'=> array(
            'softsat_locacao_veiculo' => array(
                'name' => 'Veículos',
                'foreignkey' => 'ipva_id'
            ),
        ),*/
        'groups' => array(
            'ano' => array(
                'legend' => 'IPVA',
                'fields' =>  array(
                    'ano' => array(
                        'label' => 'Ano',
                        'type'  => 'number',
                        'width' => 4,
                        'digits'=> 0,
                        'rules' => array(
                            'required'
                        )
                    ),
                ),
            ),
        )
    );

    protected $parcelas_table = array(
        'legend' => 'Final %d',
        'foreignkey' => 'ipva_id',
        'filter' => array('final_placa = %d'),
        'table' =>  array(
            'parcela' => array(
                'label' => 'Parcela',
                'type'  => 'number',
                'rules' => array(
                    'required'
                )
            ),
            'descricao' => array(
                'label' => 'Descrição',
                'type'  => 'text',
                'rules' => array(
                    'required'
                )
            ),
            'vencimento' => array(
                'label' => 'Vencimento',
                'type'  => 'date',
                'rules' => array(
                    'required'
                )
            ),
            'final_placa' => array(
                'label' => 'Final placa',
                'type'  => 'hidden',
                'default' => '%d'
            ),
        ),
    );

    protected $table = array(
        'name'   => 'Tabelas de vencimentos do IPVA',
        'cols'   => array(
            'id'  => 'Código',
            'ano' => 'Ano',
        ),
        'actions' => array(
            array(
                'route'       => 'softsat_locacao_admin_ipva_create',
                'description' => 'Novo',
                'class'       => 'btn-primary',
                'role'        => 'softsat.locacao.ipva_create'
            )
        ),
        'rowactions' => array(
            array(
                'route'       => 'softsat_locacao_admin_ipva_edit',
                'description' => 'Alterar',
                'class'       => 'btn-primary',
                'default'     => true,
                'role'        => 'softsat.locacao.ipva_edit'
            ),
            array(
                'route'       => 'softsat_locacao_admin_ipva_remove',
                'description' => 'Remover',
                'class'       => 'btn-danger',
                'confirm'     => true,
                'role'        => 'softsat.locacao.ipva_remove'
            )
        ),
        'rowcount' => true,
        'route'       => 'softsat_locacao_admin_ipva_list'
    );

    public function __construct($f3) {
        parent::__construct($f3);

        $db               = $f3->get('db');
        $this->mappers[0] = new Mapper($db, 'softsat_locacao_ipva');

        for($i = 0; $i <= 9; $i++) {
            $tablename = "parcelas_final_$i";
            $table     = $this->parcelas_table;
            $table['legend'] = sprintf($table['legend'], $i);
            $table['filter'] = array("final_placa = $i");
            $table['table']['final_placa']['default'] = $i;

            $this->form['groups'][$tablename] = $table;
            $this->mappers[$tablename] = new Mapper($db, 'softsat_locacao_ipva_parcela'); 
        }
    }

    public function index($f3) {
        $this->module->checkRole('softsat.locacao.ipva_list');
        
        echo TableBuilder::instance($this->mappers[0], $this->table)->render();
    }

    public function create($f3) {
        $this->module->checkRole('softsat.locacao.ipva_create');

        echo FormBuilder::instance($this->mappers, $this->form)->handle();
    }

    public function edit($f3) {
        $this->module->checkRole('softsat.locacao.ipva_edit');

        echo FormBuilder::instance($this->mappers, $this->form)->handle();
    }

    public function remove($f3) {
        $this->module->checkRole('softsat.locacao.ipva_remove');

        echo FormBuilder::instance($this->mappers, $this->form)->delete();
    }
}
