<?php

namespace Softsat\Locacao\Controller\Admin;

use Hwapx\Admin\Controller\Admin\Admin;
use Hwapx\Core\Library\Template;
use Hwapx\Core\Library\Validator;
use HwapX\Admin\Library\Builder\TableBuilder;
use HwapX\Admin\Library\Builder\FormBuilder;
use HwapX\Core\Library\DB\SQL\Mapper;

class Local extends Admin {
    protected $validator = null;
    protected $logger    = null;
    protected $mapper    = null;
    protected $form = array(
        'name'   => 'Local',
        'table'  => 'softsat_locacao_admin_local_list',
        'depends'=> array(
            array(
                'name'  => 'Contratos',
                'table' => 'softsat_locacao_contrato',
                'foreignkey' => 'local_saida_id'
            ),
            array(
                'name'  => 'Contratos',
                'table' => 'softsat_locacao_contrato',
                'foreignkey' => 'local_entrada_id'
            ),
        ),
        'groups' => array(
            'local' => array(
                'legend' => 'Local',
                'fields' =>  array(
                    'nome' => array(
                        'label' => 'Nome',
                        'type'  => 'text',
                        'width' => 8,
                        'rules' => array(
                            'required',
                        ),
                    ),
                    'ativo' => array(
                        'label'   => 'Ativo',
                        'type'    => 'dropdown',
                        'width'   => 4,
                        'default' => 1,
                        'options' => array(
                            '1' => 'Sim',
                            '0' => 'Não',
                        ),
                    ),
                    'razao' => array(
                        'label' => 'Razão Social',
                        'type'  => 'text',
                        'width' => 8,
                        'rules' => array(
                            'required',
                        ),
                    ),
                    'cnpj' => array(
                        'label' => 'CNPJ',
                        'type'  => 'text',
                        'width' => 4,
                        'mask'  => '99.999.999/9999-99',
                        'rules' => array(
                            'required',
                            'cnpj',
                            'regex' => '/^[0-9]{2}\.[0-9]{3}\.[0-9]{3}\/[0-9]{4}-[0-9]{2}$/',
                        ),
                    ),
                    'endereco' => array(
                        'label' => 'Endereço',
                        'type'  => 'text',
                        'width' => 8,
                        'rules' => array(
                            'required'
                        ),
                    ),
                    'numero' => array(
                        'label' => 'Número',
                        'type'  => 'text',
                        'width' => 4,
                    ),
                    'bairro' => array(
                        'label' => 'Bairro',
                        'type'  => 'text',
                        'width' => 4,
                    ),
                    'cidade' => array(
                        'label' => 'Cidade',
                        'type'  => 'text',
                        'width' => 5,
                    ),
                    'estado' => array(
                        'label'   => 'Estado',
                        'type'    => 'dropdown',
                        'width'   => 3,
                        'options' => array(
                            '' => '-- Selecione --',
                            'AC' => 'Acre',
                            'AL' => 'Alagoas',
                            'AP' => 'Amapá',
                            'AM' => 'Amazonas',
                            'BA' => 'Bahia',
                            'CE' => 'Ceará',
                            'DF' => 'Distrito Federal',
                            'ES' => 'Espírito Santo',
                            'GO' => 'Goiás',
                            'MA' => 'Maranhão',
                            'MT' => 'Mato Grosso',
                            'MS' => 'Mato Grosso do Sul',
                            'MG' => 'Minas Gerais',
                            'PA' => 'Pará',
                            'PB' => 'Paraíba',
                            'PR' => 'Paraná',
                            'PE' => 'Pernambuco',
                            'PI' => 'Piauí',
                            'RJ' => 'Rio de Janeiro',
                            'RN' => 'Rio Grande do Norte',
                            'RS' => 'Rio Grande do Sul',
                            'RO' => 'Rondônia',
                            'RR' => 'Roraima',
                            'SC' => 'Santa Catarina',
                            'SP' => 'São Paulo',
                            'SE' => 'Sergipe',
                            'TO' => 'Tocantins',
                        ),
                    ),
                    'cep' => array(
                        'label' => 'CEP',
                        'type'  => 'text',
                        'width' => 4,
                        'mask'  => '99999-999',
                    ),
                    'telefone' => array(
                        'label' => 'Telefone',
                        'type'  => 'text',
                        'width' => 4,
                        'mask'  => '(99)9999-9999[9]',
                    ),
                    'email' => array(
                        'label' => 'E-mail',
                        'type'  => 'email',
                        'width' => 4,
                    ),
                )
                ),
                'horario' => array(
                    'legend' => 'Horário de funcionamento',
                    'foreignkey' => 'local_id',
                    'allow_delete' => false,
                    'allow_insert' => false,
                    'table' => array(
                        'dia_semana' => array(
                            'label' => 'Dia',
                            'type'  => 'static',
                        ),
                        'abertura' => array(
                            'label' => 'Abertura',
                            'type'  => 'time',
                            'attributes' => array(
                                'placeholder' => 'Fechado',
                            )
                        ),
                        'fechamento' => array(
                            'label' => 'Fechamento',
                            'type'  => 'time',
                            'attributes' => array(
                                'placeholder' => 'Fechado',
                            )
                        ),
                    )
                )
        )
    );

    protected $table = array(
        'name'   => 'Locais',
        'cols'   => array(
            'id'    => 'Código',
            'nome'  => 'Nome',
            'cnpj'   => array(
                'label' => 'CNPJ',
                'mask'  => '999.999.999/9999-99',
            ),
            'telefone'    => array(
                'label' => 'Telefone',
                'mask'  => '(99)9999-9999[9]',
            )
        ),
        'actions' => array(
            array(
                'route'       => 'softsat_locacao_admin_local_create',
                'description' => 'Novo',
                'class'       => 'btn-primary',
                'role'        => 'softsat.locacao.local_create'
            )
        ),
        'rowactions' => array(
            array(
                'route'       => 'softsat_locacao_admin_local_edit',
                'description' => 'Alterar',
                'class'       => 'btn-primary',
                'default'     => true,
                'role'        => 'softsat.locacao.local_edit'
            ),
            array(
                'route'       => 'softsat_locacao_admin_local_remove',
                'description' => 'Remover',
                'class'       => 'btn-danger',
                'confirm'     => true,
                'role'        => 'softsat.locacao.local_remove'
            )
        ),
        'rowcount' => true,
        'route'    => 'softsat_locacao_admin_local_list',
        'legend'   => array(
            'default' => 'Ativo',
            'danger'  => 'Inativo'
        ),
    );

    public function __construct($f3) {
        parent::__construct($f3);

        $db            = $f3->get('db');
        $this->mappers = array(
            new \DB\SQL\Mapper($db, 'softsat_locacao_local'),
            'horario' => new \DB\SQL\Mapper($db, 'softsat_locacao_local_horario'),
        );
    }

    public function index($f3) {
        $this->module->checkRole('softsat.locacao.local_list');

        $this->table['rowcallback'] = function($mapper) {
            return array('class' => $mapper->ativo ? '' : 'danger');
        };
        
        echo TableBuilder::instance($this->mappers[0], $this->table)->render();
    }

    public function create($f3) {
        $this->module->checkRole('softsat.locacao.local_create');

        $this->form['table'] = 'softsat_locacao_admin_local_edit';

        echo FormBuilder::instance($this->mappers, $this->form)->handle();
    }

    public function edit($f3) {
        $this->module->checkRole('softsat.locacao.local_edit');

        echo FormBuilder::instance($this->mappers, $this->form)->handle();
    }

    public function remove($f3) {
        $this->module->checkRole('softsat.locacao.local_remove');

        echo FormBuilder::instance($this->mappers, $this->form)->delete();
    }
}
