<?php

namespace Softsat\Locacao\Controller\Admin;

use Hwapx\Admin\Controller\Admin\Admin;
use Hwapx\Core\Library\Template;
use Hwapx\Core\Library\Validator;
use HwapX\Admin\Library\Builder\TableBuilder;
use HwapX\Admin\Library\Builder\FormBuilder;
use HwapX\Core\Library\DB\SQL\Mapper;

class Manutencao extends Admin {
    protected $validator = null;
    protected $logger    = null;
    protected $mapper    = null;
    protected $form = array(
        'name'   => 'Situação do veículo',
        'table'  => 'softsat_locacao_admin_manutencao_list',
        'groups' => array(
            'veiculo' => array(
                'legend' => 'Veículo',
                'fields' =>  array(
                    'placa' => array(
                        'label' => 'Placa',
                        'type'  => 'static',
                        'width' => 3,
                    ),
                    'marca' => array(
                        'label' => 'Marca',
                        'type'  => 'static',
                        'width' => 3,
                    ),
                    'modelo' => array(
                        'label' => 'Modelo',
                        'type'  => 'static',
                        'width' => 6,
                    ),
                    'ano' => array(
                        'label' => 'Ano',
                        'type'  => 'static',
                        'width' => 3,
                    ),
                    'ano_modelo' => array(
                        'label' => 'Ano modelo',
                        'type'  => 'static',
                        'width' => 3,
                    ),
                    'combustivel' => array(
                        'label' => 'Combustível',
                        'type'  => 'static',
                        'width' => 6,
                    ),
                    'chassi' => array(
                        'label' => 'Chassi',
                        'type'  => 'static',
                        'width' => 6,
                    ),
                    'km_atual' => array(
                        'label' => 'Km atual',
                        'type'  => 'number',
                        'digits'=> 0,
                        'width' => 6,
                    ),
                    'data_oleo' => array(
                        'label' => 'Última troca de óleo(data)',
                        'type'  => 'date',
                        'width' => 4,
                    ),
                    'km_oleo' => array(
                        'label' => 'Última troca de óleo(Km)',
                        'type'  => 'number',
                        'digits'=> 0,
                        'width' => 4,
                    ),
                    'km_oleo_percorrido' => array(
                        'label' => 'Km óleo percorrido',
                        'type'  => 'static',
                        'digits'=> 0,
                        'width' => 4,
                    ),
                    'data_pastilha' => array(
                        'label' => 'Última manutenção das pastilhas de freio(data)',
                        'type'  => 'date',
                        'width' => 4,
                    ),
                    'km_pastilha' => array(
                        'label' => 'Última manutenção das pastilhas de freio(Km)',
                        'type'  => 'number',
                        'digits'=> 0,
                        'width' => 4,
                    ),
                    'km_pastilha_percorrido' => array(
                        'label' => 'Km suspensão percorrido',
                        'type'  => 'static',
                        'digits'=> 0,
                        'width' => 4,
                    ),
                    'data_pneu' => array(
                        'label' => 'Última manutenção dos pneus(data)',
                        'type'  => 'date',
                        'width' => 4,
                    ),
                    'km_pneu' => array(
                        'label' => 'Última manutenção dos pneus(Km)',
                        'type'  => 'number',
                        'digits'=> 0,
                        'width' => 4,
                    ),
                    'km_pneu_percorrido' => array(
                        'label' => 'Km pneus percorrido',
                        'type'  => 'static',
                        'digits'=> 0,
                        'width' => 4,
                    ),
                    'data_filtro_ar' => array(
                        'label' => 'Última manutenção do filtro de ar(data)',
                        'type'  => 'date',
                        'width' => 4,
                    ),
                    'km_filtro_ar' => array(
                        'label' => 'Última manutenção do filtro de ar(Km)',
                        'type'  => 'number',
                        'digits'=> 0,
                        'width' => 4,
                    ),
                    'km_filtro_ar_percorrido' => array(
                        'label' => 'Km filtro de ar percorrido',
                        'type'  => 'static',
                        'digits'=> 0,
                        'width' => 4,
                    ),
                    'data_filtro_comb' => array(
                        'label' => 'Última manutenção do filtro de combustível(data)',
                        'type'  => 'date',
                        'width' => 4,
                    ),
                    'km_filtro_comb' => array(
                        'label' => 'Última manutenção do filtro de combustível(Km)',
                        'type'  => 'number',
                        'digits'=> 0,
                        'width' => 4,
                    ),
                    'km_filtro_comb_percorrido' => array(
                        'label' => 'Km filtro de combustível percorrido',
                        'type'  => 'static',
                        'digits'=> 0,
                        'width' => 4,
                    ),
                    'data_disco' => array(
                        'label' => 'Última manutenção dos discos de freio(data)',
                        'type'  => 'date',
                        'width' => 4,
                    ),
                    'km_disco' => array(
                        'label' => 'Última manutenção dos discos de freio(Km)',
                        'type'  => 'number',
                        'digits'=> 0,
                        'width' => 4,
                    ),
                    'km_disco_percorrido' => array(
                        'label' => 'Km discos de freio percorrido',
                        'type'  => 'static',
                        'digits'=> 0,
                        'width' => 4,
                    ),
                    'data_correia' => array(
                        'label' => 'Última manutenção da correia dentada(data)',
                        'type'  => 'date',
                        'width' => 4,
                    ),
                    'km_correia' => array(
                        'label' => 'Última manutenção da correia dentada(Km)',
                        'type'  => 'number',
                        'digits'=> 0,
                        'width' => 4,
                    ),
                    'km_correia_percorrido' => array(
                        'label' => 'Km discos da correia dentada percorrido',
                        'type'  => 'static',
                        'digits'=> 0,
                        'width' => 4,
                    ),
                )
            ),
            'situacao' => array(
                'legend' => 'Situação',
                'fields' =>  array(
                    'situacao_frente' => array(
                        'label' => 'Frente',
                        'type'  => 'textarea',
                        'width' => 6,
                    ),
                    'situacao_traseira' => array(
                        'label' => 'Traseira',
                        'type'  => 'textarea',
                        'width' => 6,
                    ),
                    'situacao_direita' => array(
                        'label' => 'Direita',
                        'type'  => 'textarea',
                        'width' => 6,
                    ),
                    'situacao_esquerda' => array(
                        'label' => 'Esquerda',
                        'type'  => 'textarea',
                        'width' => 6,
                    ),
                    'situacao_superior' => array(
                        'label' => 'Superior',
                        'type'  => 'textarea',
                        'width' => 6,
                    ),
                    'situacao_inferior' => array(
                        'label' => 'Inferior',
                        'type'  => 'textarea',
                        'width' => 6,
                    ),
                )
            ),
        )
    );

    protected $table = array(
        'name'   => 'Situação dos veículos',
        'cols'   => array(
            //'id'     => 'Código',
            'nome'   => 'Veículo',
            'km_atual'     => array(
                'label'  => 'Km atual',
                'type'   => 'number',
                'digits' => 0
            ),
            'km_oleo_percorrido'  => array(
                'label'  => 'Km óleo',
                'type'   => 'number',
                'digits' => 0
            ),
            'dias_oleo_percorrido' => array(
                'label'  => 'Dias óleo',
                'type'   => 'number'
            ),
            'km_pastilha_percorrido' => array(
                'label'  => 'Km past.',
                'type'   => 'number',
                'digits' => 0
            ),
            'km_pneu_percorrido' => array(
                'label'  => 'Km pneus',
                'type'   => 'number',
                'digits' => 0
            ),
            'km_filtro_ar_percorrido' => array(
                'label'  => 'Km f. ar',
                'type'   => 'number',
                'digits' => 0
            ),
            'km_filtro_comb_percorrido' => array(
                'label'  => 'Km f. comb.',
                'type'   => 'number',
                'digits' => 0
            ),
            'km_disco_percorrido' => array(
                'label'  => 'Km disco',
                'type'   => 'number',
                'digits' => 0
            ),
            'km_correia_percorrido' => array(
                'label'  => 'Km correia',
                'type'   => 'number',
                'digits' => 0
            ),
        ),
        'rowactions' => array(
            array(
                'route'       => 'softsat_locacao_admin_manutencao_edit',
                'description' => 'Atualizar informações',
                'class'       => 'btn-primary',
                'default'     => false,
                'role'        => 'softsat.locacao.manutencao_edit'
            ),
        ),
        'rowcount' => true,
        'route'    => 'softsat_locacao_admin_manutencao_list',
        'legend'   => array(
            'danger' => 'Limite excedido'
        )
    );

    public function __construct($f3) {
        parent::__construct($f3);
    }

    public function index($f3) {
        $this->module->checkRole('softsat.locacao.manutencao_list');

        $db     = $f3->get('db');
        $mapper = new Mapper($db, 'softsat_locacao_veiculo_manutencao');

        $params = $f3->get('settings.softsat.locacao.manutencao');

        flash(
            'info',
            "O sistema está configurado com parâmetros:<br>".
            "Troca de óleo após {$params['dias_oleo']} dias ou {$params['km_oleo']} km.<br>".
            "Manutenção das pastilhas após {$params['km_pastilha']} km.<br>".
            "Manutenção dos pneus após {$params['km_pneu']} km.<br>".
            "Manutenção do filtro de ar após {$params['km_filtro_ar']} km.<br>".
            "Manutenção do filtro de combustível após {$params['km_filtro_comb']} km.<br>".
            "Manutenção do disco de freio após {$params['km_disco']} km.<br>".
            "Manutenção da correia dentada após {$params['km_correia']} km.<br><br>".
            "A quilometragem atual dos veículos é atualizada automaticamente quando um contrato é faturado."
        );

        $this->table['cellcallback'] = function($fieldname, $mapper, $cell, $attr) use($params) {
            if(substr($fieldname, 0, 3) == 'km_') {
                $attr['class'] = 'text-right';
            }
            switch($fieldname) {
            case 'km_oleo_percorrido':
            if($mapper->km_oleo_percorrido > $params['km_oleo'])
                $attr['class'] .= ' danger text-danger';
            break;
            case 'km_pastilha_percorrido':
            if($mapper->km_pastilha_percorrido > $params['km_pastilha'])
                $attr['class'] .= ' danger text-danger';
            break;
            case 'km_pneu_percorrido':
            if($mapper->km_pneu_percorrido > $params['km_pneu'])
                $attr['class'] .= ' danger text-danger';
            break;
            case 'dias_oleo_percorrido':
            if($mapper->dias_oleo_percorrido > $params['dias_oleo'])
                $attr['class'] .= ' danger text-danger';
            break;
            case 'km_filtro_ar_percorrido':
            if($mapper->km_filtro_ar_percorrido > $params['km_filtro_ar'])
                $attr['class'] .= ' danger text-danger';
            break;
            case 'km_filtro_comb_percorrido':
            if($mapper->km_filtro_comb_percorrido > $params['km_filtro_comb'])
                $attr['class'] .= ' danger text-danger';
            break;
            case 'km_disco_percorrido':
            if($mapper->km_disco_percorrido > $params['km_disco'])
                $attr['class'] .= ' danger text-danger';
            break;
            case 'km_correia_percorrido':
            if($mapper->km_correia_percorrido > $params['km_correia'])
                $attr['class'] .= ' danger text-danger';
            break;
            }
            return $attr;
        };

        echo TableBuilder::instance($mapper, $this->table)->render();
    }

    public function edit($f3) {
        $this->module->checkRole('softsat.locacao.manutencao_edit');

        $db     = $f3->get('db');
        $mapper = new Mapper($db, 'softsat_locacao_veiculo');
        $mapper->marca       = 'SELECT nome FROM softsat_locacao_marca WHERE id = softsat_locacao_veiculo.marca_id';
        $mapper->combustivel = 'SELECT nome FROM softsat_locacao_combustivel WHERE id = softsat_locacao_veiculo.combustivel_id';
        //$mapper->grupo       = 'SELECT nome FROM softsat_locacao_grupo WHERE id = softsat_locacao_veiculo.grupo_id';
        $mapper->km_oleo_percorrido     = 'km_atual - km_oleo';
        $mapper->km_pastilha_percorrido = 'km_atual - km_pastilha';
        $mapper->km_pneu_percorrido     = 'km_atual - km_pneu';
        $mapper->km_filtro_ar_percorrido   = 'km_atual - km_filtro_ar';
        $mapper->km_filtro_comb_percorrido = 'km_atual - km_filtro_comb';
        $mapper->km_disco_percorrido       = 'km_atual - km_disco';
        $mapper->km_correia_percorrido     = 'km_atual - km_correia';

        echo FormBuilder::instance($mapper, $this->form)->handle();
    }
}
