<?php

namespace Softsat\Locacao\Controller\Admin;

use Hwapx\Admin\Controller\Admin\Admin;
use Hwapx\Core\Library\Template;
use Hwapx\Core\Library\Validator;
use HwapX\Admin\Library\Builder\TableBuilder;
use HwapX\Admin\Library\Builder\FormBuilder;
use HwapX\Core\Library\DB\SQL\Mapper;

class Marca extends Admin {
    protected $validator = null;
    protected $logger    = null;
    protected $mapper    = null;
    protected $form = array(
        'name'   => 'Marca',
        'table'  => 'softsat_locacao_admin_marca_list',
        'depends'=> array(
            'softsat_locacao_veiculo' => array(
                'name' => 'Veículos',
                'foreignkey' => 'marca_id'
            ),
        ),
        'fields' =>  array(
            'nome' => array(
                'label' => 'Nome',
                'type'  => 'text',
                'width' => 12,
                'rules' => array(
                    'required'
                )
            ),
        )
    );

    protected $table = array(
        'name'   => 'Marcas',
        'cols'   => array(
            'id'   => 'Código',
            'nome' => 'Nome',
        ),
        'actions' => array(
            array(
                'route'       => 'softsat_locacao_admin_marca_create',
                'description' => 'Nova',
                'class'       => 'btn-primary',
                'role'        => 'softsat.locacao.marca_create'
            )
        ),
        'rowactions' => array(
            array(
                'route'       => 'softsat_locacao_admin_marca_edit',
                'description' => 'Alterar',
                'class'       => 'btn-primary',
                'default'     => true,
                'role'        => 'softsat.locacao.marca_edit'
            ),
            array(
                'route'       => 'softsat_locacao_admin_marca_remove',
                'description' => 'Remover',
                'class'       => 'btn-danger',
                'confirm'     => true,
                'role'        => 'softsat.locacao.marca_remove'
            )
        ),
        'rowcount' => true,
        'route'       => 'softsat_locacao_admin_marca_list'
    );

    public function __construct($f3) {
        parent::__construct($f3);

        $db           = $f3->get('db');
        $this->mapper = new \DB\SQL\Mapper($db, 'softsat_locacao_marca');    }

    public function index($f3) {
        $this->module->checkRole('softsat.locacao.marca_list');
        
        echo TableBuilder::instance($this->mapper, $this->table)->render();
    }

    public function create($f3) {
        $this->module->checkRole('softsat.locacao.marca_create');

        echo FormBuilder::instance($this->mapper, $this->form)->handle();
    }

    public function edit($f3) {
        $this->module->checkRole('softsat.locacao.marca_edit');

        echo FormBuilder::instance($this->mapper, $this->form)->handle();
    }

    public function remove($f3) {
        $this->module->checkRole('softsat.locacao.marca_remove');

        echo FormBuilder::instance($this->mapper, $this->form)->delete();
    }
}
