<?php

namespace Softsat\Locacao\Controller\Admin;

use Hwapx\Admin\Controller\Admin\Admin;
use Hwapx\Core\Library\Template;
use Hwapx\Core\Library\Validator;
use HwapX\Admin\Library\Builder\TableBuilder;
use HwapX\Admin\Library\Builder\FormBuilder;
use HwapX\Core\Library\DB\SQL\Mapper;

class Planoconta extends Admin {
    protected $validator = null;
    protected $logger    = null;
    protected $mapper    = null;
    protected $form = array(
        'name'   => 'Plano de Conta',
        'table'  => 'softsat_locacao_admin_plano_conta_list',
        'depends'=> array(
            'softsat_locacao_despesa' => array(
                'name' => 'Despesa',
                'foreignkey' => 'plano_conta_id'
            ),
        ),
        'fields' =>  array(
            'conta' => array(
                'label' => 'Conta',
                'type'  => 'text',
                'width' => 3,
                'default' => 1,
                'mask'  => '(1.99)|(1.99.99)',
                'rules' => array(
                    'required',
                    'uniqueRecord' => array(
                        'softsat_locacao_plano_conta',
                    ),
                ),
                'attributes' => array(
                    'data-inputmask-keepstatic' => 'true'
                )
            ),
            'nome' => array(
                'label' => 'Nome',
                'type'  => 'text',
                'width' => 9,
                'rules' => array(
                    'required'
                )
            ),
        )
    );

    protected $table = array(
        'name'   => 'Planos de conta',
        'cols'   => array(
            //'id'    => 'Código',
            'conta' => array(
                'label' => 'Conta',
                'mask'  => '(1)|(1.99)|(1.99.99)',
            ),
            'nome'  => 'Nome',
        ),
        'actions' => array(
            array(
                'route'       => 'softsat_locacao_admin_plano_conta_create',
                'description' => 'Nova',
                'class'       => 'btn-primary',
                'role'        => 'softsat.locacao.plano_conta_create'
            )
        ),
        'rowactions' => array(
            array(
                'route'       => 'softsat_locacao_admin_plano_conta_edit',
                'description' => 'Alterar',
                'class'       => 'btn-primary',
                'default'     => true,
                'role'        => 'softsat.locacao.plano_conta_edit'
            ),
            array(
                'route'       => 'softsat_locacao_admin_plano_conta_remove',
                'description' => 'Remover',
                'class'       => 'btn-danger',
                'confirm'     => true,
                'role'        => 'softsat.locacao.plano_conta_remove'
            )
        ),
        'rowcount' => true,
        'route'       => 'softsat_locacao_admin_plano_conta_list'
    );

    public function __construct($f3) {
        parent::__construct($f3);

        $db           = $f3->get('db');
        $this->mapper = new \DB\SQL\Mapper($db, 'softsat_locacao_plano_conta');
    }

    public function index($f3) {
        $this->module->checkRole('softsat.locacao.plano_conta_list');
        
        echo TableBuilder::instance($this->mapper, $this->table)->render();
    }

    public function create($f3) {
        $this->module->checkRole('softsat.locacao.plano_conta_create');

        echo FormBuilder::instance($this->mapper, $this->form)->handle();
    }

    public function edit($f3) {
        $this->module->checkRole('softsat.locacao.plano_conta_edit');

        echo FormBuilder::instance($this->mapper, $this->form)->handle();
    }

    public function remove($f3) {
        $this->module->checkRole('softsat.locacao.plano_conta_remove');

        echo FormBuilder::instance($this->mapper, $this->form)->delete();
    }
}
