<?php

namespace Softsat\Locacao\Controller\Admin;

use Hwapx\Admin\Controller\Admin\Admin;
use Hwapx\Core\Library\Template;
use Hwapx\Core\Library\Validator;
use HwapX\Admin\Library\Builder\TableBuilder;
use HwapX\Admin\Library\Builder\FormBuilder;
use HwapX\Core\Library\DB\SQL\Mapper;

use SoftSAT\Locacao\Model\Veiculo as VeiculoModel;

class Veiculo extends Admin {
    protected $validator = null;
    protected $logger    = null;
    protected $mapper    = null;
    protected $form = array(
        'name'   => 'Veículo',
        'table'  => 'softsat_locacao_admin_veiculo_list',
        'depends'=> array(
            'softsat_locacao_contrato' => array(
                'name' => 'Contratos',
                'foreignkey' => 'veiculo_id'
            ),
        ),
        'groups' => array(
            'veiculo' => array(
                'legend' => 'Veículo',
                'fields' =>  array(
                    'placa' => array(
                        'label' => 'Placa',
                        'type'  => 'text',
                        'width' => 3,
                        'mask'  => '(AAA9A99)|(AAA-9999)',
                        'rules' => array(
                            'required',
                            'uniqueRecord' => array(
                                'softsat_locacao_veiculo',
                                'placa = @placa AND NOT id <=> @id',
                            ),
                        ),
                        'attributes' => array(
                            'data-inputmask-keepstatic' => 'true'
                        )
                    ),
                    'marca_id' => array(
                        'label' => 'Marca',
                        'type'  => 'dropdown',
                        'options' => array(
                            '' => '-- Selecione --'
                        ),
                        'width' => 3,
                        'rules' => array(
                            'required',
                        ),
                    ),
                    'modelo' => array(
                        'label' => 'Modelo',
                        'type'  => 'text',
                        'width' => 6,
                        'rules' => array(
                            'required',
                        ),
                    ),
                    'ano' => array(
                        'label' => 'Ano',
                        'type'  => 'number',
                        'width' => 3,
                    ),
                    'ano_modelo' => array(
                        'label' => 'Ano modelo',
                        'type'  => 'number',
                        'width' => 3,
                    ),
                    'renavam' => array(
                        'label' => 'Renavam',
                        'type'  => 'text',
                        'width' => 3,
                        'rules' => array(
                            'uniqueRecord' => array(
                                'softsat_locacao_veiculo',
                                'renavam = @renavam AND NOT id <=> @id',
                            ),
                        ),
                    ),
                    'chassi' => array(
                        'label' => 'Chassi',
                        'type'  => 'text',
                        'width' => 3,
                        'rules' => array(
                            'uniqueRecord' => array(
                                'softsat_locacao_veiculo',
                                'chassi = @chassi AND NOT id <=> @id',
                            ),
                        ),
                    ),
                    'combustivel_id' => array(
                        'label' => 'Combustível',
                        'type'  => 'dropdown',
                        'options' => array(
                            '' => '-- Selecione --'
                        ),
                        'width' => 6,
                    ),
                    'grupo_id' => array(
                        'label' => 'Grupo',
                        'type'  => 'dropdown',
                        'options' => array(
                            '' => '-- Selecione --'
                        ),
                        'width' => 6,
                    ),
                    'tarifa_id' => array(
                        'label' => 'Tarifa',
                        'type'  => 'dropdown',
                        'options' => array(
                            '' => '-- Selecione --'
                        ),
                        'width' => 6,
                        'rules' => array(
                            'required',
                        ),
                    ),
                    'local_id' => array(
                        'label' => 'Local',
                        'type'  => 'dropdown',
                        'options' => array(
                            '' => '-- Selecione --'
                        ),
                        'width' => 6,
                        'rules' => array(
                            'required',
                        ),
                    ),
                    'indenizacao_carro' => array(
                        'label' => 'Indenização por custos Operacionais (Danos ao carro)',
                        'type'  => 'number',
                        'digits'=> 2,
                        'width' => 6,
                    ),
                    'indenizacao_terceiros' => array(
                        'label' => 'Indenização por custos Operacionais (Danos a terceiros)',
                        'type'  => 'number',
                        'digits'=> 2,
                        'width' => 6,
                    ),
                    'inativado_em' => array(
                        'label' => 'Inativado em',
                        'type'  => 'date',
                        'width' => 3,
                    ),
                    'ano_licenciamento' => array(
                        'label' => 'Ano do último licenciamento',
                        'type'  => 'number',
                        'width' => 3,
                    ),
                    'data_licenciamento' => array(
                        'label' => 'Data do último licenciamento',
                        'type'  => 'date',
                        'width' => 3,
                    ),
                    'imagem' => array(
                        'label' => 'Foto',
                        'type'  => 'image',
                        'width' => 6,
                    ),
                )
            ),
            'situacao' => array(
                'legend' => 'Situação',
                'fields' =>  array(
                    'situacao_frente' => array(
                        'label' => 'Frente',
                        'type'  => 'textarea',
                        'width' => 6,
                    ),
                    'situacao_traseira' => array(
                        'label' => 'Traseira',
                        'type'  => 'textarea',
                        'width' => 6,
                    ),
                    'situacao_direita' => array(
                        'label' => 'Direita',
                        'type'  => 'textarea',
                        'width' => 6,
                    ),
                    'situacao_esquerda' => array(
                        'label' => 'Esquerda',
                        'type'  => 'textarea',
                        'width' => 6,
                    ),
                    'situacao_superior' => array(
                        'label' => 'Superior',
                        'type'  => 'textarea',
                        'width' => 6,
                    ),
                    'situacao_inferior' => array(
                        'label' => 'Inferior',
                        'type'  => 'textarea',
                        'width' => 6,
                    ),
                )
            ),
            'manutencao' => array(
                'legend' => 'Manutenção',
                'fields' =>  array(
                    'km_atual' => array(
                        'label' => 'Km atual',
                        'type'  => 'number',
                        'digits'=> 3,
                        'width' => 6,
                    ),
                    'y' => array(
                        'label'  => '',
                        'type'   => 'placeholder',
                        'width'  => 6,
                    ),
                    'data_oleo' => array(
                        'label' => 'Última troca de óleo(data)',
                        'type'  => 'date',
                        'width' => 6,
                    ),
                    'km_oleo' => array(
                        'label' => 'Última troca de óleo(Km)',
                        'type'  => 'number',
                        'digits'=> 3,
                        'width' => 6,
                    ),
                    'data_pastilha' => array(
                        'label' => 'Última manutenção das pastilhas de freio(data)',
                        'type'  => 'date',
                        'width' => 6,
                    ),
                    'km_pastilha' => array(
                        'label' => 'Última manutenção das pastilhas de freio(Km)',
                        'type'  => 'number',
                        'digits'=> 3,
                        'width' => 6,
                    ),
                    'data_pneu' => array(
                        'label' => 'Última manutenção dos pneus(data)',
                        'type'  => 'date',
                        'width' => 6,
                    ),
                    'km_pneu' => array(
                        'label' => 'Última manutenção dos pneus(Km)',
                        'type'  => 'number',
                        'digits'=> 3,
                        'width' => 6,
                    ),
                    'data_filtro_ar' => array(
                        'label' => 'Última manutenção do filtro de ar(data)',
                        'type'  => 'date',
                        'width' => 6,
                    ),
                    'km_filtro_ar' => array(
                        'label' => 'Última manutenção do filtro de ar(Km)',
                        'type'  => 'number',
                        'digits'=> 3,
                        'width' => 6,
                    ),
                    'data_filtro_comb' => array(
                        'label' => 'Última manutenção do filtro de combustível(data)',
                        'type'  => 'date',
                        'width' => 6,
                    ),
                    'km_filtro_comb' => array(
                        'label' => 'Última manutenção do filtro de combustível(Km)',
                        'type'  => 'number',
                        'digits'=> 3,
                        'width' => 6,
                    ),
                    'data_disco' => array(
                        'label' => 'Última manutenção dos discos de freio(data)',
                        'type'  => 'date',
                        'width' => 6,
                    ),
                    'km_disco' => array(
                        'label' => 'Última manutenção dos discos de freio(Km)',
                        'type'  => 'number',
                        'digits'=> 3,
                        'width' => 6,
                    ),
                    'data_correia' => array(
                        'label' => 'Última manutenção da correia dentada(data)',
                        'type'  => 'date',
                        'width' => 6,
                    ),
                    'km_correia' => array(
                        'label' => 'Última manutenção da correia dentada(Km)',
                        'type'  => 'number',
                        'digits'=> 3,
                        'width' => 6,
                    ),
                )
            ),
            'ipva' => array(
                'legend' => 'IPVA',
                'foreignkey' => 'veiculo_id',
                'table' => array(
                    'parcela' => array(
                        'label' => 'Parcela',
                        'type'  => 'number',
                        'rules' => array(
                            'required'
                        )
                    ),
                    'vencimento' => array(
                        'label' => 'Vencimento',
                        'type'  => 'date',
                        'rules' => array(
                            'required',
                            'date'
                        )
                    ),
                    'pagamento' => array(
                        'label' => 'Pagamento',
                        'type'  => 'date',
                        'rules' => array(
                            'date'
                        )
                    ),
                    'valor' => array(
                        'label' => 'Valor',
                        'type'  => 'number',
                        'digits' => 2,
                    ),
                ),
            ),
        ),
    );

    protected $table = array(
        'name'   => 'Veículos',
        'cols'   => array(
            'id'     => 'Código',
            'placa'  => array(
                 'label' => 'Placa',
                 'mask' => '(AAA9A99)|(AAA-9999)',
                 'attributes' => array(
                     'data-inputmask-keepstatic' => 'true'
                 )
            ),
            'modelo' => 'Modelo',
            'marca'  => 'Marca',
            'grupo'  => 'Grupo',
            'renavam' => 'Renavam',
            'chassi'  => 'Chassi',
        ),
        'actions' => array(
            array(
                'route'       => 'softsat_locacao_admin_veiculo_create',
                'description' => 'Novo',
                'class'       => 'btn-primary',
                'role'        => 'softsat.locacao.veiculo_create'
            )
        ),
        'rowactions' => array(
            array(
                'route'       => 'softsat_locacao_admin_veiculo_edit',
                'description' => 'Alterar',
                'class'       => 'btn-primary',
                'default'     => true,
                'role'        => 'softsat.locacao.veiculo_edit'
            ),
            array(
                'route'       => 'softsat_locacao_admin_veiculo_remove',
                'description' => 'Remover',
                'class'       => 'btn-danger',
                'confirm'     => true,
                'role'        => 'softsat.locacao.veiculo_remove'
            ),
            array(
                'route'       => 'softsat_locacao_admin_veiculo_blueprint_preview',
                'description' => 'Croqui',
                'class'       => 'btn-default',
                'role'        => 'softsat.locacao.veiculo_blueprint'
            )
        ),
        'rowcount' => true,
        'route'       => 'softsat_locacao_admin_veiculo_list',
        'legend'   => array(
            'default' => 'Ativo',
            'warning' => 'Inativado no futuro',
            'danger'  => 'Inativo'
        ),
    );

    public function __construct($f3) {
        parent::__construct($f3);

        $db            = $f3->get('db');
        $this->mappers = array(
            new Mapper($db, 'softsat_locacao_veiculo'),
            'ipva' => new Mapper($db, 'softsat_locacao_veiculo_ipva'),
        );

        $mapper = new Mapper($db, 'softsat_locacao_marca');

        foreach ($mapper->find() as $marca) {
            $this->form['groups']['veiculo']['fields']['marca_id']['options'][$marca->id] = $marca->nome;
        }

        $mapper = new Mapper($db, 'softsat_locacao_combustivel');

        foreach ($mapper->find() as $combustivel) {
            $this->form['groups']['veiculo']['fields']['combustivel_id']['options'][$combustivel->id] = $combustivel->nome;
        }

        $mapper = new Mapper($db, 'softsat_locacao_grupo');

        foreach ($mapper->find() as $grupo) {
            $this->form['groups']['veiculo']['fields']['grupo_id']['options'][$grupo->id] = $grupo->nome;
        }

        $mapper = new Mapper($db, 'softsat_locacao_tarifa');

        foreach ($mapper->find(array()) as $tarifa) {
            $this->form['groups']['veiculo']['fields']['tarifa_id']['options'][$tarifa->id] = $tarifa->nome;
        }

        $mapper = new Mapper($db, 'softsat_locacao_local');

        foreach ($mapper->find('ativo = 1') as $local) {
            $this->form['groups']['veiculo']['fields']['local_id']['options'][$local->id] = $local->nome;
        }
    }

    public function index($f3) {
        $this->module->checkRole('softsat.locacao.veiculo_list');

        $db     = $f3->get('db');
        $mapper = new Mapper($db, 'softsat_locacao_veiculo_detalhe');

        $this->table['rowcallback'] = function($mapper) {
            $data = array();

            if(!$mapper->inativado_em)
                return $data;

            if(strtotime($mapper->inativado_em) > time())
                $data['class'] = 'warning';
            else
                $data['class'] = 'danger';

            return $data;
        };

        echo TableBuilder::instance($mapper, $this->table)->render();
    }

    public function create($f3) {
        $this->module->checkRole('softsat.locacao.veiculo_create');

        echo FormBuilder::instance($this->mappers, $this->form)->handle();
    }

    public function edit($f3) {
        $this->module->checkRole('softsat.locacao.veiculo_edit');

        echo FormBuilder::instance($this->mappers, $this->form)->handle();
    }

    public function remove($f3) {
        $this->module->checkRole('softsat.locacao.veiculo_remove');

        echo FormBuilder::instance($this->mappers, $this->form)->delete();
    }

    public function blueprint($f3) {
        $this->module->checkRole('softsat.locacao.veiculo_blueprint');

        $db           = $f3->get('db');
        $this->mapper = new Mapper($db, 'softsat_locacao_veiculo_detalhe');

        $data = array(
            'contrato' => $this->mapper->findone(array('id = ?', $f3->get('PARAMS.id')))
        );

        if(!$data['contrato'])
            $this->f3->error(404);

        echo Template::instance()->render('softsat/locacao/veiculo/preview-blueprint.html', null, $data);
    }

    public function blueprintPdf($f3) {
        $this->module->checkRole('softsat.locacao.veiculo_blueprint');

        $model = new VeiculoModel($f3);
        $data  = $model->renderBlueprintPdf($f3->get('PARAMS.id'));

        if(!$data) {
            $this->f3->error(404);
            return;
        }

        header('content-type: application/pdf');
        echo $data;
    }
}
