<?php

namespace SoftSAT\Locacao\Model;

use Dompdf\Dompdf;

use HwapX\Core\Library\Db\Sql\Mapper;
use Hwapx\Core\Library\Template;

use JasperPHP\Report;
use OpenBoleto\Banco\Santander;
use OpenBoleto\Agente;

use Softsat\Locacao\Model\Boleto;

class BoletoModel {
    protected $f3;

    public function __construct($f3) {
        $this->f3 = $f3;
    }

    public function getBoletos($boleto_id) {
        $db     = $this->f3->get('db');
        $mapper = new Mapper($db, 'softsat_locacao_boleto');
        $template = Template::instance();

        if(!$mapper->load(array('id = ? and cancelado = 0', $boleto_id)))
            return null;

        $boletos = array();

        while(!$mapper->dry()) {
            $sacado = new Agente($mapper->sacado_nome, $mapper->sacado_cnpj_cpf, $mapper->sacado_endereco, $mapper->sacado_cep, $mapper->sacado_cidade, $mapper->sacado_uf);
            $cedente = new Agente($mapper->cedente_nome, $mapper->cedente_cnpj, $mapper->cedente_endereco, $mapper->cedente_cep, $mapper->cedente_cidade, $mapper->cedente_uf);

            $agencia = explode('-', $mapper->agencia);
            $instrucoes = $template->resolve($mapper->instrucoes, array('boleto' => $mapper->cast()));
            $demonstrativo = $template->resolve($mapper->demonstrativo, array('boleto' => $mapper->cast()));
            $logo = $this->f3->get('ROOT').'/assets/img/logo_boleto.png';

            $boleto = new Santander(array(
                // Parâmetros obrigatórios
                'dataVencimento' => new \DateTime($mapper->vencimento),
                'valor' => $mapper->valor,
                'sequencial' => $mapper->sequencia, // 8 dígitos
                'sacado' => $sacado,
                'cedente' => $cedente,
                'agencia' => $agencia[0], // 4 dígitos
                'carteira' => $mapper->carteira, // 3 dígitos
                'conta' => preg_replace('/\D/', '', $mapper->cod_beneficiario), // 5 dígitos

                // Parâmetro obrigatório somente se a carteira for
                // 107, 122, 142, 143, 196 ou 198
                //'codigoCliente' => 12345, // 5 dígitos
                'numeroDocumento' => $mapper->id, // 7 dígitos

                // Parâmetros recomendáveis
                //'logoPath' => 'http://empresa.com.br/logo.jpg', // Logo da sua empresa
                //'contaDv' => 0,
                'agenciaDv' => $agencia[1],
                'descricaoDemonstrativo' => explode(PHP_EOL, $demonstrativo),
                'instrucoes' => explode(PHP_EOL, $instrucoes),

                // Parâmetros opcionais
                //'resourcePath' => '../resources',
                //'moeda' => Itau::MOEDA_REAL,
                'dataDocumento' => new \DateTime($mapper->emissao),
                'dataProcessamento' => new \DateTime($mapper->emissao),
                //'contraApresentacao' => true,
                //'pagamentoMinimo' => 23.00,
                //'aceite' => 'N',
                'especieDoc' => $mapper->especie_doc,
                //'usoBanco' => 'Uso banco',
                //'layout' => 'layout.phtml',
                'logoPath' => $logo,
                //'sacadorAvalista' => new Agente('Antônio da Silva', '02.123.123/0001-11'),
                //'descontosAbatimentos' => 123.12,
                //'moraMulta' => 123.12,
                //'outrasDeducoes' => 123.12,
                //'outrosAcrescimos' => 123.12,
                //'valorCobrado' => 123.12,
                //'valorUnitario' => 123.12,
                //'quantidade' => 1,
            ));

            $boletos[] = new Boleto($boleto);

            $mapper->skip();
        }

        return $boletos;
    }

    public function boletoPdf($boleto_id) {
        $boletos = $this->getBoletos($boleto_id);

        if(!$boletos)
            return null;

        $directory = $this->f3->get('UPLOADS').'contratos';

        if(!file_exists($directory)) {
            mkdir($directory, 0755);
        }

        $filename = "$directory/boleto_a_$boleto_id.pdf";
        
        // instanciação do objeto :1 parametro: caminho do layout do boleto , 2 parametro :  array com os parametros para consulta no banco para localizar o boleto
        // pode ser passado como paramtro um array com os numeros dos boletos que serão impressos desde que criado sql dentro do arquivo jrxml(desativado nesse exemplo)
        \JasperPHP\Report::$defaultFolder = realpath(__DIR__.'/../vendor/quilhasoft/jasperphp-openboleto/app.jrxml');
        
        $report =new \JasperPHP\Report('bol01Files/boletoA4.jrxml',array());

        \JasperPHP\Pdf::prepare($report);    // prepara o relatorio lendo o arquivo
        $report->dbData = $boletos; // aqui voce pode construir seu array de boletos em qualquer estrutura incluindo 
        $report->generate();                // gera o relatorio

        $report->out();                     // gera o pdf
        $pdf  = \JasperPHP\Pdf::get();       // extrai o objeto pdf de dentro do report
        $data = $pdf->Output($filename, "S");  // metodo do TCPF para gerar saida para o browser

        file_put_contents($filename, $data);

        return $filename;
    }

    public function renderBoletoPdf($boleto_id) {
        $boletos = $this->getBoletos($boleto_id);

        if(!$boletos)
            return null;

        // instanciação do objeto :1 parametro: caminho do layout do boleto , 2 parametro :  array com os parametros para consulta no banco para localizar o boleto
        // pode ser passado como paramtro um array com os numeros dos boletos que serão impressos desde que criado sql dentro do arquivo jrxml(desativado nesse exemplo)
        \JasperPHP\Report::$defaultFolder = realpath(__DIR__.'/../vendor/quilhasoft/jasperphp-openboleto/app.jrxml');
        
        $report =new \JasperPHP\Report('bol01Files/boletoA4.jrxml',array());

        \JasperPHP\Pdf::prepare($report);    // prepara o relatorio lendo o arquivo
        $report->dbData = $boletos; // aqui voce pode construir seu array de boletos em qualquer estrutura incluindo 
        $report->generate();                // gera o relatorio

        $report->out();                     // gera o pdf
        $pdf  = \JasperPHP\Pdf::get();       // extrai o objeto pdf de dentro do report
        return $pdf->Output('boleto.pdf', "S");  // metodo do TCPF para gerar saida para o browser
    }
}