<?php

namespace SoftSAT\Locacao\Model;

use Dompdf\Dompdf;

use HwapX\Core\Library\Db\Sql\Mapper;
use Hwapx\Core\Library\Template;

use JasperPHP\Report;
use OpenBoleto\Banco\Santander;
use OpenBoleto\Agente;

use Softsat\Locacao\Model\Boleto;

class Contrato {
    protected $f3;

    public function __construct($f3) {
        $this->f3 = $f3;
    }

    public function renderPdf($contrato_id) {
        $db           = $this->f3->get('db');
        $this->mapper = new Mapper($db, 'softsat_locacao_contrato_relatorio');

        $data = array(
            'contrato'    => $this->mapper->findone(array('id = ?', $contrato_id)),
        );

        if(!$data['contrato'])
            return null;

        $data['local_saida_horario']   = $db->exec('SELECT * FROM softsat_locacao_local_horario_resumo WHERE local_id = ?', array($data['contrato']->local_saida_id));
        $data['local_entrada_horario'] = $db->exec('SELECT * FROM softsat_locacao_local_horario_resumo WHERE local_id = ?', array($data['contrato']->local_entrada_id));

        $html = Template::instance()->render('softsat/locacao/contrato/contrato-pdf.html', null, $data);

        $dompdf = new Dompdf();
        $dompdf->loadHtml($html);

        $dompdf->set_option('defaultFont', 'Helvetica');
        $dompdf->setPaper('A4', 'portrait');

        $dompdf->render();

        return $dompdf->output();
    }

    public function pdf($contrato_id) {
        $directory = $this->f3->get('UPLOADS').'contratos';

        if(!file_exists($directory)) {
            mkdir($directory, 0755);
        }

        $filename = "$directory/contrato_$contrato_id.pdf";
        $data     = $this->renderPdf($contrato_id);

        if(!$data)
            return null;

        file_put_contents($filename, $data);

        return $filename;
    }

    public function renderFaturaPdf($contrato_id) {
        $db           = $this->f3->get('db');
        $this->mapper = new Mapper($db, 'softsat_locacao_contrato_relatorio');

        $data = array(
            'contrato'    => $this->mapper->findone(array('id = ?', $contrato_id)),
        );

        if(!$data['contrato'])
            return null;

        $data['local_saida_horario']   = $db->exec('SELECT * FROM softsat_locacao_local_horario_resumo WHERE local_id = ?', array($data['contrato']->local_saida_id));
        $data['local_entrada_horario'] = $db->exec('SELECT * FROM softsat_locacao_local_horario_resumo WHERE local_id = ?', array($data['contrato']->local_entrada_id));

        $html = Template::instance()->render('softsat/locacao/contrato/fatura-pdf.html', null, $data);

        $dompdf = new Dompdf();
        $dompdf->loadHtml($html);

        $dompdf->set_option('defaultFont', 'Helvetica');
        $dompdf->setPaper('A4', 'portrait');

        $dompdf->render();

        return $dompdf->output();
    }

    public function faturaPdf($contrato_id) {
        $directory = $this->f3->get('UPLOADS').'contratos';

        if(!file_exists($directory)) {
            mkdir($directory, 0755);
        }

        $filename = "$directory/fatura_$contrato_id.pdf";
        $data     = $this->renderFaturaPdf($contrato_id);

        if(!$data)
            return null;

        file_put_contents($filename, $data);

        return $filename;
    }

    public function renderCroquiPdf($contrato_id) {
        $db           = $this->f3->get('db');
        $this->mapper = new Mapper($db, 'softsat_locacao_contrato_relatorio');

        $data = array(
            'contrato' => $this->mapper->findone(array('id = ?', $contrato_id))
        );

        if(!$data['contrato'])
            return null;

        $html = Template::instance()->render('softsat/locacao/contrato/croqui-pdf.html', null, $data);

        $dompdf = new Dompdf();
        $dompdf->loadHtml($html);

        $dompdf->setPaper('A4', 'portrait');

        $dompdf->render();

        return $dompdf->output();
    }

    public function croquiPdf($contrato_id) {
        $directory = $this->f3->get('UPLOADS').'contratos';

        if(!file_exists($directory)) {
            mkdir($directory, 0755);
        }

        $filename = "$directory/croqui_$contrato_id.pdf";
        $data     = $this->renderCroquiPdf($contrato_id);

        if(!$data)
            return null;

        file_put_contents($filename, $data);

        return $filename;
    }

    public function renderChecklistPdf($contrato_id) {
        $db           = $this->f3->get('db');
        $this->mapper = new Mapper($db, 'softsat_locacao_contrato_relatorio');

        $data = array(
            'contrato' => $this->mapper->findone(array('id = ?', $contrato_id)),
            'checklist' => (new Mapper($db, 'softsat_locacao_checklist'))->find(),
        );

        if(!$data['contrato'])
            return null;

        $html = Template::instance()->render('softsat/locacao/contrato/checklist-pdf.html', null, $data);

        $dompdf = new Dompdf();
        $dompdf->loadHtml($html);

        $dompdf->set_option('defaultFont', 'Helvetica');
        $dompdf->setPaper('A4', 'portrait');

        $dompdf->render();

        return $dompdf->output();
    }

    public function ChecklistPdf($contrato_id) {
        $directory = $this->f3->get('UPLOADS').'contratos';

        if(!file_exists($directory)) {
            mkdir($directory, 0755);
        }

        $filename = "$directory/checklist_$contrato_id.pdf";
        $data     = $this->renderChecklistPdf($contrato_id);

        if(!$data)
            return null;

        file_put_contents($filename, $data);

        return $filename;
    }

    public function getBoletos($contrato_id) {
        $db     = $this->f3->get('db');
        $mapper = new Mapper($db, 'softsat_locacao_boleto');
        $template = Template::instance();

        if(!$mapper->load(array('contrato_id = ? and cancelado = 0', $contrato_id)))
            return null;

        $boletos = array();

        while(!$mapper->dry()) {
            $sacado = new Agente($mapper->sacado_nome, $mapper->sacado_cnpj_cpf, $mapper->sacado_endereco, $mapper->sacado_cep, $mapper->sacado_cidade, $mapper->sacado_uf);
            $cedente = new Agente($mapper->cedente_nome, $mapper->cedente_cnpj, $mapper->cedente_endereco, $mapper->cedente_cep, $mapper->cedente_cidade, $mapper->cedente_uf);

            $agencia = explode('-', $mapper->agencia);
            $instrucoes = $template->resolve($mapper->instrucoes, array('boleto' => $mapper->cast()));
            $demonstrativo = $template->resolve($mapper->demonstrativo, array('boleto' => $mapper->cast()));
            $logo = $this->f3->get('ROOT').'/assets/img/logo_boleto.png';

            $boleto = new Santander(array(
                // Parâmetros obrigatórios
                'dataVencimento' => new \DateTime($mapper->vencimento),
                'valor' => $mapper->valor,
                'sequencial' => $mapper->sequencia, // 8 dígitos
                'sacado' => $sacado,
                'cedente' => $cedente,
                'agencia' => $agencia[0], // 4 dígitos
                'carteira' => $mapper->carteira, // 3 dígitos
                'conta' => preg_replace('/\D/', '', $mapper->cod_beneficiario), // 5 dígitos

                // Parâmetro obrigatório somente se a carteira for
                // 107, 122, 142, 143, 196 ou 198
                //'codigoCliente' => 12345, // 5 dígitos
                'numeroDocumento' => $mapper->id, // 7 dígitos

                // Parâmetros recomendáveis
                //'logoPath' => 'http://empresa.com.br/logo.jpg', // Logo da sua empresa
                //'contaDv' => 0,
                'agenciaDv' => $agencia[1],
                'descricaoDemonstrativo' => explode(PHP_EOL, $demonstrativo),
                'instrucoes' => explode(PHP_EOL, $instrucoes),

                // Parâmetros opcionais
                //'resourcePath' => '../resources',
                //'moeda' => Itau::MOEDA_REAL,
                'dataDocumento' => new \DateTime($mapper->emissao),
                'dataProcessamento' => new \DateTime($mapper->emissao),
                //'contraApresentacao' => true,
                //'pagamentoMinimo' => 23.00,
                //'aceite' => 'N',
                'especieDoc' => $mapper->especie_doc,
                //'usoBanco' => 'Uso banco',
                //'layout' => 'layout.phtml',
                'logoPath' => $logo,
                //'sacadorAvalista' => new Agente('Antônio da Silva', '02.123.123/0001-11'),
                //'descontosAbatimentos' => 123.12,
                //'moraMulta' => 123.12,
                //'outrasDeducoes' => 123.12,
                //'outrosAcrescimos' => 123.12,
                //'valorCobrado' => 123.12,
                //'valorUnitario' => 123.12,
                //'quantidade' => 1,
            ));

            $boletos[] = new Boleto($boleto);

            $mapper->skip();
        }

        return $boletos;
    }

    public function boletoPdf($contrato_id) {
        $boletos = $this->getBoletos($contrato_id);

        if(!$boletos)
            return null;

        $directory = $this->f3->get('UPLOADS').'contratos';

        if(!file_exists($directory)) {
            mkdir($directory, 0755);
        }

        $filename = "$directory/boleto_$contrato_id.pdf";
        
        // instanciação do objeto :1 parametro: caminho do layout do boleto , 2 parametro :  array com os parametros para consulta no banco para localizar o boleto
        // pode ser passado como paramtro um array com os numeros dos boletos que serão impressos desde que criado sql dentro do arquivo jrxml(desativado nesse exemplo)
        \JasperPHP\Report::$defaultFolder = realpath(__DIR__.'/../vendor/quilhasoft/jasperphp-openboleto/app.jrxml');
        
        $report =new \JasperPHP\Report('bol01Files/boletoA4.jrxml',array());

        \JasperPHP\Pdf::prepare($report);    // prepara o relatorio lendo o arquivo
        $report->dbData = $boletos; // aqui voce pode construir seu array de boletos em qualquer estrutura incluindo 
        $report->generate();                // gera o relatorio

        $report->out();                     // gera o pdf
        $pdf  = \JasperPHP\Pdf::get();       // extrai o objeto pdf de dentro do report
        $data = $pdf->Output($filename, "S");  // metodo do TCPF para gerar saida para o browser

        file_put_contents($filename, $data);

        return $filename;
    }

    public function renderBoletoPdf($contrato_id) {
        $boletos = $this->getBoletos($contrato_id);

        if(!$boletos)
            return null;

        // instanciação do objeto :1 parametro: caminho do layout do boleto , 2 parametro :  array com os parametros para consulta no banco para localizar o boleto
        // pode ser passado como paramtro um array com os numeros dos boletos que serão impressos desde que criado sql dentro do arquivo jrxml(desativado nesse exemplo)
        \JasperPHP\Report::$defaultFolder = realpath(__DIR__.'/../vendor/quilhasoft/jasperphp-openboleto/app.jrxml');
        
        $report =new \JasperPHP\Report('bol01Files/boletoA4.jrxml',array());

        \JasperPHP\Pdf::prepare($report);    // prepara o relatorio lendo o arquivo
        $report->dbData = $boletos; // aqui voce pode construir seu array de boletos em qualquer estrutura incluindo 
        $report->generate();                // gera o relatorio

        $report->out();                     // gera o pdf
        $pdf  = \JasperPHP\Pdf::get();       // extrai o objeto pdf de dentro do report
        return $pdf->Output('boleto.pdf', "S");  // metodo do TCPF para gerar saida para o browser
    }
}