<?php

namespace SoftSAT\Locacao\Model;

use Dompdf\Dompdf;

use HwapX\Core\Library\Db\Sql\Mapper;
use Hwapx\Core\Library\Template;

class Relatorio {
    protected $f3;

    public function __construct($f3) {
        $this->f3 = $f3;
    }

    protected function getData($args) {
        $db        = $this->f3->get('db');

        $params = array(
            ':veiculo' => empty($args['veiculo_id']) ? null : $args['veiculo_id'],
            ':marca'   => empty($args['marca_id'])   ? null : $args['marca_id'],
            ':grupo'   => empty($args['grupo_id'])   ? null : $args['grupo_id'],
            ':de'      => empty($args['data_de'])    ? null : convertDatetime($args['data_de'], 'd/m/Y', 'Y-m-d 00:00:00'),
            ':ate'     => empty($args['data_ate'])   ? null : convertDatetime($args['data_ate'], 'd/m/Y', 'Y-m-d 23:59:59'),
        );

        $args['marca']   = array_first($db->exec('SELECT * FROM softsat_locacao_marca WHERE id = ?', array($params[':marca'])));
        $args['grupo']   = array_first($db->exec('SELECT * FROM softsat_locacao_grupo WHERE id = ?', array($params[':grupo'])));
        $args['veiculo'] = array_first($db->exec('SELECT * FROM softsat_locacao_veiculo_detalhe WHERE id = ?', array($params[':veiculo'])));
        $veiculos_count = $db->exec('SELECT COUNT(1) AS count FROM softsat_locacao_veiculo_detalhe WHERE (inativado_em IS NULL OR inativado_em > ?) AND (created_on <= ?)', array($params[':de'], $params[':ate']))[0]['count'];
        
        $veiculos = $db->exec(
            'SELECT * FROM softsat_locacao_veiculo_detalhe WHERE 
                (id = :veiculo OR :veiculo IS NULL) AND
                (marca_id = :marca OR :marca IS NULL) AND
                (grupo_id = :grupo OR :grupo IS NULL) AND
                (inativado_em IS NULL OR inativado_em > :de) AND 
                (created_on <= :ate)
                ORDER BY id',
            $params
        );

        $despesas = $db->exec(
            'SELECT * FROM softsat_locacao_despesa_detalhe WHERE 
                (veiculo_id = :veiculo OR :veiculo IS NULL) AND
                (veiculo_marca_id = :marca OR :marca IS NULL) AND
                (veiculo_grupo_id = :grupo OR :grupo IS NULL) AND
                `data` BETWEEN :de AND :ate
                ORDER BY veiculo_id, `data`',
            $params
        );

        $desp_gerais = $db->exec(
            "SELECT * FROM softsat_locacao_despesa_detalhe WHERE
                veiculo_id IS NULL AND data BETWEEN :de AND :ate
                ORDER BY veiculo_id, data", 
            array_extract($params, array(':conta', ':de', ':ate'))
        );

        $contratos = $db->exec(
            "SELECT * FROM softsat_locacao_contrato_relatorio WHERE 
                status = 'F' AND 
                (veiculo_id = :veiculo OR :veiculo IS NULL) AND
                (veiculo_marca_id = :marca OR :marca IS NULL) AND
                (veiculo_grupo_id = :grupo OR :grupo IS NULL) AND
                entrada BETWEEN :de AND :ate", 
            $params
        );

        $planos_contas = array();
        
        foreach($veiculos as $veiculo)
            $planos_contas[$veiculo['id']] = $db->exec(
                'CALL softsat_locacao_plano_conta_valor(?, ?, ?, NULL, NULL, NULL)',
                array($params[':de'], $params[':ate'], $veiculo['id'])
            );

        foreach($planos_contas as &$por_veiculo)
            $por_veiculo = array_change_key($por_veiculo, 'id');

        return array(
            'filtro'    => $args,
            'veiculos'  => $veiculos,
            'contratos' => array_group($contratos, 'veiculo_id'),
            'despesas'  => array_group($despesas, 'veiculo_id'),
            'planos_contas'   => $planos_contas,
            'despesas_gerais' => $desp_gerais,
            'qtde_veiculos'   => $veiculos_count,
        );
    }

    public function faturamentoVeiculoPlanoPdf($args) {
        $data = $this->getData($args);

        $html = Template::instance()->render('softsat/locacao/relatorio/faturamento/veiculo_plano.html', null, $data);

        $dompdf = new Dompdf();
        $dompdf->loadHtml($html);

        $dompdf->setPaper('A4', 'portrait');

        $dompdf->render();

        return $dompdf->output();
    }

    public function faturamentoDetalhePdf($args) {
        $data = $this->getData($args);

        $html = Template::instance()->render('softsat/locacao/relatorio/faturamento/veiculo_detalhe.html', null, $data);

        $dompdf = new Dompdf();
        $dompdf->loadHtml($html);

        $dompdf->setPaper('A4', 'portrait');

        $dompdf->render();

        return $dompdf->output();
    }

    public function faturamentoResumoPdf($args) {
        $data = $this->getData($args);

        $html = Template::instance()->render('softsat/locacao/relatorio/faturamento/veiculo_resumo.html', null, $data);

        $dompdf = new Dompdf();
        $dompdf->loadHtml($html);

        $dompdf->setPaper('A4', 'portrait');

        $dompdf->render();

        return $dompdf->output();
    }

    protected function getDataPlanoVeiculo($args) {
        $db        = $this->f3->get('db');

        $params = array(
            ':veiculo' => empty($args['veiculo_id']) ? null : $args['veiculo_id'],
            ':marca'   => empty($args['marca_id'])   ? null : $args['marca_id'],
            ':grupo'   => empty($args['grupo_id'])   ? null : $args['grupo_id'],
            ':de'      => empty($args['data_de'])    ? null : convertDatetime($args['data_de'], 'd/m/Y', 'Y-m-d 00:00:00'),
            ':ate'     => empty($args['data_ate'])   ? null : convertDatetime($args['data_ate'], 'd/m/Y', 'Y-m-d 23:59:59'),
        );

        $args['marca']   = array_first($db->exec('SELECT * FROM softsat_locacao_marca WHERE id = ?', array($params[':marca'])));
        $args['grupo']   = array_first($db->exec('SELECT * FROM softsat_locacao_grupo WHERE id = ?', array($params[':grupo'])));
        $args['veiculo'] = array_first($db->exec('SELECT * FROM softsat_locacao_veiculo_detalhe WHERE id = ?', array($params[':veiculo'])));
        $total_veiculos  = $db->exec('SELECT COUNT(1) AS count FROM softsat_locacao_veiculo_detalhe WHERE (inativado_em IS NULL OR inativado_em > ?) AND (created_on <= ?)', array($params[':de'], $params[':ate']))[0]['count'];
        $qtde_veiculos   = $db->exec(
            'SELECT COUNT(1) AS count FROM softsat_locacao_veiculo_detalhe WHERE
                (id = :veiculo OR :veiculo IS NULL) AND
                (marca_id = :marca OR :marca IS NULL) AND
                (grupo_id = :grupo OR :grupo IS NULL) AND
                (inativado_em IS NULL OR inativado_em > :de) AND 
                (created_on <= :ate)',
            $params
        )[0]['count'];
        
        $veiculos = $db->exec(
            'SELECT * FROM softsat_locacao_veiculo_detalhe WHERE
                (id = :veiculo OR :veiculo IS NULL) AND
                (marca_id = :marca OR :marca IS NULL) AND
                (grupo_id = :grupo OR :grupo IS NULL) AND
                (inativado_em IS NULL OR inativado_em > :de) AND 
                (created_on <= :ate)
                ORDER BY id',
            $params
        );

        $despesas = $db->exec(
            'SELECT * FROM softsat_locacao_despesa_detalhe WHERE 
                (veiculo_id = :veiculo OR (:veiculo IS NULL AND veiculo_id IS NOT NULL)) AND
                (veiculo_marca_id = :marca OR :marca IS NULL) AND
                (veiculo_grupo_id = :grupo OR :grupo IS NULL) AND
                `data` BETWEEN :de AND :ate
                ORDER BY veiculo_id, `data`',
            $params
        );

        $desp_gerais = $db->exec(
            "SELECT * FROM softsat_locacao_despesa_detalhe WHERE
                veiculo_id IS NULL AND `data` BETWEEN ? AND ?
                ORDER BY veiculo_id, `data`", 
            array($params[':de'], $params[':ate'])
        );

        $contratos = $db->exec(
            "SELECT * FROM softsat_locacao_contrato_relatorio WHERE 
                status = 'F' AND 
                (veiculo_id = :veiculo OR :veiculo IS NULL) AND
                (veiculo_marca_id = :marca OR :marca IS NULL) AND
                (veiculo_grupo_id = :grupo OR :grupo IS NULL) AND
                entrada BETWEEN :de AND :ate
                ORDER BY veiculo_grupo_id, veiculo_id, entrada", 
            $params
        );

        $contratos = array_group($contratos, 'veiculo_grupo_id');

        foreach($contratos as &$grupo)
            $grupo = array(
                'total'    => array_aggregate($grupo, 'total'),
                'veiculos' => array_group($grupo, 'veiculo_id'),
            );

        $planos_contas = $db->exec(
            'CALL softsat_locacao_plano_conta_valor(:de, :ate, :veiculo, :marca, :grupo, NULL)',
            $params
        );

        return array(
            'filtro'    => $args,
            'grupos'    => $contratos,
            'despesas'  => array_group($despesas, 'plano_conta_id'),
            'planos_contas'   => $planos_contas,
            'qtde_veiculos'   => $qtde_veiculos,
            'total_veiculos'  => $total_veiculos,
            'despesas_gerais' => $desp_gerais,
        );
    }

    public function faturamentoPlanoVeiculoPdf($args) {
        $data = $this->getDataPlanoVeiculo($args);

        $html = Template::instance()->render('softsat/locacao/relatorio/faturamento/plano_veiculo.html', null, $data);

        $dompdf = new Dompdf();
        $dompdf->loadHtml($html);

        $dompdf->setPaper('A4', 'portrait');

        $dompdf->render();

        return $dompdf->output();
    }
}