<?php

namespace Softsat\Locacao;

use DB\SQL\Schema;

use HwapX\Core\Library\DB\SQL\Mapper;
use HwapX\Core\Library\Modulebase;
use HwapX\Core\Library\Template;

use SoftSAT\Locacao\Model\Contrato as ContratoModel;

class Module extends Modulebase {
    const version = '1.0.0';

    public static $sidebar = array(
        'locacao' => array(
            'label' => '  Locação',
            'icon' => 'road',
            array('label' => 'Contratos', 'icon' => 'file', 'role' => 'softsat.locacao.contrato_list', 'route' => 'softsat_locacao_admin_contrato_list'),
            array('label' => 'Clientes', 'icon' => 'user', 'role' => 'softsat.locacao.cliente_list', 'route' => 'softsat_locacao_admin_cliente_list'),
            array('label' => 'Veiculos', 'icon' => 'record', 'role' => 'softsat.locacao.veiculo_list', 'route' => 'softsat_locacao_admin_veiculo_list'),
            array('label' => 'Manutenção', 'icon' => 'wrench', 'role' => 'softsat.locacao.manutencao_list', 'route' => 'softsat_locacao_admin_manutencao_list'),

            array('label' => 'Marcas', 'icon' => 'tag', 'role' => 'softsat.locacao.marca_list', 'route' => 'softsat_locacao_admin_marca_list'),
            array('label' => 'Combustíveis', 'icon' => 'dashboard', 'role' => 'softsat.locacao.combustivel_list', 'route' => 'softsat_locacao_admin_combustivel_list'),
            array('label' => 'Grupos', 'icon' => 'th-large', 'role' => 'softsat.locacao.grupo_list', 'route' => 'softsat_locacao_admin_grupo_list'),
            array('label' => 'Tarifas', 'icon' => 'tags', 'role' => 'softsat.locacao.tarifa_list', 'route' => 'softsat_locacao_admin_tarifa_list'),
            array('label' => 'Formas de Pagamento', 'icon' => 'credit-card', 'role' => 'softsat.locacao.forma_pagamento_list', 'route' => 'softsat_locacao_admin_forma_pagamento_list'),
            array('label' => 'Condições de Pagamento', 'icon' => 'sort-by-order', 'role' => 'softsat.locacao.condicao_pagamento_list', 'route' => 'softsat_locacao_admin_condicao_pagamento_list'),
            array('label' => 'Checklist', 'icon' => 'check', 'role' => 'softsat.locacao.checklist_list', 'route' => 'softsat_locacao_admin_checklist_list'),
            array('label' => 'IPVA', 'icon' => 'list-alt', 'role' => 'softsat.locacao.ipva_list', 'route' => 'softsat_locacao_admin_ipva_list'),
            array('label' => 'Locais', 'icon' => 'home', 'role' => 'softsat.locacao.local_list', 'route' => 'softsat_locacao_admin_local_list'),

            array('label' => 'Planos de contas', 'icon' => 'align-left', 'role' => 'softsat.locacao.plano_conta_list', 'route' => 'softsat_locacao_admin_plano_conta_list'),
            array('label' => 'Despesas', 'icon' => 'usd', 'role' => 'softsat.locacao.despesa_list', 'route' => 'softsat_locacao_admin_despesa_list'),

            array('label' => 'Relatórios', 'icon' => 'list', 'role' => 'softsat.locacao.relatorio', 'route' => 'softsat_locacao_admin_relatorio_form'),
        ),
        ' boleto' => array(
            'label' => ' Boletos',
            'icon' => 'briefcase',
            array('label' => 'Boletos', 'icon' => 'paste', 'role' => 'softsat.locacao.boleto_list', 'route' => 'softsat_locacao_admin_boleto_list'),
            array('label' => 'Remessas de boleto', 'icon' => 'save-file', 'role' => 'softsat.locacao.boleto_remessa_list', 'route' => 'softsat_locacao_admin_boleto_remessa_list'),
        ),
    );

    public static $roles = array(
        'contrato_create' => 'Criar Contrato',
        'contrato_edit'   => 'Editar Contrato',
        'contrato_remove' => 'Remover Contrato',
        'contrato_list'   => 'Listar Contrato',
        'contrato_print'  => 'Imprimir Contrato',
        'contrato_fatura_print'  => 'Imprimir Fatura do contrato',
        'contrato_boleto_print' => 'Imprimir Boleto do contrato',
        'contrato_croqui_print'  => 'Imprimir Croqui do veículo do contrato',
        'contrato_checklist_print' => 'Imprimir Checklist do contrato',

        'veiculo_create' => 'Criar Veículo',
        'veiculo_edit'   => 'Editar Veículo',
        'veiculo_remove' => 'Remover Veículo',
        'veiculo_list'   => 'Listar Veículo',
        'veiculo_blueprint' => 'Imprimir croqui do veículo',

        'manutencao_edit'   => 'Editar veículos para manutenção',
        'manutencao_list'   => 'Listar veículos para manutenção',

        'checklist_create' => 'Criar Checklist',
        'checklist_edit'   => 'Editar Checklist',
        'checklist_remove' => 'Remover Checklist',
        'checklist_list'   => 'Listar Checklist',

        'cliente_create' => 'Criar Cliente',
        'cliente_edit'   => 'Editar Cliente',
        'cliente_remove' => 'Remover Cliente',
        'cliente_list'   => 'Listar Cliente',
        'cliente_cartao' => 'Editar Cartões do cliente',

        'marca_create' => 'Criar Marca',
        'marca_edit'   => 'Editar Marca',
        'marca_remove' => 'Remover Marca',
        'marca_list'   => 'Listar Marca',

        'tarifa_create' => 'Criar Tarifa',
        'tarifa_edit'   => 'Editar Tarifa',
        'tarifa_remove' => 'Remover Tarifa',
        'tarifa_list'   => 'Listar Tarifa',

        'grupo_create' => 'Criar Grupo',
        'grupo_edit'   => 'Editar Grupo',
        'grupo_remove' => 'Remover Grupo',
        'grupo_list'   => 'Listar Grupo',

        'combustivel_create' => 'Criar Combustível',
        'combustivel_edit'   => 'Editar Combustível',
        'combustivel_remove' => 'Remover Combustível',
        'combustivel_list'   => 'Listar Combustível',

        'forma_pagamento_create' => 'Criar Forma de pagamento',
        'forma_pagamento_edit'   => 'Editar Forma de pagamento',
        'forma_pagamento_remove' => 'Remover Forma de pagamento',
        'forma_pagamento_list'   => 'Listar Forma de pagamento',

        'condicao_pagamento_create' => 'Criar Condição de pagamento',
        'condicao_pagamento_edit'   => 'Editar Condição de pagamento',
        'condicao_pagamento_remove' => 'Remover Condição de pagamento',
        'condicao_pagamento_list'   => 'Listar Condição de pagamento',

        'ipva_create' => 'Criar IPVA',
        'ipva_edit'   => 'Editar IPVA',
        'ipva_remove' => 'Remover IPVA',
        'ipva_list'   => 'Listar IPVA',

        'local_create' => 'Criar Local',
        'local_edit'   => 'Editar Local',
        'local_remove' => 'Remover Local',
        'local_list'   => 'Listar Locais',

        'plano_conta_create' => 'Criar Plano de conta',
        'plano_conta_edit'   => 'Editar Plano de conta',
        'plano_conta_remove' => 'Remover Plano de conta',
        'plano_conta_list'   => 'Listar Planos de contas',

        'despesa_create' => 'Criar Despesa',
        'despesa_edit'   => 'Editar Despesa',
        'despesa_remove' => 'Remover Despesa',
        'despesa_list'   => 'Listar Despesas',

        'boleto_create' => 'Criar Boleto',
        'boleto_edit'   => 'Editar Boleto',
        'boleto_remove' => 'Remover Boleto',
        'boleto_list'   => 'Listar Boleto',
        'boleto_print'  => 'Imprimir Boleto',
        'boleto_email'  => 'Enviar Boleto por e-mail',

        'boleto_remessa_create'   => 'Criar Remessa',
        'boleto_remessa_list'     => 'Listar Remessas',
        'boleto_remessa_download' => 'Baixar Remessas',

        'relatorio'   => 'Relatórios',
        'grafico'     => 'Gráfico',
    );

    protected $f3 = null;

    public function __construct($f3) {
        $this->f3     = $f3;
    }

    public function boot($f3) {
        \Cron::instance();
    }

    public function install() {
    }

    public function uninstall() {
        $db     = $this->f3->get('db');
        $schema = new Schema($db);
    }

    public static function cron($f3) {
        $db        = $f3->get('db');
        $contratos = new Mapper($db, 'softsat_locacao_contrato_relatorio');
        $templates = $f3->get('settings.softsat.locacao.email.contrato');

        foreach($contratos->find(array('email_reserva = 1 OR email_aberto = 1 OR email_faturado = 1')) as $contrato) {
            if($contrato->email_reserva) {
                if($templates['admin']['reserva'])
                    \SMTPEnqueue($templates['admin']['reserva'], $contrato->cast());

                if($contrato->cliente_email && $templates['cliente']['reserva'])
                    \SMTPEnqueue($templates['cliente']['reserva'], $contrato->cast(), $contrato->cliente_email);
            }

            if($contrato->email_aberto) {
                if($templates['admin']['aberto'])
                    \SMTPEnqueue($templates['admin']['aberto'], $contrato->cast());

                if($contrato->cliente_email && $templates['cliente']['aberto']) {
                    $model      = new ContratoModel($f3);
                    $attachment = array('contrato.pdf' => $model->pdf($contrato->id));
                    $boleto = $model->boletoPdf($contrato->id);
                    if($boleto)
                        $attachment['boleto.pdf'] = $boleto;

                    \SMTPEnqueue($templates['cliente']['aberto'], $contrato->cast(), $contrato->cliente_email, $attachment);
                }
            }

            if($contrato->email_faturado) {
                if($templates['admin']['faturado'])
                    \SMTPEnqueue($templates['admin']['faturado'], $contrato->cast());

                if($contrato->cliente_email && $templates['cliente']['faturado']) {
                    $model      = new ContratoModel($f3);
                    $attachment = array('fatura.pdf' => $model->faturaPdf($contrato->id));

                    \SMTPEnqueue($templates['cliente']['faturado'], $contrato->cast(), $contrato->cliente_email, $attachment);
                }
            }

            $db->exec('UPDATE softsat_locacao_contrato SET email_reserva = 0, email_aberto = 0, email_faturado = 0 WHERE id = ?', $contrato->id);
        }
    }

    public static function cron_manutencao($f3) {
        $db       = $f3->get('db');
        $veiculos = new Mapper($db, 'softsat_locacao_veiculo_manutencao');

        $templates = $f3->get('settings.softsat.locacao.email.manutencao');

        foreach($veiculos->find() as $veiculo) {
            if($veiculo->manutencao_oleo && $templates['oleo'])
                \SMTPEnqueue($templates['oleo'], $veiculo->cast());

            if($veiculo->manutencao_pastilha && $templates['pastilha'])
                \SMTPEnqueue($templates['pastilha'], $veiculo->cast());

            if($veiculo->manutencao_pneu && $templates['pneu'])
                \SMTPEnqueue($templates['pneu'], $veiculo->cast());

            if($veiculo->manutencao_filtro_ar && $templates['filtro_ar'])
                \SMTPEnqueue($templates['filtro_ar'], $veiculo->cast());

            if($veiculo->manutencao_filtro_comb && $templates['filtro_comb'])
                \SMTPEnqueue($templates['filtro_comb'], $veiculo->cast());

            if($veiculo->manutencao_disco && $templates['disco'])
                \SMTPEnqueue($templates['disco'], $veiculo->cast());

            if($veiculo->manutencao_correia && $templates['correia'])
                \SMTPEnqueue($templates['correia'], $veiculo->cast());
        }
    }

    public static function cron_licenciamento($f3) {
        $db       = $f3->get('db');
        $veiculos = new Mapper($db, 'softsat_locacao_veiculo_licenciamento');

        $template = $f3->get('settings.softsat.locacao.email.licenciamento');

        if(!$template)
            return;

        foreach($veiculos->find('mes_licenciamento = MONTH(CURRENT_DATE)') as $veiculo)
            \SMTPEnqueue($template, $veiculo->cast());
    }

    public static function cron_ipva($f3) {
        $db       = $f3->get('db');
        $parcelas = new Mapper($db, 'softsat_locacao_veiculo_ipva_pendente');

        $template = $f3->get('settings.softsat.locacao.email.ipva');
        $dias     = (int)$f3->get('settings.softsat.locacao.ipva.dias_notificacao');

        if(!$template)
            return;

        foreach($parcelas->find("CURRENT_DATE >= SUBDATE(vencimento, $dias)") as $parcela) {
            $veiculo = new Mapper($db, 'softsat_locacao_veiculo_detalhe');
            $veiculo->load(array('id = ?', $parcela->veiculo_id));
            $data = $veiculo->cast();
            $data['parcela'] = $parcela->cast();
            \SMTPEnqueue($template, $data);
        }
    }
}