(function() {
    window.buscarCNPJ = function(cnpjInput, inputmap) {
        var value = $(cnpjInput).val();

        if(!value)
            return;

        value = value.replace(/\D/g, '');

        if(value.length != 14)
            return;

        for(input in inputmap) {
            $(input).prop('disabled', true);
        }

        $.getJSON('/api/cnpj/' + value, function(resp) {
            if(!resp || resp.error) {
                alert('O CNPJ informado não foi localizado, mas não se preocupe você pode continuar o cadastro mesmo assim.');
                return;
            }

            for(input in inputmap) {
                field  = inputmap[input];
                $input = $(input);
                //if(!$input.val())
                    $input.val(resp.data[field]).trigger('change');
            }
        }).always(function() {
            for(input in inputmap) {
                $(input).prop('disabled', false);
            }
        });
    }
})();