(function() {
    window.buscarEndereco = function(cepinput, inputmap) {
        var $cepInput = $(cepinput);
        var oldValue = $cepInput.val();
        $cepInput.blur(function() {
            var maskedValue = this.value;
            var value = this.value;

            if(!value)
                return;

            if(value == oldValue)
                return;

            value = value.replace(/\D/g, '');

            if(value.length != 8)
                return;

            for(input in inputmap) {
                $(input).prop('disabled', true);
            }

            $.getJSON('/api/cep/' + value, function(resp) {
                if(!resp || resp.error) {
                    alert('O CEP informado não foi localizado, mas não se preocupe você pode continuar o cadastro mesmo assim.');
                    return;
                }

                for(input in inputmap) {
                    field  = inputmap[input];
                    $input = $(input);
                    //if(!$input.val())
                        $input.val(resp.data[field]).trigger('change');
                }

                oldValue = maskedValue;
            }).always(function() {
                for(input in inputmap) {
                    $(input).prop('disabled', false);
                }
            });
        });
    }
})();