<?php
require 'vendor/autoload.php';

function _init()
{
    require 'app/modules/hwapx/core/library/modulemanager.php';
    //use Hwapx\Core\Library\ModuleManager;

    $f3 = F3::instance();

    $f3->config('app/config/app.ini');
    $f3->config('app/config/config.ini');

    setlocale(LC_NUMERIC, 'C');

    Hwapx\Core\Library\ModuleManager::instance($f3)->load();

    $f3->route(
        'GET /minify/assets/*',
        function($f3, $args) {
            $dir  = $f3->get('ASSETS');
            $file = $args['*'];
            $filepath = $dir.$file;

            if(strpos($file, '..') !== false) {
                $f3->error(404);
            }

            if(!is_file($filepath)) {
                $f3->error(404);
            }

            $hash = md5($filepath.filemtime($filepath));
            header('ETag: "'.$hash.'"');
            header('Expires: '.gmdate('D, d M Y H:i:s \G\M\T', time() + (60 * 60)));
            echo Web::instance()->minify($file, null, true, $dir);
        },
        60 * 60
    );
    return $f3;
};

_init()->run();
