CREATE TABLE softsat_locacao_condicao_pagamento (
	id INTEGER PRIMARY KEY AUTO_INCREMENT,
	`created_on` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
	`updated_on` DATETIME NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
	`created_by` INT(11) NULL DEFAULT NULL,
	`updated_by` INT(11) NULL DEFAULT NULL,
	nome VARCHAR(255) NOT NULL,
	parcelas INTEGER NOT NULL,
	sem_entrada INTEGER NOT NULL DEFAULT 0,
	intervalo INTEGER NOT NULL,
	tipo ENUM('day','week','month') NOT NULL
)
COLLATE='utf8_unicode_ci'
ENGINE=INNODB;

ALTER TABLE `softsat_locacao_contrato`
	ADD COLUMN `condicao_pagamento_id` INT NOT NULL AFTER `subtotal`;
	
INSERT INTO `softsat_locacao_condicao_pagamento` (`id`, `created_on`, `updated_on`, `created_by`, `updated_by`, `nome`, `parcelas`, `sem_entrada`, `intervalo`, `tipo`) VALUES (1, '2019-04-30 16:05:25', '2019-04-30 16:05:20', 1, NULL, 'À Vista', 1, 0, 0, 'day');

UPDATE softsat_locacao_contrato SET condicao_pagamento_id = 1 WHERE condicao_pagamento_id IS NULL OR condicao_pagamento_id = 0;
	
ALTER TABLE `softsat_locacao_contrato`
	ADD CONSTRAINT `fk_softsat_locacao_contrato_softsat_locacao_condicao_pagamento` FOREIGN KEY (`condicao_pagamento_id`) REFERENCES `softsat_locacao_condicao_pagamento` (`id`);

CREATE TABLE softsat_locacao_boleto (
	id INTEGER PRIMARY KEY AUTO_INCREMENT,
	`created_on` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
	`updated_on` DATETIME NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
	`created_by` INT(11) NULL DEFAULT NULL,
	`updated_by` INT(11) NULL DEFAULT NULL,
	contrato_id INTEGER NOT NULL,
	cliente_id INTEGER NOT NULL,
	sacado_nome VARCHAR(40) NOT NULL,
	sacado_cnpj_cpf VARCHAR(18),
	sacado_endereco VARCHAR(40),
	sacado_bairro VARCHAR(12),
	sacado_cep VARCHAR(9),
	sacado_uf VARCHAR(2),
	sacado_municipio VARCHAR(15),
	cedente_nome VARCHAR(40) NOT NULL,
	cedente_cnpj_cpf VARCHAR(18),
	cedente_endereco VARCHAR(40),
	cedente_bairro VARCHAR(12),
	cedente_cep VARCHAR(9),
	cedente_uf VARCHAR(2),
	cedente_municipio VARCHAR(15),
	sequencia INTEGER NOT NULL,
	agencia VARCHAR(32) NOT NULL,
	carteira VARCHAR(10) NOT NULL,
	conta VARCHAR(32) NOT NULL,
	instrucoes TEXT,
	emissao DATE NOT NULL,
	vencimento DATE NOT NULL,
	valor DECIMAL(12, 2) NOT NULL,
	multa DECIMAL(12, 2) NOT NULL,
	juros DECIMAL(12, 2) NOT NULL,
	cancelado INTEGER NOT NULL DEFAULT 0,
	baixado INTEGER NOT NULL DEFAULT 0
)
COLLATE='utf8_unicode_ci'
ENGINE=INNODB;

CREATE TABLE softsat_locacao_boleto_remessa(
	id INTEGER PRIMARY KEY AUTO_INCREMENT,
	`created_on` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
	`updated_on` DATETIME NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
	`created_by` INT(11) NULL DEFAULT NULL,
	`updated_by` INT(11) NULL DEFAULT NULL,
	numero INTEGER NOT NULL,
	emissao DATE NOT NULL
)
COLLATE='utf8_unicode_ci'
ENGINE=INNODB;