DROP PROCEDURE IF EXISTS softsat_locacao_contrato_boleto_gerar;
delimiter //
CREATE PROCEDURE `softsat_locacao_contrato_boleto_gerar`(
	IN `in_cliente_id` INT,
	IN `in_valor` INT,
	IN `in_emissao` DATE,
	IN `in_parcelas` INT,
	IN `in_sem_entrada` INT,
	IN `in_dias_parcela` INT,
	IN `in_contrato_id` INT
)
LANGUAGE SQL
NOT DETERMINISTIC
CONTAINS SQL
SQL SECURITY DEFINER
BEGIN
	DECLARE parcela INT DEFAULT 0;
	DECLARE sequencia INT;
    DECLARE valor DECIMAL(12, 2);

	UPDATE softsat_locacao_boleto SET cancelado = 1 WHERE contrato_id = in_contrato_id;

    SET valor = ROUND(in_valor / in_parcelas, 2);

	WHILE(parcela < in_parcelas) DO
		/*SELECT VALUE INTO sequencia FROM hwapx_setting WHERE id = 'softsat.locacao.boleto.sequencia' FOR UPDATE;
		UPDATE hwapx_setting SET VALUE = sequencia + 1 WHERE id = 'softsat.locacao.boleto.sequencia';*/
        SET sequencia = softsat_locacao_boleto_sequencia();

		INSERT INTO softsat_locacao_boleto(sacado_nome, sacado_cnpj_cpf, sacado_email, sacado_endereco, sacado_bairro, sacado_cep, sacado_cidade, sacado_uf, 
			cedente_nome, cedente_cnpj, cedente_endereco, cedente_cep, cedente_cidade, cedente_uf, 
			agencia, carteira, conta, cod_beneficiario, demonstrativo, instrucoes, especie_doc, dias_protesto, 
            multa, multa_valor, mora, mora_valor,
            emissao, vencimento, valor, cancelado, baixado, sequencia,
			cliente_id, contrato_id)
		SELECT sacado.nome, sacado.cnpj_cpf, sacado.email, CONCAT(sacado.endereco, ', ', sacado.numero, ' '), sacado.bairro, sacado.cep, sacado.cidade, sacado.estado,
			c_nome.value, c_cnpj.value, c_endereco.value, c_cep.value, c_cidade.value, c_uf.value,
			agencia.value, carteira.value, conta.value, benef.value, demonstrativo.value, instrucoes.value, especie.value, protesto.value,
            multa.value, ROUND(multa.value / 100.00 * valor, 2), 
            mora.value, ROUND(mora.value / 100.00 * valor, 2), 
            in_emissao, 
			ADDDATE(ADDDATE(in_emissao, if(in_sem_entrada, 0, dias_venc.value)), in_dias_parcela * (parcela + in_sem_entrada)), 
			valor, 0, 0, sequencia,
			in_cliente_id, in_contrato_id
			FROM softsat_locacao_cliente AS sacado
		LEFT JOIN hwapx_setting AS agencia ON agencia.id = 'softsat.locacao.boleto.agencia'
		LEFT JOIN hwapx_setting AS carteira ON carteira.id = 'softsat.locacao.boleto.carteira'
		LEFT JOIN hwapx_setting AS conta ON conta.id = 'softsat.locacao.boleto.conta'
		LEFT JOIN hwapx_setting AS benef ON benef.id = 'softsat.locacao.boleto.cod_beneficiario'
		LEFT JOIN hwapx_setting AS instrucoes ON instrucoes.id = 'softsat.locacao.boleto.instrucoes'
		LEFT JOIN hwapx_setting AS demonstrativo ON demonstrativo.id = 'softsat.locacao.boleto.demonstrativo'
		LEFT JOIN hwapx_setting AS sequencia ON sequencia.id = 'softsat.locacao.boleto.sequencia'
		LEFT JOIN hwapx_setting AS multa ON multa.id = 'softsat.locacao.boleto.multa'
		LEFT JOIN hwapx_setting AS mora ON mora.id = 'softsat.locacao.boleto.mora'
		LEFT JOIN hwapx_setting AS especie ON especie.id = 'softsat.locacao.boleto.especie_doc'
		LEFT JOIN hwapx_setting AS protesto ON protesto.id = 'softsat.locacao.boleto.dias_protesto'
		LEFT JOIN hwapx_setting AS dias_venc ON dias_venc.id = 'softsat.locacao.boleto.dias_vencimento'
		LEFT JOIN hwapx_setting AS c_nome ON c_nome.id = 'softsat.locacao.boleto.cedente.nome'
		LEFT JOIN hwapx_setting AS c_cnpj ON c_cnpj.id = 'softsat.locacao.boleto.cedente.cnpj'
		LEFT JOIN hwapx_setting AS c_endereco ON c_endereco.id = 'softsat.locacao.boleto.cedente.endereco'
		LEFT JOIN hwapx_setting AS c_cep ON c_cep.id = 'softsat.locacao.boleto.cedente.cep'
		LEFT JOIN hwapx_setting AS c_cidade ON c_cidade.id = 'softsat.locacao.boleto.cedente.cidade'
		LEFT JOIN hwapx_setting AS c_uf ON c_uf.id = 'softsat.locacao.boleto.cedente.uf'
		WHERE sacado.id = in_cliente_id;

		SET parcela = parcela + 1;
	END WHILE;
END//
delimiter ;