ALTER TABLE `softsat_locacao_veiculo`
	ADD COLUMN `km_filtro_ar` DECIMAL(13,3) NULL DEFAULT NULL,
	ADD COLUMN `data_filtro_ar` DATE NULL DEFAULT NULL;

ALTER TABLE `softsat_locacao_veiculo`
	ADD COLUMN `km_filtro_comb` DECIMAL(13,3) NULL DEFAULT NULL,
	ADD COLUMN `data_filtro_comb` DATE NULL DEFAULT NULL;

ALTER TABLE `softsat_locacao_veiculo`
	ADD COLUMN `km_disco` DECIMAL(13,3) NULL DEFAULT NULL,
	ADD COLUMN `data_disco` DATE NULL DEFAULT NULL;

ALTER TABLE `softsat_locacao_veiculo`
	ADD COLUMN `km_correia` DECIMAL(13,3) NULL DEFAULT NULL,
	ADD COLUMN `data_correia` DATE NULL DEFAULT NULL;

ALTER TABLE `softsat_locacao_veiculo`
	CHANGE COLUMN `km_suspensao` `km_pastilha` DECIMAL(13,3) NULL DEFAULT NULL,
	CHANGE COLUMN `data_suspensao` `data_pastilha` DATE NULL DEFAULT NULL;
	
UPDATE `hwapx_setting` 
	SET id = 'softsat.locacao.manutencao.km_pastilha', label = 'Km para manutenção das pastilhas de freio'
	WHERE id = 'softsat.locacao.manutencao.km_suspensao';

UPDATE hwapx_setting
	SET id = 'softsat.locacao.email.manutencao.pastilha', label = 'Template Manutenção das pastilhas de freio'
	WHERE id = 'softsat.locacao.email.manutencao.suspensao';

INSERT INTO `hwapx_setting` (`id`, `value`, `field_order`, `label`, `group`, `type`, `rules`) VALUES ('softsat.locacao.manutencao.km_filtro_ar', '10000', 5, 'Km para manutenção do filtro de ar', 'Veículo', 'number', 'required');
INSERT INTO `hwapx_setting` (`id`, `value`, `field_order`, `label`, `group`, `type`, `rules`) VALUES ('softsat.locacao.manutencao.km_filtro_comb', '10000', 6, 'Km para manutenção do filtro de combustível', 'Veículo', 'number', 'required');
INSERT INTO `hwapx_setting` (`id`, `value`, `field_order`, `label`, `group`, `type`, `rules`) VALUES ('softsat.locacao.manutencao.km_disco', '10000', 7, 'Km para manutenção dos discos de freio', 'Veículo', 'number', 'required');
INSERT INTO `hwapx_setting` (`id`, `value`, `field_order`, `label`, `group`, `type`, `rules`) VALUES ('softsat.locacao.manutencao.km_correia', '10000', 8, 'Km para manutenção da correia dentada', 'Veículo', 'number', 'required');

UPDATE hwapx_setting SET field_order = 14 WHERE id = 'softsat.locacao.email.contato';
UPDATE hwapx_setting SET field_order = 15 WHERE id = 'softsat.locacao.email.redefinir_senha';
UPDATE hwapx_setting SET field_order = 16 WHERE id = 'softsat.locacao.email.licenciamento';
UPDATE hwapx_setting SET field_order = 17 WHERE id = 'softsat.locacao.email.ipva';
UPDATE hwapx_setting SET field_order = 18 WHERE id = 'softsat.locacao.ipva.dias_notificacao';

INSERT INTO `hwapx_setting` (`id`, `value`, `field_order`, `label`, `group`, `type`, `rules`) VALUES ('softsat.locacao.email.manutencao.filtro_ar', 'softsat_locacao_veiculo_manutencao_filtro_ar', 10, 'Template Manutenção do filtro de ar', 'Notificação', 'text', NULL);
INSERT INTO `hwapx_setting` (`id`, `value`, `field_order`, `label`, `group`, `type`, `rules`) VALUES ('softsat.locacao.email.manutencao.filtro_comb', 'softsat_locacao_veiculo_manutencao_filtro_comb', 11, 'Template Manutenção do filtro de combustível', 'Notificação', 'text', NULL);
INSERT INTO `hwapx_setting` (`id`, `value`, `field_order`, `label`, `group`, `type`, `rules`) VALUES ('softsat.locacao.email.manutencao.disco', 'softsat_locacao_veiculo_manutencao_disco', 12, 'Template Manutenção dos discos de freio', 'Notificação', 'text', NULL);
INSERT INTO `hwapx_setting` (`id`, `value`, `field_order`, `label`, `group`, `type`, `rules`) VALUES ('softsat.locacao.email.manutencao.correia', 'softsat_locacao_veiculo_manutencao_correia', 13, 'Template Manutenção da correia dentada', 'Notificação', 'text', NULL);
