-- --------------------------------------------------------
-- Servidor:                     softsatsistemas.com.br
-- Versão do servidor:           5.6.30 - MySQL Community Server (GPL)
-- OS do Servidor:               Linux
-- HeidiSQL Versão:              9.4.0.5168
-- --------------------------------------------------------

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET NAMES utf8 */;
/*!50503 SET NAMES utf8mb4 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

-- Copiando estrutura para tabela softsats_site.hwapx_audit
CREATE TABLE IF NOT EXISTS `hwapx_audit` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_on` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `done_by` int(11) DEFAULT NULL,
  `done_by_data` text COLLATE utf8_unicode_ci,
  `done_at` datetime DEFAULT NULL,
  `action` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `table` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `record_id` int(11) NOT NULL,
  `old_data` text COLLATE utf8_unicode_ci,
  `new_data` text COLLATE utf8_unicode_ci,
  `url` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `verb` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Copiando dados para a tabela softsats_site.hwapx_audit: ~0 rows (aproximadamente)
/*!40000 ALTER TABLE `hwapx_audit` DISABLE KEYS */;
INSERT INTO `hwapx_audit` (`id`, `created_on`, `done_by`, `done_by_data`, `done_at`, `action`, `table`, `record_id`, `old_data`, `new_data`, `url`, `verb`) VALUES
	(1, '2016-09-19 15:00:08', 1, '{"id":1,"created_on":"2014-11-09 02:13:01","updated_on":"2016-09-19 13:00:32","created_by":null,"updated_by":1,"username":"Admin","password":"a0c18bbde7dace71a15f80dd474e96bd068831402b528ed2cc51474f28e28fcd242afdd84d80cf5b9c1d2ab9b7ddb98801f134e5b1d29bdfeba801a9abeeb75f","email":"luis@softsatsistemas.com.br","photo":"8afe316e3f990fbdafc30ac2d8797069.jpg","active":1,"group_id":1,"correspondente_id":null,"group":{"id":1,"created_on":"2015-03-08 02:01:39","updated_on":null,"created_by":null,"updated_by":null,"active":1,"description":"Administrador","roles":["filemanager","filemanager_remove","filemanager_rename","filemanager_upload","group_create","group_edit","group_remove","group_list","settings","module_management","module_install","module_upgrade","module_uninstall","logs","log_remove","slideshow_create","slideshow_edit","slideshow_remove","slideshow_list","user_create","user_edit","user_remove","user_list"],"correspondente_id":null}}', '2016-09-19 15:00:08', 'delete', 'softsat_process_correspondente', 3, '{"id":3,"created_on":"2016-09-19 14:58:41","updated_on":"2016-09-19 14:58:41","created_by":1,"updated_by":1,"nome":"Teste","cnpj":"65.313.959\\/0001-22","fundacao":"2016-09-19","endereco":"Indefinido","numero":"S\\/N","complemento":"","bairro":"N\\u00e3o se sabe","cidade":"Jos\\u00e9 Bonif\\u00e1cio","uf":"SP","cep":"15200-000","telefone":"(17)0000-00000","celular":"(17)0000-00000","email":"contato@softsatsistemas.com.br","codigo_correspondente":"9999","ativo":1}', 'null', NULL, NULL);
/*!40000 ALTER TABLE `hwapx_audit` ENABLE KEYS */;

-- Copiando estrutura para tabela softsats_site.hwapx_email_account
CREATE TABLE IF NOT EXISTS `hwapx_email_account` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_on` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_on` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  `description` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `slug` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `email` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `password` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `host` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `port` int(11) NOT NULL,
  `scheme` varchar(3) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_hwapx_email_account_hwapx_user_created_by` (`created_by`),
  KEY `fk_hwapx_email_account_hwapx_user_updated_by` (`updated_by`),
  CONSTRAINT `fk_hwapx_email_account_hwapx_user_created_by` FOREIGN KEY (`created_by`) REFERENCES `hwapx_user` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_hwapx_email_account_hwapx_user_updated_by` FOREIGN KEY (`updated_by`) REFERENCES `hwapx_user` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Copiando dados para a tabela softsats_site.hwapx_email_account: ~0 rows (aproximadamente)
/*!40000 ALTER TABLE `hwapx_email_account` DISABLE KEYS */;
INSERT INTO `hwapx_email_account` (`id`, `created_on`, `updated_on`, `created_by`, `updated_by`, `description`, `slug`, `email`, `password`, `host`, `port`, `scheme`) VALUES
	(1, '2016-09-06 13:41:35', '2016-09-06 16:00:11', NULL, NULL, 'Webmaster', 'webmaster', 'webmaster@localhost.com', '5f4dcc3b5aa765d61d8327deb882cf99', 'localhost', 587, 'tls');
/*!40000 ALTER TABLE `hwapx_email_account` ENABLE KEYS */;

-- Copiando estrutura para tabela softsats_site.hwapx_email_queue
CREATE TABLE IF NOT EXISTS `hwapx_email_queue` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_on` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_on` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `created_by` int(11) DEFAULT NULL,
  `updated_By` int(11) DEFAULT NULL,
  `account_id` int(11) DEFAULT NULL,
  `template_id` int(11) DEFAULT NULL,
  `data` text COLLATE utf8_unicode_ci,
  `callback` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `callback_data` text COLLATE utf8_unicode_ci,
  `to` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `from` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `to_parsed` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `reply_to` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cc` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `bcc` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `subject` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `subject_parsed` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `body` text COLLATE utf8_unicode_ci NOT NULL,
  `body_parsed` text COLLATE utf8_unicode_ci,
  `attachments` text COLLATE utf8_unicode_ci,
  `sent_at` datetime DEFAULT NULL,
  `log` text COLLATE utf8_unicode_ci,
  `cancelled` tinyint(1) NOT NULL DEFAULT '0',
  `cancelled_on` datetime DEFAULT NULL,
  `executed_on` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_hwapx_email_queue_hwapx_user_created_by` (`created_by`),
  KEY `fk_hwapx_email_queue_hwapx_user_updated_by` (`updated_By`),
  KEY `fk_hwapx_email_queue_hwapx_email_account` (`account_id`),
  KEY `fk_hwapx_email_queue_hwapx_email_template` (`template_id`),
  CONSTRAINT `fk_hwapx_email_queue_hwapx_email_account` FOREIGN KEY (`account_id`) REFERENCES `hwapx_email_account` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_hwapx_email_queue_hwapx_email_template` FOREIGN KEY (`template_id`) REFERENCES `hwapx_email_template` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_hwapx_email_queue_hwapx_user_created_by` FOREIGN KEY (`created_by`) REFERENCES `hwapx_user` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_hwapx_email_queue_hwapx_user_updated_by` FOREIGN KEY (`updated_By`) REFERENCES `hwapx_user` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Copiando dados para a tabela softsats_site.hwapx_email_queue: ~0 rows (aproximadamente)
/*!40000 ALTER TABLE `hwapx_email_queue` DISABLE KEYS */;
/*!40000 ALTER TABLE `hwapx_email_queue` ENABLE KEYS */;

-- Copiando estrutura para tabela softsats_site.hwapx_email_template
CREATE TABLE IF NOT EXISTS `hwapx_email_template` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_on` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_on` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  `description` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `slug` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `account_id` int(11) DEFAULT NULL,
  `from` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `to` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cc` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `bcc` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `reply_to` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `subject` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `body` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `slug` (`slug`),
  KEY `fk_hwapx_email_template_hwapx_email_account` (`account_id`),
  KEY `fk_hwapx_email_template_hwapx_user_created_by` (`created_by`),
  KEY `fk_hwapx_email_template_hwapx_user_updated_by` (`updated_by`),
  CONSTRAINT `fk_hwapx_email_template_hwapx_email_account` FOREIGN KEY (`account_id`) REFERENCES `hwapx_email_account` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_hwapx_email_template_hwapx_user_created_by` FOREIGN KEY (`created_by`) REFERENCES `hwapx_user` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_hwapx_email_template_hwapx_user_updated_by` FOREIGN KEY (`updated_by`) REFERENCES `hwapx_user` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Copiando dados para a tabela softsats_site.hwapx_email_template: ~3 rows (aproximadamente)
/*!40000 ALTER TABLE `hwapx_email_template` DISABLE KEYS */;
INSERT INTO `hwapx_email_template` (`id`, `created_on`, `updated_on`, `created_by`, `updated_by`, `description`, `slug`, `account_id`, `from`, `to`, `cc`, `bcc`, `reply_to`, `subject`, `body`) VALUES
	(3, '2016-09-19 21:30:11', '2017-01-03 11:31:57', 1, 1, 'Redefinição de senha', 'reset_password', NULL, 'no-reply@softsatsistemas.com.br', NULL, NULL, NULL, NULL, 'SoftSAT Gestão - Redefinição de senha', 'Olá {{ @usuario.name }}.<div><br></div><div>Para redefinir sua senha acesse: <a href="http://gestao.softsatsistemas.com.br{{ \'admin_set_password\', \'token=\'.@usuario.reset_token | alias }}">http://gestao.softsatsistemas.com.br{{ \'admin_set_password\', \'token=\'.@usuario.reset_token | alias }}</a>.</div>');
INSERT INTO `hwapx_email_template` (`id`, `created_on`, `updated_on`, `created_by`, `updated_by`, `description`, `slug`, `account_id`, `from`, `to`, `cc`, `bcc`, `reply_to`, `subject`, `body`) VALUES
	(4, '2016-09-19 21:34:25', '2017-01-03 11:32:08', 1, 1, 'Definir senha', 'set_password', NULL, 'no-reply@softsatsistemas.com.br', NULL, NULL, NULL, NULL, 'SoftSAT Gestão - Definir senha', 'Bem-vindo ao SoftSAT Gestão{{ @usuario.name }}.<div><br></div><div>Seu próximo passo é definir uma senha, para isso acesse&nbsp;<a href="http://gestao.softsatsistemas.com.br{{ \'admin_set_password\', \'token=\'.@usuario.reset_token | alias }}">http://gestao.softsatsistemas.com.br{{ \'admin_set_password\', \'token=\'.@usuario.reset_token | alias }}</a>.</div>');
INSERT INTO `hwapx_email_template` (`id`, `created_on`, `updated_on`, `created_by`, `updated_by`, `description`, `slug`, `account_id`, `from`, `to`, `cc`, `bcc`, `reply_to`, `subject`, `body`) VALUES
	(5, '2016-10-07 09:22:38', '2016-10-07 11:28:21', 1, 1, 'Notificação de erro', 'error', NULL, 'no-reply@softsatsistemas.com.br', 'luis@softsatsistemas.com.br', '', '', NULL, 'Ocorreu um erro em {{ @server }}', '<div>Seguem dados coletados.<br><br></div>\r\n<div>\r\n<h4>Requisição</h4>\r\n<div>\r\nURL: {{ @url }}<br>\r\nMétodo: {{ @method }}<br>\r\nAjax: {{ @ajax}}<br>\r\nQuery: {{ @query}}<br>\r\nData: {{ @time }}<br>\r\n</div>\r\n\r\n<h4>Usuário</h4>\r\n<div>\r\nID: {{ @admin.id }}<br>\r\nNome: {{ @admin.name }} <br>\r\nEmail: {{ @admin.email }}<br>\r\n<br>\r\nIP: {{ @ip }}<br>\r\nUseragent: {{ @agent }}\r\n</div>\r\n\r\n<h4>Erro</h4>\r\n<div>Código: {{ @error.code }}<br>\r\nStatus: {{ @error.status }}<br>\r\nTexto: {{ @error.text }}<br>\r\nTrace:<br>\r\n{{ nl2br(@error.trace) }}\r\n</div>\r\n\r\n<h4>POST</h4>\r\n<pre>{{ json_encode(@post, JSON_PRETTY_PRINT) | raw }}</pre>\r\n\r\n<h4>GET</h4>\r\n<pre>{{ json_encode(@get, JSON_PRETTY_PRINT) | raw }}</pre>\r\n\r\n<h4>COOKIE</h4>\r\n<pre>{{ json_encode(@cookie, JSON_PRETTY_PRINT) | raw }}</pre>\r\n\r\n<h4>PARAMS</h4>\r\n<pre>{{ json_encode(@params, JSON_PRETTY_PRINT) | raw }}</pre>\r\n\r\n<h4>HEADERS</h4>\r\n<pre>{{ json_encode(@headers, JSON_PRETTY_PRINT) | raw }}</pre>\r\n</div>');
/*!40000 ALTER TABLE `hwapx_email_template` ENABLE KEYS */;

-- Copiando estrutura para tabela softsats_site.hwapx_group
CREATE TABLE IF NOT EXISTS `hwapx_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_on` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_on` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  `active` tinyint(1) NOT NULL,
  `description` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `roles` text COLLATE utf8_unicode_ci,
  `correspondente_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_hwapx_group_softsat_process_correspondente` (`correspondente_id`),
  KEY `fk_hwapx_group_hwapx_user_created_by` (`created_by`),
  KEY `fk_hwapx_group_hwapx_user_updated_by` (`updated_by`),
  CONSTRAINT `fk_hwapx_group_hwapx_user_created_by` FOREIGN KEY (`created_by`) REFERENCES `hwapx_user` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_hwapx_group_hwapx_user_updated_by` FOREIGN KEY (`updated_by`) REFERENCES `hwapx_user` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_hwapx_group_softsat_process_correspondente` FOREIGN KEY (`correspondente_id`) REFERENCES `softsat_process_correspondente` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Copiando dados para a tabela softsats_site.hwapx_group: ~4 rows (aproximadamente)
/*!40000 ALTER TABLE `hwapx_group` DISABLE KEYS */;
INSERT INTO `hwapx_group` (`id`, `created_on`, `updated_on`, `created_by`, `updated_by`, `active`, `description`, `roles`, `correspondente_id`) VALUES
	(1, '2015-03-08 02:01:39', '2016-09-24 12:36:31', NULL, 1, 1, 'Desenvolvedor', NULL, NULL);
INSERT INTO `hwapx_group` (`id`, `created_on`, `updated_on`, `created_by`, `updated_by`, `active`, `description`, `roles`, `correspondente_id`) VALUES
	(2, '2015-03-08 02:01:39', '2017-01-04 13:08:44', NULL, 1, 1, 'Administrador', 'hwapx.admin.settings;hwapx.admin.user_create;hwapx.admin.user_edit;hwapx.admin.user_remove;hwapx.admin.user_list;hwapx.admin.group_create;hwapx.admin.group_edit;hwapx.admin.group_remove;hwapx.admin.group_list;hwapx.admin.group_roles;hwapx.logs.logs;hwapx.logs.log_remove;softsat.licenca.create;softsat.licenca.edit;softsat.licenca.edit_obs;softsat.licenca.remove;softsat.licenca.list;softsat.licenca.load;softsat.licenca.plano_create;softsat.licenca.plano_edit;softsat.licenca.plano_remove;softsat.licenca.plano_list;softsat.licenca.plano_load;softsat.licenca.demonstracao_list', NULL);
INSERT INTO `hwapx_group` (`id`, `created_on`, `updated_on`, `created_by`, `updated_by`, `active`, `description`, `roles`, `correspondente_id`) VALUES
	(3, '2016-10-20 14:44:14', '2016-10-20 15:03:05', 1, 1, 1, 'Comercial', 'softsat.licenca.demonstracao_list', NULL);
INSERT INTO `hwapx_group` (`id`, `created_on`, `updated_on`, `created_by`, `updated_by`, `active`, `description`, `roles`, `correspondente_id`) VALUES
	(4, '2017-01-03 11:08:14', '2017-01-04 10:40:31', 4, 1, 1, 'Suporte', 'softsat.licenca.create;softsat.licenca.edit;softsat.licenca.edit_obs;softsat.licenca.remove;softsat.licenca.list;softsat.licenca.load;softsat.licenca.plano_edit;softsat.licenca.plano_list;softsat.licenca.plano_load;softsat.licenca.demonstracao_list', NULL);
/*!40000 ALTER TABLE `hwapx_group` ENABLE KEYS */;

-- Copiando estrutura para tabela softsats_site.hwapx_redirect
CREATE TABLE IF NOT EXISTS `hwapx_redirect` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_on` datetime NOT NULL,
  `updated_on` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  `description` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `url_from` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `url_to` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `active` tinyint(1) NOT NULL,
  `permanent` tinyint(1) NOT NULL,
  `method` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_hwapx_redirect_hwapx_user_created_by` (`created_by`),
  KEY `fk_hwapx_redirect_hwapx_user_updated_by` (`updated_by`),
  CONSTRAINT `fk_hwapx_redirect_hwapx_user_created_by` FOREIGN KEY (`created_by`) REFERENCES `hwapx_user` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_hwapx_redirect_hwapx_user_updated_by` FOREIGN KEY (`updated_by`) REFERENCES `hwapx_user` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Copiando dados para a tabela softsats_site.hwapx_redirect: ~0 rows (aproximadamente)
/*!40000 ALTER TABLE `hwapx_redirect` DISABLE KEYS */;
INSERT INTO `hwapx_redirect` (`id`, `created_on`, `updated_on`, `created_by`, `updated_by`, `description`, `url_from`, `url_to`, `active`, `permanent`, `method`) VALUES
	(1, '2015-10-08 23:18:02', '2015-11-13 00:11:40', NULL, NULL, 'Ammyy', '/ammyy', 'http://www.ammyy.com/AA_v3.exe', 1, 0, 'HEAD|GET');
/*!40000 ALTER TABLE `hwapx_redirect` ENABLE KEYS */;

-- Copiando estrutura para tabela softsats_site.hwapx_sessions
CREATE TABLE IF NOT EXISTS `hwapx_sessions` (
  `session_id` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `data` text COLLATE utf8_unicode_ci,
  `ip` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,
  `agent` varchar(300) COLLATE utf8_unicode_ci DEFAULT NULL,
  `stamp` int(11) DEFAULT NULL,
  PRIMARY KEY (`session_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Copiando dados para a tabela softsats_site.hwapx_sessions: ~1 rows (aproximadamente)
/*!40000 ALTER TABLE `hwapx_sessions` DISABLE KEYS */;
INSERT INTO `hwapx_sessions` (`session_id`, `data`, `ip`, `agent`, `stamp`) VALUES
	('dd57834260e17b00fce9216b18251a9e', 'flash|a:1:{s:5:"error";N;}admin|a:21:{s:2:"id";i:1;s:10:"created_on";s:19:"2016-08-20 14:33:42";s:10:"updated_on";s:19:"2017-03-21 12:53:41";s:10:"created_by";N;s:10:"updated_by";i:1;s:13:"last_activity";s:19:"2017-03-21 12:53:45";s:10:"last_login";s:19:"2017-03-21 12:30:58";s:7:"last_ip";s:13:"200.95.208.82";s:4:"name";s:6:"Desenv";s:5:"email";s:29:"desenv@softsatsistemas.com.br";s:5:"photo";s:36:"8afe316e3f990fbdafc30ac2d8797069.jpg";s:6:"active";i:1;s:8:"group_id";i:1;s:17:"correspondente_id";N;s:18:"reset_requested_on";N;s:11:"reset_token";s:32:"2af7e5bd4302a3bb5e848a2360c69df7";s:12:"reset_expire";s:19:"2016-10-11 18:27:26";s:10:"last_reset";N;s:10:"session_id";s:32:"f459b78a61e9e42cdbceb7b30eb7cccd";s:9:"firstname";s:6:"Desenv";s:5:"group";a:9:{s:2:"id";i:1;s:10:"created_on";s:19:"2015-03-08 02:01:39";s:10:"updated_on";s:19:"2016-09-24 12:36:31";s:10:"created_by";N;s:10:"updated_by";i:1;s:6:"active";i:1;s:11:"description";s:13:"Desenvolvedor";s:5:"roles";a:1:{i:0;s:0:"";}s:17:"correspondente_id";N;}}', '200.95.208.82', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3018.3 Safari/537.36 OPR/45.0.2531.0 (Edition developer)', 1490111625);
/*!40000 ALTER TABLE `hwapx_sessions` ENABLE KEYS */;

-- Copiando estrutura para tabela softsats_site.hwapx_setting
CREATE TABLE IF NOT EXISTS `hwapx_setting` (
  `id` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `value` text COLLATE utf8_unicode_ci,
  `field_order` int(11) NOT NULL,
  `label` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `group` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `type` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `rules` text COLLATE utf8_unicode_ci,
  `created_on` datetime DEFAULT CURRENT_TIMESTAMP,
  `updated_on` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Copiando dados para a tabela softsats_site.hwapx_setting: ~14 rows (aproximadamente)
/*!40000 ALTER TABLE `hwapx_setting` DISABLE KEYS */;
INSERT INTO `hwapx_setting` (`id`, `value`, `field_order`, `label`, `group`, `type`, `rules`, `created_on`, `updated_on`) VALUES
	('admin.color', 'green', 2, 'Cor', 'Admin', 'dropdown', 'in=|aqua|black|blue|fuchsia|green|light-blue|lime|maroon|navy|olive|orange|purple|red|teal|yellow|aqua-gradient|black-gradient|blue-gradient|fuchsia-gradient|green-gradient|light-blue-gradient|lime-gradient|maroon-gradient|navy-gradient|olive-gradient|orange-gradient|purple-gradient|red-gradient|teal-gradient|yellow-gradient', '2016-10-12 21:35:42', '2016-12-01 18:19:00');
INSERT INTO `hwapx_setting` (`id`, `value`, `field_order`, `label`, `group`, `type`, `rules`, `created_on`, `updated_on`) VALUES
	('admin.layout', 'fixed', 3, 'Layout', 'Admin', 'dropdown', 'required;in=normal|fixed', '2015-02-16 21:13:53', '2016-10-12 21:34:19');
INSERT INTO `hwapx_setting` (`id`, `value`, `field_order`, `label`, `group`, `type`, `rules`, `created_on`, `updated_on`) VALUES
	('admin.sidebar_color', '', 5, 'Cor (Menu lateral)', 'Admin', 'dropdown', 'in=|aqua|black|blue|fuchsia|green|light-blue|lime|maroon|navy|olive|orange|purple|red|teal|yellow|aqua-gradient|black-gradient|blue-gradient|fuchsia-gradient|green-gradient|light-blue-gradient|lime-gradient|maroon-gradient|navy-gradient|olive-gradient|orange-gradient|purple-gradient|red-gradient|teal-gradient|yellow-gradient', '2016-10-12 21:54:01', '2016-10-12 22:05:53');
INSERT INTO `hwapx_setting` (`id`, `value`, `field_order`, `label`, `group`, `type`, `rules`, `created_on`, `updated_on`) VALUES
	('admin.skin', 'blue', 1, 'Skin', 'Admin', 'dropdown', 'in=|blue|black', '2015-02-16 21:13:53', '2016-10-12 22:05:53');
INSERT INTO `hwapx_setting` (`id`, `value`, `field_order`, `label`, `group`, `type`, `rules`, `created_on`, `updated_on`) VALUES
	('api.password', 'apikey', 23, 'Senha', 'Api', 'password', 'required;lengthMin=6', '2014-11-09 23:13:30', '2016-10-12 20:48:26');
INSERT INTO `hwapx_setting` (`id`, `value`, `field_order`, `label`, `group`, `type`, `rules`, `created_on`, `updated_on`) VALUES
	('api.username', 'api', 22, 'Usuário', 'Api', 'text', 'required;lengthMin=3', '2014-11-09 23:13:30', '2016-10-12 20:48:26');
INSERT INTO `hwapx_setting` (`id`, `value`, `field_order`, `label`, `group`, `type`, `rules`, `created_on`, `updated_on`) VALUES
	('email.host', 'mail.softsatsistemas.com.br', 13, 'Servidor SMTP', 'Email', 'text', 'required', '2014-11-09 23:13:30', '2016-10-12 20:48:26');
INSERT INTO `hwapx_setting` (`id`, `value`, `field_order`, `label`, `group`, `type`, `rules`, `created_on`, `updated_on`) VALUES
	('email.password', 'softsat*2016', 17, 'Senha', 'Email', 'password', 'required', '2014-11-09 23:13:30', '2016-10-12 20:48:26');
INSERT INTO `hwapx_setting` (`id`, `value`, `field_order`, `label`, `group`, `type`, `rules`, `created_on`, `updated_on`) VALUES
	('email.port', '587', 14, 'Porta SMTP', 'Email', 'number', 'required;integer;min=1;max=65535', '2014-11-09 23:13:30', '2016-10-12 20:48:26');
INSERT INTO `hwapx_setting` (`id`, `value`, `field_order`, `label`, `group`, `type`, `rules`, `created_on`, `updated_on`) VALUES
	('email.scheme', '', 15, 'Modo de Autenticação', 'Email', 'dropdown', 'in=|ssl|tls', '2014-11-09 23:13:30', '2016-10-12 20:48:26');
INSERT INTO `hwapx_setting` (`id`, `value`, `field_order`, `label`, `group`, `type`, `rules`, `created_on`, `updated_on`) VALUES
	('email.user', 'suporte@softsatsistemas.com.br', 16, 'Email', 'Email', 'text', 'required;email', '2014-11-09 23:13:30', '2016-10-12 20:48:26');
INSERT INTO `hwapx_setting` (`id`, `value`, `field_order`, `label`, `group`, `type`, `rules`, `created_on`, `updated_on`) VALUES
	('site_name', 'SoftProcess', 1, 'Nome', 'Site', 'text', 'required', '2015-02-16 20:47:18', '2016-10-12 20:48:26');
INSERT INTO `hwapx_setting` (`id`, `value`, `field_order`, `label`, `group`, `type`, `rules`, `created_on`, `updated_on`) VALUES
	('softsat.licenca.carencia', '3', 4, 'Carência (Dias)', 'Licença', 'number', 'required', '2016-10-18 11:42:22', '2016-10-24 13:20:16');
INSERT INTO `hwapx_setting` (`id`, `value`, `field_order`, `label`, `group`, `type`, `rules`, `created_on`, `updated_on`) VALUES
	('softsat.licenca.iugu_plan_keyword', 'Licenca', 2, 'Palavra chave dos planos', 'Licença', 'text', NULL, '2016-10-17 08:49:20', '2016-10-24 13:19:55');
INSERT INTO `hwapx_setting` (`id`, `value`, `field_order`, `label`, `group`, `type`, `rules`, `created_on`, `updated_on`) VALUES
	('softsat.licenca.iugu_token', '01cb1ccdde1d3bf71c6b5d4ddb9e20d1', 1, 'Token do Iugu', 'Licença', 'text', NULL, '2016-10-14 10:05:37', '2016-10-24 13:19:52');
INSERT INTO `hwapx_setting` (`id`, `value`, `field_order`, `label`, `group`, `type`, `rules`, `created_on`, `updated_on`) VALUES
	('softsat.licenca.modulos', 'PDV;GERENCIAL', 5, 'Modulos (separados por ;)', 'Licença', 'text', NULL, '2016-10-18 11:28:21', '2016-10-24 13:20:19');
INSERT INTO `hwapx_setting` (`id`, `value`, `field_order`, `label`, `group`, `type`, `rules`, `created_on`, `updated_on`) VALUES
	('softsat.licenca.plano_demonstracao', '2', 3, 'ID do plano de demonstração', 'Licença', 'number', NULL, '2016-10-24 13:19:38', '2016-10-24 16:15:11');
/*!40000 ALTER TABLE `hwapx_setting` ENABLE KEYS */;

-- Copiando estrutura para tabela softsats_site.hwapx_user
CREATE TABLE IF NOT EXISTS `hwapx_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_on` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_on` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  `last_activity` datetime DEFAULT NULL,
  `last_login` datetime DEFAULT NULL,
  `last_ip` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `password` char(128) COLLATE utf8_unicode_ci NOT NULL,
  `email` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `photo` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `active` tinyint(1) NOT NULL,
  `group_id` int(11) NOT NULL,
  `correspondente_id` int(11) DEFAULT NULL,
  `reset_requested_on` datetime DEFAULT NULL,
  `reset_token` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `reset_expire` datetime DEFAULT NULL,
  `last_reset` datetime DEFAULT NULL,
  `session_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `un_hwapx_user_email` (`email`),
  UNIQUE KEY `un_hwapx_user_reset_token` (`reset_token`),
  KEY `fk_hwapx_user_hwapx_group` (`group_id`),
  KEY `fk_hwapx_user_softsat_process_correspondente` (`correspondente_id`),
  KEY `fk_hwapx_user_hwapx_user_created_by` (`created_by`),
  KEY `fk_hwapx_user_hwapx_user_updated_by` (`updated_by`),
  CONSTRAINT `fk_hwapx_user_hwapx_group` FOREIGN KEY (`group_id`) REFERENCES `hwapx_group` (`id`),
  CONSTRAINT `fk_hwapx_user_hwapx_user_created_by` FOREIGN KEY (`created_by`) REFERENCES `hwapx_user` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_hwapx_user_hwapx_user_updated_by` FOREIGN KEY (`updated_by`) REFERENCES `hwapx_user` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_hwapx_user_softsat_process_correspondente` FOREIGN KEY (`correspondente_id`) REFERENCES `softsat_process_correspondente` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Copiando dados para a tabela softsats_site.hwapx_user: ~5 rows (aproximadamente)
/*!40000 ALTER TABLE `hwapx_user` DISABLE KEYS */;
INSERT INTO `hwapx_user` (`id`, `created_on`, `updated_on`, `created_by`, `updated_by`, `last_activity`, `last_login`, `last_ip`, `name`, `password`, `email`, `photo`, `active`, `group_id`, `correspondente_id`, `reset_requested_on`, `reset_token`, `reset_expire`, `last_reset`, `session_id`) VALUES
	(1, '2016-08-20 14:33:42', '2017-03-21 12:53:45', NULL, 1, '2017-03-21 12:53:45', '2017-03-21 12:30:58', '200.95.208.82', 'Desenv', '$2y$10$2.NSsgF5whjBVmWqEhtlEun1ZMK55g4hzRgzPYqBsw9SKMI6.aqOO', 'desenv@softsatsistemas.com.br', '8afe316e3f990fbdafc30ac2d8797069.jpg', 1, 1, NULL, NULL, '2af7e5bd4302a3bb5e848a2360c69df7', '2016-10-11 18:27:26', NULL, 'f459b78a61e9e42cdbceb7b30eb7cccd');
INSERT INTO `hwapx_user` (`id`, `created_on`, `updated_on`, `created_by`, `updated_by`, `last_activity`, `last_login`, `last_ip`, `name`, `password`, `email`, `photo`, `active`, `group_id`, `correspondente_id`, `reset_requested_on`, `reset_token`, `reset_expire`, `last_reset`, `session_id`) VALUES
	(2, '2016-09-01 17:56:05', '2017-03-17 10:28:30', NULL, 1, '2017-03-17 10:28:30', '2017-03-17 10:12:06', '200.95.208.82', 'Admin', '$2y$10$PluOJrAIv8.LCoq3V4jVp.PyhcXiHo9kmZgwUll8W3SN5S4/xT0x.', 'contato@softsatsistemas.com.br', '84c0ed62ccb479c9a57e6aebbb712db6.jpg', 1, 2, NULL, NULL, '5a8c9d3f9c4c63f99a47a82cff52bda1', '2016-10-08 13:44:46', NULL, '20470a47452f0680c6de1a4e901ad154');
INSERT INTO `hwapx_user` (`id`, `created_on`, `updated_on`, `created_by`, `updated_by`, `last_activity`, `last_login`, `last_ip`, `name`, `password`, `email`, `photo`, `active`, `group_id`, `correspondente_id`, `reset_requested_on`, `reset_token`, `reset_expire`, `last_reset`, `session_id`) VALUES
	(3, '2016-10-20 14:47:35', '2017-03-09 16:08:20', 1, 1, '2017-01-20 08:26:15', '2017-01-20 08:26:07', '200.95.209.186', 'Carina', '$2y$10$YkpMNr9gpVgi3bCt61lQx.hVTMqbdFYpl0A1N0Q5.QL.8EQSKKnm.', 'carina@softsatsistemas.com.br', NULL, 0, 3, NULL, NULL, 'e0e0c3b77d492c2195f3e4598b90e3bf', '2016-11-11 09:44:55', NULL, '1e0ea96f4c43f86888a358aecfe9c918');
INSERT INTO `hwapx_user` (`id`, `created_on`, `updated_on`, `created_by`, `updated_by`, `last_activity`, `last_login`, `last_ip`, `name`, `password`, `email`, `photo`, `active`, `group_id`, `correspondente_id`, `reset_requested_on`, `reset_token`, `reset_expire`, `last_reset`, `session_id`) VALUES
	(4, '2016-11-28 09:43:43', '2017-03-09 16:09:29', 1, 1, '2017-01-19 15:40:45', '2017-01-17 16:03:27', '200.95.209.186', 'Luis Henrique', '$2y$10$PRHkh9xRbjSuG.GPDWNvsOdfx8n30Ds2oohXqs5/spTuEEM.xJuUS', 'luis@softsatsistemas.com.br', NULL, 1, 4, NULL, NULL, NULL, NULL, NULL, '982329f4509d28088affba1d14c7ce7f');
INSERT INTO `hwapx_user` (`id`, `created_on`, `updated_on`, `created_by`, `updated_by`, `last_activity`, `last_login`, `last_ip`, `name`, `password`, `email`, `photo`, `active`, `group_id`, `correspondente_id`, `reset_requested_on`, `reset_token`, `reset_expire`, `last_reset`, `session_id`) VALUES
	(5, '2017-01-03 11:08:38', '2017-03-20 15:47:27', 4, 4, '2017-03-20 15:47:27', '2017-03-20 14:04:51', '200.95.208.82', 'Manuel', '$2y$10$BcI.1T1qeB6ce4s92p/LGu6Y2MTsrxTvXbzIyABvILe9ouYzlHqRi', 'manuel@softsatsistemas.com.br', NULL, 1, 4, NULL, '2017-01-03 11:24:25', NULL, NULL, '2017-01-03 11:26:01', '20470a47452f0680c6de1a4e901ad154');
/*!40000 ALTER TABLE `hwapx_user` ENABLE KEYS */;

-- Copiando estrutura para tabela softsats_site.softsat_licenca
CREATE TABLE IF NOT EXISTS `softsat_licenca` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_on` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_on` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  `plano_id` int(11),
  `nome` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `cnpj` varchar(18) COLLATE utf8_unicode_ci NOT NULL,
  `email` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `telefone` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `endereco` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `numero` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `complemento` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `bairro` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cidade` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `estado` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cep` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `codigo_ibge` int(11) DEFAULT NULL,
  `data_base` date DEFAULT NULL,
  `iugu_subscription_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `iugu_customer_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `demonstracao` tinyint(1) NOT NULL DEFAULT '0',
  `ilimitada` tinyint(1) NOT NULL DEFAULT '0',
  `suspensa` tinyint(1) NOT NULL DEFAULT '0',
  `observacao` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `un_softsat_licenca_cnpj` (`cnpj`),
  UNIQUE KEY `un_softsat_licenca_iugu_subscription_id` (`iugu_subscription_id`),
  UNIQUE KEY `un_softsat_licenca_iugu_customer_id` (`iugu_customer_id`),
  KEY `fk_softsat_licenca_hwapx_user_created_by` (`created_by`),
  KEY `fk_softsat_licenca_hwapx_user_updated_by` (`updated_by`),
  KEY `fk_softsat_licenca_softsat_licenca_plano` (`plano_id`),
  CONSTRAINT `fk_softsat_licenca_hwapx_user_created_by` FOREIGN KEY (`created_by`) REFERENCES `hwapx_user` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_softsat_licenca_hwapx_user_updated_by` FOREIGN KEY (`updated_by`) REFERENCES `hwapx_user` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_softsat_licenca_softsat_licenca_plano` FOREIGN KEY (`plano_id`) REFERENCES `softsat_licenca_plano` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Copiando dados para a tabela softsats_site.softsat_licenca: ~32 rows (aproximadamente)
/*!40000 ALTER TABLE `softsat_licenca` DISABLE KEYS */;
INSERT INTO `softsat_licenca` (`id`, `created_on`, `updated_on`, `created_by`, `updated_by`, `plano_id`, `nome`, `cnpj`, `email`, `telefone`, `endereco`, `numero`, `complemento`, `bairro`, `cidade`, `estado`, `cep`, `codigo_ibge`, `data_base`, `iugu_subscription_id`, `iugu_customer_id`, `demonstracao`, `ilimitada`, `suspensa`, `observacao`) VALUES
	(2, '2016-10-20 14:41:03', '2017-03-16 08:10:33', NULL, 2, 1, 'ELETRO-ELETRONICA TAINO', '08.463.419/0001-91', 'eliana_taino@hotmail.com', '(17)3245-1656', 'RUA 28 DE DEZEMBRO, 187', '00163', NULL, 'CENTRO', 'JOSE BONIFACIO', 'SP', '15200-000', 3525706, '2016-08-20', '8D467570222248AABEA7F38143E1A7F4', 'F38CDACF8BB84A46B57C0DA123790394', 1, 0, 0, NULL);
INSERT INTO `softsat_licenca` (`id`, `created_on`, `updated_on`, `created_by`, `updated_by`, `plano_id`, `nome`, `cnpj`, `email`, `telefone`, `endereco`, `numero`, `complemento`, `bairro`, `cidade`, `estado`, `cep`, `codigo_ibge`, `data_base`, `iugu_subscription_id`, `iugu_customer_id`, `demonstracao`, `ilimitada`, `suspensa`, `observacao`) VALUES
	(3, '2016-10-20 14:41:03', '2017-03-16 07:10:30', NULL, 1, 3, 'R. C. V. SAES ROBERTO - ME', '10.308.017/0001-64', 'casasaes@hotmail.com', '', NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, '2016-08-10', '01056A464A864F12ABEF1D069777890D', 'C4856FF257F643879E2BB6533E991D54', 1, 0, 0, NULL);
INSERT INTO `softsat_licenca` (`id`, `created_on`, `updated_on`, `created_by`, `updated_by`, `plano_id`, `nome`, `cnpj`, `email`, `telefone`, `endereco`, `numero`, `complemento`, `bairro`, `cidade`, `estado`, `cep`, `codigo_ibge`, `data_base`, `iugu_subscription_id`, `iugu_customer_id`, `demonstracao`, `ilimitada`, `suspensa`, `observacao`) VALUES
	(4, '2016-10-20 14:41:03', '2017-03-21 10:21:09', NULL, 2, 4, 'DODAS COMERCIO DE BEBIDAS  - EIRELI', '09.566.827/0001-31', 'nfe.dodas@gmail.com', '(17)3265-2023', 'AVENIDA JOAQUIM MOREIRA DA SILVA', '02366', NULL, 'SAO JOSE', 'JOSE BONIFACIO', 'SP', '15200-000', 3525706, '2016-07-20', 'BAF0FE63B0C84630B3051A1B2FF15E35', 'FF3E31B59A9E494CA6B119A8B42D1120', 0, 1, 0, NULL);
INSERT INTO `softsat_licenca` (`id`, `created_on`, `updated_on`, `created_by`, `updated_by`, `plano_id`, `nome`, `cnpj`, `email`, `telefone`, `endereco`, `numero`, `complemento`, `bairro`, `cidade`, `estado`, `cep`, `codigo_ibge`, `data_base`, `iugu_subscription_id`, `iugu_customer_id`, `demonstracao`, `ilimitada`, `suspensa`, `observacao`) VALUES
	(5, '2016-10-20 14:41:03', '2017-03-20 14:32:10', NULL, 2, 2, 'CLAUDIO FELIX GIMENEZ - ME', '02.472.292/0001-90', 'devilprex@gmail.com', '', NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, '2016-07-10', '26A6EDAE55CD4E72881CAC8D7693293E', '355AEE2E80194A7D9CBD1809A3B94CD1', 0, 0, 0, NULL);
INSERT INTO `softsat_licenca` (`id`, `created_on`, `updated_on`, `created_by`, `updated_by`, `plano_id`, `nome`, `cnpj`, `email`, `telefone`, `endereco`, `numero`, `complemento`, `bairro`, `cidade`, `estado`, `cep`, `codigo_ibge`, `data_base`, `iugu_subscription_id`, `iugu_customer_id`, `demonstracao`, `ilimitada`, `suspensa`, `observacao`) VALUES
	(6, '2016-10-20 14:41:03', '2017-03-16 08:56:38', NULL, NULL, 3, 'GRAZIELA PATRICIA ABRAO JANA LOPES - ME', '24.742.722/0001-80', 'gerencia@lojastw.com.br', '', NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, '2016-07-10', 'E3B2A4F3FA2C44FFB2AB9CEC7329C7BA', '755AC311E2A0400A9530FC68437F980D', 0, 0, 0, NULL);
INSERT INTO `softsat_licenca` (`id`, `created_on`, `updated_on`, `created_by`, `updated_by`, `plano_id`, `nome`, `cnpj`, `email`, `telefone`, `endereco`, `numero`, `complemento`, `bairro`, `cidade`, `estado`, `cep`, `codigo_ibge`, `data_base`, `iugu_subscription_id`, `iugu_customer_id`, `demonstracao`, `ilimitada`, `suspensa`, `observacao`) VALUES
	(7, '2016-10-20 14:41:04', '2016-11-18 11:40:42', NULL, 1, 4, 'C & C BEBIDAS PLANALTO LTDA', '18.525.658/0001-82', 'rh@aguamineralleve.com.br', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2016-06-20', '7A8DA2B1658746708DCA9E5C268F6A21', '2AD0DF69CDEB469AB1CFE5052611443E', 0, 1, 0, NULL);
INSERT INTO `softsat_licenca` (`id`, `created_on`, `updated_on`, `created_by`, `updated_by`, `plano_id`, `nome`, `cnpj`, `email`, `telefone`, `endereco`, `numero`, `complemento`, `bairro`, `cidade`, `estado`, `cep`, `codigo_ibge`, `data_base`, `iugu_subscription_id`, `iugu_customer_id`, `demonstracao`, `ilimitada`, `suspensa`, `observacao`) VALUES
	(8, '2016-10-24 15:27:54', '2017-03-21 12:42:11', NULL, 1, 7, 'VANESSA CARLA MEIRELES MENDES - ME / Aliança Supermercado', '23.108.538/0001-10', 'welwal_pereira@hotmail.com', NULL, NULL, NULL, NULL, NULL, NULL, 'AC', NULL, 0, '2016-11-10', 'F35809698E064117837395DC01EDCC55', 'C8F6B3025A564195BD55204DF91EA561', 0, 0, 0, NULL);
INSERT INTO `softsat_licenca` (`id`, `created_on`, `updated_on`, `created_by`, `updated_by`, `plano_id`, `nome`, `cnpj`, `email`, `telefone`, `endereco`, `numero`, `complemento`, `bairro`, `cidade`, `estado`, `cep`, `codigo_ibge`, `data_base`, `iugu_subscription_id`, `iugu_customer_id`, `demonstracao`, `ilimitada`, `suspensa`, `observacao`) VALUES
	(13, '2016-10-26 13:58:42', '2017-03-20 11:02:06', NULL, 5, 5, 'DAIANE MARA PARRA - ME / Parrinha Pneus', '20.216.968/0001-67', 'parrinhapneus@gmail.com', '(17)3245-0815', 'AV JOAQUIM MOREIRA DA SILVA, 1971', '00013', NULL, 'SAO JOSE', 'JOSE BONIFACIO', 'SP', '15200-000', 3525706, '2016-09-26', 'F0A4D18729C94D58998610471698FA8B', '83732CBA22ED4C489D808A1B044E61F0', 1, 0, 0, NULL);
INSERT INTO `softsat_licenca` (`id`, `created_on`, `updated_on`, `created_by`, `updated_by`, `plano_id`, `nome`, `cnpj`, `email`, `telefone`, `endereco`, `numero`, `complemento`, `bairro`, `cidade`, `estado`, `cep`, `codigo_ibge`, `data_base`, `iugu_subscription_id`, `iugu_customer_id`, `demonstracao`, `ilimitada`, `suspensa`, `observacao`) VALUES
	(14, '2016-10-27 09:47:40', '2017-03-21 08:58:41', NULL, 1, 2, 'SOFTSAT SOLUCOES INTEGRADAS LTDA ME', '24.356.015/0001-55', 'contato@softsatsistemas.com.br', '', NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, '2016-10-27', NULL, NULL, 1, 1, 0, NULL);
INSERT INTO `softsat_licenca` (`id`, `created_on`, `updated_on`, `created_by`, `updated_by`, `plano_id`, `nome`, `cnpj`, `email`, `telefone`, `endereco`, `numero`, `complemento`, `bairro`, `cidade`, `estado`, `cep`, `codigo_ibge`, `data_base`, `iugu_subscription_id`, `iugu_customer_id`, `demonstracao`, `ilimitada`, `suspensa`, `observacao`) VALUES
	(15, '2016-11-04 08:15:54', '2017-01-24 10:16:56', NULL, 2, 8, 'VINICIO FRANCISCO VANZELA & CIA LTDA - ME', '05.849.925/0001-25', 'fernando@softsatsistemas.com.br', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2016-10-25', '30E54B1FDE2B44CEA03C84DF4744CFCF', '4AEDE2E3C1D24FE89C36A31CB615789F', 1, 0, 0, NULL);
INSERT INTO `softsat_licenca` (`id`, `created_on`, `updated_on`, `created_by`, `updated_by`, `plano_id`, `nome`, `cnpj`, `email`, `telefone`, `endereco`, `numero`, `complemento`, `bairro`, `cidade`, `estado`, `cep`, `codigo_ibge`, `data_base`, `iugu_subscription_id`, `iugu_customer_id`, `demonstracao`, `ilimitada`, `suspensa`, `observacao`) VALUES
	(16, '2016-11-04 13:43:27', '2016-11-04 13:43:27', 1, 1, 3, 'WLISSES JANUARIO DE FREITAS - ME', '07.469.393/0001-26', 'aizulloterias@uol.com.br', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2016-10-05', NULL, NULL, 1, 0, 0, NULL);
INSERT INTO `softsat_licenca` (`id`, `created_on`, `updated_on`, `created_by`, `updated_by`, `plano_id`, `nome`, `cnpj`, `email`, `telefone`, `endereco`, `numero`, `complemento`, `bairro`, `cidade`, `estado`, `cep`, `codigo_ibge`, `data_base`, `iugu_subscription_id`, `iugu_customer_id`, `demonstracao`, `ilimitada`, `suspensa`, `observacao`) VALUES
	(17, '2016-11-07 10:13:18', '2016-11-07 10:13:18', NULL, NULL, 2, 'G.M. TAKAO - RESTAURANTE - ME', '26.058.355/0001-25', 'autoposto99@hotmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2016-11-10', 'D0F83A6F04FD47589AB7A34EAA577B8C', '212706F0780D41D3A30E03FDBE9FECDA', 0, 0, 0, NULL);
INSERT INTO `softsat_licenca` (`id`, `created_on`, `updated_on`, `created_by`, `updated_by`, `plano_id`, `nome`, `cnpj`, `email`, `telefone`, `endereco`, `numero`, `complemento`, `bairro`, `cidade`, `estado`, `cep`, `codigo_ibge`, `data_base`, `iugu_subscription_id`, `iugu_customer_id`, `demonstracao`, `ilimitada`, `suspensa`, `observacao`) VALUES
	(20, '2016-11-07 14:54:22', '2017-03-20 09:31:29', NULL, 5, 6, 'HILDA LUCAS DODORICO - CONFECCOES - ME', '04.421.578/0001-72', 'dominiunjb@hotmail.com', '', NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, '2016-11-15', 'EE2B882ED3304C0BAB731C9E5B492BA5', 'CC18B3B2D498420CBF498CF2FEC0437E', 0, 0, 0, NULL);
INSERT INTO `softsat_licenca` (`id`, `created_on`, `updated_on`, `created_by`, `updated_by`, `plano_id`, `nome`, `cnpj`, `email`, `telefone`, `endereco`, `numero`, `complemento`, `bairro`, `cidade`, `estado`, `cep`, `codigo_ibge`, `data_base`, `iugu_subscription_id`, `iugu_customer_id`, `demonstracao`, `ilimitada`, `suspensa`, `observacao`) VALUES
	(21, '2016-11-07 14:54:22', '2017-03-21 09:25:02', NULL, 1, 6, 'RITA DE CASSIA DODORICO - CONFECCOES - ME', '68.081.983/0001-71', 'passarelajb@hotmail.com', '', NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, '2016-11-15', 'A829C9C3A24B43DDB328B4159546790F', 'B3A4633FEDE64FBF84370F145F730745', 0, 0, 0, NULL);
INSERT INTO `softsat_licenca` (`id`, `created_on`, `updated_on`, `created_by`, `updated_by`, `plano_id`, `nome`, `cnpj`, `email`, `telefone`, `endereco`, `numero`, `complemento`, `bairro`, `cidade`, `estado`, `cep`, `codigo_ibge`, `data_base`, `iugu_subscription_id`, `iugu_customer_id`, `demonstracao`, `ilimitada`, `suspensa`, `observacao`) VALUES
	(22, '2016-11-11 15:09:44', '2017-03-16 16:39:47', NULL, 2, 3, 'CENTER COUNTRY MAGAZINE', '07.868.606/0001-92', 'adm@centercountrymagazine.com.br', '(17)3552-3622', NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, '2017-01-10', '0E6B6CE5E4D4402AA6EB488812566A18', 'C1279444F1E4453ABDC5C8500B3250A6', 1, 0, 0, NULL);
INSERT INTO `softsat_licenca` (`id`, `created_on`, `updated_on`, `created_by`, `updated_by`, `plano_id`, `nome`, `cnpj`, `email`, `telefone`, `endereco`, `numero`, `complemento`, `bairro`, `cidade`, `estado`, `cep`, `codigo_ibge`, `data_base`, `iugu_subscription_id`, `iugu_customer_id`, `demonstracao`, `ilimitada`, `suspensa`, `observacao`) VALUES
	(23, '2016-11-25 11:19:09', '2017-03-16 08:05:33', 2, 2, 3, 'Elisangela Santana - ME', '08.196.330/0001-06', 'marcioaissa@hotmail.com', '(17)3265-3826', 'AVENIDA ANTONIO GONCALVES DA SILVA', '700', NULL, 'CENTRO', 'JOSE BONIFACIO', 'SP', '15200-000', 3525706, '2016-11-25', NULL, NULL, 0, 1, 0, NULL);
INSERT INTO `softsat_licenca` (`id`, `created_on`, `updated_on`, `created_by`, `updated_by`, `plano_id`, `nome`, `cnpj`, `email`, `telefone`, `endereco`, `numero`, `complemento`, `bairro`, `cidade`, `estado`, `cep`, `codigo_ibge`, `data_base`, `iugu_subscription_id`, `iugu_customer_id`, `demonstracao`, `ilimitada`, `suspensa`, `observacao`) VALUES
	(24, '2016-11-29 17:43:02', '2017-03-15 14:27:15', NULL, 5, 5, 'CARLOS ROBERTO ALBANEZ - ME', '18.981.440/0001-32', 'carlosalbanez@bol.com.br', '173245387', 'AV JOSE PINTO, 5', '00000', NULL, 'JARDIM FIGUEIREDO', 'JOSE BONIFACIO', 'SP', '15200-000', 3525706, '2016-12-11', 'D43A9031884A4D9AA96D92B347774BC8', 'BBAB6B814D8A42B393ED9DF5FD701FEE', 1, 0, 0, NULL);
INSERT INTO `softsat_licenca` (`id`, `created_on`, `updated_on`, `created_by`, `updated_by`, `plano_id`, `nome`, `cnpj`, `email`, `telefone`, `endereco`, `numero`, `complemento`, `bairro`, `cidade`, `estado`, `cep`, `codigo_ibge`, `data_base`, `iugu_subscription_id`, `iugu_customer_id`, `demonstracao`, `ilimitada`, `suspensa`, `observacao`) VALUES
	(26, '2016-12-07 11:08:23', '2017-01-23 17:43:50', NULL, 2, 5, 'RONALDO ADOBERTO ZANATA - ME', '05.522.609/0001-44', 'cecilia.rosana@hotmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2016-12-20', '00DB8F4750174E848DB5B82841E21CF8', '0E2467F4C2864A3A8137254EDB7C33F6', 1, 0, 0, NULL);
INSERT INTO `softsat_licenca` (`id`, `created_on`, `updated_on`, `created_by`, `updated_by`, `plano_id`, `nome`, `cnpj`, `email`, `telefone`, `endereco`, `numero`, `complemento`, `bairro`, `cidade`, `estado`, `cep`, `codigo_ibge`, `data_base`, `iugu_subscription_id`, `iugu_customer_id`, `demonstracao`, `ilimitada`, `suspensa`, `observacao`) VALUES
	(27, '2016-12-08 15:05:34', '2017-03-15 15:51:31', NULL, NULL, 5, 'Helio Raymundo - ME', '68.043.389/0001-96', 'escritoriomaltaroldo@hotmail.com', '(17)3245-2658', 'JOAO F. DA SILVA', '00678', NULL, 'SAO JOSE', 'JOSE BONIFACIO', 'SP', '15200-000', 3525706, '2016-12-08', 'F5C0DBA38EC4485E9FEA0E1BA79FAC48', '9CD6A1ADFB2D434B80A0F64E6F163806', 1, 0, 0, NULL);
INSERT INTO `softsat_licenca` (`id`, `created_on`, `updated_on`, `created_by`, `updated_by`, `plano_id`, `nome`, `cnpj`, `email`, `telefone`, `endereco`, `numero`, `complemento`, `bairro`, `cidade`, `estado`, `cep`, `codigo_ibge`, `data_base`, `iugu_subscription_id`, `iugu_customer_id`, `demonstracao`, `ilimitada`, `suspensa`, `observacao`) VALUES
	(30, '2016-12-09 12:21:31', '2017-03-15 17:44:19', NULL, 5, 5, 'MARCIO HENRIQUE DE OLIVEIRA', '17.617.664/0001-05', 'vidracariajbonifacio@hotmail.com', '172452139', 'RUA: RUI BARBOSA', '00650', NULL, 'CENTRO', 'JOSE BONIFACIO', 'SP', '15200-000', 3525706, '2016-12-10', '7C1DEAAED41148DA949A823A21DDC3D7', 'A3CEC06E4BAA4DAB969528E1734906C1', 0, 0, 0, NULL);
INSERT INTO `softsat_licenca` (`id`, `created_on`, `updated_on`, `created_by`, `updated_by`, `plano_id`, `nome`, `cnpj`, `email`, `telefone`, `endereco`, `numero`, `complemento`, `bairro`, `cidade`, `estado`, `cep`, `codigo_ibge`, `data_base`, `iugu_subscription_id`, `iugu_customer_id`, `demonstracao`, `ilimitada`, `suspensa`, `observacao`) VALUES
	(32, '2016-12-12 08:54:07', '2017-03-21 07:25:12', NULL, 2, 5, 'LEANDRO GARCIA DE OLIVEIRA - BATATAS - ME', '22.578.655/0001-84', 'batatasoliveira@gmai.com', '', NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, '2016-12-30', '539559E5B7CD47189E7EED320B5CCD99', '8F7A9D37F97F471AA71C0F69A2F885E2', 1, 0, 0, NULL);
INSERT INTO `softsat_licenca` (`id`, `created_on`, `updated_on`, `created_by`, `updated_by`, `plano_id`, `nome`, `cnpj`, `email`, `telefone`, `endereco`, `numero`, `complemento`, `bairro`, `cidade`, `estado`, `cep`, `codigo_ibge`, `data_base`, `iugu_subscription_id`, `iugu_customer_id`, `demonstracao`, `ilimitada`, `suspensa`, `observacao`) VALUES
	(34, '2016-12-13 13:15:55', '2017-03-17 10:48:02', NULL, 1, 5, 'M J JESUS MALVEZZI ME', '69.164.085/0001-40', 'lojamalvezzi@gmail.com', '32121405', 'RUA SILVA JARDIM 1806', '00000', NULL, 'BOA VISTA', 'SAO JOSE DO RIO PRETO', 'SP', '15025-065', 3549805, '2016-11-20', '8BCCC5884E344E31B3EABE40341DF5DB', '085E73CFD7F44F88A5B8BDAD78B806F5', 1, 0, 0, NULL);
INSERT INTO `softsat_licenca` (`id`, `created_on`, `updated_on`, `created_by`, `updated_by`, `plano_id`, `nome`, `cnpj`, `email`, `telefone`, `endereco`, `numero`, `complemento`, `bairro`, `cidade`, `estado`, `cep`, `codigo_ibge`, `data_base`, `iugu_subscription_id`, `iugu_customer_id`, `demonstracao`, `ilimitada`, `suspensa`, `observacao`) VALUES
	(35, '2016-12-16 10:20:10', '2017-03-21 12:36:12', NULL, 1, 5, 'VALMIR RODELA 13343002836', '25.058.336/0001-36', 'wrfriosjb@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, 'AC', NULL, 0, '2016-12-16', '19012242C19F4327B9B8AEC487635A19', '8F182051BE764C018E4670B8CB44B8D2', 1, 0, 0, NULL);
INSERT INTO `softsat_licenca` (`id`, `created_on`, `updated_on`, `created_by`, `updated_by`, `plano_id`, `nome`, `cnpj`, `email`, `telefone`, `endereco`, `numero`, `complemento`, `bairro`, `cidade`, `estado`, `cep`, `codigo_ibge`, `data_base`, `iugu_subscription_id`, `iugu_customer_id`, `demonstracao`, `ilimitada`, `suspensa`, `observacao`) VALUES
	(36, '2016-12-20 09:22:24', '2017-03-20 14:37:09', NULL, 2, 5, 'ERCARY CONFECCOES LTDA - ME', '11.920.904/0001-51', 'unifacio@gmail.com', '(17)3245-2823', 'AV RUI BARBOSA', '01621', NULL, 'SAO JOSE', 'JOSE BONIFACIO', 'SP', '15200-000', 3525706, '2016-12-20', '47FFFAC39441458EBC28D0AE916DEAC4', '280972C878374AADA7293C24EA6B6C1A', 1, 0, 0, NULL);
INSERT INTO `softsat_licenca` (`id`, `created_on`, `updated_on`, `created_by`, `updated_by`, `plano_id`, `nome`, `cnpj`, `email`, `telefone`, `endereco`, `numero`, `complemento`, `bairro`, `cidade`, `estado`, `cep`, `codigo_ibge`, `data_base`, `iugu_subscription_id`, `iugu_customer_id`, `demonstracao`, `ilimitada`, `suspensa`, `observacao`) VALUES
	(37, '2016-12-21 17:29:40', '2017-03-17 14:11:48', NULL, NULL, 5, 'JONNATHAS MACEDO MARASTON 33660138851', '14.300.625/0001-83', 'alvaromaraston@gmail.com', '172452139', 'RUA WLADOMIRO RONQUI, 185', '00000', NULL, 'RESIDENCIAL CRISTO REDENTOR', 'MENDONCA', 'SP', '15220-000', 3529500, '2016-12-21', '4BC61EBC81F94CEB88A59D2EF4FE8530', '1D7302D203794D1386B306A16C2D234E', 1, 0, 0, NULL);
INSERT INTO `softsat_licenca` (`id`, `created_on`, `updated_on`, `created_by`, `updated_by`, `plano_id`, `nome`, `cnpj`, `email`, `telefone`, `endereco`, `numero`, `complemento`, `bairro`, `cidade`, `estado`, `cep`, `codigo_ibge`, `data_base`, `iugu_subscription_id`, `iugu_customer_id`, `demonstracao`, `ilimitada`, `suspensa`, `observacao`) VALUES
	(38, '2017-01-03 13:15:58', '2017-03-21 12:29:32', NULL, 1, 5, 'MARIA L. DOS SANTOS MARTINS - ME', '01.854.434/0001-11', 'ueslls_gb@hotmail.com', NULL, NULL, NULL, NULL, NULL, NULL, 'AC', NULL, 0, '2017-01-03', 'EC1C72FCB23F492882C78A59F967C700', '2292E4F039E4471F9D8C63265634BBC8', 0, 0, 0, NULL);
INSERT INTO `softsat_licenca` (`id`, `created_on`, `updated_on`, `created_by`, `updated_by`, `plano_id`, `nome`, `cnpj`, `email`, `telefone`, `endereco`, `numero`, `complemento`, `bairro`, `cidade`, `estado`, `cep`, `codigo_ibge`, `data_base`, `iugu_subscription_id`, `iugu_customer_id`, `demonstracao`, `ilimitada`, `suspensa`, `observacao`) VALUES
	(39, '2017-01-05 16:57:04', '2017-03-21 12:29:56', NULL, 1, 5, 'LG INFORMATICA', '01.266.175/0001-08', 'gustavo00130@hotmail.com', NULL, NULL, NULL, NULL, NULL, NULL, 'AC', NULL, 0, '2017-01-05', '9BBBA55A304344928C578953DFA3BBE3', '92F37EE3B9864B9B8EDE0E2F21AC0AB0', 0, 0, 0, NULL);
INSERT INTO `softsat_licenca` (`id`, `created_on`, `updated_on`, `created_by`, `updated_by`, `plano_id`, `nome`, `cnpj`, `email`, `telefone`, `endereco`, `numero`, `complemento`, `bairro`, `cidade`, `estado`, `cep`, `codigo_ibge`, `data_base`, `iugu_subscription_id`, `iugu_customer_id`, `demonstracao`, `ilimitada`, `suspensa`, `observacao`) VALUES
	(40, '2017-01-09 10:09:38', '2017-03-20 15:42:47', NULL, NULL, 5, 'SECADOR JOSE BONIFACIO LTDA', '02.890.709/0001-35', 'fredchristal@gmail.com', '(17)3245-3028', 'ROD SP 425', 'KM236', NULL, 'ZONA RURAL', 'JOSE BONIFACIO', 'SP', '15200-000', 3525706, '2017-01-09', '5ABA6B2ADA4148A288FA31C40E40AA56', '866E5F3BA0EC473E95B3ED845180F75E', 1, 0, 0, NULL);
INSERT INTO `softsat_licenca` (`id`, `created_on`, `updated_on`, `created_by`, `updated_by`, `plano_id`, `nome`, `cnpj`, `email`, `telefone`, `endereco`, `numero`, `complemento`, `bairro`, `cidade`, `estado`, `cep`, `codigo_ibge`, `data_base`, `iugu_subscription_id`, `iugu_customer_id`, `demonstracao`, `ilimitada`, `suspensa`, `observacao`) VALUES
	(41, '2017-01-10 09:17:07', '2017-03-21 12:31:33', NULL, 1, 5, 'PAULO R. BISPO - FERRAMENTAS - ME', '26.312.797/0001-56', 'bispoprb@hotmail.com', NULL, NULL, NULL, NULL, NULL, NULL, 'AC', NULL, 0, '2017-01-10', 'CB5F14F90CC042329273C70869C632ED', 'A934052562914C74B8C87548B418B12A', 0, 0, 0, NULL);
INSERT INTO `softsat_licenca` (`id`, `created_on`, `updated_on`, `created_by`, `updated_by`, `plano_id`, `nome`, `cnpj`, `email`, `telefone`, `endereco`, `numero`, `complemento`, `bairro`, `cidade`, `estado`, `cep`, `codigo_ibge`, `data_base`, `iugu_subscription_id`, `iugu_customer_id`, `demonstracao`, `ilimitada`, `suspensa`, `observacao`) VALUES
	(42, '2017-01-18 11:37:54', '2017-02-23 15:47:03', NULL, 2, 3, 'ANTONIO CASU SOBRINHO - ME', '10.208.594/0001-84', 'casubike@hotmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2017-01-18', '843FBBFA7DB149E293AEEECED874AE4E', 'BC7A0C7A15694779A97CF42A406583DF', 0, 0, 1, NULL);
INSERT INTO `softsat_licenca` (`id`, `created_on`, `updated_on`, `created_by`, `updated_by`, `plano_id`, `nome`, `cnpj`, `email`, `telefone`, `endereco`, `numero`, `complemento`, `bairro`, `cidade`, `estado`, `cep`, `codigo_ibge`, `data_base`, `iugu_subscription_id`, `iugu_customer_id`, `demonstracao`, `ilimitada`, `suspensa`, `observacao`) VALUES
	(43, '2017-01-24 16:25:47', '2017-03-20 11:27:02', NULL, 5, 2, 'ISABEL RUIZ - ME | VIDROBONI', '02.836.171/0001-80', 'vidroboni@hotmail.com', '172452139', 'AV 9 DE JULHO, 1603', '00929', NULL, 'SAO JOSE', 'JOSE BONIFACIO', 'SP', '15200-000', 3525706, '2017-01-10', '0BEDF76B8FD149EEA46793E7559DFD88', '49E1EFC33E15488CBA80B484FCD37635', 1, 0, 0, NULL);
INSERT INTO `softsat_licenca` (`id`, `created_on`, `updated_on`, `created_by`, `updated_by`, `plano_id`, `nome`, `cnpj`, `email`, `telefone`, `endereco`, `numero`, `complemento`, `bairro`, `cidade`, `estado`, `cep`, `codigo_ibge`, `data_base`, `iugu_subscription_id`, `iugu_customer_id`, `demonstracao`, `ilimitada`, `suspensa`, `observacao`) VALUES
	(44, '2017-03-07 09:37:02', '2017-03-17 10:28:47', NULL, 1, 2, 'RAFAEL MANOEL DIONISIO - ME', '04.460.753/0001-30', 'teste@hotmail.com', '(17)3245-5468', NULL, NULL, NULL, NULL, NULL, 'AC', NULL, 0, '2017-03-07', NULL, NULL, 1, 0, 0, NULL);
/*!40000 ALTER TABLE `softsat_licenca` ENABLE KEYS */;

-- Copiando estrutura para tabela softsats_site.softsat_licenca_estacao
CREATE TABLE IF NOT EXISTS `softsat_licenca_estacao` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_on` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_on` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `licenca_id` int(11) NOT NULL,
  `nome` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `identificador` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `ativa` tinyint(1) NOT NULL,
  `acessada_em` datetime DEFAULT NULL,
  `versao_sistema` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `data` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `un_softsat_licenca_estacao_licenca_id_identificador` (`licenca_id`,`identificador`),
  CONSTRAINT `fk_softsat_licenca_estacao_softsat_licenca` FOREIGN KEY (`licenca_id`) REFERENCES `softsat_licenca` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=92 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Copiando dados para a tabela softsats_site.softsat_licenca_estacao: ~25 rows (aproximadamente)
/*!40000 ALTER TABLE `softsat_licenca_estacao` DISABLE KEYS */;
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(2, '2016-10-26 16:40:51', '2017-03-21 08:27:40', 3, 'RCV-PC', 'CCF55181', 1, '2017-03-21 08:27:40', '1', '2017-03-21 00:00:21');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(4, '2016-10-27 10:02:48', '2016-11-21 10:08:40', 3, 'SOFTSAT-003', 'CCF065AC', 1, '2016-11-21 10:08:40', '1', '2016-11-21 00:00:21');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(6, '2016-10-28 10:20:43', '2016-11-18 08:43:39', 3, 'SOFTSAT-003', 'BC1E4829', 1, '2016-11-18 08:43:39', '1', '2016-11-18 00:00:18');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(7, '2016-10-28 13:28:01', '2017-03-13 15:48:18', 14, 'SOFTSAT-003', 'BC1E4829', 1, '2016-10-28 13:28:01', '1', '2016-10-28 00:00:28');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(10, '2016-10-28 17:35:43', '2017-03-13 15:48:18', 14, 'SOFT-SAT-001', '5567A330', 1, '2016-12-27 09:18:21', '1', '2016-12-27 00:00:27');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(11, '2016-10-29 12:09:43', '2017-03-13 15:48:18', 14, 'SOFTSAT-006', 'A6D29973', 1, '2016-10-29 12:09:43', '1', '2016-10-29 00:00:29');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(12, '2016-10-31 17:34:10', '2017-03-15 10:36:31', 4, 'SOFTSAT-003', 'CCF065AC', 1, '2017-03-15 10:36:31', '1', '2017-03-15 00:00:15');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(13, '2016-11-03 14:16:30', '2017-03-13 15:48:18', 14, 'SOFTSAT-003', 'CCF065AC', 1, '2016-11-29 08:19:36', '1', '2016-11-29 00:00:29');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(14, '2016-11-04 14:17:10', '2016-11-06 10:48:55', 16, 'LOJA', 'EFF9CE05', 1, '2016-11-06 10:48:55', '1', '2016-11-06 00:00:06');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(15, '2016-11-04 17:07:57', '2016-12-14 08:56:27', 6, 'TEAMWORK-PC', '5D47C8A0', 1, '2016-12-14 08:56:27', '1', '2016-12-14 00:00:14');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(16, '2016-11-07 11:08:02', '2017-02-13 10:02:47', 6, 'FINANCEIRO-LOJA', 'EEE6CBE5', 1, '2017-02-13 10:02:47', '1', '2017-02-13 00:00:13');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(17, '2016-11-07 18:26:08', '2017-01-24 10:16:56', 15, 'VANZELA-PC', '3A2A7F25', 1, '2016-12-02 10:39:13', '1', '2016-12-02 00:00:02');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(18, '2016-11-11 10:49:40', '2017-03-13 15:48:18', 14, 'ESTOQUE2', '70149609', 1, '2016-11-11 10:49:40', '1', '2016-11-11 00:00:11');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(19, '2016-11-11 15:09:44', '2017-03-20 14:06:16', 22, 'ESTOQUE2', '70149609', 1, '2017-03-20 14:06:16', '1', '2017-03-20 00:00:20');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(20, '2016-11-16 08:41:37', '2017-03-20 17:28:30', 3, 'PC-RICARDO', 'B657AF6C', 1, '2017-03-20 17:28:30', '1', '2017-03-20 00:00:20');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(21, '2016-11-24 15:36:35', '2017-03-20 13:10:03', 14, 'SOFTSAT-006', '3943265F', 1, '2017-03-20 13:10:03', '1', '2017-03-20 00:00:20');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(22, '2016-11-25 11:19:53', '2017-01-19 07:49:47', 23, 'MRINFORMATICA', '4742A316', 1, '2017-01-19 07:49:47', '1', '2017-01-19 00:00:19');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(23, '2016-11-28 09:40:50', '2017-03-16 17:06:11', 13, 'USUARIO', '6FDD32E8', 1, '2017-03-16 17:06:11', '1', '2017-03-16 00:00:16');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(24, '2016-11-28 14:43:33', '2017-03-13 15:48:18', 14, 'NOTE-CRIS', 'AE0E60D7', 1, '2017-01-27 15:19:29', '1', '2017-01-27 00:00:27');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(25, '2016-11-28 16:11:21', '2017-03-20 11:02:06', 13, 'USUARIO', '9ACBB331', 1, '2017-03-20 11:02:06', '1', '2017-03-20 00:00:20');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(26, '2016-12-02 09:12:42', '2017-03-04 09:04:16', 15, 'VANZELA-PC', '98F87EC5', 1, '2017-03-04 09:04:16', '1', '2017-03-04 00:00:04');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(27, '2016-12-02 11:44:36', '2016-12-02 11:44:36', 23, 'MRINFORMATICA', '2E9A071B', 1, '2016-12-02 11:44:36', '1', '2016-12-02 00:00:02');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(29, '2016-12-07 09:22:00', '2017-03-16 14:14:42', 24, 'USUARIO-PC', 'F84809DF', 1, '2017-03-16 14:14:42', '1', '2017-03-16 00:00:16');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(30, '2016-12-07 11:08:23', '2017-01-23 17:42:16', 26, 'F_FORNAZIERI', '19987EDA', 1, '2016-12-07 11:08:23', '1', '2016-12-07 00:00:07');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(31, '2016-12-08 14:53:50', '2017-01-23 17:42:16', 26, 'SOFTSAT-004', '7C55C90E', 1, '2016-12-08 14:53:50', '1', '2016-12-08 00:00:08');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(32, '2016-12-08 15:05:34', '2016-12-08 15:05:34', 27, 'SOFTSAT-004', '7C55C90E', 1, '2016-12-08 15:05:34', '1', '2016-12-08 00:00:08');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(34, '2016-12-12 08:54:07', '2017-03-21 07:25:12', 32, 'IDEAL-PC', 'E49DA619', 1, '2017-03-21 07:25:12', '1', '2017-03-21 00:00:21');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(35, '2016-12-12 11:05:26', '2017-01-27 16:43:14', 27, 'F_FORNAZIERI', '90BA796C', 1, '2017-01-27 16:43:14', '1', '2017-01-27 00:00:27');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(36, '2016-12-12 11:42:24', '2017-03-06 14:09:07', 26, 'USUARIO-PC', '10D92E02', 1, '2017-03-06 14:09:06', '1', '2017-03-06 00:00:06');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(37, '2016-12-13 10:29:40', '2017-02-01 12:52:29', 4, 'DODA-APPL-001', 'E70106F6', 1, '2017-01-23 08:26:14', '1', '2017-01-23 00:00:23');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(38, '2016-12-13 13:15:55', '2017-03-21 08:38:40', 34, 'MALVEZZI-PC', 'EA9E81B4', 1, '2017-03-21 08:38:40', '1', '2017-03-21 00:00:21');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(39, '2016-12-13 15:27:20', '2017-03-15 15:51:31', 27, 'NETO', 'D8A06B37', 1, '2017-03-15 15:51:31', '1', '2017-03-15 00:00:15');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(40, '2016-12-15 09:29:04', '2017-03-20 11:31:09', 4, 'AMANDA-PC', '6811E8F6', 1, '2017-03-20 11:31:09', '1', '2017-03-20 00:00:20');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(41, '2016-12-15 09:38:55', '2017-03-21 12:42:11', 8, 'USUARIO-PC', '270F8FB7', 1, '2017-03-21 09:44:08', '1', '2017-03-21 00:00:21');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(42, '2016-12-15 09:39:01', '2017-03-21 12:42:11', 8, 'USER-PC', '7C6FE88A', 1, '2017-03-21 11:41:10', '1', '2017-03-21 00:00:21');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(43, '2016-12-15 11:28:13', '2017-02-02 10:43:56', 27, 'F_FORNAZIERI', '19987EDA', 1, '2017-02-02 10:43:56', '1', '2017-02-02 00:00:02');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(44, '2016-12-16 10:20:10', '2017-03-21 12:36:12', 35, 'SP3', '750D1BEA', 1, '2017-03-18 07:14:27', '1', '2017-03-18 00:00:18');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(45, '2016-12-17 13:12:19', '2017-03-20 14:32:38', 5, 'IDEAL-PC', '0B6FE4BA', 1, '2017-03-20 14:32:38', '1', '2017-03-20 00:00:20');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(46, '2016-12-20 09:22:24', '2017-03-20 14:37:09', 36, 'USUARIO-PC', 'A15C8A16', 1, '2017-03-20 14:37:09', '1', '2017-03-20 00:00:20');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(47, '2016-12-20 16:49:15', '2017-03-20 08:17:56', 30, 'USUARIO-PC', '67549939', 1, '2017-03-20 08:17:56', '1', '2017-03-20 00:00:20');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(48, '2016-12-21 17:29:40', '2017-03-17 14:11:48', 37, 'MARASTON-PC', '7B5C1C65', 1, '2017-03-17 14:11:48', '1', '2017-03-17 00:00:17');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(49, '2016-12-22 11:44:53', '2017-03-21 09:42:09', 2, 'DESKTOP-0RNGI5M', '6C3E01CF', 1, '2017-03-21 09:42:09', '1', '2017-03-21 00:00:21');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(50, '2016-12-23 16:08:23', '2017-02-07 14:37:45', 37, 'F_FORNAZIERI', '19987EDA', 1, '2017-02-07 14:37:45', '1', '2017-02-07 00:00:07');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(51, '2016-12-26 17:21:16', '2017-03-09 09:51:14', 4, 'AMANDA-PC', 'BB322038', 1, '2017-03-09 09:51:14', '1', '2017-03-09 00:00:09');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(52, '2016-12-29 14:04:28', '2017-02-01 12:52:29', 4, 'F_FORNAZIERI', '19987EDA', 1, '2016-12-29 14:04:28', '1', '2016-12-29 00:00:29');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(53, '2017-01-03 13:15:59', '2017-03-21 12:29:32', 38, 'UESLLS', 'E0B6085A', 1, '2017-01-03 13:15:59', '1', '2017-01-03 00:00:03');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(54, '2017-01-03 16:00:53', '2017-03-21 12:29:32', 38, 'UESLLS', 'DD941768', 1, '2017-03-17 09:15:12', '1', '2017-03-17 00:00:17');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(55, '2017-01-04 14:02:50', '2017-01-10 12:21:07', 37, 'SOFTSAT-006', '3943265F', 1, '2017-01-10 12:21:07', '1', '2017-01-10 00:00:10');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(56, '2017-01-04 17:25:54', '2017-01-05 08:18:51', 23, 'SOFTSAT-006', '3943265F', 1, '2017-01-05 08:18:51', '1', '2017-01-05 00:00:05');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(57, '2017-01-05 09:51:56', '2017-03-21 10:21:09', 4, 'SOFTSAT-003', 'BC1E4829', 1, '2017-03-21 10:21:09', '1', '2017-03-21 00:00:21');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(58, '2017-01-05 16:57:04', '2017-03-21 12:29:56', 39, 'HOME', '04FE5480', 1, '2017-02-03 09:06:38', '1', '2017-02-03 00:00:03');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(59, '2017-01-09 10:09:38', '2017-03-04 13:51:17', 40, 'USUARIO-PC', '52E09E8D', 1, '2017-03-04 13:51:17', '1', '2017-03-04 00:00:04');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(60, '2017-01-09 10:34:09', '2017-03-21 08:57:25', 6, 'USUARIO-PC', '2EFE7911', 1, '2017-03-21 08:57:25', '1', '2017-03-21 00:00:21');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(61, '2017-01-10 09:17:07', '2017-03-21 12:31:33', 41, 'USUARIO-PC', '4B99B8A2', 1, '2017-01-12 10:29:22', '1', '2017-01-12 00:00:12');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(62, '2017-01-10 13:13:31', '2017-03-21 12:31:33', 41, 'USUARIO-PC', '99FCEDA8', 1, '2017-01-10 13:13:31', '1', '2017-01-10 00:00:10');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(63, '2017-01-11 17:40:14', '2017-03-21 08:58:41', 14, 'F_FORNAZIERI', '19987EDA', 1, '2017-03-21 08:58:41', '1', '2017-03-21 00:00:21');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(64, '2017-01-12 10:43:24', '2017-03-20 12:25:38', 14, 'F_FORNAZIERI', '90BA796C', 1, '2017-03-20 12:25:38', '1', '2017-03-20 00:00:20');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(65, '2017-01-13 09:20:39', '2017-01-27 16:34:41', 37, 'SOFTSAT-007', '40C68001', 1, '2017-01-27 16:34:41', '1', '2017-01-27 00:00:27');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(66, '2017-01-13 10:23:50', '2017-01-24 10:15:56', 2, 'DESKTOP-0RNGI5M', '3C232EF3', 1, '2017-01-13 10:23:50', '1', '2017-01-13 00:00:13');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(67, '2017-01-14 13:47:11', '2017-03-21 12:31:33', 41, 'USUARIO-PC', '6632D9F9', 1, '2017-01-31 17:09:09', '1', '2017-01-31 00:00:31');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(68, '2017-01-17 09:18:05', '2017-03-21 12:42:11', 8, 'SOFTSAT-007', '40C68001', 1, '2017-02-08 10:49:00', '1', '2017-02-08 00:00:08');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(69, '2017-01-18 11:37:54', '2017-02-23 15:47:03', 42, 'USUARIO-PC', 'DC34B489', 1, '2017-02-14 15:09:54', '1', '2017-02-14 00:00:14');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(70, '2017-01-18 16:07:59', '2017-03-21 12:31:33', 41, 'USUARIO-PC', 'E475A25C', 1, '2017-03-12 15:05:06', '1', '2017-03-12 00:00:12');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(71, '2017-01-19 08:18:04', '2017-03-21 07:53:50', 23, 'MRINFORMATICA', '54FDC79F', 1, '2017-03-21 07:53:50', '1', '2017-03-21 00:00:21');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(72, '2017-01-20 11:48:24', '2017-03-21 08:10:39', 20, 'SP3', '5C2F5E87', 1, '2017-03-21 08:10:39', '1', '2017-03-21 00:00:21');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(73, '2017-01-20 12:17:50', '2017-03-21 09:25:02', 21, 'PASSARELA-PC', '0270BE17', 1, '2017-03-21 09:25:02', '1', '2017-03-21 00:00:21');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(74, '2017-01-20 14:36:52', '2017-02-02 11:25:41', 23, 'SOFTSAT-007', '40C68001', 1, '2017-02-02 11:25:41', '1', '2017-02-02 00:00:02');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(75, '2017-01-20 17:01:35', '2017-02-01 12:52:29', 4, 'SOFTSAT-007', '40C68001', 1, '2017-01-23 11:10:57', '1', '2017-01-23 00:00:23');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(76, '2017-01-20 17:30:56', '2017-03-20 07:07:16', 4, 'SERVIDOR', '57B86538', 1, '2017-03-20 07:07:16', '1', '2017-03-20 00:00:20');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(77, '2017-01-20 17:41:24', '2017-03-21 09:00:55', 4, 'DODA´S-001', 'A9B826D9', 1, '2017-03-21 09:00:55', '1', '2017-03-21 00:00:21');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(78, '2017-01-24 16:25:47', '2017-03-20 11:27:02', 43, 'LIGIA-PC', 'A4B9FA00', 1, '2017-03-20 11:27:02', '1', '2017-03-20 00:00:20');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(79, '2017-01-25 12:58:42', '2017-03-13 15:48:18', 14, 'SOFT-SAT-001', '50C4227E', 1, '2017-03-02 15:24:02', '1', '2017-03-02 00:00:02');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(80, '2017-01-26 11:41:27', '2017-02-23 15:42:03', 22, 'SOFTSAT-007', '40C68001', 1, '2017-01-30 10:23:01', '1', '2017-01-30 00:00:30');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(81, '2017-02-01 15:47:51', '2017-02-02 10:39:42', 32, 'SOFTSAT-007', '40C68001', 1, '2017-02-02 10:39:42', '1', '2017-02-02 00:00:02');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(82, '2017-02-06 11:46:34', '2017-03-21 12:29:56', 39, 'HOME', 'D4DEA342', 1, '2017-03-16 10:25:29', '1', '2017-03-16 00:00:16');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(83, '2017-02-06 12:16:27', '2017-02-06 12:16:27', 4, 'SOFTSAT-003', '529BB3F8', 1, '2017-02-06 12:16:27', '1', '2017-02-06 00:00:06');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(84, '2017-02-10 16:29:52', '2017-03-21 12:42:11', 8, 'SOFTSAT-007', '4D033189', 1, '2017-02-14 15:20:01', '1', '2017-02-14 00:00:14');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(85, '2017-02-16 17:32:29', '2017-02-16 17:32:29', 37, 'F_FORNAZIERI', '90BA796C', 1, '2017-02-16 17:32:29', '1', '2017-02-16 00:00:16');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(86, '2017-02-20 11:47:20', '2017-02-20 14:17:44', 34, 'SOFTSAT-007', '4D033189', 1, '2017-02-20 14:17:44', '1', '2017-02-20 00:00:20');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(87, '2017-02-21 14:13:50', '2017-03-03 09:23:47', 23, 'SOFTSAT-007', '4D033189', 1, '2017-03-03 09:23:47', '1', '2017-03-03 00:00:03');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(88, '2017-03-03 10:14:36', '2017-03-20 15:42:47', 40, 'USUARIO-PC', '0D9A7645', 1, '2017-03-20 15:42:47', '1', '2017-03-20 00:00:20');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(89, '2017-03-03 10:22:12', '2017-03-15 10:42:21', 22, 'SOFTSAT-007', '4D033189', 1, '2017-03-15 10:42:21', '1', '2017-03-15 00:00:15');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(90, '2017-03-07 09:37:03', '2017-03-17 10:28:47', 44, 'FRANCIS-PC', '1DAEFA6E', 1, '2017-03-07 09:37:03', '1', '2017-03-07 00:00:07');
INSERT INTO `softsat_licenca_estacao` (`id`, `created_on`, `updated_on`, `licenca_id`, `nome`, `identificador`, `ativa`, `acessada_em`, `versao_sistema`, `data`) VALUES
	(91, '2017-03-10 11:25:29', '2017-03-13 16:13:12', 4, 'SOFTSAT-003', '2BAC7608', 1, '2017-03-13 16:13:12', '1', '2017-03-13 00:00:13');
/*!40000 ALTER TABLE `softsat_licenca_estacao` ENABLE KEYS */;

-- Copiando estrutura para tabela softsats_site.softsat_licenca_extensao
CREATE TABLE IF NOT EXISTS `softsat_licenca_extensao` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_by` int(11) DEFAULT NULL,
  `created_on` datetime DEFAULT CURRENT_TIMESTAMP,
  `updated_by` int(11) DEFAULT NULL,
  `updated_on` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `licenca_id` int(11) NOT NULL,
  `expira_em` date NOT NULL,
  `justificativa` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_softsat_licenca_extensao_hwapx_user_created_by` (`created_by`),
  KEY `fk_softsat_licenca_extensao_hwapx_user_updated_by` (`updated_by`),
  KEY `fk_softsat_licenca_extensao_softsat_licenca` (`licenca_id`),
  CONSTRAINT `fk_softsat_licenca_extensao_hwapx_user_created_by` FOREIGN KEY (`created_by`) REFERENCES `hwapx_user` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_softsat_licenca_extensao_hwapx_user_updated_by` FOREIGN KEY (`updated_by`) REFERENCES `hwapx_user` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_softsat_licenca_extensao_softsat_licenca` FOREIGN KEY (`licenca_id`) REFERENCES `softsat_licenca` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=latin1;

-- Copiando dados para a tabela softsats_site.softsat_licenca_extensao: ~10 rows (aproximadamente)
/*!40000 ALTER TABLE `softsat_licenca_extensao` DISABLE KEYS */;
INSERT INTO `softsat_licenca_extensao` (`id`, `created_by`, `created_on`, `updated_by`, `updated_on`, `licenca_id`, `expira_em`, `justificativa`) VALUES
	(2, 2, '2017-02-23 15:47:41', 2, '2017-02-23 15:47:41', 35, '2017-02-28', 'Não foi gerada a cobrança');
INSERT INTO `softsat_licenca_extensao` (`id`, `created_by`, `created_on`, `updated_by`, `updated_on`, `licenca_id`, `expira_em`, `justificativa`) VALUES
	(3, 2, '2017-02-23 15:50:29', 2, '2017-02-23 15:50:29', 36, '2017-02-24', 'Não foi gerada a cobrança');
INSERT INTO `softsat_licenca_extensao` (`id`, `created_by`, `created_on`, `updated_by`, `updated_on`, `licenca_id`, `expira_em`, `justificativa`) VALUES
	(4, 5, '2017-03-08 18:01:14', 5, '2017-03-08 18:01:14', 13, '2017-03-08', 'Boleto não foi pago, será enviado outro com o vencimento para amanhã (09/03).');
INSERT INTO `softsat_licenca_extensao` (`id`, `created_by`, `created_on`, `updated_by`, `updated_on`, `licenca_id`, `expira_em`, `justificativa`) VALUES
	(5, 2, '2017-03-15 10:26:43', 2, '2017-03-15 10:26:43', 5, '2017-03-16', 'Falha na assinatura Iugu');
INSERT INTO `softsat_licenca_extensao` (`id`, `created_by`, `created_on`, `updated_by`, `updated_on`, `licenca_id`, `expira_em`, `justificativa`) VALUES
	(6, 5, '2017-03-15 14:26:55', 5, '2017-03-15 14:26:55', 24, '2017-03-16', 'Boleto pago hoje.');
INSERT INTO `softsat_licenca_extensao` (`id`, `created_by`, `created_on`, `updated_by`, `updated_on`, `licenca_id`, `expira_em`, `justificativa`) VALUES
	(7, 5, '2017-03-15 17:44:09', 5, '2017-03-15 17:44:09', 30, '2017-03-16', 'Reenviado boleto para o cliente pagar.');
INSERT INTO `softsat_licenca_extensao` (`id`, `created_by`, `created_on`, `updated_by`, `updated_on`, `licenca_id`, `expira_em`, `justificativa`) VALUES
	(8, 5, '2017-03-17 11:01:52', 5, '2017-03-17 11:01:52', 43, '2017-03-15', 'Boleto não foi pago, será enviado outro com o vencimento para Segunda (20/03).');
INSERT INTO `softsat_licenca_extensao` (`id`, `created_by`, `created_on`, `updated_by`, `updated_on`, `licenca_id`, `expira_em`, `justificativa`) VALUES
	(9, 5, '2017-03-20 09:31:16', 5, '2017-03-20 09:31:16', 20, '2017-03-20', 'Boleto não foi gerado.');
INSERT INTO `softsat_licenca_extensao` (`id`, `created_by`, `created_on`, `updated_by`, `updated_on`, `licenca_id`, `expira_em`, `justificativa`) VALUES
	(10, 5, '2017-03-20 11:26:59', 5, '2017-03-20 11:26:59', 43, '2017-03-16', 'Boleto não foi pago. Será pago hoje.');
INSERT INTO `softsat_licenca_extensao` (`id`, `created_by`, `created_on`, `updated_by`, `updated_on`, `licenca_id`, `expira_em`, `justificativa`) VALUES
	(11, 5, '2017-03-20 12:17:43', 5, '2017-03-20 12:17:43', 21, '2017-03-17', 'Boleto não foi pago, será enviado outro com o vencimento para amanhã (21/03).');
INSERT INTO `softsat_licenca_extensao` (`id`, `created_by`, `created_on`, `updated_by`, `updated_on`, `licenca_id`, `expira_em`, `justificativa`) VALUES
	(12, 1, '2017-03-21 09:24:41', 1, '2017-03-21 09:24:41', 21, '2017-03-21', 'Extensão, pois o boleto não compensou ainda.');
INSERT INTO `softsat_licenca_extensao` (`id`, `created_by`, `created_on`, `updated_by`, `updated_on`, `licenca_id`, `expira_em`, `justificativa`) VALUES
	(13, 1, '2017-03-21 12:36:12', 1, '2017-03-21 12:36:12', 35, '2017-03-23', 'Novo boleto gerado');
/*!40000 ALTER TABLE `softsat_licenca_extensao` ENABLE KEYS */;

-- Copiando estrutura para tabela softsats_site.softsat_licenca_fatura
CREATE TABLE IF NOT EXISTS `softsat_licenca_fatura` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_on` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_on` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `licenca_id` int(11) NOT NULL,
  `iugu_invoice_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `emissao` date DEFAULT NULL,
  `vencimento` date NOT NULL,
  `valor` decimal(18,2) DEFAULT NULL,
  `pagamento` datetime DEFAULT NULL,
  `valor_pago` decimal(18,2) DEFAULT NULL,
  `cancelada` tinyint(1) NOT NULL DEFAULT '0',
  `observacao` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `un_softsat_licenca_fatura_iugu_invoice_id` (`iugu_invoice_id`),
  KEY `fk_softsat_licenca_fatura_softsat_licenca` (`licenca_id`),
  CONSTRAINT `fk_softsat_licenca_fatura_softsat_licenca` FOREIGN KEY (`licenca_id`) REFERENCES `softsat_licenca` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=168 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Copiando dados para a tabela softsats_site.softsat_licenca_fatura: ~107 rows (aproximadamente)
/*!40000 ALTER TABLE `softsat_licenca_fatura` DISABLE KEYS */;
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(1, '2016-10-20 14:41:05', '2017-02-01 12:52:29', 4, 'FCDC68200921436085EC55D1F0474687', '2016-10-15', '2016-10-20', 200.00, '2016-10-21 08:45:26', 200.00, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(3, '2016-10-20 14:41:05', '2017-01-24 10:15:56', 2, 'E9FF454D563A48ACBF929A62EE021A38', '2016-10-11', '2016-10-20', 69.90, '2016-10-25 08:07:26', 71.35, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(4, '2016-10-20 14:41:05', '2016-11-18 11:40:42', 7, 'B9F078E14AA74E7A874CCB271C7FEDC3', '2016-10-06', '2016-10-15', 200.00, '2016-10-18 08:32:12', 200.00, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(5, '2016-10-20 14:41:05', '2016-10-20 14:41:05', 6, '8AAE850FD693424DB25C0390FF8BA15E', '2016-10-01', '2016-10-10', 149.90, '2016-10-11 08:19:12', 149.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(6, '2016-10-20 14:41:05', '2016-10-26 18:17:34', 3, '5F6870247667419982750A68FDAA624F', '2016-10-01', '2016-10-10', 149.90, '2016-10-11 08:31:15', 149.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(7, '2016-10-20 14:41:05', '2017-02-01 12:52:29', 4, '04C901CEDDD2479E85E77E0A5ABB3AE5', '2016-09-23', '2016-09-23', 200.00, '2016-09-26 08:17:49', 200.00, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(8, '2016-10-20 14:41:05', '2017-01-24 10:15:56', 2, '887D3CB1C05949AE89E3CBB4B570B087', '2016-09-11', '2016-09-20', 69.90, '2016-09-21 08:16:05', 69.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(9, '2016-10-20 14:41:05', '2016-11-18 11:40:42', 7, '592C4951C7C84FB6BECCD921CE2131C1', '2016-09-06', '2016-09-15', 200.00, '2016-09-15 08:28:06', 200.00, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(10, '2016-10-20 14:41:05', '2016-10-26 18:17:34', 3, '1A3A02B267124F13AB6EE043BA8F30A8', '2016-09-01', '2016-09-10', 149.90, '2016-09-13 08:11:21', 149.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(11, '2016-10-20 14:41:05', '2016-10-20 14:41:05', 6, 'D3AFD75811E7489E8ED85F001DF89DF2', '2016-09-01', '2016-09-10', 149.90, '2016-09-13 08:20:16', 149.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(12, '2016-10-20 14:41:05', '2017-02-01 12:52:29', 4, '8B69C22687A843D993035D8F8FC33984', '2016-08-11', '2016-08-20', 200.00, '2016-08-25 08:48:15', 200.00, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(13, '2016-10-20 14:41:05', '2016-11-18 11:40:42', 7, 'F76F77C7D3CD4326BB5E7BD6642D8880', '2016-08-06', '2016-08-15', 200.00, '2016-08-16 08:14:29', 200.00, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(14, '2016-10-20 14:41:05', '2016-10-20 14:41:05', 6, 'C369CB6A036D4F99B9A7E69FB609D753', '2016-08-02', '2016-08-10', 149.90, '2016-08-08 08:16:18', 149.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(15, '2016-10-20 14:41:05', '2017-02-01 12:52:29', 4, 'C46ECFD395964BF4BB9C59144DC7B8A9', '2016-07-20', '2016-07-22', 200.00, '2016-07-25 08:36:11', 200.00, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(16, '2016-10-20 14:41:05', '2017-03-15 10:26:43', 5, 'B4460BD065C94F0F93DA374E663E093D', '2016-07-12', '2016-07-18', 119.90, '2016-07-26 08:44:24', 119.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(17, '2016-10-20 14:41:05', '2016-10-20 14:41:05', 6, '582258CFE5FC444D817DEE45DDFC8A6C', '2016-07-06', '2016-07-10', 149.90, '2016-07-12 10:00:31', 149.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(18, '2016-10-20 14:41:05', '2016-11-18 11:40:42', 7, 'DD95E01A10B343A088EA6EF2DFB1A135', '2016-06-30', '2016-07-15', 200.00, '2016-07-18 08:40:21', 200.00, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(19, '2016-10-20 14:41:05', '2016-11-18 11:40:42', 7, 'B9004F85DE814F8FB741BBC1FB844EC7', '2016-06-09', '2016-06-15', 200.00, '2016-06-16 08:26:21', 200.00, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(20, '2016-10-20 14:41:46', '2017-03-15 10:26:43', 5, NULL, NULL, '2016-08-10', NULL, '2016-08-20 00:00:00', NULL, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(21, '2016-10-20 14:41:46', '2017-03-15 10:26:43', 5, NULL, NULL, '2016-09-10', NULL, '2016-09-20 00:00:00', NULL, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(25, '2016-10-28 10:20:39', '2017-03-08 18:01:14', 13, '73F62C677068422A9F0B8075C484723A', '2016-10-28', '2016-10-31', 49.90, '2016-11-01 08:28:57', 49.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(26, '2016-11-01 05:10:30', '2016-11-11 08:27:27', 3, 'D2062CDCF51040F584761FF20B726F7D', '2016-11-01', '2016-11-10', 149.90, '2016-11-11 08:24:44', 149.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(28, '2016-11-01 05:10:43', '2016-11-11 08:41:18', 6, '9E7A26240ED249FCBDA8000B82BC7355', '2016-11-01', '2016-11-10', 149.90, '2016-11-11 08:34:11', 149.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(29, '2016-11-01 13:28:49', '2017-03-15 10:26:43', 5, NULL, NULL, '2016-10-10', NULL, '2016-10-31 00:00:00', NULL, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(31, '2016-11-06 05:10:12', '2016-11-18 11:40:42', 7, 'DF13FC5819AB48DE92F761615909B51F', '2016-11-06', '2016-11-15', 200.00, '2016-11-17 08:32:43', 200.00, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(33, '2016-11-07 14:54:24', '2017-03-21 12:42:11', 8, '0EBCF684C35D44CE8B0F26E6CA2AD307', '2016-11-07', '2016-11-10', 220.00, '2016-11-11 08:22:08', 220.00, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(37, '2016-11-11 05:11:49', '2017-01-24 10:15:56', 2, 'C72765940C5C4D568DE9D6A9091583AC', '2016-11-11', '2016-11-20', 69.90, '2016-11-22 08:24:21', 69.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(39, '2016-11-11 08:31:36', '2016-11-11 08:31:36', 17, 'BB9FB98497BD46229FDCD300FFE17920', '2016-11-07', '2016-11-10', 119.90, '2016-11-11 08:27:11', 119.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(41, '2016-11-17 05:08:48', '2017-03-08 18:01:14', 13, '41DD6ADB117D4B689C1CAD4BF0EE4A63', '2016-11-17', '2016-11-26', 49.90, '2016-11-29 08:50:05', 49.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(42, '2016-11-18 11:17:05', '2017-03-21 09:24:41', 21, 'C8568FAE375F40DDA5A4051BA90A1ADF', '2016-11-18', '2016-11-20', 110.00, '2016-11-22 08:17:30', 110.00, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(43, '2016-11-18 11:18:12', '2017-03-20 09:31:16', 20, '5B524C7BDCEA4A7A8AED59CF65267EFD', '2016-11-18', '2016-11-20', 110.00, '2016-11-22 08:22:48', 110.00, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(44, '2016-11-18 11:37:20', '2017-03-15 10:26:43', 5, NULL, NULL, '2016-11-10', NULL, '2016-11-13 00:00:00', NULL, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(46, '2016-11-22 17:15:59', '2017-02-01 12:52:29', 4, '15C7A709102140AFAFE7C0D7E9B33233', '2016-11-22', '2016-11-23', 200.00, '2016-11-24 08:19:47', 200.00, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(47, '2016-12-01 05:18:44', '2016-12-13 08:17:22', 3, '2576D546A4114705B466DF29F1A6DAB8', '2016-12-01', '2016-12-10', 149.90, '2016-12-13 08:12:25', 149.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(48, '2016-12-01 05:19:06', '2016-12-12 09:24:55', 17, 'AAD5995835B3476483F0C83D0F9514D2', '2016-12-01', '2016-12-10', 119.90, '2016-12-12 09:23:46', 119.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(50, '2016-12-01 05:19:09', '2016-12-13 08:05:55', 6, 'C930DEC6DE2744B2BD601FD1149AA9EE', '2016-12-01', '2016-12-10', 149.90, '2016-12-13 08:03:38', 149.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(52, '2016-12-01 11:11:20', '2017-01-24 10:16:56', 15, NULL, NULL, '2016-11-30', NULL, '2016-12-01 11:10:56', NULL, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(53, '2016-12-06 05:14:22', '2016-12-16 08:47:01', 7, '2D01F5C3BFE94B7DBFF5BE7E8023DACD', '2016-12-06', '2016-12-15', 200.00, '2016-12-16 08:40:45', 200.00, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(54, '2016-12-09 12:21:36', '2017-03-15 17:44:09', 30, '7DF0A0FBEA324DBC9DB494C781B9662A', '2016-12-09', '2016-12-10', 49.90, '2016-12-16 08:43:12', 49.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(57, '2016-12-11 05:16:39', '2017-01-24 10:15:56', 2, '52EA26EC3A694415834955309550830E', '2016-12-11', '2016-12-20', 69.90, '2016-12-21 09:43:47', 69.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(58, '2016-12-14 09:01:06', '2016-12-19 08:36:18', 34, '7B1E9D75D88845EE892FBF468CD762EB', '2016-12-12', '2016-12-20', 49.90, '2016-12-19 08:32:53', 49.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(60, '2016-12-15 09:43:21', '2017-03-21 12:42:11', 8, NULL, NULL, '2016-12-15', NULL, '2016-12-15 09:43:19', NULL, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(62, '2016-12-17 05:16:10', '2017-03-08 18:01:14', 13, 'EA4F66E82C7E4610807A331A9CF0EE63', '2016-12-17', '2016-12-26', 49.90, '2016-12-27 09:40:43', 49.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(63, '2016-12-20 15:36:25', '2017-03-21 09:24:41', 21, '8BE572D55E724306BCD82D5BB386E5D2', '2016-12-20', '2016-12-21', 110.00, '2016-12-22 08:51:25', 110.00, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(64, '2016-12-20 15:36:48', '2017-03-20 09:31:16', 20, '178B3188888F4C7D8B3A657003729C9B', '2016-12-20', '2016-12-21', 110.00, '2016-12-22 08:46:53', 110.00, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(67, '2016-12-22 16:24:29', '2017-03-15 10:26:43', 5, NULL, NULL, '2016-12-10', NULL, '2016-12-10 16:24:20', NULL, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(69, '2016-12-23 11:56:34', '2017-01-24 10:16:56', 15, NULL, NULL, '2016-12-20', NULL, '2016-12-23 00:00:00', NULL, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(70, '2016-12-26 15:18:44', '2017-02-01 12:52:29', 4, '3C06ECA8E1624D00BCD71D2EFCC8F952', '2016-12-26', '2016-12-27', 200.00, '2016-12-27 09:36:16', 200.00, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(71, '2017-01-01 05:08:12', '2017-01-11 08:35:31', 3, 'DCD539996CFE4D049E4EC3DE67CF6E1A', '2017-01-01', '2017-01-10', 149.90, '2017-01-11 08:33:41', 149.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(72, '2017-01-01 05:09:26', '2017-01-11 08:40:34', 17, 'F3DE3266A56846E7B4F229991BF98D3C', '2017-01-01', '2017-01-10', 119.90, '2017-01-11 08:36:30', 119.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(73, '2017-01-01 05:09:35', '2017-01-06 07:44:35', 6, 'BDBB68733DFE4B029E0D319F1A393810', '2017-01-01', '2017-01-10', 149.90, '2017-01-06 07:40:18', 149.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(74, '2017-01-01 05:09:49', '2017-01-11 08:47:29', 27, '1A9DF7859F53499287618D2E2450334E', '2017-01-01', '2017-01-10', 49.90, '2017-01-11 08:40:55', 49.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(75, '2017-01-04 12:18:20', '2017-01-06 07:51:39', 37, '01B6444B47C442CC8370E523D795DFD3', '2017-01-04', '2017-01-10', 49.90, '2017-01-06 07:44:05', 49.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(76, '2017-01-04 12:18:38', '2017-03-21 12:29:32', 38, '75704134AF7D4D0FA4F8B0DDBDE5C884', '2017-01-04', '2017-01-10', 49.90, '2017-01-16 09:44:44', 49.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(77, '2017-01-05 11:40:07', '2017-03-21 12:36:12', 35, 'D8BD8772A61B4119A5D005A147F918AD', '2017-01-05', '2017-01-06', 49.90, '2017-01-09 08:58:16', 49.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(78, '2017-01-06 05:14:40', '2017-01-17 08:08:04', 7, '978CC854D4C34CDC91F2BCC299FE1E02', '2017-01-06', '2017-01-15', 200.00, '2017-01-17 07:51:05', 200.00, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(79, '2017-01-10 09:50:32', '2017-03-15 17:44:09', 30, 'DEC9F4E28CBB42B9AB3CBA41B133B2AF', '2017-01-10', '2017-01-10', 49.90, '2017-01-11 08:40:54', 49.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(81, '2017-01-10 12:28:14', '2017-03-20 09:31:16', 20, '2A2A29F184554DCD8AC6F33ED54E61CA', '2017-01-10', '2017-01-15', 110.00, '2017-01-17 08:00:25', 110.00, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(82, '2017-01-11 07:46:36', '2017-01-23 09:49:57', 34, '341D0F618F1B4730BD1EF12497DC011C', '2017-01-11', '2017-01-20', 49.90, '2017-01-23 09:42:38', 49.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(84, '2017-01-11 07:46:37', '2017-03-21 09:24:41', 21, '6620694405074F4B97F7BD943BA9C23D', '2017-01-11', '2017-01-15', 110.00, '2017-01-17 07:41:11', 110.00, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(85, '2017-01-11 07:46:38', '2017-02-01 12:52:29', 4, 'C92AD2520A3E43F8B4D2F98A8609887B', '2017-01-11', '2017-01-20', 200.00, '2017-01-20 08:28:28', 200.00, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(88, '2017-01-11 10:43:56', '2017-03-15 10:26:43', 5, '3C3ABE9E610F4C3EB46A433AD5EA24BD', '2017-01-11', '2017-01-11', 119.90, '2017-01-18 08:42:54', 119.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(90, '2017-01-16 09:36:43', '2017-03-15 14:26:55', 24, NULL, NULL, '2017-01-10', NULL, '2017-01-16 09:36:34', NULL, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(91, '2017-01-16 16:33:12', '2017-03-21 12:42:11', 8, NULL, NULL, '2017-01-10', NULL, '2017-01-16 16:33:21', NULL, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(92, '2017-01-17 05:22:36', '2017-03-08 18:01:14', 13, 'E2C20DF4508246D286CBBF6AD3875E6C', '2017-01-17', '2017-01-26', 49.90, '2017-01-27 08:58:08', 49.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(93, '2017-01-18 14:59:42', '2017-03-21 12:29:56', 39, '2A9D45FA0B4B4746B949D56BD11D906E', '2017-01-18', '2017-01-20', 49.90, '2017-01-19 08:17:42', 49.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(95, '2017-01-23 17:42:16', '2017-01-23 17:42:16', 26, NULL, NULL, '2017-01-20', NULL, '2017-01-20 00:00:00', NULL, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(96, '2017-01-23 17:46:02', '2017-01-31 08:10:15', 32, 'AEDA1046420F41D6BB72796C6A5B5FAC', '2017-01-23', '2017-01-30', 49.90, '2017-01-31 08:03:34', 49.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(97, '2017-01-24 10:13:18', '2017-01-25 11:28:07', 2, 'BFE37B482A844118A950DFF0E68088F3', '2017-01-24', '2017-01-24', 69.90, '2017-01-25 11:25:27', 69.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(100, '2017-01-24 22:39:18', '2017-03-21 12:31:33', 41, 'D6330E733579444B945E12938F60E8B5', '2017-01-24', '2017-01-25', 49.90, '2017-01-26 08:31:55', 49.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(101, '2017-01-25 11:31:43', '2017-02-23 15:50:29', 36, 'E89D61F61F704D6C9C07E50BC6DE628D', '2017-01-24', '2017-01-25', 49.90, '2017-01-25 11:28:22', 49.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(102, '2017-01-25 13:05:49', '2017-01-27 09:11:47', 15, '45B18391BCB1408887389323DE92ABE8', '2017-01-25', '2017-01-26', 89.90, '2017-01-27 08:59:23', 89.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(104, '2017-02-01 05:21:24', '2017-02-13 08:24:29', 3, '10CCF75A533145AD8A9ACB6DE3003C2F', '2017-02-01', '2017-02-10', 149.90, '2017-02-13 08:21:22', 149.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(105, '2017-02-01 05:21:26', '2017-02-03 07:20:22', 37, 'F92A34EF2CA44754B21F8F45373390B1', '2017-02-01', '2017-02-10', 49.90, '2017-02-03 07:18:49', 49.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(106, '2017-02-01 05:21:29', '2017-02-13 08:36:46', 40, '8E96B28745F1466681EDD1436FBB4ED5', '2017-02-01', '2017-02-10', 49.90, '2017-02-13 08:31:53', 49.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(108, '2017-02-01 05:21:38', '2017-02-10 08:52:25', 17, 'DCB6691F6D024CE688621E0B766AA629', '2017-02-01', '2017-02-10', 119.90, '2017-02-10 08:46:34', 119.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(109, '2017-02-01 05:21:40', '2017-02-13 08:35:51', 6, 'F813C8CF1751487C8E8D83CF403B23E8', '2017-02-01', '2017-02-10', 149.90, '2017-02-13 08:30:03', 149.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(110, '2017-02-01 05:22:13', '2017-03-21 12:29:32', 38, '5595BE2CDB0E4D98BA328D57C7671E2E', '2017-02-01', '2017-02-10', 49.90, '2017-02-13 08:34:25', 49.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(112, '2017-02-06 05:14:08', '2017-02-16 10:20:17', 7, 'EACF2CC12CCC4DDC9A1F91C0FDADBD68', '2017-02-06', '2017-02-15', 200.00, '2017-02-16 08:59:03', 200.00, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(113, '2017-02-07 05:10:38', '2017-03-21 09:24:41', 21, 'E0AFDF74448F4DD095A9666B76ABEC77', '2017-02-07', '2017-02-15', 110.00, '2017-02-16 09:11:56', 110.00, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(114, '2017-02-07 05:10:43', '2017-03-20 09:31:16', 20, 'C20496C0200E49ACA15F73BC6B885517', '2017-02-07', '2017-02-15', 110.00, '2017-02-16 09:17:57', 110.00, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(116, '2017-02-11 05:19:29', '2017-02-21 09:12:15', 26, 'E65CA5AFFE21450282BABE943020F81F', '2017-02-11', '2017-02-20', 49.90, '2017-02-21 09:05:40', 49.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(117, '2017-02-11 05:19:43', '2017-02-21 09:06:00', 34, 'EBFD49898DE34091B6575818109246E9', '2017-02-11', '2017-02-20', 49.90, '2017-02-21 09:02:13', 49.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(118, '2017-02-11 05:19:45', '2017-02-21 09:23:30', 2, 'E8A3C0E866D24B7BA2E32D25C19D0091', '2017-02-11', '2017-02-20', 69.90, '2017-02-21 09:16:29', 69.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(119, '2017-02-11 05:19:49', '2017-03-21 12:29:56', 39, 'E8203B18F92245E4BD3C38DF86B07D6F', '2017-02-11', '2017-02-20', 49.90, '2017-02-14 08:14:30', 49.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(120, '2017-02-11 05:19:50', '2017-02-21 09:21:48', 4, '82DF442C31E34F75BAAC31632F9F1504', '2017-02-11', '2017-02-20', 200.00, '2017-02-21 09:10:45', 200.00, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(121, '2017-02-11 05:19:54', '2017-03-21 12:31:33', 41, '74A4FBE1A0D64E228C3B5C3E30117A95', '2017-02-11', '2017-02-20', 49.90, '2017-02-21 09:10:29', 49.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(122, '2017-02-13 08:29:10', '2017-03-20 11:26:59', 43, '14102AF15A984E2993B7CC1BDD131FD4', '2017-02-01', '2017-02-10', 49.90, '2017-02-13 08:24:28', 49.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(123, '2017-02-13 12:28:02', '2017-03-15 17:44:09', 30, '1575298024564C9B9AB5E2B800B11114', '2017-02-13', '2017-02-13', 49.90, '2017-02-14 08:02:55', 49.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(124, '2017-02-13 14:32:35', '2017-03-15 10:26:43', 5, 'A42F4E5D7AC945F9BB8D24B17DA7498A', '2017-02-13', '2017-02-14', 119.90, '2017-02-15 07:31:51', 119.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(125, '2017-02-16 14:02:32', '2017-03-21 12:42:11', 8, '0ECDC7B63F864994881FEFFFF388AD9D', '2017-02-16', '2017-02-16', 220.00, '2017-02-17 08:57:21', 220.00, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(126, '2017-02-16 15:00:13', '2017-02-17 09:00:09', 27, '558B1FF9592E4F8AA2369AB4A88257B9', '2017-02-16', '2017-02-17', 49.90, '2017-02-17 08:53:17', 49.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(129, '2017-02-23 13:32:44', '2017-03-15 14:26:55', 24, NULL, NULL, '2017-02-10', NULL, '2017-02-22 00:00:00', NULL, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(130, '2017-02-23 14:31:06', '2017-03-01 14:23:18', 15, '272C4773805E41F2BFE33916F215830F', '2017-02-23', '2017-02-24', 89.90, '2017-03-01 14:21:40', 89.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(131, '2017-02-23 15:41:31', '2017-02-23 15:42:03', 22, NULL, NULL, '2017-02-10', NULL, '2017-02-17 00:00:00', NULL, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(132, '2017-02-23 15:45:55', '2017-03-21 12:36:12', 35, '1752195C28C3420C8C2420C4D0F6E4F6', '2017-02-23', '2017-02-28', 49.90, '2017-03-01 14:24:04', 49.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(137, '2017-03-01 05:08:02', '2017-03-13 10:09:14', 3, 'FAD2DDAB3E8641E2BB8408817DC70AFD', '2017-03-01', '2017-03-10', 149.90, '2017-03-13 09:53:11', 149.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(139, '2017-03-01 05:08:08', '2017-03-06 09:15:54', 37, 'C266D827EE7B4786902584ED054563C5', '2017-03-01', '2017-03-10', 49.90, '2017-03-06 09:11:02', 49.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(140, '2017-03-01 05:08:09', '2017-03-13 10:05:05', 40, 'A86E6BB7C7D54A5DAB6FEBC7DF61C49E', '2017-03-01', '2017-03-10', 49.90, '2017-03-13 09:50:02', 49.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(141, '2017-03-01 05:08:13', '2017-03-13 10:11:58', 17, 'CF8FDE5A7631490497AA05BD8241FA39', '2017-03-01', '2017-03-10', 119.90, '2017-03-13 09:55:17', 119.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(142, '2017-03-01 05:08:14', '2017-03-16 09:03:08', 24, '0759F7B212C844A5A835B8F0A17675B9', '2017-03-01', '2017-03-10', 49.90, '2017-03-16 09:02:15', 49.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(143, '2017-03-01 05:08:16', '2017-03-08 08:53:22', 6, '209D02BC162740F1B9D823089B440716', '2017-03-01', '2017-03-10', 149.90, '2017-03-08 08:51:16', 149.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(144, '2017-03-01 05:08:19', '2017-03-21 12:29:32', 38, 'E37ABD939DFA4D0EBDBA22010331B50F', '2017-03-01', '2017-03-10', 49.90, '2017-03-13 09:37:39', 49.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(145, '2017-03-01 05:08:20', '2017-03-21 12:42:11', 8, '9F14AD5B1C3543CAAE5A5F5CBC4B385C', '2017-03-01', '2017-03-10', 220.00, '2017-03-13 09:52:15', 220.00, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(146, '2017-03-01 05:08:21', '2017-03-13 09:55:52', 27, '1C7182BFA14042B48D5668007E743A7B', '2017-03-01', '2017-03-10', 49.90, '2017-03-13 09:44:54', 49.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(147, '2017-03-01 14:25:16', '2017-03-01 14:25:16', 36, 'FD73BF01667D472D855EC3868F172E9D', '2017-02-23', '2017-02-24', 49.90, '2017-03-01 14:23:32', 49.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(149, '2017-03-06 05:10:01', '2017-03-16 09:14:57', 7, '29458B33C6214313A74029ECCD3AC8D7', '2017-03-06', '2017-03-15', 200.00, '2017-03-16 09:09:24', 200.00, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(150, '2017-03-06 13:58:19', '2017-03-08 08:44:39', 32, '582898D856B94185813DB881F20B9A6A', '2017-03-06', '2017-03-06', 49.90, '2017-03-08 08:44:10', 49.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(151, '2017-03-08 13:12:30', '2017-03-10 08:54:53', 22, '573C0BF9646F4B8689C8413F76A6A735', '2017-03-08', '2017-03-10', 149.90, '2017-03-10 08:51:27', 149.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(152, '2017-03-08 17:57:58', '2017-03-10 08:51:27', 13, '1E46AC87EE6F4493A194B211EA4A93EF', '2017-03-08', '2017-03-09', 49.90, '2017-03-10 08:49:47', 49.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(153, '2017-03-11 05:07:33', '2017-03-21 09:41:03', 34, 'CDE9516ACAB94A71BC342826B7869E33', '2017-03-11', '2017-03-20', 49.90, '2017-03-21 09:34:05', 49.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(154, '2017-03-11 05:07:33', '2017-03-21 09:42:19', 26, '6976A856F7BA435EAC51B19148199012', '2017-03-11', '2017-03-20', 49.90, '2017-03-21 09:36:44', 49.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(155, '2017-03-11 05:07:35', '2017-03-11 05:07:35', 2, 'B3A16DF0877A4D1AA97F743E1E17939E', '2017-03-11', '2017-03-20', 69.90, NULL, NULL, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(156, '2017-03-11 05:07:37', '2017-03-21 12:29:56', 39, '7CF2D2EC74C64AAE89E2F6D8CA8062D8', '2017-03-11', '2017-03-20', 49.90, '2017-03-21 09:35:40', 49.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(157, '2017-03-11 05:07:38', '2017-03-20 09:32:05', 4, 'DE83991593474DE085FCEC9868A9B1E7', '2017-03-11', '2017-03-20', 200.00, '2017-03-20 09:29:17', 200.00, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(158, '2017-03-11 05:07:40', '2017-03-21 12:31:33', 41, '855563ACC5524B5CB5C57E36C538CB0D', '2017-03-11', '2017-03-20', 49.90, '2017-03-21 09:28:11', 49.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(159, '2017-03-14 05:07:35', '2017-03-21 12:36:12', 35, '201A257AAA784CF5B4DAC7C0011E39C8', '2017-03-14', '2017-03-23', 49.90, NULL, NULL, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(160, '2017-03-14 13:57:45', '2017-03-16 09:15:34', 30, 'B0BA25EA4AE34ECBA26BC8828D0A9F58', '2017-03-14', '2017-03-15', 49.90, '2017-03-16 09:10:29', 49.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(161, '2017-03-15 10:24:06', '2017-03-15 10:26:43', 5, '97C344ABB9E046A48E4907D8E78378E1', '2017-03-15', '2017-03-16', 119.90, NULL, NULL, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(162, '2017-03-17 05:06:59', '2017-03-17 05:06:59', 13, '3C92B36E0223430CAC861CBF5C1B28E9', '2017-03-17', '2017-03-26', 49.90, NULL, NULL, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(163, '2017-03-17 10:39:53', '2017-03-21 09:25:01', 43, '6D19E28F8CB34F97B5374C865BB802D1', '2017-03-17', '2017-03-20', 49.90, '2017-03-21 09:24:12', 49.90, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(164, '2017-03-19 05:12:53', '2017-03-19 05:12:53', 32, 'ACB0438151D24517B6C7929B86485BE7', '2017-03-19', '2017-03-28', 49.90, NULL, NULL, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(166, '2017-03-20 09:37:16', '2017-03-21 09:24:41', 21, '9EC185D586B644FCAF5692DCD234E9F1', '2017-03-20', '2017-03-21', 110.00, NULL, NULL, 0, NULL);
INSERT INTO `softsat_licenca_fatura` (`id`, `created_on`, `updated_on`, `licenca_id`, `iugu_invoice_id`, `emissao`, `vencimento`, `valor`, `pagamento`, `valor_pago`, `cancelada`, `observacao`) VALUES
	(167, '2017-03-20 09:38:08', '2017-03-20 09:38:08', 20, 'B6A24C3C614E42F4B416B4C6689DEB9D', '2017-03-20', '2017-03-21', 110.00, NULL, NULL, 0, NULL);
/*!40000 ALTER TABLE `softsat_licenca_fatura` ENABLE KEYS */;

-- Copiando estrutura para tabela softsats_site.softsat_licenca_plano
CREATE TABLE IF NOT EXISTS `softsat_licenca_plano` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_on` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_on` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  `nome` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `valor` decimal(18,2) NOT NULL,
  `iugu_plan_identifier` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `iugu_plan_id` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `modulos` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `un_softsat_licenca_plano_iugu_plan_id` (`iugu_plan_id`),
  UNIQUE KEY `un_softsat_licenca_plano_iugu_plan_identifier` (`iugu_plan_identifier`),
  KEY `fk_softsat_licenca_plano_hwapx_user_created_by` (`created_by`),
  KEY `fk_softsat_licenca_plano_hwapx_user_updated_by` (`updated_by`),
  CONSTRAINT `fk_softsat_licenca_plano_hwapx_user_created_by` FOREIGN KEY (`created_by`) REFERENCES `hwapx_user` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_softsat_licenca_plano_hwapx_user_updated_by` FOREIGN KEY (`updated_by`) REFERENCES `hwapx_user` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Copiando dados para a tabela softsats_site.softsat_licenca_plano: ~7 rows (aproximadamente)
/*!40000 ALTER TABLE `softsat_licenca_plano` DISABLE KEYS */;
INSERT INTO `softsat_licenca_plano` (`id`, `created_on`, `updated_on`, `created_by`, `updated_by`, `nome`, `valor`, `iugu_plan_identifier`, `iugu_plan_id`, `modulos`) VALUES
	(1, '2016-10-20 14:40:53', '2016-10-20 14:40:53', NULL, NULL, 'Licença Gerencial 69,90', 69.90, 'Licenca Gerencial 69,90', '5107437ACF5643F9941A7D6D26285446', '');
INSERT INTO `softsat_licenca_plano` (`id`, `created_on`, `updated_on`, `created_by`, `updated_by`, `nome`, `valor`, `iugu_plan_identifier`, `iugu_plan_id`, `modulos`) VALUES
	(2, '2016-10-20 14:40:53', '2016-10-20 14:40:53', NULL, NULL, 'Licença Gerencial - NFE', 119.90, 'Licenca Gerencial - 119,90', 'B785CC41FFF9422A9E45214B8A8889E1', '');
INSERT INTO `softsat_licenca_plano` (`id`, `created_on`, `updated_on`, `created_by`, `updated_by`, `nome`, `valor`, `iugu_plan_identifier`, `iugu_plan_id`, `modulos`) VALUES
	(3, '2016-10-20 14:40:53', '2016-10-20 14:40:53', NULL, NULL, 'Licença Gerencial', 149.90, 'Licenca 149,90', '4836DEA4A039484780D41ED75808ADA5', '');
INSERT INTO `softsat_licenca_plano` (`id`, `created_on`, `updated_on`, `created_by`, `updated_by`, `nome`, `valor`, `iugu_plan_identifier`, `iugu_plan_id`, `modulos`) VALUES
	(4, '2016-10-20 14:40:53', '2016-10-20 14:40:53', NULL, NULL, 'Licença', 200.00, 'Licenca', '04830251D55D412C86F2101240ABAEF9', '');
INSERT INTO `softsat_licenca_plano` (`id`, `created_on`, `updated_on`, `created_by`, `updated_by`, `nome`, `valor`, `iugu_plan_identifier`, `iugu_plan_id`, `modulos`) VALUES
	(5, '2016-10-26 13:57:28', '2016-10-26 13:57:28', NULL, NULL, 'Gerencial Basico', 49.90, 'Licenca Basico', 'F020040E1B3C4D12856617777A2CB4CA', '');
INSERT INTO `softsat_licenca_plano` (`id`, `created_on`, `updated_on`, `created_by`, `updated_by`, `nome`, `valor`, `iugu_plan_identifier`, `iugu_plan_id`, `modulos`) VALUES
	(6, '2016-11-07 14:46:05', '2016-11-07 14:46:05', NULL, NULL, 'Licença Gerencial 110,00', 110.00, 'Licenca Gerencial 110,00', '82BFE2704F2E44D785E86E04F8918C09', '');
INSERT INTO `softsat_licenca_plano` (`id`, `created_on`, `updated_on`, `created_by`, `updated_by`, `nome`, `valor`, `iugu_plan_identifier`, `iugu_plan_id`, `modulos`) VALUES
	(7, '2016-11-07 14:46:05', '2016-11-07 14:46:05', NULL, NULL, 'Gerencial Mercado', 220.00, 'Licenca Gerencial - Mercado', 'DE59754F623F4909B7FB8045642AE29F', '');
INSERT INTO `softsat_licenca_plano` (`id`, `created_on`, `updated_on`, `created_by`, `updated_by`, `nome`, `valor`, `iugu_plan_identifier`, `iugu_plan_id`, `modulos`) VALUES
	(8, '2016-12-01 11:09:24', '2016-12-01 11:09:24', NULL, NULL, 'Licença SAT 89,90', 89.90, 'Licenca SAT', 'BD3A1EF079164DB79856C90486E15AE1', '');
/*!40000 ALTER TABLE `softsat_licenca_plano` ENABLE KEYS */;

-- Copiando estrutura para tabela softsats_site.sss_download_request
CREATE TABLE IF NOT EXISTS `sss_download_request` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_on` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `email` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `phone` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `token` char(32) COLLATE utf8_unicode_ci NOT NULL,
  `count` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=58 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Copiando dados para a tabela softsats_site.sss_download_request: ~30 rows (aproximadamente)
/*!40000 ALTER TABLE `sss_download_request` DISABLE KEYS */;
INSERT INTO `sss_download_request` (`id`, `created_on`, `name`, `email`, `phone`, `token`, `count`) VALUES
	(1, '2016-08-29 13:22:35', 'Luis Henrique', 'luis@softsatsistemas.com.br', '170000000', '91b30bf2e1697b0a2a42a97b29f3118b', 0);
INSERT INTO `sss_download_request` (`id`, `created_on`, `name`, `email`, `phone`, `token`, `count`) VALUES
	(2, '2016-08-29 14:25:43', 'Luis Henrique', 'luis@softsatsistemas.com.br', '170000000', 'd2b0593500dd9a7d86eb488d4835f5e6', 0);
INSERT INTO `sss_download_request` (`id`, `created_on`, `name`, `email`, `phone`, `token`, `count`) VALUES
	(3, '2016-08-28 14:32:47', 'Luis Henrique', 'luis@softsatsistemas.com.br', '170000000', '720d7b95c453ec2aef616bed73bca080', 1);
INSERT INTO `sss_download_request` (`id`, `created_on`, `name`, `email`, `phone`, `token`, `count`) VALUES
	(4, '2016-08-29 14:44:35', 'Luis Henrique', 'luis@softsatsistemas.com.br', '170000000', '71252b552c9fa6b5a40889867acda8af', 2);
INSERT INTO `sss_download_request` (`id`, `created_on`, `name`, `email`, `phone`, `token`, `count`) VALUES
	(5, '2016-08-29 14:45:42', 'Fernando Fornazieri', 'fernando@softsatsistemas.com.br', '1732659828', 'b99067df36151e1e0115bf9079e628c5', 6);
INSERT INTO `sss_download_request` (`id`, `created_on`, `name`, `email`, `phone`, `token`, `count`) VALUES
	(6, '2016-08-29 14:46:04', 'Luis Henrique', 'luis@softsatsistemas.com.br', '170000000', '31bffe6aa0e72dee1733d7bdb6b209f8', 2);
INSERT INTO `sss_download_request` (`id`, `created_on`, `name`, `email`, `phone`, `token`, `count`) VALUES
	(7, '2016-09-01 15:39:11', 'LINCOLN ANTUNES DOS SANTOS', 'lincolnsantos_@hotmail.com', '1730218490', '428ec3b28ae1b83415dde736c20fbc34', 2);
INSERT INTO `sss_download_request` (`id`, `created_on`, `name`, `email`, `phone`, `token`, `count`) VALUES
	(8, '2016-09-04 22:40:31', 'giovani', 'giovani.gna@gmail.com', '1736411745', '3d60eb088302687819213e9dbfb5a3d6', 1);
INSERT INTO `sss_download_request` (`id`, `created_on`, `name`, `email`, `phone`, `token`, `count`) VALUES
	(9, '2016-09-04 22:40:37', 'giovani', 'giovani.gna@gmail.com', '1799', '2e34e7ab5e8d55ca507a63ffdb798913', 0);
INSERT INTO `sss_download_request` (`id`, `created_on`, `name`, `email`, `phone`, `token`, `count`) VALUES
	(10, '2016-09-04 22:40:37', 'giovani', 'giovani.gna@gmail.com', '1799', '2e34e7ab5e8d55ca507a63ffdb798913', 0);
INSERT INTO `sss_download_request` (`id`, `created_on`, `name`, `email`, `phone`, `token`, `count`) VALUES
	(11, '2016-09-04 22:40:41', 'giovani', 'giovani.gna@gmail.com', '17997345858', 'f85e967a50fcdda5cf353b679054410d', 0);
INSERT INTO `sss_download_request` (`id`, `created_on`, `name`, `email`, `phone`, `token`, `count`) VALUES
	(12, '2016-09-05 09:35:04', 'Vidra&#195;&#167;aria Jos&#195;&#169; Bonif&#195;&#161;cio', 'vidracariajbonifacio@hotmail.com', '32451790', '1712c4e30d5b596cf082a444795c1a54', 0);
INSERT INTO `sss_download_request` (`id`, `created_on`, `name`, `email`, `phone`, `token`, `count`) VALUES
	(13, '2016-09-05 10:42:50', 'Vidra&#195;&#167;aria Jos&#195;&#169; Bonif&#195;&#161;cio', 'vidracariajbonifacio@hotmail.com', '32451790', 'd0dd78974cb9c2a031dd3609c7ebe714', 0);
INSERT INTO `sss_download_request` (`id`, `created_on`, `name`, `email`, `phone`, `token`, `count`) VALUES
	(14, '2016-09-05 10:42:59', 'Vidra&#195;&#167;aria Jos&#195;&#169; Bonif&#195;&#161;cio', 'vidracariajbonifacio@hotmail.com', '32451790', 'b37f77b5200c2ae947013aa68d51561c', 0);
INSERT INTO `sss_download_request` (`id`, `created_on`, `name`, `email`, `phone`, `token`, `count`) VALUES
	(15, '2016-09-05 10:43:01', 'Vidra&#195;&#167;aria Jos&#195;&#169; Bonif&#195;&#161;cio', 'vidracariajbonifacio@hotmail.com', '32451790', '73ae8ceac66a2b2ab43a003bb47d6fe2', 0);
INSERT INTO `sss_download_request` (`id`, `created_on`, `name`, `email`, `phone`, `token`, `count`) VALUES
	(16, '2016-09-05 14:36:56', 'Vidra&#195;&#167;aria Jos&#195;&#169; Bonif&#195;&#161;cio', 'vidracariajbonifacio@hotmail.com', '32451790', '4a8c8b91202bbb7e5c8470d5e918d831', 0);
INSERT INTO `sss_download_request` (`id`, `created_on`, `name`, `email`, `phone`, `token`, `count`) VALUES
	(17, '2016-09-06 15:00:29', 'Vidra&#195;&#167;aria Jos&#195;&#169; Bonif&#195;&#161;cio', 'vidracariajbonifacio@hotmail.com', '32451790', '586ac0a4b10d4375a7a9579fc8136103', 1);
INSERT INTO `sss_download_request` (`id`, `created_on`, `name`, `email`, `phone`, `token`, `count`) VALUES
	(18, '2016-09-06 17:20:17', 'Vidra&#195;&#167;aria Jos&#195;&#169; Bonif&#195;&#161;cio', 'vidracariajbonifacio@hotmail.com', '32451790', '22300af688a7ed370e2a2522b680107d', 0);
INSERT INTO `sss_download_request` (`id`, `created_on`, `name`, `email`, `phone`, `token`, `count`) VALUES
	(19, '2016-09-08 09:38:14', 'Vinicius', 'cardosin@gmail.com', '1932254687', 'c4eca52a86554c4e9011c485ec154317', 1);
INSERT INTO `sss_download_request` (`id`, `created_on`, `name`, `email`, `phone`, `token`, `count`) VALUES
	(20, '2016-09-13 17:42:24', 'Fernando Fornazieri', 'fernando@softsatsistemas.com.br', '1732659828', '58f12b0623ba5f03c9e3a61423fb7f45', 0);
INSERT INTO `sss_download_request` (`id`, `created_on`, `name`, `email`, `phone`, `token`, `count`) VALUES
	(21, '2016-09-13 17:42:26', 'Fernando Fornazieri', 'fernando@softsatsistemas.com.br', '1732659828', '9fca7544624f2292a6e3a7361073d7b1', 0);
INSERT INTO `sss_download_request` (`id`, `created_on`, `name`, `email`, `phone`, `token`, `count`) VALUES
	(22, '2016-09-13 17:42:27', 'Fernando Fornazieri', 'fernando@softsatsistemas.com.br', '1732659828', '7f4dff55f7af8a7c61f10a355da38382', 0);
INSERT INTO `sss_download_request` (`id`, `created_on`, `name`, `email`, `phone`, `token`, `count`) VALUES
	(23, '2016-09-13 17:42:35', 'Fernando Fornazieri', 'fernando@softsatsistemas.com.b', '1732659828', '3631a1a44c6fe02cda96d13107ae70ce', 0);
INSERT INTO `sss_download_request` (`id`, `created_on`, `name`, `email`, `phone`, `token`, `count`) VALUES
	(24, '2016-09-13 17:42:38', 'Fernando Fornazieri', 'fernando@softsatsistemas.com.br', '1732659828', '5b0a14129a9b4c25b8c7e631cdd1978c', 0);
INSERT INTO `sss_download_request` (`id`, `created_on`, `name`, `email`, `phone`, `token`, `count`) VALUES
	(25, '2016-09-21 11:45:06', 'Fabiana Padilha', 'ramoveishospitalares@gmail.com', '017-3271-0514', 'd6a65896dba24dd89fb6579f35643a62', 9);
INSERT INTO `sss_download_request` (`id`, `created_on`, `name`, `email`, `phone`, `token`, `count`) VALUES
	(26, '2016-09-21 11:56:13', 'Luis Henrique Barbosa de Lima', 'luis@softsatsistemas.com.br', '170000-00000', '69123f8aba2039cf8a3f5f0284456105', 1);
INSERT INTO `sss_download_request` (`id`, `created_on`, `name`, `email`, `phone`, `token`, `count`) VALUES
	(27, '2016-10-04 14:02:07', 'progefer', 'progefer@hotmail.com', '1732710455', '746d308faa19321a47e88e0dfeb7575b', 0);
INSERT INTO `sss_download_request` (`id`, `created_on`, `name`, `email`, `phone`, `token`, `count`) VALUES
	(28, '2016-10-04 14:02:11', 'progefer', 'progefer@hotmail.com', '1732710455', '112cc26d870270e1d3f58801d55fb675', 1);
INSERT INTO `sss_download_request` (`id`, `created_on`, `name`, `email`, `phone`, `token`, `count`) VALUES
	(29, '2016-10-05 16:58:48', 'Luis Henrique', 'luis@softsatsistemas.com.br', '170000000', '33c2a7d6c51d81c3f686769efd7527f4', 2);
INSERT INTO `sss_download_request` (`id`, `created_on`, `name`, `email`, `phone`, `token`, `count`) VALUES
	(30, '2016-10-11 11:49:41', 'adriana de lima felix', 'apucadriana@hotmail.com', '4399178249', 'ac1973cb6e02338145dc47421cc81f8d', 0);
INSERT INTO `sss_download_request` (`id`, `created_on`, `name`, `email`, `phone`, `token`, `count`) VALUES
	(31, '2016-10-17 11:18:08', 'Luis Henrique', 'desenv@softsatsistemas.com.br', '170000000', '20f0c808cfd122d74d931892c0fa2aea', 0);
INSERT INTO `sss_download_request` (`id`, `created_on`, `name`, `email`, `phone`, `token`, `count`) VALUES
	(32, '2016-11-04 13:02:21', 'wlisses januario de freitas', 'aizulloterias@uol.com.br', '17997899697', '1dc4ffd59015d0022067f7d74a622353', 1);
INSERT INTO `sss_download_request` (`id`, `created_on`, `name`, `email`, `phone`, `token`, `count`) VALUES
	(33, '2016-11-07 09:25:59', 'ELIEZER MAZZUCCA', 'eliezermazzucca@hotmail.com', '17997090931', '3b875d1e0b192d1b60e07b3a9aa8a6c8', 0);
INSERT INTO `sss_download_request` (`id`, `created_on`, `name`, `email`, `phone`, `token`, `count`) VALUES
	(34, '2016-11-09 14:17:13', 'Igor Casemiro Perencine', 'igorperencine@gmail.com', '17991353611', 'ca39710ce285210e37e88e09c31a832a', 1);
INSERT INTO `sss_download_request` (`id`, `created_on`, `name`, `email`, `phone`, `token`, `count`) VALUES
	(35, '2016-11-09 16:15:09', 'Ariane Silva de Castilho', 'castilho.adriane@bol.com.br', '17992365862', '504d843ceec3060c5e739f73f73010c2', 2);
INSERT INTO `sss_download_request` (`id`, `created_on`, `name`, `email`, `phone`, `token`, `count`) VALUES
	(36, '2016-11-10 12:21:18', 'Ronaldo', 'ronaldocasper@gmail.com', '1194837293', '91817743ed5dd6f2008f6375c7a8dbde', 0);
INSERT INTO `sss_download_request` (`id`, `created_on`, `name`, `email`, `phone`, `token`, `count`) VALUES
	(37, '2016-11-10 21:30:31', 'Evandro Mota', 'evandromota2008@gmail.com', '11947324533', 'cd2a996b896f62f3cae75d034192f7d7', 2);
INSERT INTO `sss_download_request` (`id`, `created_on`, `name`, `email`, `phone`, `token`, `count`) VALUES
	(38, '2016-11-19 17:17:09', 'GILSON MARTINS ', 'gilson@ecocentauro.com.br', '6599440721', '10f722121c7299cab9fb28c9bd58234a', 0);
INSERT INTO `sss_download_request` (`id`, `created_on`, `name`, `email`, `phone`, `token`, `count`) VALUES
	(39, '2016-11-19 19:24:58', 'genivan souza', 'k2bruxa@live.com', '4198272493', '18df3c1c16ec63ee560e0a2818b309b5', 8);
INSERT INTO `sss_download_request` (`id`, `created_on`, `name`, `email`, `phone`, `token`, `count`) VALUES
	(40, '2016-11-22 15:20:29', 'Leandro Moreira', 'leandro.buri@gmail.com', '18996011878', 'eae3e32c0429fe4f059e2efadea4e2f2', 0);
INSERT INTO `sss_download_request` (`id`, `created_on`, `name`, `email`, `phone`, `token`, `count`) VALUES
	(41, '2016-11-25 12:16:14', 'vagner', 'jwvwagner@hotmail.com', '713682-2502', '8a13c16d20e3f1102fb598166e792bb7', 0);
INSERT INTO `sss_download_request` (`id`, `created_on`, `name`, `email`, `phone`, `token`, `count`) VALUES
	(42, '2016-11-29 08:46:08', 'Leandro Moreira', 'leandro.buri@gmail.com', '18996011878', '2c60761cba2a0f114c0e7c2f96ae77c6', 1);
INSERT INTO `sss_download_request` (`id`, `created_on`, `name`, `email`, `phone`, `token`, `count`) VALUES
	(43, '2016-11-29 16:32:46', 'Jo&#195;&#163;o Francez', 'joao@stokfrios.com.br', '17981269337', 'bc7890921133af433b440088dc24c50f', 1);
INSERT INTO `sss_download_request` (`id`, `created_on`, `name`, `email`, `phone`, `token`, `count`) VALUES
	(44, '2016-12-07 10:21:08', 'CARINA SETE', 'carinasete@yahoo.com.br', '17997437871', 'b0c5c4c317fff02e752b8c79ad8a6d25', 0);
INSERT INTO `sss_download_request` (`id`, `created_on`, `name`, `email`, `phone`, `token`, `count`) VALUES
	(45, '2016-12-07 10:21:10', '000000', 'lojamalvezzi@gmail.com', '17-32121405', '9b34354c689938a1cd6f0e9869b4c1f2', 1);
INSERT INTO `sss_download_request` (`id`, `created_on`, `name`, `email`, `phone`, `token`, `count`) VALUES
	(46, '2016-12-07 10:43:01', 'Luis Henrique', 'luis@softsatsistemas.com.br', '1732455144', 'd74b91fdb527988cc723389c6544954d', 0);
INSERT INTO `sss_download_request` (`id`, `created_on`, `name`, `email`, `phone`, `token`, `count`) VALUES
	(47, '2016-12-13 13:49:17', 'Marcela e Luciano', 'duasrodasjb@yahoo.com.br', '1732454004', '123cee9e582582b7ff0d2cb18dbaae04', 0);
INSERT INTO `sss_download_request` (`id`, `created_on`, `name`, `email`, `phone`, `token`, `count`) VALUES
	(48, '2016-12-13 17:52:46', 'luciano', 'duasrodasjb@yahoo.com.br', '1732454004', 'baeaa6223ebe466fad6d7b1f9e529469', 2);
INSERT INTO `sss_download_request` (`id`, `created_on`, `name`, `email`, `phone`, `token`, `count`) VALUES
	(49, '2016-12-13 17:52:49', 'luciano', 'duasrodasjb@yahoo.com.br', '1732454004', '06576a8a77052c5c9f2606256c8084dd', 0);
INSERT INTO `sss_download_request` (`id`, `created_on`, `name`, `email`, `phone`, `token`, `count`) VALUES
	(50, '2016-12-13 17:52:55', 'luciano', 'duasrodasjb@yahoo.com.br', '1732454004', '2604bacb9dbf622ce9c544c45d0fbda6', 0);
INSERT INTO `sss_download_request` (`id`, `created_on`, `name`, `email`, `phone`, `token`, `count`) VALUES
	(51, '2016-12-14 14:21:39', 'Duas Rodas', 'luis@softsatsistemas.com.br', '1732454004', 'c29bd0e37be55e7885b1c166ac85ba3a', 0);
INSERT INTO `sss_download_request` (`id`, `created_on`, `name`, `email`, `phone`, `token`, `count`) VALUES
	(52, '2016-12-29 11:13:25', 'luiz gustavo valieri ferreira', 'gustavo00130@hotmail.com', '14996939451', '8a684b859f1f639e0db4167de230cd13', 1);
INSERT INTO `sss_download_request` (`id`, `created_on`, `name`, `email`, `phone`, `token`, `count`) VALUES
	(53, '2016-12-29 11:52:01', 'Fernando Fornazieri', 'fernando@softsatsistemas.com.br', '1732659828', '70531beec688316ced4f4926e4253465', 0);
INSERT INTO `sss_download_request` (`id`, `created_on`, `name`, `email`, `phone`, `token`, `count`) VALUES
	(54, '2016-12-30 09:41:14', 'Isabel Fernanda Del Rio Grassiotin ', 'dellagrassi@hotmail.com', '1499118-4852', '4c6f0339b8f7a108248c8134fc6b9d7a', 0);
INSERT INTO `sss_download_request` (`id`, `created_on`, `name`, `email`, `phone`, `token`, `count`) VALUES
	(55, '2016-12-30 16:04:24', 'antonio', 'josebonifacio@byebyepaper.com.br', '1732653047', '25202d36b7fb283909bb39953b779acc', 2);
INSERT INTO `sss_download_request` (`id`, `created_on`, `name`, `email`, `phone`, `token`, `count`) VALUES
	(56, '2016-12-30 16:04:30', 'antonio', 'josebonifacio@byebyepaper.com.br', '1732653047', '5d74351b4e3c7350f3da3d3bd34aca07', 0);
INSERT INTO `sss_download_request` (`id`, `created_on`, `name`, `email`, `phone`, `token`, `count`) VALUES
	(57, '2016-12-30 16:04:36', 'antonio', 'josebonifacio@byebyepaper.com.br', '1732653047', '87f4b9e2a3e63bec3dc5ea213267ab12', 0);
/*!40000 ALTER TABLE `sss_download_request` ENABLE KEYS */;

-- Copiando estrutura para view softsats_site.softsat_licenca_vencimento
-- Criando tabela temporária para evitar erros de dependência de VIEW
CREATE TABLE `softsat_licenca_vencimento` (
	`licenca_id` INT(11) NOT NULL,
	`data_base` DATE NULL,
	`cnpj` VARCHAR(18) NOT NULL COLLATE 'utf8_unicode_ci',
	`plano` VARCHAR(255) NOT NULL COLLATE 'utf8_unicode_ci',
	`modulos` VARCHAR(255) NOT NULL COLLATE 'utf8_unicode_ci',
	`vencimento` DATE NULL,
	`carencia` INT(1) NOT NULL
) ENGINE=MyISAM;

-- Copiando estrutura para view softsats_site.softsat_licenca_vencimento_20172501
-- Criando tabela temporária para evitar erros de dependência de VIEW
CREATE TABLE `softsat_licenca_vencimento_20172501` (
	`licenca_id` INT(11) NOT NULL,
	`data_base` DATE NULL,
	`cnpj` VARCHAR(18) NOT NULL COLLATE 'utf8_unicode_ci',
	`plano` VARCHAR(255) NOT NULL COLLATE 'utf8_unicode_ci',
	`modulos` VARCHAR(255) NOT NULL COLLATE 'utf8_unicode_ci',
	`vencimento` DATE NULL,
	`carencia` TEXT NULL COLLATE 'utf8_unicode_ci'
) ENGINE=MyISAM;

-- Copiando estrutura para view softsats_site.softsat_licenca_vencimento
-- Removendo tabela temporária e criando a estrutura VIEW final
DROP TABLE IF EXISTS `softsat_licenca_vencimento`;
CREATE VIEW `softsat_licenca_vencimento` AS select `l`.`id` AS `licenca_id`,`l`.`data_base` AS `data_base`,`l`.`cnpj` AS `cnpj`,`lp`.`nome` AS `plano`,`lp`.`modulos` AS `modulos`,cast(if((`l`.`ilimitada` <> 1),greatest(((`l`.`data_base` + interval (count(distinct `lf`.`id`) + `l`.`demonstracao`) month) + interval `s`.`value` day),ifnull(max(`le`.`expira_em`),0)),(curdate() + interval 1 month)) as date) AS `vencimento`,0 AS `carencia` from ((((`softsat_licenca` `l` join `softsat_licenca_plano` `lp` on((`lp`.`id` = `l`.`plano_id`))) left join `hwapx_setting` `s` on((`s`.`id` = 'softsat.licenca.carencia'))) left join `softsat_licenca_fatura` `lf` on(((`lf`.`licenca_id` = `l`.`id`) and (`lf`.`pagamento` is not null) and (`lf`.`cancelada` = 0)))) left join `softsat_licenca_extensao` `le` on((`le`.`licenca_id` = `l`.`id`))) group by `l`.`id`;

-- Copiando estrutura para view softsats_site.softsat_licenca_vencimento_20172501
-- Removendo tabela temporária e criando a estrutura VIEW final
DROP TABLE IF EXISTS `softsat_licenca_vencimento_20172501`;
CREATE VIEW `softsat_licenca_vencimento_20172501` AS select `l`.`id` AS `licenca_id`,`l`.`data_base` AS `data_base`,`l`.`cnpj` AS `cnpj`,`lp`.`nome` AS `plano`,`lp`.`modulos` AS `modulos`,if((`l`.`ilimitada` <> 1),(`l`.`data_base` + interval (count(`lf`.`id`) + `l`.`demonstracao`) month),(curdate() + interval 1 month)) AS `vencimento`,`s`.`value` AS `carencia` from (((`softsat_licenca` `l` join `softsat_licenca_plano` `lp` on((`lp`.`id` = `l`.`plano_id`))) left join `hwapx_setting` `s` on((`s`.`id` = 'softsat.licenca.carencia'))) left join `softsat_licenca_fatura` `lf` on(((`lf`.`licenca_id` = `l`.`id`) and (`lf`.`pagamento` is not null) and (`lf`.`cancelada` = 0)))) group by `l`.`id`;

/*!40101 SET SQL_MODE=IFNULL(@OLD_SQL_MODE, '') */;
/*!40014 SET FOREIGN_KEY_CHECKS=IF(@OLD_FOREIGN_KEY_CHECKS IS NULL, 1, @OLD_FOREIGN_KEY_CHECKS) */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
