-- --------------------------------------------------------
-- Servidor:                     127.0.0.1
-- Versão do servidor:           10.1.10-MariaDB - mariadb.org binary distribution
-- OS do Servidor:               Win32
-- HeidiSQL Versão:              9.5.0.5277
-- --------------------------------------------------------

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET NAMES utf8 */;
/*!50503 SET NAMES utf8mb4 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

-- Copiando estrutura para tabela softsats_locacao.hwapx_audit
CREATE TABLE IF NOT EXISTS `hwapx_audit` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_on` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `done_by` int(11) DEFAULT NULL,
  `done_by_data` text COLLATE utf8_unicode_ci,
  `done_at` datetime DEFAULT NULL,
  `action` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `table` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `record_id` int(11) NOT NULL,
  `old_data` text COLLATE utf8_unicode_ci,
  `new_data` text COLLATE utf8_unicode_ci,
  `url` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `verb` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Copiando dados para a tabela softsats_locacao.hwapx_audit: ~0 rows (aproximadamente)
DELETE FROM `hwapx_audit`;
/*!40000 ALTER TABLE `hwapx_audit` DISABLE KEYS */;
INSERT INTO `hwapx_audit` (`id`, `created_on`, `done_by`, `done_by_data`, `done_at`, `action`, `table`, `record_id`, `old_data`, `new_data`, `url`, `verb`) VALUES
	(1, '2016-09-19 15:00:08', 1, '{"id":1,"created_on":"2014-11-09 02:13:01","updated_on":"2016-09-19 13:00:32","created_by":null,"updated_by":1,"username":"Admin","password":"a0c18bbde7dace71a15f80dd474e96bd068831402b528ed2cc51474f28e28fcd242afdd84d80cf5b9c1d2ab9b7ddb98801f134e5b1d29bdfeba801a9abeeb75f","email":"luis@softsatsistemas.com.br","photo":"8afe316e3f990fbdafc30ac2d8797069.jpg","active":1,"group_id":1,"correspondente_id":null,"group":{"id":1,"created_on":"2015-03-08 02:01:39","updated_on":null,"created_by":null,"updated_by":null,"active":1,"description":"Administrador","roles":["filemanager","filemanager_remove","filemanager_rename","filemanager_upload","group_create","group_edit","group_remove","group_list","settings","module_management","module_install","module_upgrade","module_uninstall","logs","log_remove","slideshow_create","slideshow_edit","slideshow_remove","slideshow_list","user_create","user_edit","user_remove","user_list"],"correspondente_id":null}}', '2016-09-19 15:00:08', 'delete', 'softsat_process_correspondente', 3, '{"id":3,"created_on":"2016-09-19 14:58:41","updated_on":"2016-09-19 14:58:41","created_by":1,"updated_by":1,"nome":"Teste","cnpj":"65.313.959\\/0001-22","fundacao":"2016-09-19","endereco":"Indefinido","numero":"S\\/N","complemento":"","bairro":"N\\u00e3o se sabe","cidade":"Jos\\u00e9 Bonif\\u00e1cio","uf":"SP","cep":"15200-000","telefone":"(17)0000-00000","celular":"(17)0000-00000","email":"contato@softsatsistemas.com.br","codigo_correspondente":"9999","ativo":1}', 'null', NULL, NULL);
/*!40000 ALTER TABLE `hwapx_audit` ENABLE KEYS */;

-- Copiando estrutura para tabela softsats_locacao.hwapx_email_account
CREATE TABLE IF NOT EXISTS `hwapx_email_account` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_on` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_on` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  `description` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `slug` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `email` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `password` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `host` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `port` int(11) NOT NULL,
  `scheme` varchar(3) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_hwapx_email_account_hwapx_user_created_by` (`created_by`),
  KEY `fk_hwapx_email_account_hwapx_user_updated_by` (`updated_by`),
  CONSTRAINT `fk_hwapx_email_account_hwapx_user_created_by` FOREIGN KEY (`created_by`) REFERENCES `hwapx_user` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_hwapx_email_account_hwapx_user_updated_by` FOREIGN KEY (`updated_by`) REFERENCES `hwapx_user` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Copiando dados para a tabela softsats_locacao.hwapx_email_account: ~0 rows (aproximadamente)
DELETE FROM `hwapx_email_account`;
/*!40000 ALTER TABLE `hwapx_email_account` DISABLE KEYS */;
INSERT INTO `hwapx_email_account` (`id`, `created_on`, `updated_on`, `created_by`, `updated_by`, `description`, `slug`, `email`, `password`, `host`, `port`, `scheme`) VALUES
	(1, '2016-09-06 13:41:35', '2016-09-06 16:00:11', NULL, NULL, 'Webmaster', 'webmaster', 'webmaster@localhost.com', '5f4dcc3b5aa765d61d8327deb882cf99', 'localhost', 587, 'tls');
/*!40000 ALTER TABLE `hwapx_email_account` ENABLE KEYS */;

-- Copiando estrutura para tabela softsats_locacao.hwapx_email_queue
CREATE TABLE IF NOT EXISTS `hwapx_email_queue` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_on` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_on` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `created_by` int(11) DEFAULT NULL,
  `updated_By` int(11) DEFAULT NULL,
  `account_id` int(11) DEFAULT NULL,
  `template_id` int(11) DEFAULT NULL,
  `data` text COLLATE utf8_unicode_ci,
  `callback` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `callback_data` text COLLATE utf8_unicode_ci,
  `to` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `from` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `to_parsed` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `reply_to` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cc` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `bcc` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `subject` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `subject_parsed` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `body` text COLLATE utf8_unicode_ci NOT NULL,
  `body_parsed` text COLLATE utf8_unicode_ci,
  `attachments` text COLLATE utf8_unicode_ci,
  `sent_at` datetime DEFAULT NULL,
  `log` text COLLATE utf8_unicode_ci,
  `cancelled` tinyint(1) NOT NULL DEFAULT '0',
  `cancelled_on` datetime DEFAULT NULL,
  `executed_on` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_hwapx_email_queue_hwapx_user_created_by` (`created_by`),
  KEY `fk_hwapx_email_queue_hwapx_user_updated_by` (`updated_By`),
  KEY `fk_hwapx_email_queue_hwapx_email_account` (`account_id`),
  KEY `fk_hwapx_email_queue_hwapx_email_template` (`template_id`),
  CONSTRAINT `fk_hwapx_email_queue_hwapx_email_account` FOREIGN KEY (`account_id`) REFERENCES `hwapx_email_account` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_hwapx_email_queue_hwapx_email_template` FOREIGN KEY (`template_id`) REFERENCES `hwapx_email_template` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_hwapx_email_queue_hwapx_user_created_by` FOREIGN KEY (`created_by`) REFERENCES `hwapx_user` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_hwapx_email_queue_hwapx_user_updated_by` FOREIGN KEY (`updated_By`) REFERENCES `hwapx_user` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Copiando dados para a tabela softsats_locacao.hwapx_email_queue: ~0 rows (aproximadamente)
DELETE FROM `hwapx_email_queue`;
/*!40000 ALTER TABLE `hwapx_email_queue` DISABLE KEYS */;
/*!40000 ALTER TABLE `hwapx_email_queue` ENABLE KEYS */;

-- Copiando estrutura para tabela softsats_locacao.hwapx_email_template
CREATE TABLE IF NOT EXISTS `hwapx_email_template` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_on` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_on` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  `description` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `slug` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `account_id` int(11) DEFAULT NULL,
  `from` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `to` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cc` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `bcc` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `reply_to` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `subject` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `body` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `slug` (`slug`),
  KEY `fk_hwapx_email_template_hwapx_email_account` (`account_id`),
  KEY `fk_hwapx_email_template_hwapx_user_created_by` (`created_by`),
  KEY `fk_hwapx_email_template_hwapx_user_updated_by` (`updated_by`),
  CONSTRAINT `fk_hwapx_email_template_hwapx_email_account` FOREIGN KEY (`account_id`) REFERENCES `hwapx_email_account` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_hwapx_email_template_hwapx_user_created_by` FOREIGN KEY (`created_by`) REFERENCES `hwapx_user` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_hwapx_email_template_hwapx_user_updated_by` FOREIGN KEY (`updated_by`) REFERENCES `hwapx_user` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Copiando dados para a tabela softsats_locacao.hwapx_email_template: ~8 rows (aproximadamente)
DELETE FROM `hwapx_email_template`;
/*!40000 ALTER TABLE `hwapx_email_template` DISABLE KEYS */;
INSERT INTO `hwapx_email_template` (`id`, `created_on`, `updated_on`, `created_by`, `updated_by`, `description`, `slug`, `account_id`, `from`, `to`, `cc`, `bcc`, `reply_to`, `subject`, `body`) VALUES
	(3, '2016-09-19 21:30:11', '2017-09-06 14:23:18', 1, 1, 'Redefinição de senha', 'reset_password', NULL, 'webmaster@softsatsistemas.com.br', NULL, NULL, NULL, NULL, 'SoftSAT Gestão - Redefinição de senha', 'Olá {{ @usuario.name }}.<div><br></div><div>Para redefinir sua senha acesse: <a href="http://gestao.softsatsistemas.com.br{{ \'admin_set_password\', \'token=\'.@usuario.reset_token | alias }}">http://gestao.softsatsistemas.com.br{{ \'admin_set_password\', \'token=\'.@usuario.reset_token | alias }}</a>.</div>'),
	(4, '2016-09-19 21:34:25', '2017-09-06 14:23:33', 1, 1, 'Definir senha', 'set_password', NULL, 'webmaster@softsatsistemas.com.br', NULL, NULL, NULL, NULL, 'SoftSAT Gestão - Definir senha', 'Bem-vindo ao SoftSAT Gestão{{ @usuario.name }}.<div><br></div><div>Seu próximo passo é definir uma senha, para isso acesse&nbsp;<a href="http://gestao.softsatsistemas.com.br{{ \'admin_set_password\', \'token=\'.@usuario.reset_token | alias }}">http://gestao.softsatsistemas.com.br{{ \'admin_set_password\', \'token=\'.@usuario.reset_token | alias }}</a>.</div>'),
	(5, '2016-10-07 09:22:38', '2017-09-06 13:47:56', 1, 1, 'Notificação de erro', 'error', NULL, 'webmaster@softsatsistemas.com.br', 'luis@softsatsistemas.com.br', NULL, NULL, NULL, 'Ocorreu um erro em {{ @server }}', '<div>Seguem dados coletados.<br><br></div>\r\n<div>\r\n<h4>Requisição</h4>\r\n<div>\r\nURL: {{ @url }}<br>\r\nMétodo: {{ @method }}<br>\r\nAjax: {{ @ajax}}<br>\r\nQuery: {{ @query}}<br>\r\nData: {{ @time }}<br>\r\n</div>\r\n\r\n<h4>Usuário</h4>\r\n<div>\r\nID: {{ @admin.id }}<br>\r\nNome: {{ @admin.name }} <br>\r\nEmail: {{ @admin.email }}<br>\r\n<br>\r\nIP: {{ @ip }}<br>\r\nUseragent: {{ @agent }}\r\n</div>\r\n\r\n<h4>Erro</h4>\r\n<div>Código: {{ @error.code }}<br>\r\nStatus: {{ @error.status }}<br>\r\nTexto: {{ @error.text }}<br>\r\nTrace:<br>\r\n{{ nl2br(@error.trace) }}\r\n</div>\r\n\r\n<h4>POST</h4>\r\n<pre>{{ json_encode(@post, JSON_PRETTY_PRINT) | raw }}</pre>\r\n\r\n<h4>GET</h4>\r\n<pre>{{ json_encode(@get, JSON_PRETTY_PRINT) | raw }}</pre>\r\n\r\n<h4>COOKIE</h4>\r\n<pre>{{ json_encode(@cookie, JSON_PRETTY_PRINT) | raw }}</pre>\r\n\r\n<h4>PARAMS</h4>\r\n<pre>{{ json_encode(@params, JSON_PRETTY_PRINT) | raw }}</pre>\r\n\r\n<h4>HEADERS</h4>\r\n<pre>{{ json_encode(@headers, JSON_PRETTY_PRINT) | raw }}</pre>\r\n</div>'),
	(6, '2018-04-13 11:34:41', '2018-04-13 12:32:12', 1, 1, 'Contato pelo site', 'contato_site', NULL, NULL, 'desenv@softsatsistemas.com.br', NULL, NULL, '{{ @email }}', 'Contato pelo site [{{ @assunto }}]', '<div>Você recebeu uma nova mensagem pelo site.</div><div><br></div><div><b>Nome:</b> {{ @nome }}.</div><div><b>Email:</b> {{ @email }}.</div><div><b>Assunto:</b> {{ @assunto }}.</div><div><br></div><div><b>Mensagem:</b></div><div><p>{{ @mensagem }}</p></div>'),
	(7, '2018-04-14 17:44:23', '2018-04-15 18:28:18', 1, 1, 'Redefinição de senha', 'redefinir_senha_site', NULL, NULL, NULL, NULL, NULL, NULL, 'Redefinição de senha', 'Para redefinir sua senha acesse o seguinte link http://wlocation.local{{ @link }}.<br>'),
	(8, '2018-04-18 16:26:49', '2018-04-19 09:05:34', 1, 1, 'Reserva de veículo - admin', 'reserva_veiculo_admin_site', NULL, NULL, 'desenv@softsatsistemas.com.br', NULL, NULL, NULL, '{{ @cliente }} reservou um veiculo', '<div>{{ @cliente }} reservou o {{ @marca }} {{ @modelo }} placa {{ @placa }} de {{ @saida|date }} até {{ @entrada|date }}.</div>'),
	(9, '2018-04-18 16:29:30', '2018-04-18 16:29:30', 1, 1, 'Reserva de veículo - cliente', 'reserva_veiculo_cliente_site', NULL, NULL, NULL, NULL, NULL, NULL, 'Reserva de veículo', 'Obrigado por reservar o {{ @marca }} {{ @modelo }} de {{ @saida }} até {{ @entrada }}.<br>'),
	(10, '2018-04-18 16:32:26', '2018-04-19 09:06:18', 1, 1, 'Faturamento realizado', 'faturamento_veiculo', NULL, NULL, NULL, NULL, NULL, NULL, 'Faturamento realizado', '<div>Caro(a) {{ @cliente }} sua reserva do {{ @marca }} {{ @modelo }} foi faturada.</div><div><br></div><div>Segue cópia do contrato em anexo.<br></div>');
/*!40000 ALTER TABLE `hwapx_email_template` ENABLE KEYS */;

-- Copiando estrutura para tabela softsats_locacao.hwapx_group
CREATE TABLE IF NOT EXISTS `hwapx_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_on` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_on` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  `active` tinyint(1) NOT NULL,
  `description` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `roles` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `fk_hwapx_group_hwapx_user_created_by` (`created_by`),
  KEY `fk_hwapx_group_hwapx_user_updated_by` (`updated_by`),
  CONSTRAINT `fk_hwapx_group_hwapx_user_created_by` FOREIGN KEY (`created_by`) REFERENCES `hwapx_user` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_hwapx_group_hwapx_user_updated_by` FOREIGN KEY (`updated_by`) REFERENCES `hwapx_user` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Copiando dados para a tabela softsats_locacao.hwapx_group: ~4 rows (aproximadamente)
DELETE FROM `hwapx_group`;
/*!40000 ALTER TABLE `hwapx_group` DISABLE KEYS */;
INSERT INTO `hwapx_group` (`id`, `created_on`, `updated_on`, `created_by`, `updated_by`, `active`, `description`, `roles`) VALUES
	(1, '2015-03-08 02:01:39', '2016-09-24 12:36:31', NULL, 1, 1, 'Desenvolvedor', NULL),
	(2, '2015-03-08 02:01:39', '2017-01-04 13:08:44', NULL, 1, 1, 'Administrador', 'hwapx.admin.settings;hwapx.admin.user_create;hwapx.admin.user_edit;hwapx.admin.user_remove;hwapx.admin.user_list;hwapx.admin.group_create;hwapx.admin.group_edit;hwapx.admin.group_remove;hwapx.admin.group_list;hwapx.admin.group_roles;hwapx.logs.logs;hwapx.logs.log_remove;softsat.licenca.create;softsat.licenca.edit;softsat.licenca.edit_obs;softsat.licenca.remove;softsat.licenca.list;softsat.licenca.load;softsat.licenca.plano_create;softsat.licenca.plano_edit;softsat.licenca.plano_remove;softsat.licenca.plano_list;softsat.licenca.plano_load;softsat.licenca.demonstracao_list'),
	(3, '2016-10-20 14:44:14', '2016-10-20 15:03:05', 1, 1, 1, 'Comercial', 'softsat.licenca.demonstracao_list'),
	(4, '2017-01-03 11:08:14', '2017-03-23 12:06:23', 4, 1, 1, 'Suporte', 'softsat.licenca.edit;softsat.licenca.edit_obs;softsat.licenca.list;softsat.licenca.load;softsat.licenca.plano_list;softsat.licenca.plano_load;softsat.licenca.demonstracao_list');
/*!40000 ALTER TABLE `hwapx_group` ENABLE KEYS */;

-- Copiando estrutura para tabela softsats_locacao.hwapx_redirect
CREATE TABLE IF NOT EXISTS `hwapx_redirect` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_on` datetime NOT NULL,
  `updated_on` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  `description` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `url_from` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `url_to` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `active` tinyint(1) NOT NULL,
  `permanent` tinyint(1) NOT NULL,
  `method` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_hwapx_redirect_hwapx_user_created_by` (`created_by`),
  KEY `fk_hwapx_redirect_hwapx_user_updated_by` (`updated_by`),
  CONSTRAINT `fk_hwapx_redirect_hwapx_user_created_by` FOREIGN KEY (`created_by`) REFERENCES `hwapx_user` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_hwapx_redirect_hwapx_user_updated_by` FOREIGN KEY (`updated_by`) REFERENCES `hwapx_user` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Copiando dados para a tabela softsats_locacao.hwapx_redirect: ~0 rows (aproximadamente)
DELETE FROM `hwapx_redirect`;
/*!40000 ALTER TABLE `hwapx_redirect` DISABLE KEYS */;
INSERT INTO `hwapx_redirect` (`id`, `created_on`, `updated_on`, `created_by`, `updated_by`, `description`, `url_from`, `url_to`, `active`, `permanent`, `method`) VALUES
	(1, '2015-10-08 23:18:02', '2018-04-13 08:24:54', NULL, 1, 'Ammyy', '/ammyy', 'http://www.ammyy.com/AA_v3.exe', 0, 0, 'HEAD|GET');
/*!40000 ALTER TABLE `hwapx_redirect` ENABLE KEYS */;

-- Copiando estrutura para tabela softsats_locacao.hwapx_sessions
CREATE TABLE IF NOT EXISTS `hwapx_sessions` (
  `session_id` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `data` text COLLATE utf8_unicode_ci,
  `ip` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,
  `agent` varchar(300) COLLATE utf8_unicode_ci DEFAULT NULL,
  `stamp` int(11) DEFAULT NULL,
  PRIMARY KEY (`session_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Copiando dados para a tabela softsats_locacao.hwapx_sessions: ~6 rows (aproximadamente)
DELETE FROM `hwapx_sessions`;
/*!40000 ALTER TABLE `hwapx_sessions` DISABLE KEYS */;
INSERT INTO `hwapx_sessions` (`session_id`, `data`, `ip`, `agent`, `stamp`) VALUES
	('dq5ie9io44nquq91saejmmpa76', 'cliente|a:4:{s:2:"id";i:1;s:5:"email";s:29:"desenv@softsatsistemas.com.br";s:4:"nome";s:16:"SoftSAT Sistemas";s:4:"nick";s:33:"<script>alert(1);</script>SoftSAT";}flash|a:1:{s:5:"error";N;}admin|a:20:{s:2:"id";i:1;s:10:"created_on";s:19:"2016-08-20 14:33:42";s:10:"updated_on";s:19:"2018-04-19 09:06:20";s:10:"created_by";N;s:10:"updated_by";i:1;s:13:"last_activity";s:19:"2018-04-19 09:06:38";s:10:"last_login";s:19:"2018-04-18 10:32:15";s:7:"last_ip";s:9:"127.0.0.1";s:4:"name";s:6:"Desenv";s:5:"email";s:29:"desenv@softsatsistemas.com.br";s:5:"photo";s:36:"8afe316e3f990fbdafc30ac2d8797069.jpg";s:6:"active";i:1;s:8:"group_id";i:1;s:18:"reset_requested_on";s:19:"2017-09-06 13:53:06";s:11:"reset_token";s:32:"65247820d26499d01df93b74fb77047e";s:12:"reset_expire";s:19:"2017-09-07 13:53:06";s:10:"last_reset";N;s:10:"session_id";s:32:"c307afb8509d9abe4493eb7c327dd9a8";s:9:"firstname";s:6:"Desenv";s:5:"group";a:8:{s:2:"id";i:1;s:10:"created_on";s:19:"2015-03-08 02:01:39";s:10:"updated_on";s:19:"2016-09-24 12:36:31";s:10:"created_by";N;s:10:"updated_by";i:1;s:6:"active";i:1;s:11:"description";s:13:"Desenvolvedor";s:5:"roles";a:1:{i:0;s:0:"";}}}', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:60.0) Gecko/20100101 Firefox/60.0', 1524139600);
/*!40000 ALTER TABLE `hwapx_sessions` ENABLE KEYS */;

-- Copiando estrutura para tabela softsats_locacao.hwapx_setting
CREATE TABLE IF NOT EXISTS `hwapx_setting` (
  `id` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `value` text COLLATE utf8_unicode_ci,
  `field_order` int(11) NOT NULL,
  `label` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `group` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `type` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `rules` text COLLATE utf8_unicode_ci,
  `created_on` datetime DEFAULT CURRENT_TIMESTAMP,
  `updated_on` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Copiando dados para a tabela softsats_locacao.hwapx_setting: ~12 rows (aproximadamente)
DELETE FROM `hwapx_setting`;
/*!40000 ALTER TABLE `hwapx_setting` DISABLE KEYS */;
INSERT INTO `hwapx_setting` (`id`, `value`, `field_order`, `label`, `group`, `type`, `rules`, `created_on`, `updated_on`) VALUES
	('admin.color', 'olive', 2, 'Cor', 'Admin', 'dropdown', 'in=|aqua|black|blue|fuchsia|green|light-blue|lime|maroon|navy|olive|orange|purple|red|teal|yellow|aqua-gradient|black-gradient|blue-gradient|fuchsia-gradient|green-gradient|light-blue-gradient|lime-gradient|maroon-gradient|navy-gradient|olive-gradient|orange-gradient|purple-gradient|red-gradient|teal-gradient|yellow-gradient', '2016-10-12 21:35:42', '2018-04-12 21:27:03'),
	('admin.layout', 'fixed', 3, 'Layout', 'Admin', 'dropdown', 'required;in=normal|fixed', '2015-02-16 21:13:53', '2016-10-12 21:34:19'),
	('admin.sidebar_color', '', 5, 'Cor (Menu lateral)', 'Admin', 'dropdown', 'in=|aqua|black|blue|fuchsia|green|light-blue|lime|maroon|navy|olive|orange|purple|red|teal|yellow|aqua-gradient|black-gradient|blue-gradient|fuchsia-gradient|green-gradient|light-blue-gradient|lime-gradient|maroon-gradient|navy-gradient|olive-gradient|orange-gradient|purple-gradient|red-gradient|teal-gradient|yellow-gradient', '2016-10-12 21:54:01', '2016-10-12 22:05:53'),
	('admin.skin', 'blue', 1, 'Skin', 'Admin', 'dropdown', 'in=|blue|black', '2015-02-16 21:13:53', '2018-04-12 21:24:37'),
	('api.password', 'apikey', 23, 'Senha', 'Api', 'password', 'required;lengthMin=6', '2014-11-09 23:13:30', '2016-10-12 20:48:26'),
	('api.username', 'api', 22, 'Usuário', 'Api', 'text', 'required;lengthMin=3', '2014-11-09 23:13:30', '2016-10-12 20:48:26'),
	('email.host', 'smtp.yandex.com', 13, 'Servidor SMTP', 'Email', 'text', 'required', '2014-11-09 23:13:30', '2017-03-30 17:03:09'),
	('email.password', 'niwwkprjlhdtpldb', 17, 'Senha', 'Email', 'password', 'required', '2014-11-09 23:13:30', '2017-09-06 12:36:09'),
	('email.port', '587', 14, 'Porta SMTP', 'Email', 'number', 'required;integer;min=1;max=65535', '2014-11-09 23:13:30', '2017-09-06 14:29:34'),
	('email.scheme', 'tls', 15, 'Modo de Autenticação', 'Email', 'dropdown', 'in=|ssl|tls', '2014-11-09 23:13:30', '2017-09-06 14:11:44'),
	('email.user', 'webmaster@softsatsistemas.com.br', 16, 'Email', 'Email', 'text', 'required;email', '2014-11-09 23:13:30', '2017-09-06 10:59:21'),
	('site_name', 'W.Location', 1, 'Nome', 'Site', 'text', 'required', '2015-02-16 20:47:18', '2018-04-11 20:16:07');
/*!40000 ALTER TABLE `hwapx_setting` ENABLE KEYS */;

-- Copiando estrutura para tabela softsats_locacao.hwapx_user
CREATE TABLE IF NOT EXISTS `hwapx_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_on` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_on` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  `last_activity` datetime DEFAULT NULL,
  `last_login` datetime DEFAULT NULL,
  `last_ip` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `password` char(128) COLLATE utf8_unicode_ci NOT NULL,
  `email` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `photo` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `active` tinyint(1) NOT NULL,
  `group_id` int(11) NOT NULL,
  `reset_requested_on` datetime DEFAULT NULL,
  `reset_token` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `reset_expire` datetime DEFAULT NULL,
  `last_reset` datetime DEFAULT NULL,
  `session_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `un_hwapx_user_email` (`email`),
  UNIQUE KEY `un_hwapx_user_reset_token` (`reset_token`),
  KEY `fk_hwapx_user_hwapx_group` (`group_id`),
  KEY `fk_hwapx_user_hwapx_user_created_by` (`created_by`),
  KEY `fk_hwapx_user_hwapx_user_updated_by` (`updated_by`),
  CONSTRAINT `fk_hwapx_user_hwapx_group` FOREIGN KEY (`group_id`) REFERENCES `hwapx_group` (`id`),
  CONSTRAINT `fk_hwapx_user_hwapx_user_created_by` FOREIGN KEY (`created_by`) REFERENCES `hwapx_user` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_hwapx_user_hwapx_user_updated_by` FOREIGN KEY (`updated_by`) REFERENCES `hwapx_user` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Copiando dados para a tabela softsats_locacao.hwapx_user: ~3 rows (aproximadamente)
DELETE FROM `hwapx_user`;
/*!40000 ALTER TABLE `hwapx_user` DISABLE KEYS */;
INSERT INTO `hwapx_user` (`id`, `created_on`, `updated_on`, `created_by`, `updated_by`, `last_activity`, `last_login`, `last_ip`, `name`, `password`, `email`, `photo`, `active`, `group_id`, `reset_requested_on`, `reset_token`, `reset_expire`, `last_reset`, `session_id`) VALUES
	(1, '2016-08-20 14:33:42', '2018-04-19 09:06:38', NULL, 1, '2018-04-19 09:06:38', '2018-04-18 10:32:15', '127.0.0.1', 'Desenv', '$2y$10$2.NSsgF5whjBVmWqEhtlEun1ZMK55g4hzRgzPYqBsw9SKMI6.aqOO', 'desenv@softsatsistemas.com.br', '8afe316e3f990fbdafc30ac2d8797069.jpg', 1, 1, '2017-09-06 13:53:06', '65247820d26499d01df93b74fb77047e', '2017-09-07 13:53:06', NULL, 'c307afb8509d9abe4493eb7c327dd9a8'),
	(2, '2016-09-01 17:56:05', '2018-04-05 16:15:28', NULL, 1, '2018-04-05 16:15:28', '2018-04-05 09:13:36', '200.95.219.22', 'Admin', '$2y$10$PluOJrAIv8.LCoq3V4jVp.PyhcXiHo9kmZgwUll8W3SN5S4/xT0x.', 'contato@softsatsistemas.com.br', '84c0ed62ccb479c9a57e6aebbb712db6.jpg', 1, 2, NULL, '5a8c9d3f9c4c63f99a47a82cff52bda1', '2016-10-08 13:44:46', NULL, 'e10f15c04f25356f45d0a22975866933'),
	(4, '2016-11-28 09:43:43', '2018-04-11 12:40:18', 1, 4, '2018-04-11 12:40:18', '2018-04-11 11:57:27', '200.95.216.251', 'Luis Henrique', '$2y$10$tApYRZpUvUKG3se6bmVBnuBGAxlvStKDkHUxFw.5IMUzWSH8Rxs4i', 'luis@softsatsistemas.com.br', NULL, 1, 4, '2017-09-06 14:31:45', '0ba0295dc6007b501ddc784f30b7f410', '2017-09-07 14:31:45', NULL, '071824ba1ffca3442c73da8864f236e8');
/*!40000 ALTER TABLE `hwapx_user` ENABLE KEYS */;

-- Copiando estrutura para tabela softsats_locacao.softsat_locacao_cliente
CREATE TABLE IF NOT EXISTS `softsat_locacao_cliente` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_on` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_on` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  `nome` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `cpf` varchar(15) COLLATE utf8_unicode_ci NOT NULL,
  `rg` varchar(15) COLLATE utf8_unicode_ci NOT NULL,
  `cnh` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `nascimento` date NOT NULL,
  `endereco` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `numero` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
  `bairro` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cidade` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `estado` varchar(2) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cep` varchar(9) COLLATE utf8_unicode_ci DEFAULT NULL,
  `celular` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `telefone` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `telefone_comercial` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `email` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `senha` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `token` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `token_date` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_softsat_locacao_cliente_hwapx_user_created_by` (`created_by`),
  KEY `fk_softsat_locacao_cliente_hwapx_user_updated_by` (`updated_by`),
  CONSTRAINT `fk_softsat_locacao_cliente_hwapx_user_created_by` FOREIGN KEY (`created_by`) REFERENCES `hwapx_user` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_softsat_locacao_cliente_hwapx_user_updated_by` FOREIGN KEY (`updated_by`) REFERENCES `hwapx_user` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Copiando dados para a tabela softsats_locacao.softsat_locacao_cliente: ~4 rows (aproximadamente)
DELETE FROM `softsat_locacao_cliente`;
/*!40000 ALTER TABLE `softsat_locacao_cliente` DISABLE KEYS */;
INSERT INTO `softsat_locacao_cliente` (`id`, `created_on`, `updated_on`, `created_by`, `updated_by`, `nome`, `cpf`, `rg`, `cnh`, `nascimento`, `endereco`, `numero`, `bairro`, `cidade`, `estado`, `cep`, `celular`, `telefone`, `telefone_comercial`, `email`, `senha`, `token`, `token_date`) VALUES
	(1, '2018-04-12 21:19:14', '2018-04-18 17:28:11', NULL, 1, 'SoftSAT Sistemas', '000.000.001-91', '11.111.1111-1', '1234567890', '2016-03-01', 'Rua Jeronimo Higino de Carvalho', '1210', 'Aclimação', 'José Bonifácio', 'SP', '15200-000', '(017)99648-8292', NULL, '(017)3265-9828', 'desenv@softsatsistemas.com.br', '$2y$10$jSdz/ki/fKmv5QodBuLa7.YD.MZ1Kdj1re6wBZ6Q.2R31hSCVStiq', NULL, '2018-04-16'),
	(2, '2018-04-16 15:56:03', '2018-04-16 15:56:03', NULL, NULL, 'Luis Henrique Barbosa de Lima', '397.725.108-20', '22.222.2222-2', '1234567890', '2016-01-03', 'Endereço', '', '', '', '', '', '(017)99648-8292', '', '', 'luis@softsatsistemas.com.br', '$2y$10$/z0YB8osE6zd28axS0d.MurZ2aE/HyXk4vIodC25yG3jFjqydOL7q', NULL, NULL),
	(3, '2018-04-16 16:14:04', '2018-04-16 16:18:03', NULL, 1, 'Contato SoftSAT', '000.000.001-91', '16.516.5464-6', '654646464', '2016-01-03', 'Endereço', NULL, NULL, NULL, NULL, NULL, '(111)11111-1111', NULL, NULL, 'contato@softsatsistemas.com.br', '$2y$10$57G75bWtgmUUjyubDDEQzeQkHByZIx0a2VL3ZnI1wdfTj6iGYt3Qi', NULL, NULL),
	(4, '2018-04-16 16:16:55', '2018-04-16 16:16:55', NULL, NULL, 'Suporte SoftSAT', '000.000.001-91', '35.165.1651-6', '65165161', '2016-01-03', 'Endereço', '', '', '', '', '', '(000)00000-0000', '', '', 'suporte@softsatsistemas.com.br', '$2y$10$s72/2lJfb09nP8IMXUTDReOBWawvPMZKArW.eK3v2rHBfVAdem9iy', NULL, NULL);
/*!40000 ALTER TABLE `softsat_locacao_cliente` ENABLE KEYS */;

-- Copiando estrutura para tabela softsats_locacao.softsat_locacao_combustivel
CREATE TABLE IF NOT EXISTS `softsat_locacao_combustivel` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_on` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_on` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  `nome` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_softsat_locacao_combustivel_hwapx_user_created_by` (`created_by`),
  KEY `fk_softsat_locacao_combustivel_hwapx_user_updated_by` (`updated_by`),
  CONSTRAINT `fk_softsat_locacao_combustivel_hwapx_user_created_by` FOREIGN KEY (`created_by`) REFERENCES `hwapx_user` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_softsat_locacao_combustivel_hwapx_user_updated_by` FOREIGN KEY (`updated_by`) REFERENCES `hwapx_user` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Copiando dados para a tabela softsats_locacao.softsat_locacao_combustivel: ~4 rows (aproximadamente)
DELETE FROM `softsat_locacao_combustivel`;
/*!40000 ALTER TABLE `softsat_locacao_combustivel` DISABLE KEYS */;
INSERT INTO `softsat_locacao_combustivel` (`id`, `created_on`, `updated_on`, `created_by`, `updated_by`, `nome`) VALUES
	(1, '2018-04-12 21:19:21', '2018-04-12 21:19:21', NULL, NULL, 'Alcool'),
	(2, '2018-04-12 21:19:21', '2018-04-12 21:19:21', NULL, NULL, 'Diesel'),
	(3, '2018-04-12 21:19:21', '2018-04-12 21:19:21', NULL, NULL, 'Flex'),
	(4, '2018-04-12 21:19:21', '2018-04-12 21:19:21', NULL, NULL, 'Gasolina');
/*!40000 ALTER TABLE `softsat_locacao_combustivel` ENABLE KEYS */;

-- Copiando estrutura para tabela softsats_locacao.softsat_locacao_contrato
CREATE TABLE IF NOT EXISTS `softsat_locacao_contrato` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_on` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_on` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  `cliente_id` int(11) NOT NULL,
  `veiculo_id` int(11) NOT NULL,
  `saida` date NOT NULL,
  `entrada` date DEFAULT NULL,
  `diaria` decimal(12,2) NOT NULL,
  `forma_pagamento_id` int(11) DEFAULT NULL,
  `tarifa_id` int(11) NOT NULL,
  `status` varchar(1) COLLATE utf8_unicode_ci NOT NULL,
  `tanque` int(11) DEFAULT NULL,
  `km_saida` decimal(13,3) DEFAULT NULL,
  `km_entrada` decimal(13,3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_softsat_locacao_contrato_softsat_locacao_cliente` (`cliente_id`),
  KEY `fk_softsat_locacao_contrato_softsat_locacao_veiculo` (`veiculo_id`),
  KEY `fk_softsat_locacao_contrato_softsat_locacao_forma_pagamento` (`forma_pagamento_id`),
  KEY `fk_softsat_locacao_contrato_hwapx_user_created_by` (`created_by`),
  KEY `fk_softsat_locacao_contrato_hwapx_user_updated_by` (`updated_by`),
  KEY `FK_softsat_locacao_contrato_softsat_locacao_tarifa` (`tarifa_id`),
  CONSTRAINT `FK_softsat_locacao_contrato_softsat_locacao_tarifa` FOREIGN KEY (`tarifa_id`) REFERENCES `softsat_locacao_tarifa` (`id`),
  CONSTRAINT `fk_softsat_locacao_contrato_hwapx_user_created_by` FOREIGN KEY (`created_by`) REFERENCES `hwapx_user` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_softsat_locacao_contrato_hwapx_user_updated_by` FOREIGN KEY (`updated_by`) REFERENCES `hwapx_user` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_softsat_locacao_contrato_softsat_locacao_cliente` FOREIGN KEY (`cliente_id`) REFERENCES `softsat_locacao_cliente` (`id`),
  CONSTRAINT `fk_softsat_locacao_contrato_softsat_locacao_forma_pagamento` FOREIGN KEY (`forma_pagamento_id`) REFERENCES `softsat_locacao_forma_pagamento` (`id`),
  CONSTRAINT `fk_softsat_locacao_contrato_softsat_locacao_veiculo` FOREIGN KEY (`veiculo_id`) REFERENCES `softsat_locacao_veiculo` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Copiando dados para a tabela softsats_locacao.softsat_locacao_contrato: ~4 rows (aproximadamente)
DELETE FROM `softsat_locacao_contrato`;
/*!40000 ALTER TABLE `softsat_locacao_contrato` DISABLE KEYS */;
INSERT INTO `softsat_locacao_contrato` (`id`, `created_on`, `updated_on`, `created_by`, `updated_by`, `cliente_id`, `veiculo_id`, `saida`, `entrada`, `diaria`, `forma_pagamento_id`, `tarifa_id`, `status`, `tanque`, `km_saida`, `km_entrada`) VALUES
	(1, '2018-04-12 21:19:28', '2018-04-17 15:52:34', NULL, 1, 1, 1, '2018-04-12', '2018-04-14', 150.00, 1, 1, 'F', 30, 1234.000, 1955.000),
	(2, '2018-04-12 21:19:28', '2018-04-17 15:52:34', NULL, 1, 1, 3, '2018-04-14', '2018-04-19', 200.00, 1, 1, 'F', 10, 0.000, 0.000),
	(3, '2018-04-14 14:24:47', '2018-04-17 15:52:34', 1, 1, 1, 5, '2018-04-14', NULL, 150.00, 1, 1, 'A', 0, 2000.000, 2345.000),
	(7, '2018-04-19 09:01:21', '2018-04-19 09:01:21', NULL, NULL, 1, 2, '2018-04-19', '2018-04-19', 150.00, NULL, 1, 'R', NULL, NULL, NULL);
/*!40000 ALTER TABLE `softsat_locacao_contrato` ENABLE KEYS */;

-- Copiando estrutura para tabela softsats_locacao.softsat_locacao_forma_pagamento
CREATE TABLE IF NOT EXISTS `softsat_locacao_forma_pagamento` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_on` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_on` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  `nome` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_softsat_locacao_forma_pagamento_hwapx_user_created_by` (`created_by`),
  KEY `fk_softsat_locacao_forma_pagamento_hwapx_user_updated_by` (`updated_by`),
  CONSTRAINT `fk_softsat_locacao_forma_pagamento_hwapx_user_created_by` FOREIGN KEY (`created_by`) REFERENCES `hwapx_user` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_softsat_locacao_forma_pagamento_hwapx_user_updated_by` FOREIGN KEY (`updated_by`) REFERENCES `hwapx_user` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Copiando dados para a tabela softsats_locacao.softsat_locacao_forma_pagamento: ~4 rows (aproximadamente)
DELETE FROM `softsat_locacao_forma_pagamento`;
/*!40000 ALTER TABLE `softsat_locacao_forma_pagamento` DISABLE KEYS */;
INSERT INTO `softsat_locacao_forma_pagamento` (`id`, `created_on`, `updated_on`, `created_by`, `updated_by`, `nome`) VALUES
	(1, '2018-04-12 21:19:35', '2018-04-12 21:19:35', NULL, NULL, 'À Vista'),
	(2, '2018-04-12 21:19:35', '2018-04-12 21:19:35', NULL, NULL, 'Cartão de Crédito'),
	(3, '2018-04-12 21:19:35', '2018-04-12 21:19:35', NULL, NULL, 'Cartão de Débito'),
	(4, '2018-04-12 21:19:35', '2018-04-12 21:19:35', NULL, NULL, 'Cheque');
/*!40000 ALTER TABLE `softsat_locacao_forma_pagamento` ENABLE KEYS */;

-- Copiando estrutura para tabela softsats_locacao.softsat_locacao_grupo
CREATE TABLE IF NOT EXISTS `softsat_locacao_grupo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_on` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_on` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  `nome` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_softsat_locacao_grupo_hwapx_user_created_by` (`created_by`),
  KEY `fk_softsat_locacao_grupo_hwapx_user_updated_by` (`updated_by`),
  CONSTRAINT `fk_softsat_locacao_grupo_hwapx_user_created_by` FOREIGN KEY (`created_by`) REFERENCES `hwapx_user` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_softsat_locacao_grupo_hwapx_user_updated_by` FOREIGN KEY (`updated_by`) REFERENCES `hwapx_user` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Copiando dados para a tabela softsats_locacao.softsat_locacao_grupo: ~5 rows (aproximadamente)
DELETE FROM `softsat_locacao_grupo`;
/*!40000 ALTER TABLE `softsat_locacao_grupo` DISABLE KEYS */;
INSERT INTO `softsat_locacao_grupo` (`id`, `created_on`, `updated_on`, `created_by`, `updated_by`, `nome`) VALUES
	(1, '2018-04-12 21:19:40', '2018-04-12 21:19:40', NULL, NULL, 'Economico com ar'),
	(2, '2018-04-12 21:19:40', '2018-04-12 21:19:40', NULL, NULL, 'Economico sem ar'),
	(3, '2018-04-12 21:19:40', '2018-04-12 21:19:40', NULL, NULL, 'Luxo'),
	(4, '2018-04-12 21:19:40', '2018-04-12 21:19:40', NULL, NULL, 'Especial'),
	(5, '2018-04-12 21:19:40', '2018-04-12 21:19:40', NULL, NULL, 'Utilitario');
/*!40000 ALTER TABLE `softsat_locacao_grupo` ENABLE KEYS */;

-- Copiando estrutura para tabela softsats_locacao.softsat_locacao_marca
CREATE TABLE IF NOT EXISTS `softsat_locacao_marca` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_on` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_on` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  `nome` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_softsat_locacao_marca_hwapx_user_created_by` (`created_by`),
  KEY `fk_softsat_locacao_marca_hwapx_user_updated_by` (`updated_by`),
  CONSTRAINT `fk_softsat_locacao_marca_hwapx_user_created_by` FOREIGN KEY (`created_by`) REFERENCES `hwapx_user` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_softsat_locacao_marca_hwapx_user_updated_by` FOREIGN KEY (`updated_by`) REFERENCES `hwapx_user` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Copiando dados para a tabela softsats_locacao.softsat_locacao_marca: ~9 rows (aproximadamente)
DELETE FROM `softsat_locacao_marca`;
/*!40000 ALTER TABLE `softsat_locacao_marca` DISABLE KEYS */;
INSERT INTO `softsat_locacao_marca` (`id`, `created_on`, `updated_on`, `created_by`, `updated_by`, `nome`) VALUES
	(1, '2018-04-12 21:19:45', '2018-04-12 21:19:45', NULL, NULL, 'VW'),
	(2, '2018-04-12 21:19:45', '2018-04-12 21:19:45', NULL, NULL, 'GM'),
	(3, '2018-04-12 21:19:45', '2018-04-12 21:19:45', NULL, NULL, 'FIAT'),
	(4, '2018-04-12 21:19:45', '2018-04-12 21:19:45', NULL, NULL, 'Ford'),
	(5, '2018-04-12 21:19:45', '2018-04-12 21:19:45', NULL, NULL, 'Citroen'),
	(6, '2018-04-12 21:19:45', '2018-04-13 12:59:27', NULL, 1, 'Renault'),
	(7, '2018-04-12 21:19:45', '2018-04-12 21:19:45', NULL, NULL, 'Toyota'),
	(8, '2018-04-12 21:19:45', '2018-04-12 21:19:45', NULL, NULL, 'Honda'),
	(9, '2018-04-13 16:12:58', '2018-04-13 16:12:58', 1, 1, 'Hyundai');
/*!40000 ALTER TABLE `softsat_locacao_marca` ENABLE KEYS */;

-- Copiando estrutura para tabela softsats_locacao.softsat_locacao_tarifa
CREATE TABLE IF NOT EXISTS `softsat_locacao_tarifa` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_on` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_on` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  `nome` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `valor` decimal(12,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_softsat_locacao_tarifa_hwapx_user_created_by` (`created_by`),
  KEY `fk_softsat_locacao_tarifa_hwapx_user_updated_by` (`updated_by`),
  CONSTRAINT `fk_softsat_locacao_tarifa_hwapx_user_created_by` FOREIGN KEY (`created_by`) REFERENCES `hwapx_user` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_softsat_locacao_tarifa_hwapx_user_updated_by` FOREIGN KEY (`updated_by`) REFERENCES `hwapx_user` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Copiando dados para a tabela softsats_locacao.softsat_locacao_tarifa: ~0 rows (aproximadamente)
DELETE FROM `softsat_locacao_tarifa`;
/*!40000 ALTER TABLE `softsat_locacao_tarifa` DISABLE KEYS */;
INSERT INTO `softsat_locacao_tarifa` (`id`, `created_on`, `updated_on`, `created_by`, `updated_by`, `nome`, `valor`) VALUES
	(1, '2018-04-12 21:19:51', '2018-04-12 21:19:51', NULL, NULL, 'Normal', 150.00);
/*!40000 ALTER TABLE `softsat_locacao_tarifa` ENABLE KEYS */;

-- Copiando estrutura para tabela softsats_locacao.softsat_locacao_veiculo
CREATE TABLE IF NOT EXISTS `softsat_locacao_veiculo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_on` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_on` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  `placa` varchar(8) COLLATE utf8_unicode_ci NOT NULL,
  `marca_id` int(11) DEFAULT NULL,
  `modelo` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ano` int(11) DEFAULT NULL,
  `ano_modelo` int(11) DEFAULT NULL,
  `combustivel_id` int(11) DEFAULT NULL,
  `chassi` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `grupo_id` int(11) DEFAULT NULL,
  `tarifa_id` int(11) NOT NULL,
  `imagem` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_softsat_locacao_veiculo_softsat_locacao_combustivel` (`combustivel_id`),
  KEY `fk_softsat_locacao_veiculo_softsat_locacao_grupo` (`grupo_id`),
  KEY `fk_softsat_locacao_veiculo_hwapx_user_created_by` (`created_by`),
  KEY `fk_softsat_locacao_veiculo_hwapx_user_updated_by` (`updated_by`),
  KEY `fk_softsat_locacao_veiculo_softsat_locacao_marca` (`marca_id`),
  KEY `fk_softsat_locacao_veiculo_softsat_locacao_tarifa` (`tarifa_id`),
  CONSTRAINT `fk_softsat_locacao_veiculo_hwapx_user_created_by` FOREIGN KEY (`created_by`) REFERENCES `hwapx_user` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_softsat_locacao_veiculo_hwapx_user_updated_by` FOREIGN KEY (`updated_by`) REFERENCES `hwapx_user` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_softsat_locacao_veiculo_softsat_locacao_combustivel` FOREIGN KEY (`combustivel_id`) REFERENCES `softsat_locacao_combustivel` (`id`),
  CONSTRAINT `fk_softsat_locacao_veiculo_softsat_locacao_grupo` FOREIGN KEY (`grupo_id`) REFERENCES `softsat_locacao_grupo` (`id`),
  CONSTRAINT `fk_softsat_locacao_veiculo_softsat_locacao_marca` FOREIGN KEY (`marca_id`) REFERENCES `softsat_locacao_marca` (`id`),
  CONSTRAINT `fk_softsat_locacao_veiculo_softsat_locacao_tarifa` FOREIGN KEY (`tarifa_id`) REFERENCES `softsat_locacao_tarifa` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Copiando dados para a tabela softsats_locacao.softsat_locacao_veiculo: ~6 rows (aproximadamente)
DELETE FROM `softsat_locacao_veiculo`;
/*!40000 ALTER TABLE `softsat_locacao_veiculo` DISABLE KEYS */;
INSERT INTO `softsat_locacao_veiculo` (`id`, `created_on`, `updated_on`, `created_by`, `updated_by`, `placa`, `marca_id`, `modelo`, `ano`, `ano_modelo`, `combustivel_id`, `chassi`, `grupo_id`, `tarifa_id`, `imagem`) VALUES
	(1, '2018-04-12 21:19:56', '2018-04-17 15:49:06', NULL, 1, 'ABC-1234', 3, 'Uno', 2014, 2015, 3, NULL, 2, 1, '8504ee3aa91d1ce618311efa85bbb35b.jpg'),
	(2, '2018-04-13 12:57:45', '2018-04-17 15:49:06', 1, 1, 'DEF-5678', 8, 'Civic', 2018, 2018, 3, NULL, 3, 1, '52fe608b33f908c8e3889bf8887411e4.jpg'),
	(3, '2018-04-13 12:59:02', '2018-04-17 15:49:06', 1, 1, 'GHI-9012', 6, 'Fluence', 2016, 2017, 3, NULL, 3, 1, '76be132d795d28e213e45e5b6988d005.jpg'),
	(4, '2018-04-13 15:56:29', '2018-04-17 15:49:06', 1, 1, 'JKL-3456', 4, 'Fusion', 2015, 2015, 3, NULL, 3, 1, 'af2e8a31d6de7b45931552013aa37cc9.jpg'),
	(5, '2018-04-13 16:12:13', '2018-04-17 15:49:06', 1, 1, 'MNO-7890', 7, 'Corolla', 2018, 2019, 3, NULL, 3, 1, '331f4573b68006120d670db027bf6f84.jpg'),
	(6, '2018-04-13 16:13:57', '2018-04-17 15:49:06', 1, 1, 'PQR-1234', 9, 'HB20', 2016, 2017, 1, NULL, 1, 1, '68ab4354e740ce9bc61da5b3f6df58eb.jpg');
/*!40000 ALTER TABLE `softsat_locacao_veiculo` ENABLE KEYS */;

-- Copiando estrutura para view softsats_locacao.softsat_locacao_contrato_relatorio
-- Criando tabela temporária para evitar erros de dependência de VIEW
CREATE TABLE `softsat_locacao_contrato_relatorio` (
	`id` INT(11) NOT NULL,
	`cliente_id` INT(11) NOT NULL,
	`cliente` VARCHAR(255) NULL COLLATE 'utf8_unicode_ci',
	`cpf` VARCHAR(15) NULL COLLATE 'utf8_unicode_ci',
	`email` VARCHAR(255) NULL COLLATE 'utf8_unicode_ci',
	`veiculo_id` INT(11) NOT NULL,
	`placa` VARCHAR(8) NULL COLLATE 'utf8_unicode_ci',
	`modelo` VARCHAR(255) NULL COLLATE 'utf8_unicode_ci',
	`saida` DATE NOT NULL,
	`entrada` DATE NULL,
	`tarifa_id` INT(11) NULL,
	`tarifa` VARCHAR(255) NULL COLLATE 'utf8_unicode_ci',
	`diaria` DECIMAL(12,2) NOT NULL,
	`qtde_dias` INT(7) NULL,
	`valor` DECIMAL(18,2) NULL,
	`forma_pagamento_id` INT(11) NULL,
	`status` VARCHAR(1) NOT NULL COLLATE 'utf8_unicode_ci',
	`tanque` INT(11) NULL,
	`km_saida` DECIMAL(13,3) NULL,
	`km_entrada` DECIMAL(13,3) NULL,
	`grupo` VARCHAR(255) NULL COLLATE 'utf8_unicode_ci',
	`marca` VARCHAR(255) NULL COLLATE 'utf8_unicode_ci'
) ENGINE=MyISAM;

-- Copiando estrutura para procedure softsats_locacao.softsat_locacao_veiculo_disponivel
DELIMITER //
CREATE PROCEDURE `softsat_locacao_veiculo_disponivel`(
	IN `in_de` DATE,
	IN `in_ate` DATE,
	IN `in_marca_id` INT,
	IN `in_veiculo_id` INT
)
    READS SQL DATA
    SQL SECURITY INVOKER
SELECT 
    vei.id,
    vei.created_on,
    vei.updated_on,
    vei.created_by,
    vei.updated_by,
    vei.placa,
    vei.marca_id,
    vei.modelo,
    vei.ano,
    vei.ano_modelo,
    vei.combustivel_id,
    vei.chassi,
    vei.grupo_id,
    vei.imagem,
    vei.tarifa_id,
    gru.nome AS grupo,
    mar.nome AS marca,
    tar.valor AS diaria,
    tar.nome AS tarifa
FROM softsat_locacao_veiculo AS vei
LEFT JOIN softsat_locacao_grupo AS gru ON gru.id = vei.grupo_id
LEFT JOIN softsat_locacao_marca AS mar ON mar.id = vei.marca_id
LEFT JOIN softsat_locacao_tarifa AS tar ON tar.id = vei.tarifa_id
LEFT JOIN softsat_locacao_contrato AS con ON con.veiculo_id = vei.id AND con.`status` <> 'C'
WHERE (in_veiculo_id IS NULL OR vei.id = in_veiculo_id)
AND (in_marca_id IS NULL OR mar.id = in_marca_id)
AND (con.id IS NULL OR 
    NOT(con.saida BETWEEN in_de AND in_ate OR con.entrada BETWEEN in_de AND in_ate
     OR in_de BETWEEN con.saida AND con.entrada OR in_ate BETWEEN con.saida AND con.entrada))//
DELIMITER ;

-- Copiando estrutura para view softsats_locacao.softsat_locacao_contrato_relatorio
-- Removendo tabela temporária e criando a estrutura VIEW final
DROP TABLE IF EXISTS `softsat_locacao_contrato_relatorio`;
CREATE SQL SECURITY DEFINER VIEW `softsat_locacao_contrato_relatorio` AS SELECT 
    con.id, 
    con.cliente_id, 
    cli.nome AS cliente,
    cli.cpf,
    cli.email,
    con.veiculo_id, 
    vei.placa,
    vei.modelo,
    con.saida, 
    con.entrada, 
    vei.tarifa_id,
    tar.nome AS tarifa,
    con.diaria, 
    DATEDIFF(con.entrada, con.saida) AS qtde_dias, 
    con.diaria * DATEDIFF(entrada, saida) AS valor, 
    con.forma_pagamento_id, 
    con.status, 
    con.tanque,
    con.km_saida,
    con.km_entrada,
    gru.nome AS grupo,
    mar.nome AS marca
FROM softsat_locacao_contrato AS con
LEFT JOIN softsat_locacao_cliente AS cli ON cli.id = con.cliente_id
LEFT JOIN softsat_locacao_veiculo AS vei ON vei.id = con.veiculo_id
LEFT JOIN softsat_locacao_tarifa AS tar ON tar.id = vei.tarifa_id
LEFT JOIN softsat_locacao_grupo AS gru ON gru.id = vei.grupo_id
LEFT JOIN softsat_locacao_marca AS mar ON mar.id = vei.marca_id ;

/*!40101 SET SQL_MODE=IFNULL(@OLD_SQL_MODE, '') */;
/*!40014 SET FOREIGN_KEY_CHECKS=IF(@OLD_FOREIGN_KEY_CHECKS IS NULL, 1, @OLD_FOREIGN_KEY_CHECKS) */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
