DROP PROCEDURE IF EXISTS softsat_locacao_ipva_lancar;

CREATE PROCEDURE softsat_locacao_ipva_lancar(in_ano INTEGER, in_veiculo_id INTEGER) 
    LANGUAGE SQL
    NOT DETERMINISTIC
    READS SQL DATA
    SQL SECURITY INVOKER
        INSERT INTO softsat_locacao_veiculo_ipva(veiculo_id, ipva_parcela_id, parcela, vencimento)
            SELECT vei.id, par.id, par.parcela, par.vencimento FROM softsat_locacao_veiculo AS vei
            INNER JOIN softsat_locacao_ipva AS ipva ON ipva.ano = in_ano OR (in_ano IS NULL AND ipva.ano > YEAR(CURRENT_DATE))
            INNER JOIN softsat_locacao_ipva_parcela AS par ON par.ipva_id = ipva.id AND par.final_placa = SUBSTR(vei.placa, 8, 1)
            WHERE vei.ativo = 1
            AND vei.ano < ipva.ano
            AND (vei.id = in_veiculo_id OR in_veiculo_id IS NULL)
        ON DUPLICATE KEY UPDATE parcela = par.parcela, vencimento = par.vencimento;
            
CREATE TRIGGER `softsat_locacao_veiculo_after_insert` AFTER INSERT ON `softsat_locacao_veiculo` FOR EACH ROW 
    CALL softsat_locacao_ipva_lancar(NULL, NEW.id);
    
CREATE TRIGGER `softsat_locacao_ipva_parcela_after_insert` AFTER INSERT ON `softsat_locacao_ipva_parcela` FOR EACH ROW
    CALL softsat_locacao_ipva_lancar((SELECT ipva.ano FROM softsat_locacao_ipva AS ipva WHERE ipva.id = NEW.ipva_id), NULL);
    
CREATE TRIGGER `softsat_locacao_ipva_parcela_after_update` AFTER UPDATE ON `softsat_locacao_ipva_parcela` FOR EACH ROW
    CALL softsat_locacao_ipva_lancar((SELECT ipva.ano FROM softsat_locacao_ipva AS ipva WHERE ipva.id = NEW.ipva_id), NULL);
    
DROP VIEW IF EXISTS softsat_locacao_veiculo_ipva_pendente;

CREATE VIEW softsat_locacao_veiculo_ipva_pendente AS
    SELECT vi.*, par.descricao, par.final_placa, par.ipva_id, IFNULL(ipva.ano, YEAR(vi.vencimento)) as ano FROM softsat_locacao_veiculo_ipva AS vi
    LEFT JOIN softsat_locacao_ipva_parcela AS par ON par.id = vi.ipva_parcela_id
    LEFT JOIN softsat_locacao_ipva AS ipva ON ipva.id = par.ipva_id
    INNER JOIN softsat_locacao_veiculo AS vei ON vei.id = vi.veiculo_id
    WHERE vi.pagamento IS NULL AND vei.ativo = 1;