CREATE TABLE softsat_locacao_local(
    id INTEGER PRIMARY KEY AUTO_INCREMENT,
	`created_on` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
	`updated_on` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
	`created_by` INT(11) NULL DEFAULT NULL,
	`updated_by` INT(11) NULL DEFAULT NULL,
    nome VARCHAR(255) NOT NULL,
    cnpj VARCHAR(18) NOT NULL,
    endereco VARCHAR(255) NOT NULL,
    numero VARCHAR(10),
    bairro VARCHAR(255),
    cidade VARCHAR(255),
    estado VARCHAR(2),
    cep VARCHAR(9),
    telefone VARCHAR(20),
    ativo INTEGER NOT NULL,
    dom_abertura TIME,
    dom_fechamento TIME,
    seg_abertura TIME,
    seg_fechamento TIME,
    ter_abertura TIME,
    ter_fechametno TIME,
    qua_abertura TIME,
    qua_fechamento TIME,
    qui_abertura TIME,
    qui_fechamento TIME,
    sex_abertura TIME,
    sex_fechamento TIME,
    sab_abertura TIME,
    sab_fechamento TIME,
	CONSTRAINT `fk_softsat_locacao_local_hwapx_user_created_by` FOREIGN KEY (`created_by`) REFERENCES `hwapx_user` (`id`) ON DELETE SET NULL,
	CONSTRAINT `fk_softsat_locacao_local_hwapx_user_updated_by` FOREIGN KEY (`updated_by`) REFERENCES `hwapx_user` (`id`) ON DELETE SET NULL
);

CREATE TABLE softsat_locacao_local_horario(
    id INTEGER PRIMARY KEY AUTO_INCREMENT,
	`created_on` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
	`updated_on` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
	`created_by` INT(11) NULL DEFAULT NULL,
	`updated_by` INT(11) NULL DEFAULT NULL,
    local_id INTEGER NOT NULL,
    dia_semana ENUM('DOM', 'SEG', 'TER', 'QUA', 'QUI', 'SEX', 'SAB') NOT NULL,
    abertura TIME,
    fechamento TIME,
	CONSTRAINT `fk_softsat_locacao_local_horario_hwapx_user_created_by` FOREIGN KEY (`created_by`) REFERENCES `hwapx_user` (`id`) ON DELETE SET NULL,
	CONSTRAINT `fk_softsat_locacao_local_horario_hwapx_user_updated_by` FOREIGN KEY (`updated_by`) REFERENCES `hwapx_user` (`id`) ON DELETE SET NULL
);

CREATE TRIGGER `softsat_locacao_local_after_insert` AFTER INSERT ON `softsat_locacao_local` FOR EACH ROW INSERT INTO softsat_locacao_local_horario(created_by, local_id, dia_semana)
    VALUES(NEW.created_by, NEW.id, 'DOM'),
          (NEW.created_by, NEW.id, 'SEG'),
          (NEW.created_by, NEW.id, 'TER'),
          (NEW.created_by, NEW.id, 'QUA'),
          (NEW.created_by, NEW.id, 'QUI'),
          (NEW.created_by, NEW.id, 'SEX'),
          (NEW.created_by, NEW.id, 'SAB');
          