DROP PROCEDURE IF EXISTS softsat_locacao_plano_conta_valor;

delimiter //

CREATE PROCEDURE softsat_locacao_plano_conta_valor(in_data_de DATE, in_date_ate DATE,  in_veiculo_id INTEGER, 
    in_marca_id INTEGER, in_grupo_id INTEGER, in_conta VARCHAR(10))
BEGIN
    SELECT COUNT(1) INTO @total_veiculos FROM softsat_locacao_veiculo AS vei WHERE vei.ativo = 1;
    
    SELECT COUNT(1) INTO @qtde_veiculos FROM softsat_locacao_veiculo AS vei
        WHERE ativo = 1 AND
        (vei.id = in_veiculo_id OR in_veiculo_id IS NULL)  AND
        (vei.marca_id = in_marca_id OR in_marca_id IS NULL) AND
        (vei.grupo_id = in_grupo_id OR in_grupo_id IS NULL);
    
    SELECT
        pc.id,
        pc.conta,
        pc.nome,
        COALESCE(SUM(IF(des.veiculo_id IS NOT NULL, des.valor, 0)), 0) AS veiculo_total,
        COALESCE(SUM(IF(des.veiculo_id IS NULL, des.valor / @total_veiculos * @qtde_veiculos, 0)), 0) AS outro_total,
        COALESCE(SUM(IF(des.veiculo_id IS NULL, des.valor / @total_veiculos * @qtde_veiculos, des.valor)), 0) AS total,
        CASE LENGTH(pc.conta) WHEN 7 THEN 2 WHEN 4 THEN 1 ELSE 0 END AS nivel
    FROM softsat_locacao_plano_conta AS pc
    INNER JOIN softsat_locacao_despesa_detalhe AS des ON des.plano_conta_conta3 LIKE CONCAT(pc.conta, '%')
    LEFT JOIN softsat_locacao_veiculo AS vei ON vei.id = des.veiculo_id
    WHERE
        (in_conta IS NULL OR pc.conta = in_conta OR in_conta LIKE CONCAT(pc.conta, '%')) AND
        (des.id IS NULL OR des.`data` BETWEEN in_data_de AND in_date_ate) AND
        (des.veiculo_id = in_veiculo_id OR in_veiculo_id IS NULL OR des.veiculo_id IS NULL)  AND
        (vei.marca_id = in_marca_id OR in_marca_id IS NULL OR vei.marca_id IS NULL) AND
        (vei.grupo_id = in_grupo_id OR in_grupo_id IS NULL OR vei.grupo_id IS NULL) 
    GROUP BY
        pc.id,
        pc.conta,
        pc.nome
    ORDER BY pc.conta;
END//
    
delimter ;
    
CALL softsat_locacao_plano_conta_valor('2018-01-01', '2018-12-12', 1, NULL);
CALL softsat_locacao_plano_conta_valor('2018-01-01', '2018-12-12', NULL, NULL);
CALL softsat_locacao_plano_conta_valor('2018-01-01', '2018-12-12', NULL, NULL, NULL, NULL);