DROP PROCEDURE if EXISTS softsat_locacao_boleto_remessa_gerar;
delimiter //
CREATE PROCEDURE softsat_locacao_boleto_remessa_gerar() 
BEGIN
    DECLARE num_remessa INT;
    DECLARE qtd_boletos INT;

    SELECT COUNT(1) INTO qtd_boletos FROM softsat_locacao_boleto 
        WHERE (cancelado = 0 AND remessa_criacao IS NULL) OR
        (cancelado = 1 AND remessa_criacao IS NOT NULL AND remessa_baixa IS NULL);

    IF(qtd_boletos > 0)THEN
        SELECT VALUE INTO num_remessa FROM hwapx_setting WHERE id = 'softsat.locacao.boleto.numero_remessa' FOR UPDATE;
        UPDATE hwapx_setting SET VALUE = num_remessa + 1 WHERE id = 'softsat.locacao.boleto.numero_remessa';

        INSERT INTO softsat_locacao_boleto_remessa(numero, emissao) VALUES(num_remessa, CURRENT_TIMESTAMP);

        UPDATE softsat_locacao_boleto SET remessa_criacao = num_remessa WHERE cancelado = 0 AND remessa_criacao IS NULL;
        UPDATE softsat_locacao_boleto SET remessa_baixa = num_remessa WHERE cancelado = 1 AND remessa_criacao IS NOT NULL AND remessa_baixa IS NULL;
    END IF;
END//