DROP PROCEDURE IF EXISTS reset_auto_increment;
delimiter //
CREATE PROCEDURE reset_auto_increment()
BEGIN
    DECLARE done INT DEFAULT FALSE;
    DECLARE tbl_name CHAR(255);
    DECLARE cur1 CURSOR FOR SELECT t.table_name FROM INFORMATION_SCHEMA.TABLES AS t 
        WHERE t.TABLE_TYPE = 'BASE TABLE' AND t.TABLE_SCHEMA = DATABASE();

    DECLARE CONTINUE HANDLER FOR NOT FOUND SET done = TRUE;
    OPEN cur1;

    tloop: loop
        FETCH cur1 INTO tbl_name;
        IF done THEN
            LEAVE tloop;
        END IF;
        SET @sql = CONCAT('ALTER TABLE ', tbl_name, ' AUTO_INCREMENT = 1');
        PREPARE stmt FROM @sql;
        EXECUTE stmt;
        DROP PREPARE stmt;
    END LOOP;

    CLOSE cur1;
END