-- --------------------------------------------------------
-- Servidor:                     softsatsistemas.com.br
-- Versão do servidor:           5.6.30 - MySQL Community Server (GPL)
-- OS do Servidor:               Linux
-- HeidiSQL Versão:              9.4.0.5169
-- --------------------------------------------------------

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET NAMES utf8 */;
/*!50503 SET NAMES utf8mb4 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

-- Copiando estrutura para tabela softsats_teste.hwapx_audit
CREATE TABLE IF NOT EXISTS `hwapx_audit` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_on` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `done_by` int(11) DEFAULT NULL,
  `done_by_data` text COLLATE utf8_unicode_ci,
  `done_at` datetime DEFAULT NULL,
  `action` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `table` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `record_id` int(11) NOT NULL,
  `old_data` text COLLATE utf8_unicode_ci,
  `new_data` text COLLATE utf8_unicode_ci,
  `url` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `verb` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Exportação de dados foi desmarcado.
-- Copiando estrutura para tabela softsats_teste.hwapx_email_account
CREATE TABLE IF NOT EXISTS `hwapx_email_account` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_on` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_on` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  `description` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `slug` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `email` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `password` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `host` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `port` int(11) NOT NULL,
  `scheme` varchar(3) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_hwapx_email_account_hwapx_user_created_by` (`created_by`),
  KEY `fk_hwapx_email_account_hwapx_user_updated_by` (`updated_by`),
  CONSTRAINT `fk_hwapx_email_account_hwapx_user_created_by` FOREIGN KEY (`created_by`) REFERENCES `hwapx_user` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_hwapx_email_account_hwapx_user_updated_by` FOREIGN KEY (`updated_by`) REFERENCES `hwapx_user` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Exportação de dados foi desmarcado.
-- Copiando estrutura para tabela softsats_teste.hwapx_email_queue
CREATE TABLE IF NOT EXISTS `hwapx_email_queue` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_on` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_on` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `created_by` int(11) DEFAULT NULL,
  `updated_By` int(11) DEFAULT NULL,
  `account_id` int(11) DEFAULT NULL,
  `template_id` int(11) DEFAULT NULL,
  `data` text COLLATE utf8_unicode_ci,
  `callback` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `callback_data` text COLLATE utf8_unicode_ci,
  `to` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `from` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `to_parsed` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `reply_to` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cc` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `bcc` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `subject` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `subject_parsed` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `body` text COLLATE utf8_unicode_ci NOT NULL,
  `body_parsed` text COLLATE utf8_unicode_ci,
  `attachments` text COLLATE utf8_unicode_ci,
  `sent_at` datetime DEFAULT NULL,
  `log` text COLLATE utf8_unicode_ci,
  `cancelled` tinyint(1) NOT NULL DEFAULT '0',
  `cancelled_on` datetime DEFAULT NULL,
  `executed_on` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_hwapx_email_queue_hwapx_user_created_by` (`created_by`),
  KEY `fk_hwapx_email_queue_hwapx_user_updated_by` (`updated_By`),
  KEY `fk_hwapx_email_queue_hwapx_email_account` (`account_id`),
  KEY `fk_hwapx_email_queue_hwapx_email_template` (`template_id`),
  CONSTRAINT `fk_hwapx_email_queue_hwapx_email_account` FOREIGN KEY (`account_id`) REFERENCES `hwapx_email_account` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_hwapx_email_queue_hwapx_email_template` FOREIGN KEY (`template_id`) REFERENCES `hwapx_email_template` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_hwapx_email_queue_hwapx_user_created_by` FOREIGN KEY (`created_by`) REFERENCES `hwapx_user` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_hwapx_email_queue_hwapx_user_updated_by` FOREIGN KEY (`updated_By`) REFERENCES `hwapx_user` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Exportação de dados foi desmarcado.
-- Copiando estrutura para tabela softsats_teste.hwapx_email_template
CREATE TABLE IF NOT EXISTS `hwapx_email_template` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_on` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_on` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  `description` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `slug` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `account_id` int(11) DEFAULT NULL,
  `from` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `to` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cc` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `bcc` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `reply_to` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `subject` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `body` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `slug` (`slug`),
  KEY `fk_hwapx_email_template_hwapx_email_account` (`account_id`),
  KEY `fk_hwapx_email_template_hwapx_user_created_by` (`created_by`),
  KEY `fk_hwapx_email_template_hwapx_user_updated_by` (`updated_by`),
  CONSTRAINT `fk_hwapx_email_template_hwapx_email_account` FOREIGN KEY (`account_id`) REFERENCES `hwapx_email_account` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_hwapx_email_template_hwapx_user_created_by` FOREIGN KEY (`created_by`) REFERENCES `hwapx_user` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_hwapx_email_template_hwapx_user_updated_by` FOREIGN KEY (`updated_by`) REFERENCES `hwapx_user` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Exportação de dados foi desmarcado.
-- Copiando estrutura para tabela softsats_teste.hwapx_group
CREATE TABLE IF NOT EXISTS `hwapx_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_on` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_on` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  `active` tinyint(1) NOT NULL,
  `description` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `roles` text COLLATE utf8_unicode_ci,
  `correspondente_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_hwapx_group_softsat_process_correspondente` (`correspondente_id`),
  KEY `fk_hwapx_group_hwapx_user_created_by` (`created_by`),
  KEY `fk_hwapx_group_hwapx_user_updated_by` (`updated_by`),
  CONSTRAINT `fk_hwapx_group_hwapx_user_created_by` FOREIGN KEY (`created_by`) REFERENCES `hwapx_user` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_hwapx_group_hwapx_user_updated_by` FOREIGN KEY (`updated_by`) REFERENCES `hwapx_user` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_hwapx_group_softsat_process_correspondente` FOREIGN KEY (`correspondente_id`) REFERENCES `softsat_process_correspondente` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Exportação de dados foi desmarcado.
-- Copiando estrutura para tabela softsats_teste.hwapx_redirect
CREATE TABLE IF NOT EXISTS `hwapx_redirect` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_on` datetime NOT NULL,
  `updated_on` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  `description` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `url_from` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `url_to` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `active` tinyint(1) NOT NULL,
  `permanent` tinyint(1) NOT NULL,
  `method` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_hwapx_redirect_hwapx_user_created_by` (`created_by`),
  KEY `fk_hwapx_redirect_hwapx_user_updated_by` (`updated_by`),
  CONSTRAINT `fk_hwapx_redirect_hwapx_user_created_by` FOREIGN KEY (`created_by`) REFERENCES `hwapx_user` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_hwapx_redirect_hwapx_user_updated_by` FOREIGN KEY (`updated_by`) REFERENCES `hwapx_user` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Exportação de dados foi desmarcado.
-- Copiando estrutura para tabela softsats_teste.hwapx_sessions
CREATE TABLE IF NOT EXISTS `hwapx_sessions` (
  `session_id` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `data` text COLLATE utf8_unicode_ci,
  `ip` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,
  `agent` varchar(300) COLLATE utf8_unicode_ci DEFAULT NULL,
  `stamp` int(11) DEFAULT NULL,
  PRIMARY KEY (`session_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Exportação de dados foi desmarcado.
-- Copiando estrutura para tabela softsats_teste.hwapx_setting
CREATE TABLE IF NOT EXISTS `hwapx_setting` (
  `id` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `value` text COLLATE utf8_unicode_ci,
  `field_order` int(11) NOT NULL,
  `label` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `group` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `type` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `rules` text COLLATE utf8_unicode_ci,
  `created_on` datetime DEFAULT CURRENT_TIMESTAMP,
  `updated_on` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Exportação de dados foi desmarcado.
-- Copiando estrutura para tabela softsats_teste.hwapx_user
CREATE TABLE IF NOT EXISTS `hwapx_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_on` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_on` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  `last_activity` datetime DEFAULT NULL,
  `last_login` datetime DEFAULT NULL,
  `last_ip` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `password` char(128) COLLATE utf8_unicode_ci NOT NULL,
  `email` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `photo` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `active` tinyint(1) NOT NULL,
  `group_id` int(11) NOT NULL,
  `correspondente_id` int(11) DEFAULT NULL,
  `reset_requested_on` datetime DEFAULT NULL,
  `reset_token` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `reset_expire` datetime DEFAULT NULL,
  `last_reset` datetime DEFAULT NULL,
  `session_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `un_hwapx_user_email` (`email`),
  UNIQUE KEY `un_hwapx_user_reset_token` (`reset_token`),
  KEY `fk_hwapx_user_hwapx_group` (`group_id`),
  KEY `fk_hwapx_user_softsat_process_correspondente` (`correspondente_id`),
  KEY `fk_hwapx_user_hwapx_user_created_by` (`created_by`),
  KEY `fk_hwapx_user_hwapx_user_updated_by` (`updated_by`),
  CONSTRAINT `fk_hwapx_user_hwapx_group` FOREIGN KEY (`group_id`) REFERENCES `hwapx_group` (`id`),
  CONSTRAINT `fk_hwapx_user_hwapx_user_created_by` FOREIGN KEY (`created_by`) REFERENCES `hwapx_user` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_hwapx_user_hwapx_user_updated_by` FOREIGN KEY (`updated_by`) REFERENCES `hwapx_user` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_hwapx_user_softsat_process_correspondente` FOREIGN KEY (`correspondente_id`) REFERENCES `softsat_process_correspondente` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Exportação de dados foi desmarcado.
-- Copiando estrutura para tabela softsats_teste.softsat_licenca
CREATE TABLE IF NOT EXISTS `softsat_licenca` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_on` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_on` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  `plano_id` int(11) DEFAULT NULL,
  `nome` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `cnpj` varchar(18) COLLATE utf8_unicode_ci NOT NULL,
  `email` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `telefone` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `endereco` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `numero` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `complemento` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `bairro` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cidade` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `estado` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cep` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `codigo_ibge` int(11) DEFAULT NULL,
  `data_base` date DEFAULT NULL,
  `iugu_subscription_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `iugu_customer_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `demonstracao` tinyint(1) NOT NULL DEFAULT '0',
  `ilimitada` tinyint(1) NOT NULL DEFAULT '0',
  `suspensa` tinyint(1) NOT NULL DEFAULT '0',
  `observacao` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `un_softsat_licenca_cnpj` (`cnpj`),
  UNIQUE KEY `un_softsat_licenca_iugu_subscription_id` (`iugu_subscription_id`),
  UNIQUE KEY `un_softsat_licenca_iugu_customer_id` (`iugu_customer_id`),
  KEY `fk_softsat_licenca_hwapx_user_created_by` (`created_by`),
  KEY `fk_softsat_licenca_hwapx_user_updated_by` (`updated_by`),
  KEY `fk_softsat_licenca_softsat_licenca_plano` (`plano_id`),
  CONSTRAINT `fk_softsat_licenca_hwapx_user_created_by` FOREIGN KEY (`created_by`) REFERENCES `hwapx_user` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_softsat_licenca_hwapx_user_updated_by` FOREIGN KEY (`updated_by`) REFERENCES `hwapx_user` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_softsat_licenca_softsat_licenca_plano` FOREIGN KEY (`plano_id`) REFERENCES `softsat_licenca_plano` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Exportação de dados foi desmarcado.
-- Copiando estrutura para tabela softsats_teste.softsat_licenca_estacao
CREATE TABLE IF NOT EXISTS `softsat_licenca_estacao` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_on` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_on` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `licenca_id` int(11) NOT NULL,
  `nome` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `identificador` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `ativa` tinyint(1) NOT NULL,
  `acessada_em` datetime DEFAULT NULL,
  `versao_sistema` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `data` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `un_softsat_licenca_estacao_licenca_id_identificador` (`licenca_id`,`identificador`),
  CONSTRAINT `fk_softsat_licenca_estacao_softsat_licenca` FOREIGN KEY (`licenca_id`) REFERENCES `softsat_licenca` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=92 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Exportação de dados foi desmarcado.
-- Copiando estrutura para tabela softsats_teste.softsat_licenca_extensao
CREATE TABLE IF NOT EXISTS `softsat_licenca_extensao` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_by` int(11) DEFAULT NULL,
  `created_on` datetime DEFAULT CURRENT_TIMESTAMP,
  `updated_by` int(11) DEFAULT NULL,
  `updated_on` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `licenca_id` int(11) NOT NULL,
  `expira_em` date NOT NULL,
  `justificativa` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_softsat_licenca_extensao_hwapx_user_created_by` (`created_by`),
  KEY `fk_softsat_licenca_extensao_hwapx_user_updated_by` (`updated_by`),
  KEY `fk_softsat_licenca_extensao_softsat_licenca` (`licenca_id`),
  CONSTRAINT `fk_softsat_licenca_extensao_hwapx_user_created_by` FOREIGN KEY (`created_by`) REFERENCES `hwapx_user` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_softsat_licenca_extensao_hwapx_user_updated_by` FOREIGN KEY (`updated_by`) REFERENCES `hwapx_user` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_softsat_licenca_extensao_softsat_licenca` FOREIGN KEY (`licenca_id`) REFERENCES `softsat_licenca` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=latin1;

-- Exportação de dados foi desmarcado.
-- Copiando estrutura para tabela softsats_teste.softsat_licenca_fatura
CREATE TABLE IF NOT EXISTS `softsat_licenca_fatura` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_on` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_on` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `licenca_id` int(11) NOT NULL,
  `iugu_invoice_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `emissao` date DEFAULT NULL,
  `vencimento` date NOT NULL,
  `valor` decimal(18,2) DEFAULT NULL,
  `pagamento` datetime DEFAULT NULL,
  `valor_pago` decimal(18,2) DEFAULT NULL,
  `cancelada` tinyint(1) NOT NULL DEFAULT '0',
  `observacao` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `un_softsat_licenca_fatura_iugu_invoice_id` (`iugu_invoice_id`),
  KEY `fk_softsat_licenca_fatura_softsat_licenca` (`licenca_id`),
  CONSTRAINT `fk_softsat_licenca_fatura_softsat_licenca` FOREIGN KEY (`licenca_id`) REFERENCES `softsat_licenca` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=171 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Exportação de dados foi desmarcado.
-- Copiando estrutura para tabela softsats_teste.softsat_licenca_plano
CREATE TABLE IF NOT EXISTS `softsat_licenca_plano` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_on` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_on` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  `nome` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `valor` decimal(18,2) NOT NULL,
  `iugu_plan_identifier` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `iugu_plan_id` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `modulos` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `un_softsat_licenca_plano_iugu_plan_id` (`iugu_plan_id`),
  UNIQUE KEY `un_softsat_licenca_plano_iugu_plan_identifier` (`iugu_plan_identifier`),
  KEY `fk_softsat_licenca_plano_hwapx_user_created_by` (`created_by`),
  KEY `fk_softsat_licenca_plano_hwapx_user_updated_by` (`updated_by`),
  CONSTRAINT `fk_softsat_licenca_plano_hwapx_user_created_by` FOREIGN KEY (`created_by`) REFERENCES `hwapx_user` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_softsat_licenca_plano_hwapx_user_updated_by` FOREIGN KEY (`updated_by`) REFERENCES `hwapx_user` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Exportação de dados foi desmarcado.
-- Copiando estrutura para tabela softsats_teste.sss_download_request
CREATE TABLE IF NOT EXISTS `sss_download_request` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_on` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `email` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `phone` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `token` char(32) COLLATE utf8_unicode_ci NOT NULL,
  `count` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=58 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Exportação de dados foi desmarcado.
-- Copiando estrutura para view softsats_teste.softsat_licenca_vencimento_20172501
-- Criando tabela temporária para evitar erros de dependência de VIEW
CREATE TABLE `softsat_licenca_vencimento_20172501` (
	`licenca_id` INT(1) NOT NULL,
	`data_base` INT(1) NOT NULL,
	`cnpj` INT(1) NOT NULL,
	`plano` INT(1) NOT NULL,
	`modulos` INT(1) NOT NULL,
	`vencimento` INT(1) NOT NULL,
	`carencia` INT(1) NOT NULL
) ENGINE=MyISAM;

-- Copiando estrutura para view softsats_teste.softsat_licenca_vencimento_20172501
-- Removendo tabela temporária e criando a estrutura VIEW final
DROP TABLE IF EXISTS `softsat_licenca_vencimento_20172501`;
CREATE ALGORITHM=UNDEFINED DEFINER=`softsats_teste`@`localhost` SQL SECURITY DEFINER VIEW `softsat_licenca_vencimento_20172501` AS select 1 AS `licenca_id`,1 AS `data_base`,1 AS `cnpj`,1 AS `plano`,1 AS `modulos`,1 AS `vencimento`,1 AS `carencia`;

/*!40101 SET SQL_MODE=IFNULL(@OLD_SQL_MODE, '') */;
/*!40014 SET FOREIGN_KEY_CHECKS=IF(@OLD_FOREIGN_KEY_CHECKS IS NULL, 1, @OLD_FOREIGN_KEY_CHECKS) */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
