CREATE TABLE softsat_locacao_marca(
    id INTEGER PRIMARY KEY AUTO_INCREMENT,
    nome VARCHAR(255) NOT NULL
);

CREATE TABLE softsat_locacao_combustivel(
    id INTEGER PRIMARY KEY AUTO_INCREMENT,
    nome VARCHAR(255) NOT NULL
);

CREATE TABLE softsat_locacao_grupo(
    id INTEGER PRIMARY KEY AUTO_INCREMENT,
    nome VARCHAR(255) NOT NULL
);

CREATE TABLE softsat_locacao_veiculos(
    id INTEGER PRIMARY KEY AUTO_INCREMENT,
    placa VARCHAR(8) NOT NULL,
    marca INTEGER,
    modelo VARCHAR(255),
    ano INTEGER,
    ano_modelo INTEGER,
    combustivel INTEGER,
    chassi VARCHAR(255),
    grupo INTEGER
);

CREATE TABLE softsat_locacao_forma_pagamento(
    id INTEGER PRIMARY KEY AUTO_INCREMENT,
    nome VARCHAR(255) NOT NULL
);

CREATE TABLE softsat_locacao_tarifa(
    id INTEGER PRIMARY KEY AUTO_INCREMENT,
    nome VARCHAR(255) NOT NULL,
    valor DECIMAL(12, 2) NOT NULL
);

CREATE TABLE softsat_locacao_cliente(
    id INTEGER PRIMARY KEY AUTO_INCREMENT,
    nome VARCHAR(255) NOT NULL,
    cpf VARCHAR(15) NOT NULL,
    rg VARCHAR(15) NOT NULL,
    cnh VARCHAR(20) NOT NULL,
    nascimento DATE NOT NULL,
    endereco VARCHAR(255) NOT NULL,
    numero VARCHAR(10),
    bairro VARCHAR(255),
    cidade VARCHAR(255),
    estado VARCHAR(2),
    cep VARCHAR(9),
    celular VARCHAR(15),
    telefone VARCHAR(15),
    telefone_comercial VARCHAR(15),
    email VARCHAR(255)
);

CREATE TABLE softsat_locacao_contrato(
    id INTEGER PRIMARY KEY AUTO_INCREMENT,
    cliente_id INTEGER NOT NULL,
    veiculo_id INTEGER NOT NULL,
    saida DATE NOT NULL,
    entrada DATE,
    tarifa_id INTEGER NOT NULL,
    diaria DECIMAL(12, 2) NOT NULL,
    forma_pagamento_id INTEGER,
    status VARCHAR(1) NOT NULL,
    tanque INTEGER
);

CREATE OR REPLACE VIEW softsat_locacao_contrato_relatorio AS
    SELECT 
        con.id, 
        con.cliente_id, 
        cli.nome AS cliente,
        con.veiculo_id, 
        vei.placa,
        con.saida, 
        con.entrada, 
        con.tarifa_id,
        tar.nome AS tarifa,
        con.diaria, 
        DATEDIFF(con.entrada, con.saida) AS qtde_dias, 
        con.diaria * DATEDIFF(entrada, saida) AS valor, 
        con.forma_pagamento_id, 
        con.status, 
        con.tanque 
    FROM 
        softsat_locacao_contrato AS con
    LEFT JOIN softsat_locacao_cliente AS cli ON cli.id = con.cliente_id
    LEFT JOIN softsat_locacao_veiculo AS vei ON vei.id = con.veiculo_id
    LEFT JOIN softsat_locacao_tarifa AS tar ON tar.id = con.tarifa_id
    
    