DROP TRIGGER IF EXISTS softsat_locacao_contrato_after_update;
delimiter //
CREATE TRIGGER `softsat_locacao_contrato_after_update` AFTER UPDATE ON `softsat_locacao_contrato` FOR EACH ROW 
BEGIN
	DECLARE forma_boleto VARCHAR(255);
	DECLARE condicao_parcelas INT;
	DECLARE condicao_sem_entrada INT;
	DECLARE condicao_intervalo INT;

	IF(NEW.status = 'F') THEN
	    UPDATE softsat_locacao_veiculo SET km_atual = GREATEST(NEW.km_entrada, km_atual) WHERE id = NEW.veiculo_id;
	END IF;

	SELECT VALUE INTO forma_boleto FROM hwapx_setting WHERE id = 'softsat.locacao.boleto.forma_pagamento_id';

	IF(NEW.status = 'A' AND NEW.forma_pagamento_id = forma_boleto AND
		(OLD.status = 'R' OR OLD.saida <> NEW.saida OR NEW.forma_pagamento_id <> OLD.forma_pagamento_id OR NEW.total_previsto <> OLD.total_previsto OR NEW.cliente_id <> OLD.cliente_id OR NEW.condicao_pagamento_id <> OLD.condicao_pagamento_id))THEN
		SELECT parcelas, sem_entrada, intervalo INTO condicao_parcelas, condicao_sem_entrada, condicao_intervalo FROM softsat_locacao_condicao_pagamento WHERE id = NEW.condicao_pagamento_id;

		CALL softsat_locacao_contrato_boleto_gerar(NEW.cliente_id, NEW.total_previsto, NEW.saida, condicao_parcelas, condicao_sem_entrada, condicao_intervalo, NEW.id);
	END IF;

	IF((NEW.status = 'R' AND OLD.status = 'A' AND OLD.forma_pagamento_id = forma_boleto) OR 
        (OLD.forma_pagamento_id = forma_boleto AND NEW.forma_pagamento_id <> OLD.forma_pagamento_id) OR
        (NEW.status = 'C'))THEN
		UPDATE softsat_locacao_boleto SET cancelado = 1 WHERE contrato_id = NEW.id;
	END IF;
END//

DROP TRIGGER IF EXISTS softsat_locacao_contrato_after_insert//
CREATE TRIGGER `softsat_locacao_contrato_after_insert` AFTER INSERT ON `softsat_locacao_contrato` FOR EACH ROW BEGIN
	DECLARE forma_boleto VARCHAR(255);
	DECLARE condicao_parcelas INT;
	DECLARE condicao_sem_entrada INT;
	DECLARE condicao_intervalo INT;

	SELECT VALUE INTO forma_boleto FROM hwapx_setting WHERE id = 'softsat.locacao.boleto.forma_pagamento_id';

	IF(NEW.forma_pagamento_id = forma_boleto AND (NEW.status = 'A' OR NEW.status = 'F'))THEN
		SELECT parcelas, sem_entrada, intervalo INTO condicao_parcelas, condicao_sem_entrada, condicao_intervalo FROM softsat_locacao_condicao_pagamento WHERE id = NEW.condicao_pagamento_id;

		CALL softsat_locacao_contrato_boleto_gerar(NEW.cliente_id, NEW.total_previsto, NEW.saida, condicao_parcelas, condicao_sem_entrada, condicao_intervalo, NEW.id);
	END IF;
END//