DROP TRIGGER IF EXISTS softsat_locacao_contrato_before_update;

delimiter //
CREATE TRIGGER `softsat_locacao_contrato_before_update` BEFORE UPDATE ON `softsat_locacao_contrato` FOR EACH ROW
BEGIN
    IF(NEW.status <> OLD.status)THEN
        CASE NEW.status
        WHEN 'R' THEN SET NEW.email_reserva = 1;
        WHEN 'A' THEN SET NEW.email_aberto = 1;
        WHEN 'F' THEN SET NEW.email_faturado = 1;
        ELSE BEGIN END;
        END CASE;
        
        SET NEW.data_status  = CURRENT_TIMESTAMP;
    END IF;
END//
