DROP VIEW IF EXISTS softsat_locacao_contrato_relatorio;
CREATE VIEW softsat_locacao_contrato_relatorio AS 
SELECT 
	`con`.`id` AS `id`,
	`con`.`created_on` AS `created_on`,
	`con`.`updated_on` AS `updated_on`,
	`con`.`created_by` AS `created_by`,
	`con`.`updated_by` AS `updated_by`,
	`con`.`cliente_id` AS `cliente_id`,
	`con`.`veiculo_id` AS `veiculo_id`,
	`con`.`local_saida_id` AS `local_saida_id`,
	`con`.`local_entrada_id` AS `local_entrada_id`,
	`con`.`saida` AS `saida`,
	`con`.`previsto` AS `previsto`,
	`con`.`dias_previstos` AS `dias_previstos`,
	`con`.`entrada` AS `entrada`,
	`con`.`dias_utilizados` AS `dias_utilizados`,
	`con`.`dias_cobrados` AS `dias_cobrados`,
	`con`.`dias_excedidos` AS `dias_excedidos`,
	`con`.`diaria` AS `diaria`,
	`con`.`perc_multa_excedido` AS `perc_multa_excedido`,
	`con`.`valor_multa_excedido` AS `valor_multa_excedido`,
	`con`.`acrescimo_desconto` AS `acrescimo_desconto`,
	`con`.`total_previsto` AS `total_previsto`,
	`con`.`total` AS `total`,
	`con`.`forma_pagamento_id` AS `forma_pagamento_id`,
	`con`.`tarifa_id` AS `tarifa_id`,
	`con`.`status` AS `status`,
	`con`.`data_status` AS `data_status`,
	`con`.`tanque_saida` AS `tanque_saida`,
	`con`.`tanque_entrada` AS `tanque_entrada`,
	`con`.`km_saida` AS `km_saida`,
	`con`.`km_contratado` AS `km_contratado`,
	`con`.`km_entrada` AS `km_entrada`,
	con.km_excedido,
	con.total_km_excedido,
	con.valor_km_excedido,
	`con`.`indenizacao_carro` AS `indenizacao_carro`,
	`con`.`indenizacao_terceiros` AS `indenizacao_terceiros`,
	`con`.`observacao` AS `observacao`,
	`con`.`email_reserva` AS `email_reserva`,
	`con`.`email_aberto` AS `email_aberto`,
	`con`.`email_faturado` AS `email_faturado`,
	`cli`.`nome` AS `cliente`,
	`cli`.`cnpj_cpf` AS `cliente_cnpj_cpf`,
	`cli`.`email` AS `cliente_email`,
	`cli`.`endereco` AS `cliente_endereco`,
	`cli`.`numero` AS `cliente_numero`,
	`cli`.`bairro` AS `cliente_bairro`,
	`cli`.`cidade` AS `cliente_cidade`,
	`cli`.`estado` AS `cliente_estado`,
	`cli`.`cep` AS `cliente_cep`,
	`tar`.`nome` AS `tarifa`, IF(((`con`.`km_entrada` - `con`.`km_saida`) < 0), NULL,(`con`.`km_entrada` - `con`.`km_saida`)) AS `km_utilizado`,
	`vei`.`placa` AS `veiculo_placa`,
	`vei`.`nome` AS `veiculo_nome`,
	`vei`.`modelo` AS `veiculo_modelo`,
	`vei`.`grupo` AS `veiculo_grupo`,
	`vei`.`marca` AS `veiculo_marca`,
	`vei`.`grupo_id` AS `veiculo_grupo_id`,
	`vei`.`marca_id` AS `veiculo_marca_id`,
	`vei`.`combustivel_id` AS `veiculo_combustivel_id`,
	`fpag`.`nome` AS `forma_pagamento`,
    cpag.nome AS condicao_pagamento,
	`lsai`.`nome` AS `local_saida`,
	`lsai`.`razao` AS `local_saida_razao`,
	`lsai`.`cnpj` AS `local_saida_cnpj`,
	`lsai`.`endereco` AS `local_saida_endereco`,
	`lsai`.`numero` AS `local_saida_numero`,
	`lsai`.`bairro` AS `local_saida_bairro`,
	`lsai`.`cidade` AS `local_saida_cidade`,
	`lsai`.`estado` AS `local_saida_estado`,
	`lsai`.`cep` AS `local_saida_cep`,
	`lsai`.`telefone` AS `local_saida_telefone`,
	`lsai`.`email` AS `local_saida_email`,
	`lent`.`nome` AS `local_entrada`,
	`lent`.`razao` AS `local_entrada_razao`,
	`lent`.`cnpj` AS `local_entrada_cnpj`,
	`lent`.`endereco` AS `local_entrada_endereco`,
	`lent`.`numero` AS `local_entrada_numero`,
	`lent`.`bairro` AS `local_entrada_bairro`,
	`lent`.`cidade` AS `local_entrada_cidade`,
	`lent`.`estado` AS `local_entrada_estado`,
	`lent`.`cep` AS `local_entrada_cep`,
	`lent`.`telefone` AS `local_entrada_telefone`,
	`lent`.`email` AS `local_entrada_email`
FROM `softsat_locacao_contrato` `con`
LEFT JOIN `softsat_locacao_cliente` `cli` ON `cli`.`id` = `con`.`cliente_id`
LEFT JOIN `softsat_locacao_veiculo_detalhe` `vei` ON `vei`.`id` = `con`.`veiculo_id`
LEFT JOIN `softsat_locacao_tarifa` `tar` ON `tar`.`id` = `con`.`tarifa_id`
LEFT JOIN `softsat_locacao_forma_pagamento` `fpag` ON `fpag`.`id` = `con`.`forma_pagamento_id`
LEFT JOIN `softsat_locacao_condicao_pagamento` `cpag` ON `cpag`.`id` = `con`.`condicao_pagamento_id`
LEFT JOIN `softsat_locacao_local` `lsai` ON `lsai`.`id` = `con`.`local_saida_id`
LEFT JOIN `softsat_locacao_local` `lent` ON `lent`.`id` = `con`.`local_entrada_id`