DROP VIEW IF EXISTS softsat_locacao_veiculo_receita;
CREATE VIEW softsat_locacao_veiculo_receita AS
    SELECT id AS contrato_id, veiculo_id, total, COALESCE(entrada, saida) AS data
    FROM softsat_locacao_contrato 
    WHERE status = 'F';

DROP VIEW IF EXISTS softsat_locacao_despesa_veiculo;
CREATE VIEW softsat_locacao_despesa_veiculo AS
SELECT 
    des.id, 
    des.data,
    des.valor / COUNT(DISTINCT cvei.id) AS valor, 
    vei.id AS veiculo_id,
    MIN(vei.nome) AS veiculo_nome,
    vei.placa AS veiculo_placa, 
    vei.marca AS veiculo_marca, 
    vei.modelo AS veiculo_modelo, 
    vei.grupo AS veiculo_grupo,
    vei.marca_id AS veiculo_marca_id,
    vei.grupo_id AS veiculo_grupo_id
FROM softsat_locacao_despesa AS des
LEFT JOIN softsat_locacao_veiculo_detalhe AS vei ON des.veiculo_id = vei.id OR des.veiculo_id IS NULL
LEFT JOIN softsat_locacao_veiculo AS cvei ON cvei.ativo = 1 AND (des.veiculo_id = cvei.id OR des.veiculo_id IS NULL)
GROUP BY 
    des.id, 
    des.data,
    des.valor, 
    vei.id,
    vei.placa, 
    vei.marca, 
    vei.modelo, 
    vei.grupo,
    vei.descricao,
    vei.marca_id,
    vei.grupo_id;
    
/*CREATE VIEW softsat_locacao_despesa_veiculo AS
    SELECT des.id, vei.id as veiculo_id, des.valor / COUNT(DISTINCT cvei.id) AS valor, des.data
    FROM softsat_locacao_despesa AS des
    LEFT JOIN softsat_locacao_veiculo AS vei ON des.veiculo_id = vei.id OR des.veiculo_id IS NULL
    LEFT JOIN softsat_locacao_veiculo AS cvei ON cvei.ativo = 1 AND (des.veiculo_id = cvei.id OR des.veiculo_id IS NULL)
    GROUP BY des.id, vei.id, des.valor, des.data;*/
/*
CREATE VIEW softsat_locacao_despesa_veiculo AS
    SELECT des.id, COALESCE(vei.id, veiculo_id) as veiculo_id, des.valor / des.ratear_por AS valor, data
    FROM softsat_locacao_veiculo AS vei
    LEFT JOIN softsat_locacao_despesa_detalhe AS des ON des.veiculo_id = vei.id OR des.veiculo_id IS NULL;
*/

/*
DROP VIEW IF EXISTS softsat_locacao_veiculo_despesa;
CREATE VIEW softsat_locacao_veiculo_despesa AS
    SELECT COALESCE(veiculo_id, vei.id) as veiculo_id, SUM(des.valor / des.ratear_por) AS total
    FROM softsat_locacao_veiculo AS vei
    LEFT JOIN softsat_locacao_despesa_detalhe AS des ON des.veiculo_id = vei.id OR des.veiculo_id IS NULL
    GROUP BY COALESCE(des.veiculo_id, vei.id);
*/    
