DROP VIEW IF EXISTS softsat_locacao_veiculo_detalhe;

CREATE VIEW softsat_locacao_veiculo_detalhe AS
SELECT
    vei.id,
    vei.created_on,
    vei.updated_on,
    vei.created_by,
    vei.updated_by,
    CONCAT('[', vei.placa, '] ', mar.nome, ' ', vei.modelo) AS nome,
    CONCAT('[', vei.placa, '] ', mar.nome, ' ', vei.modelo, ' - ', gru.nome) AS descricao,
    vei.placa,
    vei.marca_id,
    vei.modelo,
    vei.ano,
    vei.ano_modelo,
    vei.combustivel_id,
    vei.chassi,
    vei.grupo_id,
    vei.imagem,
    vei.tarifa_id,
    vei.km_atual,
    vei.km_oleo,
    vei.data_oleo,
    vei.km_suspensao,
    vei.data_suspensao,
    vei.km_pneu,
    vei.data_pneu,
    vei.ativo,
    vei.indenizacao_carro,
    vei.indenizacao_terceiros,
    vei.situacao_frente,
    vei.situacao_traseira,
    vei.situacao_direita,
    vei.situacao_esquerda,
    vei.situacao_superior,
    vei.situacao_inferior,
    vei.ano_licenciamento,
    gru.nome AS grupo,
    mar.nome AS marca,
    com.nome AS combustivel,
    tar.nome AS tarifa,
    tar.valor AS diaria
FROM softsat_locacao_veiculo AS vei
LEFT JOIN softsat_locacao_grupo AS gru ON gru.id = vei.grupo_id
LEFT JOIN softsat_locacao_marca AS mar ON mar.id = vei.marca_id
LEFT JOIN softsat_locacao_combustivel AS com ON com.id = vei.combustivel_id
LEFT JOIN softsat_locacao_tarifa AS tar ON tar.id = vei.tarifa_id;

SELECT * FROM softsat_locacao_veiculo_detalhe;