DROP VIEW IF EXISTS softsat_locacao_veiculo_detalhe;
CREATE VIEW softsat_locacao_veiculo_detalhe AS
SELECT 
	`vei`.`id` AS `id`,
	`vei`.`created_on` AS `created_on`,
	`vei`.`updated_on` AS `updated_on`,
	`vei`.`created_by` AS `created_by`,
	`vei`.`updated_by` AS `updated_by`, CONCAT('[',`vei`.`placa`,'] ',`mar`.`nome`,' ',`vei`.`modelo`) AS `nome`, CONCAT('[',`vei`.`placa`,'] ',`mar`.`nome`,' ',`vei`.`modelo`,' - ',`gru`.`nome`) AS `descricao`,
	`vei`.`placa` AS `placa`,
	`vei`.`marca_id` AS `marca_id`,
	`vei`.`modelo` AS `modelo`,
	`vei`.`ano` AS `ano`,
	`vei`.`ano_modelo` AS `ano_modelo`,
	`vei`.`combustivel_id` AS `combustivel_id`,
	`vei`.`chassi` AS `chassi`,
	`vei`.`renavam` AS `renavam`,
	`vei`.`grupo_id` AS `grupo_id`,
	`vei`.`imagem` AS `imagem`,
	`vei`.`tarifa_id` AS `tarifa_id`,
	`vei`.`km_atual` AS `km_atual`,
	`vei`.`km_oleo` AS `km_oleo`,
	`vei`.`data_oleo` AS `data_oleo`,
	`vei`.`km_pastilha` AS `km_pastilha`,
	`vei`.`data_pastilha` AS `data_pastilha`,
	`vei`.`km_pneu` AS `km_pneu`,
	`vei`.`data_pneu` AS `data_pneu`,
	`vei`.`km_filtro_ar` AS `km_filtro_ar`,
	`vei`.`data_filtro_ar` AS `data_filtro_ar`,
	`vei`.`km_filtro_comb` AS `km_filtro_comb`,
	`vei`.`data_filtro_comb` AS `data_filtro_comb`,
	`vei`.`km_disco` AS `km_disco`,
	`vei`.`data_disco` AS `data_disco`,
	`vei`.`km_correia` AS `km_correia`,
	`vei`.`data_correia` AS `data_correia`,
	`vei`.`ativo` AS `ativo`,
	`vei`.`indenizacao_carro` AS `indenizacao_carro`,
	`vei`.`indenizacao_terceiros` AS `indenizacao_terceiros`,
	`vei`.`situacao_frente` AS `situacao_frente`,
	`vei`.`situacao_traseira` AS `situacao_traseira`,
	`vei`.`situacao_direita` AS `situacao_direita`,
	`vei`.`situacao_esquerda` AS `situacao_esquerda`,
	`vei`.`situacao_superior` AS `situacao_superior`,
	`vei`.`situacao_inferior` AS `situacao_inferior`,
	`vei`.`ano_licenciamento` AS `ano_licenciamento`,
	`gru`.`nome` AS `grupo`,
	`mar`.`nome` AS `marca`,
	`com`.`nome` AS `combustivel`,
	`tar`.`nome` AS `tarifa`,
	`tar`.`valor` AS `diaria`
FROM ((((`desenv_locacao`.`softsat_locacao_veiculo` `vei`
LEFT JOIN `desenv_locacao`.`softsat_locacao_grupo` `gru` ON((`gru`.`id` = `vei`.`grupo_id`)))
LEFT JOIN `desenv_locacao`.`softsat_locacao_marca` `mar` ON((`mar`.`id` = `vei`.`marca_id`)))
LEFT JOIN `desenv_locacao`.`softsat_locacao_combustivel` `com` ON((`com`.`id` = `vei`.`combustivel_id`)))
LEFT JOIN `desenv_locacao`.`softsat_locacao_tarifa` `tar` ON((`tar`.`id` = `vei`.`tarifa_id`)))